#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""get fsp env"""

from __future__ import print_function
import os
import sys
import base64
import subprocess
import six
from networking_huawei.drivers.ac.cryptor.cryptor import AESCryptor
from networking_huawei.drivers.ac.encode_convert import \
    convert_to_bytes, convert_to_str

BASH_DIR = os.path.realpath("/bin/bash")
FS_VERSION_FILE = os.path.realpath('/etc/hostos.version')
ENV_DATA_FILE = os.path.realpath(
    "/root/networking-huawei/tools/setenv_fsp_data.txt")
ENV_IV_FILE = os.path.realpath(
    "/root/networking-huawei/tools/setenv_fsp_cfg.txt")


def is_fsp_8_0_3():
    """Check fsp version if before fsp_6_3_1 or not"""
    file_cmd = '{} {}'.format('cat', FS_VERSION_FILE)
    fs_version = os.popen(file_cmd).readline().split()[2]
    return fs_version.startswith("8.0.3")


def get_fsp_cps_pass():
    """get fsp cps pass"""
    section_conf = 'FSP803' if is_fsp_8_0_3() else 'DEFAULT'
    config_paser = six.moves.configparser.ConfigParser()
    config_paser.read(ENV_DATA_FILE)
    data = config_paser.get(section_conf, 'data')

    config_paser.read(ENV_IV_FILE)
    pw_key = config_paser.get(section_conf, 'pw_key')
    pw_iv = config_paser.get(section_conf, 'pw_iv')
    key_iv = config_paser.get(section_conf, 'key_iv')

    cryptor = AESCryptor(
        base64.b64decode(convert_to_bytes(pw_key)),
        base64.b64decode(convert_to_bytes(pw_iv)),
        base64.b64decode(convert_to_bytes(key_iv)))
    fsp_env_pass = cryptor.decrypt_data(
        base64.b64decode(convert_to_bytes(data)),
        config_paser.get(section_conf, 'cfg_factor'))
    return convert_to_str(fsp_env_pass)


def exec_cps_command(cps_command):
    """exec cps command

    :param cps_command: list,command
    :return:
    """
    sh_path = os.path.realpath(
        '/root/networking-huawei/tools/cps_command.sh')

    cmd = [BASH_DIR, sh_path, cps_command, get_fsp_cps_pass()]
    print('{}:{}'.format("Exec command:", sh_path))
    process_obj = subprocess.Popen(cmd, stdout=subprocess.PIPE,
                                   executable=BASH_DIR, env=None)
    std_output = process_obj.communicate()[0]
    print(convert_to_str(std_output))
    process_obj.wait()


def exec_cps_install(method):
    """exec cps install"""
    if method == 'cps_install':
        sh_path = os.path.realpath(
            '/root/networking-huawei/tools/cps_install.sh')
    elif method == 'cps_uninstall':
        sh_path = os.path.realpath(
            '/root/networking-huawei/tools/cps_uninstall.sh')
    else:
        print("Not support parameter '%s'." % method)
        return
    cmd = [BASH_DIR, sh_path, get_fsp_cps_pass()]
    print('{}:{}'.format("Exec command:", sh_path))
    process_obj = subprocess.Popen(cmd, stdout=subprocess.PIPE,
                                   executable=BASH_DIR, env=None)
    std_output = process_obj.communicate()[0]
    print(convert_to_str(std_output))
    process_obj.wait()


def main():
    """main function"""
    if len(sys.argv) != 2:
        print("The number of parameter is not right.")
        sys.exit(1)
    if sys.argv[1] == 'neutron_status' or sys.argv[1] == 'ac_plugin_status':
        exec_cps_command(sys.argv[1])
    elif sys.argv[1] == 'cps_install' or sys.argv[1] == 'cps_uninstall':
        exec_cps_install(sys.argv[1])
    else:
        print("Not support parameter \"%s\"." % sys.argv[1])
        sys.exit(1)


if __name__ == "__main__":
    main()
