#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""
Health check file
"""

from __future__ import print_function

import six

from networking_huawei.drivers.ac.neutron_client import health_check
from networking_huawei.drivers.ac.common import constants as ac_constants


def choose_scene():
    """Choose scene to exec"""
    scene_info = 'Scenario:\n' \
                 '[1]Openstack network overlay scenario\n' \
                 '[2]Openstack hybrid overlay scenario\n' \
                 '[3]FusionSphere network overlay scenario\n' \
                 '[4]FusionSphere hybrid overlay scenario\n' \
                 'Please choose [1/2/3/4]: '
    while True:
        scene_num = six.moves.input(scene_info)
        if scene_num in ['1', '2', '3', '4']:
            return scene_num


class CheckProcess(object):
    """Check process class"""

    def __init__(self):
        """Init function"""
        self.manager = health_check.ManageBase()
        self.results = []

    def check_process(self):
        """Check plugin process"""
        res = health_check.check_plugin()
        if res[1] == 'ok':
            scene_num = choose_scene()
            print('\n')
            print('[1]Check mandatory items')
            health_check.display_title1()
            for elem in health_check.check_config_value(self.manager):
                health_check.display_required_filled_general(elem)
            for config_name in ac_constants.CHECK_MANDATORY_PARAMS:
                health_check.display_required_filled_general(
                    self.manager.check_required_filled_general(
                        ac_constants.HUAWEI_CONFIG, config_name))
            for config_name in ac_constants.CHECK_DEFAULT_VALUE_PARAMS:
                health_check.display_default_config(
                    self.manager.check_default_config(config_name))
            if scene_num in ['3', '4']:
                for config_name in ac_constants.CHECK_FSP_OTHER_ITEMS:
                    health_check.display_required_filled_general(
                        self.manager.check_optional_filled_general(
                            ac_constants.HUAWEI_CONFIG, config_name))
            self._check_process_ok(scene_num)
        else:
            health_check.display_title('0', 'Check whether the plug-in '
                                            'is installed and deployed')
            health_check.display_plugin_install(res)

    def _check_process_ok(self, scene_num):
        """Check plugin process:res[1] == 'ok'"""
        health_check.display_title(
            '2', 'Check whether the plug-in can connect to Agile Controller-DCN'
                 ' and obtain the token')
        health_check.check_and_display_results(
            self.manager.check_rpc_server_ip(),
            self.manager.check_ac_passwd())
        health_check.display_title('3', 'Check keystone authentication')
        self.manager.display_keystone_info()
        health_check.display_title(
            '4', 'Check whether the value of black_and_white_list has invalid '
                 'symbol')
        health_check.display_network_black_and_white_list()
        health_check.display_title('5', 'Check process and thread status')
        health_check.check_and_display_results(
            health_check.check_neutron_server(self.manager.ops_version, True),
            health_check.check_normal_sync())
        health_check.display_title('6', 'Check ext_gw and ext_net')
        if self.manager.check_ac_passwd()[1] == 'ok':
            health_check.display_ext_net(health_check.check_ext_net(
                self.manager.get_ext_net_from_db(),
                self.manager.get_external_gateway_name()))
        else:
            print('   \033[1;31mFail\033[0m')
            print('       \033[1;31m%s\033[0m' % 'Error: get token failed.')
        health_check.display_title(
            '7', 'Check whether the value of vhost_user is consistent with the '
                 'selected scenario')
        health_check.display_vhost_user(
            self.manager.check_vhost_user(scene_num, ['2', '4']))
        health_check.display_title(
            '8', 'Check cpu and mem being used by neutron-server')
        self.manager.display_neutronserver_cpu_and_mem_used()
        health_check.display_title('9', "Check the file user and group")
        self.manager.display_file_user_and_group()


CheckProcess().check_process()
