#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2020 Huawei Technologies Co. Ltd. All rights reserved.
"""功能:FusionSphere8.0.* --> FusionSphere22.*升级，插件代码路径及相关配置项修改
适用范围:仅供FusionSphere升级时调用
"""
import sys
import os
import subprocess

SOFTWARE_CHANGE = "--software-change"
CONFIG_CHANGE = "--config-change"
PYTHON_2_7_PATH = "/usr/lib/python2.7/site-packages/"
PYTHON_3_7_PATH = "/usr/lib/python3.7/site-packages/"
PLUGIN_NAME = "networking_huawei"
PLUGIN_EGG_INFO_2_7 = "networking_huawei-3.1.0-py2.7.egg-info"
PLUGIN_EGG_INFO_3_7 = "networking_huawei-3.1.0-py3.7.egg-info"


def del_directory(path):
    """delete directory"""
    if os.path.exists(path):
        file_cmd = ['rm', '-rf', path]
        subprocess.call(file_cmd)


def software_change():
    """copy plugin"""
    original_plugin_path = "%s%s" % (PYTHON_2_7_PATH, PLUGIN_NAME)
    purpose_plugin_path = "%s%s" % (PYTHON_3_7_PATH, PLUGIN_NAME)
    original_plugin_egg_info = "%s%s" % (PYTHON_2_7_PATH, PLUGIN_EGG_INFO_2_7)
    purpose_plugin_egg_info = "%s%s" % (PYTHON_3_7_PATH, PLUGIN_EGG_INFO_3_7)

    del_directory(purpose_plugin_path)
    if os.path.exists(original_plugin_path):
        file_cmd = ['cp', '-af', original_plugin_path, PYTHON_3_7_PATH]
        subprocess.call(file_cmd)
    else:
        print("Error:No such directory: %s" % original_plugin_path)

    del_directory(purpose_plugin_egg_info)
    if os.path.exists(original_plugin_egg_info):
        file_cmd = ['cp', '-af', original_plugin_egg_info,
                    purpose_plugin_egg_info]
        subprocess.call(file_cmd)
    else:
        print("Error:No such directory: %s" % original_plugin_egg_info)


def main():
    """main function"""
    if sys.argv[1] == SOFTWARE_CHANGE:
        software_change()


if __name__ == '__main__':
    main()
