#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""modify controller password"""

from __future__ import print_function

import getpass
import os

import six
import requests.packages.urllib3
import sys

sys.path.append("/usr/lib/python3.7/site-packages")
from configobj import ConfigObj
import eventlet

from modify_controller_account import get_token_test, modify_account

requests.packages.urllib3.disable_warnings()
requests = eventlet.import_patched('requests.__init__')

CONFIG_FILE = os.path.realpath("/etc/neutron/huawei_driver_config.ini")
PRODUCT_NAME = "iMaster NCE-Fabric"
CONTROLLER_PORT = '18002'
MAX_PWD_LEN = 128
MAX_TRY_TIMES = 3


def check_setted_on_ac():
    """check set on ac"""
    while True:
        print("Please ensure the password has set on %s" % PRODUCT_NAME)
        p_input = six.moves.input(
            "press [Y] has set or press [N] not set #[Y/N]")
        if p_input == "Y" or p_input == "y":
            return True
        elif p_input == "N" or p_input == "n":
            return False
        else:
            continue


def main():
    """main function"""
    enter_ensure_times = 0
    while True:
        if enter_ensure_times == MAX_TRY_TIMES:
            print("[Error] Ensure new password to max retry times")
            print("Please operate again to modify password")
            break
        # before motify, need to ensure the password if has
        # setted on agile controller
        print("Please ensure the password has set on %s" % PRODUCT_NAME)

        password = getpass.getpass('Please enter new password: ')
        if len(password) > MAX_PWD_LEN:
            print("The length of password should not be more than 128 bytes.")
            enter_ensure_times += 1
            continue

        password_ensure = getpass.getpass('Please enter new password '
                                          'again to confirm: ')

        if password != password_ensure:
            print("Sorry, passwords do not match.")
            enter_ensure_times += 1
            continue

        config = ConfigObj(CONFIG_FILE, encoding='UTF8')
        username = config["huawei_ac_config"]["ac_auth_username"]
        auth_result = get_token_test(username, password, '18002')
        for host in auth_result:
            if auth_result.get(host) == requests.codes.ok:
                print("[success]The north account is authenticated on "
                      "%s(%s)" % (PRODUCT_NAME, host))
            elif auth_result.get(host) == requests.codes.unauthorized:
                print("[Warning]The north account is failed to authenticate "
                      "on %s(%s), Please check the "
                      "account" % (PRODUCT_NAME, host))
            else:
                print("[Warning]The north account can't be authenticated on "
                      "%s(%s)(network or other reason)" % (PRODUCT_NAME, host))

        modify_account(None, password)
        break


if __name__ == "__main__":
    main()
