#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""modify the password of keystone"""


from __future__ import print_function
import base64
import getpass
import os
import six
import sys

sys.path.append("/usr/lib/python3.7/site-packages")
from configobj import ConfigObj
import encryptor

from networking_huawei.drivers.ac.common.constants \
    import KEYSTONE_AUTH_SECURE_KEY
from networking_huawei.drivers.ac.encode_convert import convert_to_bytes

CONFIG_FILE = os.path.realpath("/etc/neutron/huawei_driver_config.ini")

MAX_PWD_LEN = 128
MAX_TRY_TIMES = 3


def modify_pwd(pwd):
    """modify password"""
    while True:
        user_input = six.moves.input("Press [Y] to confirm or "
                                     "press [N] to give up #[Y/N]")
        if user_input == "Y" or user_input == "y":
            break
        elif user_input == "N" or user_input == "n":
            return
    try:
        print("processing... please wait")
        encrypt_pwd = encryptor.encrypt_password(
            pwd, data_type=KEYSTONE_AUTH_SECURE_KEY)
        config = ConfigObj(CONFIG_FILE,
                           encoding='UTF8')
        config["huawei_ac_config"]["keystone_passwd"] = \
            base64.b64encode(convert_to_bytes(encrypt_pwd)).decode()
        config.write()
    except Exception as ex:
        print("Modify password fail")
        print(str(ex))
        return
    print("Modify password success")


ENTER_ENSURE_TIMES = 0
while True:
    if ENTER_ENSURE_TIMES == MAX_TRY_TIMES:
        print("[Error] Ensure new password to max retry times")
        print("Please operate again to modify password")
        break

    PASSWORD = getpass.getpass('Please enter new password: ')
    if len(PASSWORD) > MAX_PWD_LEN:
        print("The length of password should not be more than 128 bytes.")
        ENTER_ENSURE_TIMES += 1
        continue

    PASSWORD_ENSURE = getpass.getpass(
        'Please enter new password again to confirm: ')
    if PASSWORD != PASSWORD_ENSURE:
        print("Sorry, passwords do not match.")
        ENTER_ENSURE_TIMES += 1
        continue

    modify_pwd(PASSWORD)
    break
