#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
""" modify websocket key password """

from __future__ import print_function
import base64
import getpass
import os
import six
import sys

sys.path.append("/usr/lib/python3.7/site-packages")
from configobj import ConfigObj
import encryptor

from networking_huawei.drivers.ac.common.constants \
    import WEBSOCKET_SECURE_KEY
from networking_huawei.drivers.ac.encode_convert import convert_to_bytes

CONFIG_FILE = os.path.realpath("/etc/neutron/huawei_driver_config.ini")

MAX_PWD_LEN = 128
MAX_TRY_TIMES = 3


def modify_pwd(pwd):
    """ modify password """
    while True:
        press = six.moves.input("Press [Y] to confirm or "
                                "press [N] to give up #[Y/N]")
        if press == "Y" or press == "y":
            break
        elif press == "N" or press == "n":
            return
    try:
        print("processing... please wait")
        encrypt_pwd = encryptor.encrypt_password(
            pwd, data_type=WEBSOCKET_SECURE_KEY)
        config = ConfigObj(CONFIG_FILE,
                           encoding='UTF8')
        config["huawei_ac_config"]["websocket_key_password"] = \
            base64.b64encode(convert_to_bytes(encrypt_pwd)).decode()
        config.write()
    except Exception as ex:
        print("Modify password fail")
        print(str(ex))
        return
    print("Modify password success")


def main():
    """main function"""
    enter_ensure_times = 0
    while True:
        if enter_ensure_times == MAX_TRY_TIMES:
            print("[Error] Ensure new password to max retry times")
            print("Please operate again to modify password")
            break

        password = getpass.getpass('Please enter new password: ')
        if len(password) > MAX_PWD_LEN:
            print("The length of password should not be more than 128 bytes.")
            enter_ensure_times += 1
            continue

        password_ensure = getpass.getpass(
            'Please enter new password again to confirm: ')
        if password != password_ensure:
            print("Sorry, passwords do not match.")
            enter_ensure_times += 1
            continue

        modify_pwd(password)
        break


if __name__ == "__main__":
    main()
