#!/bin/bash

CUR_PATH=$(dirname $(readlink -f $0))
source $CUR_PATH/common_function.sh

CENTOS_NS_PATH=/usr/lib/systemd/system
CENTOS_NS_CUR=$CENTOS_NS_PATH/neutron-server.service
UBUNTU_PYTHON_PATH=/usr/local/lib/python2.7/dist-packages
NEUTRON_CONF_PATH=/etc/neutron
HUAWEI_INI_CUR=$NEUTRON_CONF_PATH/huawei_driver_config.ini
HUAWEI_CONF_CUR=/usr/share/neutron/server/huawei_driver_config.conf
KOLLA_CONFIG_FILES=/var/lib/kolla/config_files
IPV6_NS_QOS_POLICY_DRIVER=IPV6_NS_QOS_POLICY:huawei:networking_huawei.drivers.ac.plugins.qos.ac_ipv6_ns_qos_policy_driver.HuaweiIpv6NsQosPolicyDriver:default

declare -A OPS_VERSION_DICT
OPS_VERSION_DICT=([1]=Kilo [2]=Liberty [3]=Mitaka [4]=Newton [5]=Ocata [6]=Pike \
[7]=Queens [8]=EZ_Mitaka [9]=Rocky [10]=Pike [11]=Train [12]=Wallaby)

function select_system(){
    while true; do
        echo -e "Press [1/2/3] to select system type: \c"
        read SYS_SELE
        case "$SYS_SELE" in
        "1" | "2" | "3")
            break;;
        esac
    done
}

echo "****Begin to check the install-package absolutely correct or not****"
CURRENT_PATH=$(cd $(dirname $0); pwd)
mkdir -p $CURRENT_PATH/certs/
bash $CURRENT_PATH/verify_file_list.sh
if [ $? -eq 0 ];then
    echo "The install-package is absolutely correct, continue to install"
else
    echo "Error: the install-package is not absolutely correct, abort to install"
    exit 1
fi

echo "****Please select current operating system type****"
echo "[1] CentOS"
echo "[2] Ubuntu"
echo "[3] Redhat"
select_system

select_openstack_version

check_os_version

if [ "$SYS_SELE" == "1" ] ||  [ "$SYS_SELE" == "3" ]; then
  check_python_version
fi

function change_mode_and_owner(){
    for file in `ls $1`
    do
        if [ -d $1"/"$file ]; then
            chmod 500 $1"/"$file
            if [ $OPENSTACK_VERSION -eq 10 ]; then
                chown openstack:openstack $1"/"$file
            else
                chown neutron:neutron $1"/"$file
            fi
            change_mode_and_owner $1"/"$file
        else
            chmod 400 $1"/"$file
            if [ $OPENSTACK_VERSION -eq 10 ]; then
                chown openstack:openstack $1"/"$file
            else
                chown neutron:neutron $1"/"$file
            fi
        fi
    done
}

function change_mode_and_owner_read(){
    for file in `ls $1`
    do
        if [ -d $1"/"$file ]; then
            change_mode_and_owner_read $1"/"$file
        else
            chmod 444 $1"/"$file
            if [ $OPENSTACK_VERSION -eq 10 ]; then
                chown openstack:openstack $1"/"$file
            else
                chown neutron:neutron $1"/"$file
            fi
        fi
    done
}

function fix_plugin_db(){
    echo -e "+ Please input mysql username: \c"
    read username
    echo -e "+ Please input mysql password: \c"
    read -s password
    version_flag=`mysql -u$username -p$password -e "SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA= 'neutron' AND TABLE_NAME = 'huawei_ac_alembic_version';"`
    if [[ -n "$version_flag" ]]; then
        version_num=`mysql -u$username -p$password -e "SELECT version_num FROM neutron.huawei_ac_alembic_version;" | awk '{print $1}' | sed -n '2p'`
    else
        version_num=''
    fi
}

INSTALL_PATH=$(cd `dirname $0`; cd ../; pwd)
EGG_VERSION=$(grep '^Version' $INSTALL_PATH/PKG-INFO | awk '{print $2}')
PYTHON_VERSION=$(python -c "import sys; print ('py%s.%s' % (sys.version_info.major, sys.version_info.minor))")
NETWORKING_HUAWEI_EGG=$PYTHON_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info

find  $INSTALL_PATH/tools/networking_huawei_config.txt  ! -type f  -a  ! -type d -exec  ls -l {} \;
find  $INSTALL_PATH/tools/networking_huawei_config.txt -type f -exec sed  -i  -e "s/\x0D$//g"  -e 's/^M$//g'  {} \;
find  $INSTALL_PATH/tools/networking_huawei_config.txt -type f -exec echo  {} \;

cd /etc/neutron/
cp -af neutron.conf backup_neutron.conf.tmp
cd /etc/neutron/plugins/ml2/
cp -af ml2_conf.ini  backup_ml2_conf.ini.tmp

bash $INSTALL_PATH/tools/networking_huawei_uninstall.sh $SYS_SELE

echo "****Install networking huawei plugin begin****"
#exec setup.py to install
echo "****Step1: Execute setup script****"
cd ${INSTALL_PATH}
if [ $OPENSTACK_VERSION -eq 12 ]; then
    python setup.py install --prefix=/usr 1>/dev/null
else
    python setup.py install 1>/dev/null
fi

#change python file mode to 400 and owner to neutron
if [ $OPENSTACK_VERSION -eq 8 ]; then
    change_mode_and_owner_read $NETWORKING_HUAWEI
else
    change_mode_and_owner $NETWORKING_HUAWEI
fi
change_mode_and_owner_read $NETWORKING_HUAWEI_EGG

if [ "$SYS_SELE" == "2" ] ; then
    change_mode_and_owner $UBUNTU_PYTHON_PATH/networking_huawei/
    change_mode_and_owner_read $UBUNTU_PYTHON_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info
fi

if [ $OPENSTACK_VERSION -eq 10 ]; then
    chown openstack:openstack $NETWORKING_HUAWEI
    chown openstack:openstack $NETWORKING_HUAWEI_EGG
else
    chown neutron:neutron $NETWORKING_HUAWEI
    chown neutron:neutron $NETWORKING_HUAWEI_EGG
fi

oslo-config-generator --config-file ${INSTALL_PATH}/etc/oslo-config-generator/huawei_driver.ini > /dev/null 2>&1
mv ${INSTALL_PATH}/etc/huawei_driver_config.ini.sample /etc/neutron/huawei_driver_config.ini
sed -i "s#\#\(OPS_version =\).*#\1 ${OPS_VERSION_DICT[${OPENSTACK_VERSION}]}#" /etc/neutron/huawei_driver_config.ini

#upgrade database
echo "****Step2: Upgrade database****"
if [ ! -e /usr/local/bin/kolla_start ]; then
    fix_plugin_db
fi

db_upgrade_flag=`neutron-db-manage --subproject networking-huawei history | grep "$version_num"`
if [[ -n "$db_upgrade_flag" ]]; then
    neutron-db-manage --subproject networking-huawei upgrade head
    modify_action="ALTER "
    modify_target="TABLE "
    db_modify_sql=${modify_action}${modify_target}"neutron.huawei_ac_plugin MODIFY COLUMN data LONGBLOB;"
    mysql -u$username -p$password -e "${db_modify_sql}"
else
    echo "warning: the database already be upgraded, no need to upgrade again"
fi

#generate config file
echo "****Step3: Generate configuration file****"


sed -i '/^#.*value)$/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^# From networking_huawei.ac_config/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#$/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#token_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#token_retry.*/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#error_retry_interval.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#error_retry_interval.*/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#error_retry_count.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#error_retry_count.*/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#neutron_sync_enable_white_list.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#neutron_sync_enable_white_list.*/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#ac_detect_period.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#ac_detect_period.*/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^#timeout_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#timeout_retry.*/d' /etc/neutron/huawei_driver_config.ini

#change config file mode to 600
chmod 600 /etc/neutron/huawei_driver_config.ini

#change config file owner to neutron
if [ $OPENSTACK_VERSION -eq 10 ]; then
    chown openstack:openstack /etc/neutron/huawei_driver_config.ini
else
    chown neutron:neutron /etc/neutron/huawei_driver_config.ini
fi

echo "****Generate whitelist configuration file****"
cp -f ${INSTALL_PATH}/tools/whitelist_sample.ini /etc/neutron/whitelist.ini

#change config file mode to 600
chmod 600 /etc/neutron/whitelist.ini

#change config file owner to neutron
if [ $OPENSTACK_VERSION -eq 10 ]; then
    chown openstack:openstack /etc/neutron/whitelist.ini
else
    chown neutron:neutron /etc/neutron/whitelist.ini
fi

#change owner /root/networking-huawei
if [ $OPENSTACK_VERSION -eq 10 ]; then
    chown openstack:openstack /root/networking-huawei -R
else
    chown neutron:neutron /root/networking-huawei
fi

#modify config file
echo "****Step4: Modify config setting****"

server_ip=$(grep "^rpc_server_ip[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
RPC_SERVER_IP=${server_ip#*rpc_server_ip*=}
if [ -n "$RPC_SERVER_IP" ]; then
    sed -i "s/#\(rpc_server_ip =\).*/\1 $RPC_SERVER_IP/" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: rpc_server_ip is not setted"
fi


hostip=$(grep "^host_ip[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
HOST_IP=${hostip#*host_ip*=}
if [ -n "$HOST_IP" ]; then
    sed -i "s/#\(host_ip =\).*/\1 $HOST_IP/" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: host_ip is not setted"
fi

echo "Please config iMaster NCE-Fabric account"
echo "Please enter username:"
read USERNAME
if [ -n "$USERNAME" ]; then
    sed -i "s/#\(ac_auth_username =\).*/\1 $USERNAME/" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: username is not setted"
fi

echo "Please enter password:"
read -s PASSWORD
echo "processing... please wait"
PASSWORD_ENCRYPT=$(python ${INSTALL_PATH}/tools/encode.py "$PASSWORD" "account_passwd")
sed -i "s#\#ac_auth_password.=.*#ac_auth_password = $PASSWORD_ENCRYPT#g" /etc/neutron/huawei_driver_config.ini

echo "Please config OpenStack tenant name(Advice: admin tenant)"
echo "Please enter tenant name:"
read TENANTNAME
if [ -n "$TENANTNAME" ]; then
    sed -i "s/#\(keystone_tenant =\).*/\1 $TENANTNAME/" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: tenant is not setted"
fi

echo "Please config OpenStack user name(Advice: admin user)"
echo "Please enter user name:"
read USERNAME
if [ -n "$USERNAME" ]; then
    sed -i "s/#\(keystone_user =\).*/\1 $USERNAME/" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: username is not setted"
fi

echo "Please enter OpenStack user password(Advice: admin user password):"
echo "Please enter user password:"
read -s PASSWORD
echo "processing... please wait"
PASSWORD_ENCRYPT=$(python ${INSTALL_PATH}/tools/encode.py "$PASSWORD" "keystone_auth_passwd")
sed -i "s#\#keystone_passwd.=.*#keystone_passwd = $PASSWORD_ENCRYPT#g" /etc/neutron/huawei_driver_config.ini

websocket_key_password=$(grep "^websocket_key_password[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
WEBSOCKET_KEY_PASSWORD=${websocket_key_password#*websocket_key_password*=}
if [ -n "WEBSOCKET_KEY_PASSWORD" ]; then
    sed -i "s&^#websocket_key_password[[:space:]]*=.*&websocket_key_password = $WEBSOCKET_KEY_PASSWORD&g" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: websocket_key_password is not setted"
fi

auth_url=$(grep "^auth_url[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
AUTH_URL=${auth_url#*auth_url*=}
if [ -n "$AUTH_URL" ]; then
    sed -i "s&^#auth_url[[:space:]]*=.*&auth_url = $AUTH_URL&g" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: auth_url is not setted"
fi

cloud_name=$(grep "^cloud_name[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
CLOUD_NAME=${cloud_name#*cloud_name*=}
if [ -n "$CLOUD_NAME" ]; then
    sed -i "s/#\(cloud_name =\).*/\1 $CLOUD_NAME/" /etc/neutron/huawei_driver_config.ini
else
    echo "Error: cloud_name is not setted"
fi

request_timeout=$(grep "^request_timeout[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
REQUEST_TIMEOUT=${request_timeout#*request_timeout*=}
if [ -n "$REQUEST_TIMEOUT" ]; then
    sed -i "s/#\(request_timeout =\).*/\1 $REQUEST_TIMEOUT/" /etc/neutron/huawei_driver_config.ini
fi

token_retry=$(grep "^token_retry[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
TOKEN_RETRY=${token_retry#*token_retry*=}
if [ -n "$TOKEN_RETRY" ]; then
    sed -i "s/#\(token_retry =\).*/\1 $TOKEN_RETRY/" /etc/neutron/huawei_driver_config.ini
fi

ac_response_time=$(grep "^ac_response_time[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
AC_RESPONSE_TIME=${ac_response_time#*ac_response_time*=}
if [ -n "$AC_RESPONSE_TIME" ]; then
    sed -i "s/#\(ac_response_time =\).*/\1 $AC_RESPONSE_TIME/" /etc/neutron/huawei_driver_config.ini
fi

error_retry_interval=$(grep "^error_retry_interval[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
ERROR_RETRY_INTERVAL=${error_retry_interval#*error_retry_interval*=}
if [ -n "$ERROR_RETRY_INTERVAL" ]; then
    sed -i "s/#\(error_retry_interval =\).*/\1 $ERROR_RETRY_INTERVAL/" /etc/neutron/huawei_driver_config.ini
fi

error_retry_count=$(grep "^error_retry_count[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
ERROR_RETRY_COUNT=${error_retry_count#*error_retry_count*=}
if [ -n "$ERROR_RETRY_COUNT" ]; then
    sed -i "s/#\(error_retry_count =\).*/\1 $ERROR_RETRY_COUNT/" /etc/neutron/huawei_driver_config.ini
fi

enable_snat=$(grep "^enable_snat[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
ENABLE_SNAT=${enable_snat#*enable_snat*=}
if [ -n "$ENABLE_SNAT" ]; then
    sed -i "s/#\(enable_snat =\).*/\1 $ENABLE_SNAT/" /etc/neutron/huawei_driver_config.ini
fi

physical_network=$(grep "^physical_network[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
PHYSICAL_NETWORK=${physical_network#*physical_network*=}
if [ -n "$PHYSICAL_NETWORK" ]; then
    sed -i "s/#\(physical_network =\).*/\1 $PHYSICAL_NETWORK/" /etc/neutron/huawei_driver_config.ini
fi

neutron_sync_time=$(grep "^neutron_sync_time[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
NEUTRON_SYNC_TIME=${neutron_sync_time#*neutron_sync_time*=}
if [ -n "$NEUTRON_SYNC_TIME" ]; then
    sed -i "s/#\(neutron_sync_time =\).*/\1 $NEUTRON_SYNC_TIME/" /etc/neutron/huawei_driver_config.ini
fi

neutron_sync_type=$(grep "^neutron_sync_type[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
NEUTRON_SYNC_TYPE=${neutron_sync_type#*neutron_sync_type*=}
if [ -n "$NEUTRON_SYNC_TYPE" ]; then
    sed -i "s/#\(neutron_sync_type =\).*/\1 $NEUTRON_SYNC_TYPE/" /etc/neutron/huawei_driver_config.ini
fi

ac_detect_period=$(grep "^ac_detect_period[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
AC_DETECT_PERIOD=${ac_detect_period#*ac_detect_period*=}
if [ -n "$AC_DETECT_PERIOD" ]; then
    sed -i "s/#\(ac_detect_period =\).*/\1 $AC_DETECT_PERIOD/" /etc/neutron/huawei_driver_config.ini
fi

vhost_user=$(grep "^vhost_user[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
VHOST_USER=${vhost_user#*vhost_user*=}
if [ -n "$VHOST_USER" ]; then
    sed -i "s/#\(vhost_user =\).*/\1 $VHOST_USER/" /etc/neutron/huawei_driver_config.ini
fi

enable_security_group=$(grep "^enable_security_group[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
ENABLE_SECURITY_GROUP=${enable_security_group#*enable_security_group*=}
if [ -n "$ENABLE_SECURITY_GROUP" ]; then
    sed -i "s/#\(enable_security_group =\).*/\1 $ENABLE_SECURITY_GROUP/" /etc/neutron/huawei_driver_config.ini
fi

security_group_sync_times=$(grep "^security_group_sync_times[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
SECURITY_GROUP_SYNC_TIMES=${security_group_sync_times#*security_group_sync_times*=}
if [ -n "$SECURITY_GROUP_SYNC_TIMES" ]; then
    sed -i "s/#\(security_group_sync_times =\).*/\1 $SECURITY_GROUP_SYNC_TIMES/" /etc/neutron/huawei_driver_config.ini
fi

network_black_list=$(grep "^network_black_list[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
NETWORK_BLACK_LIST=${network_black_list#*network_black_list*=}
if [ -n "$NETWORK_BLACK_LIST" ]; then
    sed -i "s/#\(network_black_list =\).*/\1 $NETWORK_BLACK_LIST/" /etc/neutron/huawei_driver_config.ini
fi

network_white_list=$(grep "^network_white_list[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
NETWORK_WHITE_LIST=${network_white_list#*network_white_list*=}
if [ -n "$NETWORK_WHITE_LIST" ]; then
    sed -i "s/#\(network_white_list =\).*/\1 $NETWORK_WHITE_LIST/" /etc/neutron/huawei_driver_config.ini
fi

network_list_matching=$(grep "^network_list_matching[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
NETWORK_LIST_MATCHING=${network_list_matching#*network_list_matching*=}
if [ -n "$NETWORK_LIST_MATCHING" ]; then
    sed -i "s/#\(network_list_matching =\).*/\1 $NETWORK_LIST_MATCHING/" /etc/neutron/huawei_driver_config.ini
fi

bare_metal_bond_mode=$(grep "^bare_metal_bond_mode[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
BARE_METAL_BOND_MODE=${bare_metal_bond_mode#*bare_metal_bond_mode*=}
if [ -n "$BARE_METAL_BOND_MODE" ]; then
    sed -i "s/#\(bare_metal_bond_mode =\).*/\1 $BARE_METAL_BOND_MODE/" /etc/neutron/huawei_driver_config.ini
fi

external_access_mode=$(grep "^external_access_mode[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
EXTERNAL_ACCESS_MODE=${external_access_mode#*external_access_mode*=}
if [ -n "$EXTERNAL_ACCESS_MODE" ]; then
    sed -i "s/#\(external_access_mode =\).*/\1 $EXTERNAL_ACCESS_MODE/" /etc/neutron/huawei_driver_config.ini
fi

enable_ce1800v_dhcp=$(grep "^enable_ce1800v_dhcp[[:space:]]*=" ${INSTALL_PATH}/tools/networking_huawei_config.txt)
ENABLE_CE1800V_DHCP=${enable_ce1800v_dhcp#*enable_ce1800v_dhcp*=}
if [ -n "$ENABLE_CE1800V_DHCP" ]; then
    sed -i "s/#\(enable_ce1800v_dhcp =\).*/\1 $ENABLE_CE1800V_DHCP/" /etc/neutron/huawei_driver_config.ini
fi

if [ $OPENSTACK_VERSION -eq 10 ]; then
    sed -i "s/#\(cmcc_env =\).*/\1 true/" /etc/neutron/huawei_driver_config.ini
fi

echo "Huawei plugin config, please check"
echo "+--------------------------------+"
grep "^[^#]" /etc/neutron/huawei_driver_config.ini
echo "+--------------------------------+"

chcon -t etc_t /etc/neutron/huawei_driver_config.ini > /dev/null 2>&1

# modify init file
echo "****Step5: Modify boot file****"
if [ "$SYS_SELE" == "1" ] ; then
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "Error: neutron-server.service does not exist."
    fi
    cp neutron-server.service backup_neutron-server.service.bak
    signal=$(grep "^KillSignal[[:space:]]*=" /usr/lib/systemd/system/neutron-server.service)
    if [ -n "$signal" ]; then
        sed -i "s/.*\(KillSignal=\).*/\1SIGKILL/" /usr/lib/systemd/system/neutron-server.service
    else
        sed -i 'N;/\[Service\]/a\KillSignal=SIGKILL' /usr/lib/systemd/system/neutron-server.service
    fi
    NEUTRON_SERVER_SERVICE=/usr/lib/systemd/system/neutron-server.service
    EXEC_STOP="ps -ef | grep -w neutron-server | grep -w huawei_driver_config.ini | grep -v grep | awk '{if(\$2 != \" \"){print \"kill -9 \"\$2} else{exit}}' | sh"
    grep ExecStop $NEUTRON_SERVER_SERVICE
    if [ $? -eq 0 ]; then
        sed -i "s/.*\(ExecStop=\).*/\1$EXEC_STOP/" $NEUTRON_SERVER_SERVICE
    else
        sed -i "N;/\[Service\]/a\ExecStop=$EXEC_STOP" $NEUTRON_SERVER_SERVICE
    fi
    grep KillMode $NEUTRON_SERVER_SERVICE
    if [ $? -eq 0 ]; then
        sed -i "s/.*\(KillMode=\).*/\1control-group/" $NEUTRON_SERVER_SERVICE
    else
        sed -i "N;/\[Service\]/a\KillMode=control-group" $NEUTRON_SERVER_SERVICE
    fi
    EXTRA_CONF="\/etc\/neutron\/huawei_driver_config.ini"
    sed -i "s/\s*--config-file\s*$EXTRA_CONF//g" $CENTOS_NS_CUR
    if [ $OPENSTACK_VERSION -eq 6 -o $OPENSTACK_VERSION -eq 10 ]; then
        sed -i "s/^\(ExecStart=.*\)/\1 --config-file $EXTRA_CONF/g" $CENTOS_NS_CUR
    else
        ln -s $HUAWEI_INI_CUR $HUAWEI_CONF_CUR
    fi
elif [ "$SYS_SELE" == "2" ] ; then
    cd /etc/init/
    cp neutron-server.conf backup_neutron-server.conf.bak
    sed -i 's/\"$DAEMON_ARGS --log-file=\/var\/log\/neutron\/neutron-server.log.*/\"$DAEMON_ARGS --log-file=\/var\/log\/neutron\/neutron-server.log --config-file \/etc\/neutron\/huawei_driver_config.ini\"/g' neutron-server.conf
elif [ "$SYS_SELE" == "3" ]; then
    ln -s $HUAWEI_INI_CUR $HUAWEI_CONF_CUR
fi

# enable huawei plugin
echo "****Step6: Enable huawei plugin****"
cd /etc/neutron/plugins/ml2/
if [ ! -f ml2_conf.ini ]; then
    echo "ml2_conf.ini does not exist."
fi

cp -af backup_ml2_conf.ini.tmp  backup_ml2_conf.ini.bak
mech_drivers=$(grep "^mechanism_drivers[[:space:]]*=" ml2_conf.ini)
if [ -n "$mech_drivers" ]; then
    old_mech_drivers=`echo $mech_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g`
    if [[ ! $old_mech_drivers =~ huawei_ac_ml2 ]]; then
        sed -i "s/^mechanism_drivers[[:space:]]*=.*/mechanism_drivers = huawei_ac_ml2,$old_mech_drivers/g" ml2_conf.ini
    fi
else
    sed -i "/^\[ml2\]/a\mechanism_drivers = huawei_ac_ml2,openvswitch" ml2_conf.ini
fi

if [ -e $KOLLA_CONFIG_FILES/ml2_conf.ini ]; then
    if [ ! -e $KOLLA_CONFIG_FILES/ml2_conf.ini.bak ]; then
        cp -af $KOLLA_CONFIG_FILES/ml2_conf.ini $KOLLA_CONFIG_FILES/ml2_conf.ini.bak
    fi
    kolla_mechanism_drivers=`grep ^mechanism_drivers $KOLLA_CONFIG_FILES/ml2_conf.ini | cut -d "=" -f 2 | sed s/[[:space:]]//g`
    if [[ -n "$kolla_mechanism_drivers" ]]; then
        if [[ ! $kolla_mechanism_drivers =~ huawei_ac_ml2 ]]; then
            sed -i "s/^mechanism_drivers.*/mechanism_drivers = huawei_ac_ml2,$kolla_mechanism_drivers/" $KOLLA_CONFIG_FILES/ml2_conf.ini
        fi
    else
        sed -i "/^\[ml2\]/a\mechanism_drivers = huawei_ac_ml2,openvswitch" $KOLLA_CONFIG_FILES/ml2_conf.ini
    fi
fi

cd /etc/neutron/
if [ ! -f neutron.conf ]; then
    echo "neutron.conf does not exist."
fi
cp -af backup_neutron.conf.tmp backup_neutron.conf.bak
sed -i "/^vlan_transparent/d" neutron.conf
sed -i '/^api_extensions_path/d' neutron.conf
service_plugins=$(grep "^service_plugins[[:space:]]*=" neutron.conf)
old_service_plugin=`echo $service_plugins | cut -d "=" -f 2 | sed s/[[:space:]]//g`
old_plugin_string=${old_service_plugin//,/ }
old_plugin_array=($old_plugin_string)
if [ -n "$service_plugins" ]; then
    sed -i "s/^service_plugins[[:space:]]*=.*/service_plugins = huawei_ac_router/g" neutron.conf
else
    sed -i "4a\service_plugins = huawei_ac_router" neutron.conf
fi
sed -i '/^service_plugins.*/a\vlan_transparent = True' neutron.conf

if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
    if [ ! -e $KOLLA_CONFIG_FILES/neutron.conf.bak ]; then
        cp -af $KOLLA_CONFIG_FILES/neutron.conf $KOLLA_CONFIG_FILES/neutron.conf.bak
    fi
    kolla_service_plugins=`grep ^service_plugins $KOLLA_CONFIG_FILES/neutron.conf | cut -d "=" -f 2 | sed s/[[:space:]]//g`
    kolla_api_extensions_path=`grep ^api_extensions_path $KOLLA_CONFIG_FILES/neutron.conf | cut -d "=" -f 2 | sed s/[[:space:]]//g`

    kolla_service_plugins=`echo $kolla_service_plugins | sed 's/router,//g' | sed 's/,router//g' | sed 's/router//g'`
    if [[ ! $kolla_service_plugins =~ huawei_ac_router ]]; then
        if [[ -z "$kolla_service_plugins" ]]; then
            kolla_service_plugins="huawei_ac_router"
        else
            kolla_service_plugins=$kolla_service_plugins",huawei_ac_router"
        fi
    fi

    if [[ ! $kolla_api_extensions_path =~ ac/extensions/exroute ]]; then
        if [[ -z "$kolla_api_extensions_path" ]]; then
            kolla_api_extensions_path="$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute"
        else
            kolla_api_extensions_path=$kolla_api_extensions_path":$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute"
        fi
    fi

    if [[ ! $kolla_service_plugins =~ huawei_ac_ext ]]; then
        kolla_service_plugins=$kolla_service_plugins",huawei_ac_ext"
    fi

    if [[ ! $kolla_api_extensions_path =~ ac/extensions/sync ]]; then
        kolla_api_extensions_path=$kolla_api_extensions_path":$PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync"
    fi
fi

SERVICE_PLUGIN="huawei_ac_router"
API_EXTENSIONS_PATH=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute

if [ "$SYS_SELE" == "2" ] ; then
    if [ ! -f $API_EXTENSIONS_PATH ]; then
        API_EXTENSIONS_PATH="$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute"
        if [ ! -f $API_EXTENSIONS_PATH ]; then
            API_EXTENSIONS_PATH="$UBUNTU_PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute"
        fi
    fi
fi

# add huawei_ac_ext huawei_ac_sync_result huawei_ac_compare_result plugin
SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_ext"
SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_sync_result"
SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_compare_result"
if [ "$SYS_SELE" == "2" ] ; then
    if [ ! -f $PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync ]; then
        API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$UBUNTU_PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync"
    else
        API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync"
    fi
else
    API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync"
fi

# Add huawei_ac_portforwarding in Rocky or Train
if [ $OPENSTACK_VERSION -eq 9 ] || [ $OPENSTACK_VERSION -eq 11 ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_portforwarding"
fi

if [ $OPENSTACK_VERSION -eq 10 ]; then
    # add huawei_ac_config,huawei_ac_config_check plugin
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_config,huawei_ac_config_check"
    API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$PYTHON_PATH/networking_huawei/drivers/ac/extensions/config_check"
fi

# confirm to config firewall plugin
function install_firewall() {
    echo "Confirm to config firewall plugin(Please ensure firewall plugin installed)"
    check_input
    INSTALL_FW=$USER_INPUT
    if [ "$INSTALL_FW" == "y" ] || [ "$INSTALL_FW" == "Y" ] && [ $OPENSTACK_VERSION -ne 1 ]; then
        SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_fwaas"
        if [ "$API_EXTENSIONS_PATH" == "" ] ; then
            API_EXTENSIONS_PATH=$PYTHON_PATH/neutron_fwaas/extensions
        else
            API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$PYTHON_PATH/neutron_fwaas/extensions"
        fi

        if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
            plugins=`echo $service_plugins`
            for plugin in ${plugins//,/ }; do
                if [[ $plugin =~ firewall ]]; then
                    kolla_service_plugins=`echo $kolla_service_plugins | sed 's/'"$plugin"',//g' | sed 's/,'"$plugin"'//g' | sed 's/'"$plugin"'//g'`
                fi
            done
            if [[ ! $kolla_service_plugins =~ huawei_ac_fwaas ]]; then
                kolla_service_plugins=$kolla_service_plugins",huawei_ac_fwaas"
            fi
            if [[ ! $kolla_api_extensions_path =~ neutron_fwaas/extensions ]]; then
                kolla_api_extensions_path=$kolla_api_extensions_path":$PYTHON_PATH/neutron_fwaas/extensions"
            fi
        fi
    fi
}

if [ $OPENSTACK_VERSION -ne 12 ]; then
    install_firewall
fi

# confirm to config vpn plugin
echo "Confirm to config vpn plugin(Please ensure vpn plugin installed)"
check_input
INSTALL_VPN=$USER_INPUT
if [ "$INSTALL_VPN" == "y" ] || [ "$INSTALL_VPN" == "Y" ] && [ $OPENSTACK_VERSION -ne 1 ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_ipsecvpn"
    if [ "$API_EXTENSIONS_PATH" == "" ] ; then
        API_EXTENSIONS_PATH=$PYTHON_PATH/neutron_vpnaas/extensions
    else
        API_EXTENSIONS_PATH=${API_EXTENSIONS_PATH}":$PYTHON_PATH/neutron_vpnaas/extensions"
    fi

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
        plugins=`echo $service_plugins`
        for plugin in ${plugins//,/ }; do
            if [[ $plugin =~ vpnaas ]]; then
                kolla_service_plugins=`echo $kolla_service_plugins | sed 's/'"$plugin"',//g' | sed 's/,'"$plugin"'//g' | sed 's/'"$plugin"'//g'`
            fi
        done
        if [[ ! $kolla_service_plugins =~ huawei_ac_ipsecvpn ]]; then
            kolla_service_plugins=$kolla_service_plugins",huawei_ac_ipsecvpn"
        fi
        if [[ ! $kolla_api_extensions_path =~ neutron_vpnaas/extensions ]]; then
            kolla_api_extensions_path=$kolla_api_extensions_path":$PYTHON_PATH/neutron_vpnaas/extensions"
        fi
    fi
fi

# confirm to config qos plugin
echo "Config qos plugin(Support OpenStack Liberty, Mitaka, Newton, Ocata, Pike, Queens, Rocky, Train, Wallaby,
not Kilo, Please ensure QoS plugin installed)"
check_input
INSTALL_QOS=$USER_INPUT
if [ "$INSTALL_QOS" == "y" ] || [ "$INSTALL_QOS" == "Y" ] ; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_qos"
    qos=$(grep "^\[qos\]" neutron.conf)
    if [ -n "$qos" ]; then
        notify_drivers=$(grep "^notification_drivers[[:space:]]*=" neutron.conf)
        if [ -n "$notify_drivers" ]; then
            old_notify_drivers=`echo $notify_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g`
            if [[ ! $old_notify_drivers =~ huawei_ac_qos_driver ]]; then
                sed -i "s/^notification_drivers[[:space:]]*=.*/notification_drivers = huawei_ac_qos_driver,$old_notify_drivers/g" neutron.conf
            fi
        else
            sed -i "/^\[qos\]/a\notification_drivers = huawei_ac_qos_driver,message_queue" neutron.conf
        fi
    else
        echo >> neutron.conf
        echo "[qos]" >> neutron.conf
        notify_drivers=$(grep "^notification_drivers[[:space:]]*=" neutron.conf)
        if [ -n "$notify_drivers" ]; then
            old_notify_drivers=`echo $notify_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g`
            if [[ ! $old_notify_drivers =~ huawei_ac_qos_driver ]]; then
                sed -i "s/^notification_drivers[[:space:]]*=.*/notification_drivers = huawei_ac_qos_driver,$old_notify_drivers/g" neutron.conf
            fi
        else
            sed -i "/^\[qos\]/a\notification_drivers = huawei_ac_qos_driver,message_queue" neutron.conf
        fi
    fi

    cd /etc/neutron/plugins/ml2/
    extent_drivers=$(grep "^extension_drivers[[:space:]]*=" ml2_conf.ini)
    if [ -n "$extent_drivers" ]; then
        old_extent_drivers=`echo $extent_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g`
        if [[ ! $old_extent_drivers =~ qos ]]; then
            sed -i "s/^extension_drivers[[:space:]]*=.*/extension_drivers = qos,$old_extent_drivers/g" ml2_conf.ini
        fi
    else
        sed -i "/^\[ml2\]/a\extension_drivers = qos" ml2_conf.ini
    fi

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf -a -e $KOLLA_CONFIG_FILES/ml2_conf.ini ]; then
        plugins=`echo $service_plugins`
        for plugin in ${plugins//,/ }; do
            if [[ $plugin =~ qos ]]; then
                kolla_service_plugins=`echo $kolla_service_plugins | sed 's/'"$plugin"',//g' | sed 's/,'"$plugin"'//g' | sed 's/'"$plugin"'//g'`
            fi
        done
        if [[ ! $kolla_service_plugins =~ huawei_ac_qos ]]; then
            kolla_service_plugins=$kolla_service_plugins",huawei_ac_qos"
        fi
        if [[ -n `grep "^\[qos\]" $KOLLA_CONFIG_FILES/neutron.conf` ]]; then
            kolla_notification_drivers=`grep ^notification_drivers $KOLLA_CONFIG_FILES/neutron.conf | cut -d "=" -f 2 | sed s/[[:space:]]//g`
            if [[ -n "$kolla_notification_drivers" ]]; then
                if [[ ! $kolla_notification_drivers =~ huawei_ac_qos_driver ]]; then
                    sed -i "s/^notification_drivers.*/notification_drivers = huawei_ac_qos_driver,$kolla_notification_drivers/g" $KOLLA_CONFIG_FILES/neutron.conf
                fi
            else
                sed -i "/^\[qos\]/a\notification_drivers = huawei_ac_qos_driver,message_queue" $KOLLA_CONFIG_FILES/neutron.conf
            fi
        else
            echo -e "\n[qos]" >> $KOLLA_CONFIG_FILES/neutron.conf
            echo -e "notification_drivers = huawei_ac_qos_driver,message_queue" >> $KOLLA_CONFIG_FILES/neutron.conf
        fi
        kolla_extension_drivers=`grep ^extension_drivers $KOLLA_CONFIG_FILES/ml2_conf.ini | cut -d "=" -f 2 | sed s/[[:space:]]//g`
        if [[ -n "$kolla_extension_drivers" ]]; then
            if [[ ! $kolla_extension_drivers =~ qos ]]; then
                sed -i "s/^extension_drivers.*/extension_drivers = qos,$kolla_extension_drivers/g" $KOLLA_CONFIG_FILES/ml2_conf.ini
            fi
        else
            sed -i "/^\[ml2\]/a\extension_drivers = qos" $KOLLA_CONFIG_FILES/ml2_conf.ini
        fi
    fi
fi

# confirm to config dnat plugin
echo "Config DNAT plugin(support OpenStack Mitak, Train and Wallaby)"
check_input
INSTALL_DNAT=$USER_INPUT
if [ "$INSTALL_DNAT" == "y" ] || [ "$INSTALL_DNAT" == "Y" ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_dnat"

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
        kolla_service_plugins=$kolla_service_plugins",huawei_ac_dnat"
    fi
fi

# confirm to config vpc_connection plugin
echo "Confirm to config vpc_connection plugin(Please ensure vpc_connection plugin installed)"
check_input
INSTALL_VPC_CONNECTION=$USER_INPUT
if [ "$INSTALL_VPC_CONNECTION" == "y" ] || [ "$INSTALL_VPC_CONNECTION" == "Y" ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_vpc_connection"

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
        kolla_service_plugins=$kolla_service_plugins",huawei_ac_vpc_connection"
    fi
fi

# confirm to config snat plugin
echo "Confirm to config snat plugin(Please ensure snat plugin installed)"
check_input
INSTALL_SNAT=$USER_INPUT
if [ "$INSTALL_SNAT" == "y" ] || [ "$INSTALL_SNAT" == "Y" ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_snat"

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
        kolla_service_plugins=$kolla_service_plugins",huawei_ac_snat"
    fi
fi

# confirm to config bgp_route plugin
echo "Confirm to config bgp_route plugin(Please ensure bgp_route plugin installed)"
check_input
INSTALL_BGP_ROUTE=$USER_INPUT
if [ "$INSTALL_BGP_ROUTE" == "y" ] || [ "$INSTALL_BGP_ROUTE" == "Y" ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_bgp_route"

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
        kolla_service_plugins=$kolla_service_plugins",huawei_ac_bgp_route"
    fi
fi

# confirm to config l2br plugin
echo "Confirm to config l2br plugin(Please ensure l2br plugin installed)"
check_input
INSTALL_L2BR=$USER_INPUT
if [ "$INSTALL_L2BR" == "y" ] || [ "$INSTALL_L2BR" == "Y" ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}",huawei_ac_l2br"

    if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
        kolla_service_plugins=$kolla_service_plugins",huawei_ac_l2br"
    fi
fi

# confirm to config huawei_ac_firewall_rule driver
function install_huawei_ac_firewall() {
    echo "Confirm to config huawei_ac_firewall_rule driver(Support OpenStack Kilo, Mitaka, Pike)"
    check_input
    INSTALL_FIREWALL_RULE=$USER_INPUT
    if [ "$INSTALL_FIREWALL_RULE" == "y" ] || [ "$INSTALL_FIREWALL_RULE" == "Y" ]; then
        extent_drivers=$(grep "^extension_drivers[[:space:]]*=" /etc/neutron/plugins/ml2/ml2_conf.ini)
        if [ -n "$extent_drivers" ]; then
            old_extent_drivers=`echo $extent_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g`
            if [[ ! $old_extent_drivers =~ huawei_ac_firewall_rule ]]; then
                sed -i "s/^extension_drivers[[:space:]]*=.*/extension_drivers = $old_extent_drivers,huawei_ac_firewall_rule/g" /etc/neutron/plugins/ml2/ml2_conf.ini
            fi
        else
            sed -i "/^\[ml2\]/a\extension_drivers = huawei_ac_firewall_rule" /etc/neutron/plugins/ml2/ml2_conf.ini
        fi
    fi
}

if [ $OPENSTACK_VERSION -ne 12 ]; then
    install_huawei_ac_firewall
fi

cd /etc/neutron/
add_service_plugin=""
for(( i=0;i<${#old_plugin_array[@]};i++))do
    huawei_config=${old_plugin_array[i]}
    if [[ ! "${SERVICE_PLUGIN}" =~ "${huawei_config}" ]]; then
        if [[ ! "${huawei_config}" =~ (firewall|vpnaas) ]] && [[ ! "${huawei_config}" =~ "huawei" ]]; then
            add_service_plugin=${add_service_plugin}",${huawei_config}"
        fi
    fi
done

if [ -n "${add_service_plugin}" ]; then
    SERVICE_PLUGIN=${SERVICE_PLUGIN}"${add_service_plugin}"
fi

sed -i "s/^service_plugins[[:space:]]*=.*/service_plugins = $SERVICE_PLUGIN/g" neutron.conf

if [[ "${SERVICE_PLUGIN}" =~ "ipv6_ns_qos_policy" ]]; then
    sed -i "s/^service_provider[[:space:]]*=[[:space:]]*IPV6_NS_QOS_POLICY.*/service_provider = $IPV6_NS_QOS_POLICY_DRIVER/g" neutron.conf
fi

if [ "$API_EXTENSIONS_PATH" != "" ] ; then
    sed -i "/^service_plugins.*/a\api_extensions_path = $API_EXTENSIONS_PATH" neutron.conf
fi

if [ -e $KOLLA_CONFIG_FILES/neutron.conf ]; then
    if [[ -n `grep ^service_plugins $KOLLA_CONFIG_FILES/neutron.conf` ]]; then
        sed -i "s/^service_plugins.*/service_plugins = $kolla_service_plugins/g" $KOLLA_CONFIG_FILES/neutron.conf
    else
        sed -i "/^\[DEFAULT\]/a\service_plugins = $kolla_service_plugins" $KOLLA_CONFIG_FILES/neutron.conf
    fi

    if [[ -n `grep ^api_extensions_path $KOLLA_CONFIG_FILES/neutron.conf` ]]; then
        sed -i "s#^api_extensions_path.*#api_extensions_path = $kolla_api_extensions_path#g" $KOLLA_CONFIG_FILES/neutron.conf
    else
        sed -i "/^service_plugins/a\api_extensions_path = $kolla_api_extensions_path" $KOLLA_CONFIG_FILES/neutron.conf
    fi
fi


# restart neutron server
if [ ! -e /usr/local/bin/kolla_start ]; then
    echo "****Step7: Restart neutron server****"
    case "$SYS_SELE" in
    "1")
        cd /root/
        setenforce 0
        systemctl daemon-reload
        systemctl restart neutron-server.service
        ;;
    "2" | "3")
        service neutron-server restart
        ;;
    esac
fi

rm -rf $INSTALL_PATH/build $INSTALL_PATH/networking_huawei.egg-info

if [ -e /usr/local/bin/kolla_start ]; then
    exec=`grep ^exec /usr/local/bin/kolla_start`
    if [[ ! $exec =~ huawei_driver_config.ini ]]; then
        sed -i "s#^\(exec.*\)#\1 --config-file /etc/neutron/huawei_driver_config.ini#g" /usr/local/bin/kolla_start
    fi
fi

echo "****Install huawei plugin end****"
