#!/bin/bash

UBUNTU_PYTHON_PATH=/usr/local/lib/python2.7/dist-packages
CENTOS_NS_PATH=/usr/lib/systemd/system
CENTOS_NS_BAK=$CENTOS_NS_PATH/backup_neutron-server.service.bak
CENTOS_NS_CUR=$CENTOS_NS_PATH/neutron-server.service
UBUNTU_NS_BAK=/etc/init/backup_neutron-server.conf.bak
UBUNTU_NS_CUR=/etc/init/neutron-server.conf
ML2_CONF_PATH=/etc/neutron/plugins/ml2
ML2_CONF_BAK=$ML2_CONF_PATH/backup_ml2_conf.ini.bak
ML2_CONF_CUR=$ML2_CONF_PATH/ml2_conf.ini
NEUTRON_CONF_PATH=/etc/neutron
NEUTRON_CONF_BAK=$NEUTRON_CONF_PATH/backup_neutron.conf.bak
NEUTRON_CONF_TMP=$NEUTRON_CONF_PATH/backup_neutron.conf.tmp
NEUTRON_CONF_CUR=$NEUTRON_CONF_PATH/neutron.conf
HUAWEI_INI_CUR=$NEUTRON_CONF_PATH/huawei_driver_config.ini
HUAWEI_CONF_CUR=/usr/share/neutron/server/huawei_driver_config.conf
KOLLA_CONFIG_FILES=/var/lib/kolla/config_files
IPV6_NS_QOS_POLICY_DRIVER_BAK=IPV6_NS_QOS_POLICY:test:neutron.services.ipv6_ns_qos_policy.drivers.test_driver.TestDriver:default

function select_system(){
    while true; do
        echo -e "Press [1/2/3] to select systemc type: \c"
        read SYS_SELE
        case "$SYS_SELE" in
        "1" | "2" | "3")
            break;;
        esac
    done
}

echo "****Begin to check the install-package absolutely correct or not****"
CURRENT_PATH=$(cd $(dirname $0); pwd)
source $CURRENT_PATH/common_function.sh
PYTHON_VERSION=$(python -c "import sys; print ('py%s.%s' % (sys.version_info.major, sys.version_info.minor))")
INSTALL_PATH=$(cd `dirname $0`; cd ../; pwd)
EGG_VERSION=$(grep '^Version' $INSTALL_PATH/PKG-INFO | awk '{print $2}')
bash $CURRENT_PATH/verify_file_list.sh
if [ $? -eq 0 ];then
    echo "The install-package is absolutely correct, continue to install"
else
    echo "Error: the install-package is not absolutely correct, abort to install"
    exit 1
fi

if [[ -z $1 ]]; then
    echo "****Please select current operating system type****"
    echo "[1] CentOS"
    echo "[2] Ubuntu"
    echo "[3] Redhat"
    select_system
else
    SYS_SELE=$1
fi

echo "****Uninstall networking huawei plugin begin****"

case "$SYS_SELE" in
"1" | "3")
    rm -rf $PYTHON_PATH/networking_huawei
    rm -rf $PYTHON_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info
    ;;
"2")
    PYTHON_PATH=$UBUNTU_PYTHON_PATH
    rm -rf $UBUNTU_PYTHON_PATH/networking_huawei
    rm -rf $UBUNTU_PYTHON_PATH/networking_huawei-3.1.0-py2.7.egg-info
    ;;
esac

if [ -e $HUAWEI_INI_CUR ]; then
    rm -f $HUAWEI_INI_CUR
fi
if [ -L $HUAWEI_CONF_CUR ]; then
    rm -f $HUAWEI_CONF_CUR
fi

echo "****Step1 Modify init file****"
case "$SYS_SELE" in
"1" | "3")
    if [ -f $CENTOS_NS_BAK ]; then
        cp -f $CENTOS_NS_BAK $CENTOS_NS_CUR
        rm -f $CENTOS_NS_BAK
    else
        echo "[WARNING]$CENTOS_NS_BAK does not exist."
        EXTRA_CONF="\/etc\/neutron\/huawei_driver_config.ini"
        sed -i "s/\s*--config-file\s*$EXTRA_CONF//g" $CENTOS_NS_CUR
    fi
    ;;
"2")
    if [ -f $UBUNTU_NS_BAK ]; then
        cp -f $UBUNTU_NS_BAK $UBUNTU_NS_CUR
        rm -f $UBUNTU_NS_BAK
    else
        echo "[WARNING]$UBUNTU_NS_BAK does not exist."
    fi
    ;;
esac

echo "****Step2 Unable huawei plugin****"
####################
##@1 配置文件
##@2 配置项名字
##@3 华为配置内容
##@4 需要回滚成的配置
##@5 配置项分隔符
##@6 配置项标签
####################
function rollback_config()
{
    current_file=$1
    config_name=$2
    huawei_config_lists=$3
    rollback_config_lists=$4
    OLD_IFS="$IFS"
    IFS=" "
    huawei_config_list=($huawei_config_lists)
    rollback_config_list=($rollback_config_lists)
    IFS="$OLD_IFS"
    seperator=$5
    label=$6
    current_config=`sed "/^$config_name[[:space:]]*=/!d;s/.*=//" $current_file`
    new_config=`echo $current_config | sed -e "s/[[:space:]]//g"`
    new_config=`echo $new_config | sed -e "s|^$seperator||" | sed -e "s|$seperator$||"`
    for i in ${rollback_config_list[@]}
    do
        if [[ "$i" == "firewall" ]];then
            if [[ ! "${new_config}" =~ huawei_ac_fwaas ]]  && [[ "${new_config}" =~ huawei_ac_router ]];then
                new_config+=','huawei_ac_fwaas
            fi
        fi
        if [[ "$i" == "vpnaas" ]]  ;then
            if [[ ! "${new_config}" =~ huawei_ac_ipsecvpn ]] &&  [[ "${new_config}" =~ huawei_ac_router ]];then
                new_config+=','huawei_ac_ipsecvpn
            fi
        fi
    done
    new_plugin_array=($new_config)
    for i in ${new_plugin_array[@]}
    do
        if [[ "$i" == "firewall" ]];then
            rollback_config_list[2]=firewall
        fi
        if [[ "$i" == "vpnaas" ]];then
            rollback_config_list[3]=vpnaas
        fi
    done
    ##remove huawei config
    for(( i=0;i<${#huawei_config_list[@]};i++))do
        huawei_config=${huawei_config_list[i]}
        rollback_to=${rollback_config_list[i]}
        if [[ $rollback_to != "" ]];then
            new_config=`echo $new_config | sed -e "s|^$huawei_config$seperator|$rollback_to$seperator|g"`
            new_config=`echo $new_config | sed -e "s|$seperator$huawei_config$seperator|$seperator$rollback_to$seperator|g"`
            new_config=`echo $new_config | sed -e "s|$seperator$huawei_config$|$seperator$rollback_to|g"`
            new_config=`echo $new_config | sed -e "s|^$huawei_config$|$rollback_to|g"`
        else
            new_config=`echo $new_config | sed -e "s|^$huawei_config$seperator||g"`
            new_config=`echo $new_config | sed -e "s|$seperator$huawei_config$seperator|$seperator|g"`
            new_config=`echo $new_config | sed -e "s|$seperator$huawei_config$||g"`
            new_config=`echo $new_config | sed -e "s|^$huawei_config$||g"`
        fi
    done
    new_config=`echo $new_config | sed -e "s/^$seperator//" | sed -e "s/$seperator$//"`
    ##write into config file
    if [[ -n "$current_config" ]]; then
        if [[ -n "$new_config" ]]; then
            sed -i "s#^$config_name[[:space:]]*=.*#$config_name = $new_config#g" $current_file
        else
            sed -i "s#^$config_name[[:space:]]*=.*#\#$config_name = #g" $current_file
        fi
    else
        if [[ -n "$new_config" ]]; then
            new_config=`echo $new_config | sed 's#/#\\/#g'`
            sed -i "/^\[${label}\]/a $config_name = $new_config" $current_file
        fi
    fi
    echo "original config is: $current_config"
    echo "rollback config to: $new_config"
    echo ""
}

##mechanism_drivers
echo "  unable huawei mechanism drivers"
mechanism_drivers_name=mechanism_drivers
huawei_mechanism_list=(huawei_ac_ml2)
rollback_mechanism_list=("")
rollback_config $ML2_CONF_CUR $mechanism_drivers_name "${huawei_mechanism_list[*]}" "${rollback_mechanism_list[*]}" ',' 'ml2'

##extension_drivers
echo "  unable huawei extension_drivers"
extension_drivers_name=extension_drivers
huawei_extension_drivers_list=(huawei_ac_binding huawei_ac_status_port huawei_ac_status_firewall_policy huawei_ac_firewall_rule)
rollback_extension_list=("" "" "" "")
rollback_config $ML2_CONF_CUR $extension_drivers_name "${huawei_extension_drivers_list[*]}" "${rollback_extension_list[*]}" ',' 'ml2'

##policy_drivers
echo "  unable huawei policy_drivers"
policy_drivers_name=policy_drivers
huawei_policy_drivers_list=(huawei_ac_gbp huawei_ac_gbp_external)
rollback_policy_list=("" "")
rollback_config $NEUTRON_CONF_CUR $policy_drivers_name "${huawei_policy_drivers_list[*]}" "${rollback_policy_list[*]}" ',' 'group_policy'

##service_plugins
echo "  unable huawei service_plugins"
service_plugins_name=service_plugins
huawei_service_plugins_list=(huawei_ac_router huawei_ac_ext huawei_ac_fwaas huawei_ac_ipsecvpn huawei_ac_qos huawei_ac_dnat huawei_ac_vpc_connection huawei_ac_bgp_route huawei_ac_l2br huawei_ac_snat huawei_ac_portforwarding huawei_ac_flow_mirror huawei_ac_sync_result huawei_ac_compare_result huawei_ac_config huawei_ac_config_check)
service_plugins_bak=$(grep "^service_plugins[[:space:]]*=" $NEUTRON_CONF_TMP)
old_service_plugin=`echo $service_plugins_bak | cut -d "=" -f 2 | sed s/[[:space:]]//g`
old_plugin_string=${old_service_plugin//,/ }
old_plugin_array=($old_plugin_string)
rollback_service_list=(router "" "" "" "" "" "" "" "" "" "")
for i in ${old_plugin_array[@]}
do
    if [[ "$i" == "firewall" ]];then
        rollback_service_list[2]=firewall
    fi
    if [[ "$i" == "vpnaas" ]]; then
        rollback_service_list[3]=vpnaas
    fi
done
rollback_config $NEUTRON_CONF_CUR $service_plugins_name "${huawei_service_plugins_list[*]}" "${rollback_service_list[*]}" ',' 'DEFAULT' $new_config

SERVICE_PLUGIN=`grep ^service_plugins $NEUTRON_CONF_CUR`
if [[ "${SERVICE_PLUGIN}" =~ "ipv6_ns_qos_policy" ]]; then
    sed -i "s/^service_provider[[:space:]]*=[[:space:]]*IPV6_NS_QOS_POLICY.*/service_provider = $IPV6_NS_QOS_POLICY_DRIVER_BAK/g" $NEUTRON_CONF_CUR
fi

##api_extensions_path
echo "  unable huawei api_extensions_path"
api_extensions_path_name=api_extensions_path
api_exroute=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute
api_sync=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync
api_flowmirror=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/flowmirror
api_fwaas=$PYTHON_PATH/neutron_fwaas/extensions
api_vpnaas=$PYTHON_PATH/neutron_vpnaas/extensions
huawei_ac_extensions_path_list=($api_exroute $api_sync $api_flowmirror $api_fwaas $api_vpnaas)
rollback_extensions_path_list=("" "" "" "")
rollback_config $NEUTRON_CONF_CUR $api_extensions_path_name "${huawei_ac_extensions_path_list[*]}" "${rollback_extensions_path_list[*]}" ':' 'DEFAULT'

##notification_drivers
echo "  unable huawei notification_drivers"
notification_drivers_name=notification_drivers
huawei_notification_drivers_list=(huawei_ac_qos_driver)
rollback_notification_list=("")
rollback_config $NEUTRON_CONF_CUR $notification_drivers_name "${huawei_notification_drivers_list[*]}" "${rollback_notification_list[*]}" ',' 'qos'

if [ -e /etc/neutron/plugin.ini ];then
    rm -f /etc/neutron/plugin.ini
fi

ln -s /etc/neutron/plugins/ml2/ml2_conf.ini /etc/neutron/plugin.ini

if [ -e $ML2_CONF_BAK ];then
    rm -f $ML2_CONF_BAK
fi
if [ -e $NEUTRON_CONF_BAK ];then
    rm -f $NEUTRON_CONF_BAK
fi

if [ ! -e /usr/local/bin/kolla_start ]; then
    echo "****Step3 Stop neutron-server service****"
    case "$SYS_SELE" in
    "1" | "3")
        systemctl daemon-reload
        systemctl stop neutron-server.service
        ;;
    "2")
        service neutron-server stop
        ;;
    esac
fi

if [ -e $KOLLA_CONFIG_FILES/ml2_conf.ini.bak ]; then
    mv -f $KOLLA_CONFIG_FILES/ml2_conf.ini.bak $KOLLA_CONFIG_FILES/ml2_conf.ini
fi

if [ -e $KOLLA_CONFIG_FILES/neutron.conf.bak ]; then
    mv -f $KOLLA_CONFIG_FILES/neutron.conf.bak $KOLLA_CONFIG_FILES/neutron.conf
fi

if [ ! -e /usr/local/bin/kolla_start ]; then
    ps -ef | grep neutron-server | grep -v grep | awk '{print $2}' | xargs -r kill -9
else
    exec=`grep ^exec /usr/local/bin/kolla_start`
    if [[ $exec =~ huawei_driver_config.ini ]]; then
        sed -i "s#\s*--config-file /etc/neutron/huawei_driver_config.ini##g" /usr/local/bin/kolla_start
    fi
fi

if [ ! -e /usr/local/bin/kolla_start ]; then
    echo "****Step4 Start neutron-server service****"
    case "$SYS_SELE" in
    "1" | "3")
        systemctl start neutron-server.service
        ;;
    "2")
        service neutron-server start
        ;;
    esac
fi

echo "****Uninstall networking huawei plugin end****"