#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Transfer Config Of Ac Plugin To Json File."""
import os
import sys
import json
import logging
import subprocess
from configobj import ConfigObj
from oslo_config import cfg
from networking_huawei.drivers.ac.common import config

DRIVER_PREFIX = "huawei_driver_config.huawei_ac_config."
AGENT_PREFIX = "huawei_driver_config.huawei_ac_agent_config."

LOCAL_CONF = cfg.ConfigOpts()
LOCAL_CONF.register_opts(config.HUAWEI_AC_DRIVER_OPTS,
                         "huawei_ac_driver_config")
LOCAL_CONF.register_opts(config.HUAWEI_AC_AGENT_OPT, "huawei_ac_agent_config")

LOG = logging.getLogger(__name__)
FORMATTER = logging.Formatter('[%(levelname)s] %(message)s')
CONSOLE_HANDLE = logging.StreamHandler(sys.stdout)
CONSOLE_HANDLE.setFormatter(FORMATTER)
LOG.addHandler(CONSOLE_HANDLE)
LOG.setLevel(logging.INFO)

CONFIG_FILE = os.path.realpath('/etc/neutron/huawei_driver_config.ini')
CONFIG_FILE_BAK = os.path.realpath('/etc/neutron/huawei_driver_config.ini_bak')
JSON_FILE_PATH = os.path.realpath(
    '/opt/fusionplatform/data/upgrade/upg_tmp/ac_plugin_cfg.json')


class ReWriteAcPluginCfgToCpsCfg(object):
    """ReWriteAcPluginCfg class"""

    def __init__(self):
        self.huawei_driver_config = {}
        if not os.path.exists(CONFIG_FILE):
            LOG.error('[AC] ReWriteAcPluginCfgToCpsCfg: Please ensure %s exists'
                      , CONFIG_FILE)
            raise Exception('[AC] Config file huawei_driver_config.ini of ac '
                            'pluginnot exist')
        self._config = ConfigObj(CONFIG_FILE, encoding='UTF8')

    @staticmethod
    def backup_ac_config_file():
        """Backup config file of ac plugin."""
        try:
            LOG.info("[AC] backup_ac_config_file: begin to backup ac plugin "
                     "config")
            bak_command = ['cp', '-af', CONFIG_FILE, CONFIG_FILE_BAK]
            subprocess.call(bak_command)
            LOG.info("[AC] backup_ac_config_file: end to backup ac plugin "
                     "config")
        except OSError:
            LOG.error("[AC] backup_ac_config_file: backup ac plugin config "
                      "failed")
            return False
        return True

    @staticmethod
    def rollback_ac_config_file():
        """Rollback config file of ac plugin."""
        try:
            LOG.info("[AC] rollback_ac_config_file: begin to rollback ac "
                     "plugin config")
            rollback_command = ['cp', '-af', CONFIG_FILE, CONFIG_FILE_BAK]
            subprocess.call(rollback_command)
            LOG.info("[AC] rollback_ac_config_file: end to rollback ac plugin "
                     "config")
        except OSError:
            LOG.error("[AC] rollback_ac_config_file: rollback ac plugin config"
                      " failed")
            return False
        return True

    def record_ac_plugin_cfg_to_file(self):
        return True
