#!/bin/sh
FUSIONSPHERE_INFO_LOG_PATH='/var/log/fusionsphere/component/neutron-server/neutron-server_info.log.200'
REDHAT_LOG_PATH='/var/log/neutron/server.log'
CENTOS_LOG_PATH='/var/log/neutron/server.log'
NORMAL_SYNC_TEST_INFO="normal sync heart beat time stamp"
NORMAL_SYNC_MONITOR_INFO="normal sync monitor time stamp"
LOG_PATH=""

num_of_process=`ps -fe|grep neutron-server |grep -v grep|wc -l`
if [ $num_of_process -lt 1 ];then
   echo "neutron server process stoped,please check"
   exit
fi


check_normal_sync(){
grep "$1"  "$2" | tail -1

}

if [  -e "$FUSIONSPHERE_INFO_LOG_PATH" ]; then
LOG_PATH=$FUSIONSPHERE_INFO_LOG_PATH
elif [  -e "$CENTOS_LOG_PATH" ]; then
LOG_PATH=$CENTOS_LOG_PATH
else 
    echo "can not find the neutron server log path"
fi

normal_sync_log=`check_normal_sync "$NORMAL_SYNC_TEST_INFO" "$LOG_PATH"`
normal_sync_monitor_log=`check_normal_sync "$NORMAL_SYNC_MONITOR_INFO" "$LOG_PATH"`
normal_sync_time=`echo $normal_sync_log|awk -F "stamp:" '{print $2}'`
normal_sync_monitor_time=`echo $normal_sync_monitor_log|awk -F "stamp:" '{print $2}'`

now_time=`date +"%s"`

normal_sync_time_gap=`echo "$now_time - $normal_sync_time"|bc -l`
normal_sync_monitor_gap=`echo "$now_time - $normal_sync_monitor_time"|bc -l`

compare_sync_time=`echo $normal_sync_time_gap '<' 150| bc -l`
compare_sync_monitor_time=`echo $normal_sync_monitor_gap '<' 450| bc -l`

if [ $compare_sync_time -eq 1 ];then
   echo "normal sync is alive"
else
   echo "normal sync is dead"
fi
if [ $compare_sync_monitor_time -eq 1 ];then
   echo "normal sync monitor is alive"
else
   echo "normal sync monitor is dead"
fi

