#!/bin/bash
# -*- coding:utf-8 -*-
# Copyright 2021 Huawei Technologies Co. Ltd. All rights reserved.
#------------------------------------------------
#功能：插件升级（R20C10 -> R21C00）后，配置恢复。
#适用范围:
#<1> openstack插件,手动卸载重装方式升级
#<2> fusionsphere插件，cps界面卸载重装方式升级
#------------------------------------------------

CUR_PATH=$(dirname $(readlink -f $0))
source $CUR_PATH/upgrade_common_function.sh

BAK_VERSION=$1

PlUGIN_VERSIONS=(
"v1r20c10"
)

if [[ -z ${BAK_VERSION} ]] || [[ ! ${PlUGIN_VERSIONS[@]} =~ $BAK_VERSION ]]; then
    echo "Please input a correct plugin version in: [${PlUGIN_VERSIONS[@]}]"
    exit 1
fi

NEUTRON_CONF_PATH=/etc/neutron
NEUTRON_CONF=$NEUTRON_CONF_PATH/neutron.conf
ML2_CONF=$NEUTRON_CONF_PATH/plugins/ml2/ml2_conf.ini
DRIVER_CONF=$NEUTRON_CONF_PATH/huawei_driver_config.ini
WHITE_LIST=$NEUTRON_CONF_PATH/whitelist.ini

NEUTRON_CONF_BAK=$NEUTRON_CONF_PATH/neutron.conf.$BAK_VERSION
ML2_CONF_BAK=$NEUTRON_CONF_PATH/plugins/ml2/ml2_conf.ini.$BAK_VERSION
DRIVER_CONF_BAK=$NEUTRON_CONF_PATH/huawei_driver_config.ini.$BAK_VERSION
WHITE_LIST_BAK=$NEUTRON_CONF_PATH/whitelist.ini.$BAK_VERSION

ZK_SERVICE_CACHE_PARSER_FILE='/usr/bin/install_tool/zk_cache_cfg_parser.py'
UBUNTU_PYTHON_PATH=/usr/local/lib/python2.7/dist-packages
PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
NETWORKING_HUAWEI_CONF=$PYTHON_PATH/networking_huawei/drivers/ac/common/config.py
UBUNTU_HUAWEI_CONF=$UBUNTU_PYTHON_PATH/networking_huawei/drivers/ac/common/config.py
if [ ! -e $NETWORKING_HUAWEI_CONF ] && [ -e $UBUNTU_HUAWEI_CONF ]; then
    NETWORKING_HUAWEI_CONF=$UBUNTU_HUAWEI_CONF
fi
ERROR_RETRY_INTERVAL_DEFAULT=180
ERROR_RETRY_COUNT_DEFAULT=1

IGNORE_PARAMS=(
"ac_auth_username"
"ac_auth_password"
"keystone_tenant"
"keystone_user"
"keystone_passwd"
"websocket_key_password"
)

ops_version=$(grep ^OPS_version $DRIVER_CONF_BAK)
get_conf_params
if [[ $ops_version =~ "FusionSphere" ]]; then
    DC_ADMIN_NAME=$(python $ZK_SERVICE_CACHE_PARSER_FILE -s cps -t cps-web -c dc_admin_name)
    echo -e "+ Please input ${DC_ADMIN_NAME}_admin password: \c"
    while :; do
        ret=$(get_char)
        if [ x$ret = x ]; then
            echo
            break
        fi
        password="$password$ret"
    done
    source set_env << EOF > /dev/null
    1
    $password
EOF
fi

echo "****Begin to config /etc/neutron/huawei_driver_config.ini****"
if [[ ! $ops_version =~ "FusionSphere" ]] || [[ $ops_version =~ "FusionSphere6.1" ]] || [[ $ops_version =~ "FusionSphere6.3.0" ]]; then
    for param in ${params_arr[@]}; do
        param_name=$(echo $param | sed s/[[:space:]]//g)
        if [[ ! -z $param_name && -e $DRIVER_CONF_BAK ]]; then
            huawei_param_bak=$(grep ^$param_name $DRIVER_CONF_BAK | awk -F = '{print $2}' | sed s/[[:space:]]//g)
            if [ ! -z $huawei_param_bak ] && [[ ! $(echo ${IGNORE_PARAMS[@]}|grep -w $param_name) ]]; then
                echo "    Set parameter $param_name to value: $huawei_param_bak"
                if [[ $(grep ^$param_name $DRIVER_CONF) ]];then
                    sed -i "s/^\($param_name =\).*/\1 ${huawei_param_bak//\//\\/}/" $DRIVER_CONF
                else
                    sed -i "s/#\($param_name =\).*/\1 ${huawei_param_bak//\//\\/}/" $DRIVER_CONF
                fi
            fi
        fi
    done
    error_retry_interval=$(grep "^error_retry_interval[[:space:]]*=" $DRIVER_CONF | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$error_retry_interval" ]; then
        sed -i "s/^error_retry_interval[[:space:]]*=.*/error_retry_interval = 180/g" $DRIVER_CONF
    fi

    error_retry_count=$(grep "^error_retry_count[[:space:]]*=" $DRIVER_CONF | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$error_retry_count" ]; then
        sed -i "s/^error_retry_count[[:space:]]*=.*/error_retry_count = 1/g" $DRIVER_CONF
    fi
else
    error_retry_interval_bak=$(cat $DRIVER_CONF_BAK|grep '^error_retry_interval'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
    if [[ $error_retry_interval_bak ]];then
        echo "    Exec: cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_interval=$ERROR_RETRY_INTERVAL_DEFAULT"
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_interval=$ERROR_RETRY_INTERVAL_DEFAULT
    fi
    error_retry_count_bak=$(cat $DRIVER_CONF_BAK|grep '^error_retry_count'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
    if [[ $error_retry_count_bak ]];then
        echo "    Exec: cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_count=$ERROR_RETRY_COUNT_DEFAULT"
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_count=$ERROR_RETRY_COUNT_DEFAULT
    fi
    echo "    Cps updated huawei ac config."
fi
echo "****End to config /etc/neutron/huawei_driver_config.ini****"
echo ''

echo "****Begin to config /etc/neutron/whitelist.ini****"
if [[ -e $WHITE_LIST_BAK ]]; then
    echo "    Exec: cp -af $WHITE_LIST_BAK $WHITE_LIST"
    cp -af $WHITE_LIST_BAK $WHITE_LIST
fi
echo "****End to config /etc/neutron/whitelist.ini****"
echo ''

echo "****Begin to config /etc/neutron/neutron.conf****"
if [[ -e $NEUTRON_CONF_BAK ]]; then
    if [[ ! $ops_version =~ "FusionSphere" ]]; then
        echo "    Exec: cp -af $NEUTRON_CONF_BAK $NEUTRON_CONF"
        cp -af $NEUTRON_CONF_BAK $NEUTRON_CONF
    else
        service_plugins_bak=$(cat $NEUTRON_CONF_BAK|grep '^service_plugin'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        service_plugins_curr=$(cat $NEUTRON_CONF|grep '^service_plugin'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        if [[ $service_plugins_bak != $service_plugins_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter service_plugins=$service_plugins_bak"
            cps template-params-update --service neutron neutron-server --parameter service_plugins=$service_plugins_bak
        fi

        api_extensions_path_bak=$(cat $NEUTRON_CONF_BAK|grep '^api_extensions_path'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        api_extensions_path_curr=$(cat $NEUTRON_CONF|grep '^api_extensions_path'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        if [[ $api_extensions_path_bak != $api_extensions_path_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$api_extensions_path_bak"
            cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$api_extensions_path_bak
        fi

        notification_drivers_bak=$(cat $NEUTRON_CONF_BAK|grep '^notification_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        notification_drivers_curr=$(cat $NEUTRON_CONF|grep '^notification_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        if [[ $notification_drivers_bak != $notification_drivers_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter notification_drivers=$notification_drivers_bak"
            cps template-params-update --service neutron neutron-server --parameter notification_drivers=$notification_drivers_bak
        fi
    fi
fi
echo "****End to config /etc/neutron/neutron.conf****"
echo ''

echo "****Begin to config /etc/neutron/plugins/ml2/ml2_conf.ini****"
if [[ -e $ML2_CONF_BAK ]]; then
    if [[ ! $ops_version =~ "FusionSphere" ]]; then
        echo "    Exec: cp -af $ML2_CONF_BAK $ML2_CONF"
        cp -af $ML2_CONF_BAK $ML2_CONF
    else
        extension_drivers_bak=$(cat $ML2_CONF_BAK|grep '^extension_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        extension_drivers_curr=$(cat $ML2_CONF|grep '^extension_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
        if [[ $extension_drivers_bak != $extension_drivers_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter extension_drivers=$extension_drivers_bak"
            cps template-params-update --service neutron neutron-server --parameter extension_drivers=$extension_drivers_bak
        fi
    fi
fi
echo "****End to config /etc/neutron/plugins/ml2/ml2_conf.ini****"
echo ''

echo "****Begin to recover certs****"
if [[ ! $ops_version =~ "FusionSphere8.0" ]] && [[ ! $ops_version =~ "FusionSphere21.0" ]]; then
    cp -af /tmp/certs/ssl_cacert.pem $PYTHON_PATH/networking_huawei/drivers/ac/client/
    cp -af /tmp/certs/client.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/
    cp -af /tmp/certs/client_key.pem $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/
    cp -af /tmp/certs/trust.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/
else
    WEBSOCKET_PUBLIC_KEY=`python -c 'import six;config=six.moves.configparser.ConfigParser(); config.read("'$DRIVER_CONF_BAK'");print(config.get("huawei_ac_config", "websocket_public_key"))'`
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
fi
echo "****End to recover certs****"
echo ''

echo "****Begin to config websocket private key password****"
if [[ ! $ops_version =~ "FusionSphere" ]] || [[ $ops_version =~ "FusionSphere6.1" ]] || [[ $ops_version =~ "FusionSphere6.3.0" ]]; then
    WEBSOCKET_KEY_PASSWORD=`grep 'websocket_key_password' $DRIVER_CONF_BAK`
    sed -i "s#websocket_key_password.=.*#$WEBSOCKET_KEY_PASSWORD#g" /etc/neutron/huawei_driver_config.ini
fi
echo "****End to config websocket private key password****"
echo ''

echo '****Restart neutron-server****'
if [[ $ops_version =~ "FusionSphere" ]]; then
    cps commit
    cps host-template-instance-operate --service neutron neutron-server --action stop
    cps host-template-instance-operate --service neutron neutron-server --action start
else
    service neutron-server restart
fi