#!/bin/bash
# Copyright 2021 Huawei Technologies Co. Ltd. All rights reserved.

set -e

if [ $# != 2 ] ; then
    echo "Parameter wrong, Please input identity certificate(.p12) and trust certificate(.cer)."
    echo "Example: bash upload_cert.sh websocket.p12 websocket.cer"
    exit 1
fi

CUR_PATH=$(dirname $(readlink -f $0))
DRIVER_CONF=/etc/neutron/huawei_driver_config.ini
source $CUR_PATH/common_function.sh

function upload_cert_end() {
    echo "*****************************************************************************************"
    echo "**                              upload cert end                                        **"
    echo "*****************************************************************************************"
}

select_cloud_platform
echo "Confirm to upload cert(please ensure you have put apimlb_ca.cer(export from master controller and slave controller), ${1}, ${2} in /root/networking-huawei/tools/certs)"
check_input

cd $CUR_PATH/certs/

# merge http ca cert
cat apimlb_ca*.cer > ssl_cacert.pem

# generate websocket public key and private key
echo "Input ${1} password:"
read -s WEBSOCKET_CLIENT_PASS
P12_PASSWORD=$WEBSOCKET_CLIENT_PASS

echo "Set websocket private key password:"
read -s WEBSOCKET_KEY_PASS
KEY_PASSWORD=$WEBSOCKET_KEY_PASS

openssl pkcs12 -in ${1} -passin pass:$P12_PASSWORD -out client.cer -nokeys -nomacver
openssl pkcs12 -in ${1} -passin pass:$P12_PASSWORD -nocerts -nomacver -out client_key.pem -passout pass:$KEY_PASSWORD

cp ${2} trust.cer

# if FSP after 8.0.0 (include)
if [ $OPENSTACK_VERSION -eq 4 ]; then
    SSL_CACERT=`cat $CUR_PATH/certs/ssl_cacert.pem`
    TRUST_CERT=`cat $CUR_PATH/certs/trust.cer`
    WEBSOCKET_PUBLIC_KEY=`cat $CUR_PATH/certs/client.cer`
    WEBSOCKET_PRIVATE_KEY=`cat $CUR_PATH/certs/client_key.pem`

    SSL_CACERT_FLAG=`cat $DRIVER_CONF|grep '^https_ca_cert'|awk -F = '{print $1}'`
    TRUST_CERT_FLAG=`cat $DRIVER_CONF|grep '^websocket_ca_cert'|awk -F = '{print $1}'`
    WEBSOCKET_PUBLIC_KEY_FLAG=`cat $DRIVER_CONF|grep '^websocket_public_key'|awk -F = '{print $1}'`
    WEBSOCKET_PRIVATE_KEY_FLAG=`cat $DRIVER_CONF|grep '^websocket_private_key'|awk -F = '{print $1}'`
    WEBSOCKET_KEY_PASS_FLAG=`cat $DRIVER_CONF|grep '^websocket_key_password'|awk -F = '{print $1}'`

    if [[ $SSL_CACERT_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert="$SSL_CACERT"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert="$SSL_CACERT"
    fi
    if [[ $TRUST_CERT_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert="$TRUST_CERT"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert="$TRUST_CERT"
    fi
    if [[ $WEBSOCKET_PUBLIC_KEY_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
    fi
    if [[ $WEBSOCKET_PRIVATE_KEY_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_private_key="$WEBSOCKET_PRIVATE_KEY"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_private_key="$WEBSOCKET_PRIVATE_KEY"
    fi
    if [[ $WEBSOCKET_KEY_PASS_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password="$KEY_PASSWORD"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password="$KEY_PASSWORD"
    fi

    cps commit
    upload_cert_end
    exit
fi

# copy cert to plugin code directory
cp $CUR_PATH/certs/ssl_cacert.pem $NETWORKING_HUAWEI/drivers/ac/client/
cp $CUR_PATH/certs/client.cer $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
cp $CUR_PATH/certs/client_key.pem $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
cp $CUR_PATH/certs/trust.cer $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/

# change cert file owner to neutron
if [ $OPENSTACK_VERSION -eq 1 ]; then
    chown -R neutron:neutron $NETWORKING_HUAWEI
else
    chown -R openstack:openstack $NETWORKING_HUAWEI
fi

#change cert file permission
chmod 600 $NETWORKING_HUAWEI/drivers/ac/client/ssl_cacert.pem
chmod 600 $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/client.cer
chmod 600 $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/client_key.pem
chmod 600 $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/trust.cer

# if FSP between 6.3.1 (include) and 8.0.0 (not include)
if [ $OPENSTACK_VERSION -eq 3 ]; then
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password=$KEY_PASSWORD
    cps commit
    upload_cert_end
    exit
fi

python /root/networking-huawei/tools/modify_pwd_websocket_key.py

systemctl restart neutron-server

upload_cert_end