#!/bin/bash
# Copyright 2021 Huawei Technologies Co. Ltd. All rights reserved.

set -e

CUR_PATH=$(dirname $(readlink -f $0))
source $CUR_PATH/common_function.sh

select_cloud_platform
echo "Confirm to upload cert(please put https.crl or websocket.crl in /tmp/certs)"
check_input

if [ -f /tmp/certs/https.crl ]; then
    cp /tmp/certs/https.crl $NETWORKING_HUAWEI/drivers/ac/client/
    chmod 600 $NETWORKING_HUAWEI/drivers/ac/client/https.crl
fi

if [ -f /tmp/certs/websocket.crl ]; then
    cp /tmp/certs/websocket.crl $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
    chmod 600 $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/websocket.crl
fi

# change cert file owner to neutron
if [ $OPENSTACK_VERSION -eq 1 ]; then
    chown -R neutron:neutron $NETWORKING_HUAWEI
else
    chown -R openstack:openstack $NETWORKING_HUAWEI
fi

echo "*********************"
echo "**  upload crl end **"
echo "*********************"