var BDFDETECTION = {};
BDFDETECTION.loading = function (tipText, elementId) {
    !tipText && (tipText = iemp.i18n.translate('ac.dc.network.bdfdetect.loading'));
    !elementId && (elementId = '');
    var parentElm = elementId ? document.getElementById(elementId) : document.getElementsByTagName("html")[0];
    if (document.getElementById('_loading_background')) return;
    var backgroundDiv = document.createElement("div");
    backgroundDiv.setAttribute('id', elementId + '_loading_background');
    backgroundDiv.setAttribute('class', 'loading_bg')
    var loadingDiv = document.createElement('div');
    loadingDiv.setAttribute('id', elementId + "_loading_wrap");
    loadingDiv.setAttribute('class', 'loading_wrap');

    if (parentElm) {
        if (elementId) {
            parentElm.style.position = 'relative';
            backgroundDiv.setAttribute('class', 'loading_bg card');
            loadingDiv.setAttribute('class', 'loading_wrap card');
        }
        parentElm.appendChild(backgroundDiv);
        parentElm.appendChild(loadingDiv);

        var loadingHtml = '<img src="/views/images/web_page_loading.gif" alt=""><span>';
        loadingHtml += tipText;
        loadingHtml += '</span>';
        $('#' + elementId + "_loading_wrap").html(loadingHtml);
        var timer = setTimeout(function () {
            if ($('#' + elementId + "_loading_wrap span").length !== 0)
                $('#' + elementId + "_loading_wrap span").css({
                    'visibility': 'visible'
                });
        }, 3000);
        return timer;
    }
}

BDFDETECTION.ending = function (timer, elementId) {
    timer && (clearTimeout(timer));
    !elementId && (elementId = '');
    var bc = document.getElementById(elementId + '_loading_background');
    var wrap = document.getElementById(elementId + "_loading_wrap");
    if (!(bc && wrap)) return;
    if (elementId) {
        if (!document.getElementById(elementId)) return;
        document.getElementById(elementId).removeChild(document.getElementById(elementId + '_loading_background'));
        document.getElementById(elementId).removeChild(document.getElementById(elementId + "_loading_wrap"));
    } else {
        document.getElementsByTagName("html")[0].removeChild(document.getElementById(elementId + '_loading_background'));
        document.getElementsByTagName("html")[0].removeChild(document.getElementById(elementId + "_loading_wrap"));
    }
}

BDFDETECTION.tableloading = function (tabScope, tabId) {
    if (!tabScope || !tabId)
        return;
    tabScope[tabId].attr('dataset', []);
    var loadingHtml = '<div style="display: inline-block;" id="' + tabId + '_loading">' + '<img style="height:16px;margin-right:5px;vertical-align: middle;" src="/dcnwebsite/oam-app/common/images/table_loading.gif"/>';
    loadingHtml += '<span style="vertical-align: middle;display: none;" id="' + tabId + 'Text" class="tableLoadingText">' + iemp.i18n.pageinfo.translate('ac.dc.network.bdfdetect.loading') + '</span></div>';
    tabScope[tabId].attr('empty-table-msg', loadingHtml);
    var timer = setTimeout(function () {
        if ($('#' + tabId + 'Text').length !== 0)
            $('#' + tabId + 'Text').css({
                'display': 'inline'
            });
    }, 3000);
    return timer;
}

BDFDETECTION.tableending = function (tabScope, tabId, timer) {
    if (!tabScope || !tabId)
        return;
    timer && (clearTimeout(timer));
    tabScope[tabId].attr('empty-table-msg', iemp.i18n.pageinfo.translate('ac.oam.bdfdetect.noRecords'));
}
