// 根据使用量和配额的值获取进度条的json体
function getUsagePercentage(usage, quota, alarmValue, isSpec) {
  var percentage = getPercentage(usage, quota);
  var colour = "";
  var ret = {};
  var usedStr = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.used");
  var alarmStr = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.alarmRecoveryValue");
  var quotaOrSpec = '';
  if (isSpec && true === isSpec) {
    quotaOrSpec = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.spec");
  } else {
    quotaOrSpec = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.quota");
  }
  ret.tips = usedStr + ":" + usage + " " + quotaOrSpec + ':' + quota + " " + alarmStr + ":" + alarmValue + "%";
  ret.value = percentage;
  //此处告警暂时不做
  if (parseFloat(percentage) >= parseFloat(alarmValue)) {
    ret.color = "orange";
  } else {
    ret.color = "green";
  }
  return ret;

}



function getPercentage(usage, sum) {
  usage = parseFloat(usage);
  sum = parseFloat(sum);

  if (usage + '' === 'NaN' || sum + '' === 'NaN' || sum === 0) {
    return 0;
  }
  var num = (usage / sum);
  var per = (num * 100).toFixed(2);
  return per;

}



function transferOnlineAndOffline(name) {
  if (iemp.i18n.language === "zh_CN") {
    if (name.toUpperCase() === "UP") {
      name = "在线";
    }
    if (name.toUpperCase() === "DOWN") {
      name = "离线";
    }
  } else {
    if (name.toUpperCase() === "UP") {
      name = "Up";
    }
    if (name.toUpperCase() === "DOWN") {
      name = "Down";
    }

  }
  return name;

}



status_customEditor = function (event, online, offline) {

  var split = "Operate";
  var colId = event.colId;
  var rowObj = event.rowData;
  if (rowObj.status === offline) {


    return '<div style="float:left;"><img src="/dcnwebsite/oam-app/themes/default/eview_modules/deviceCapacity/switchAndVSwitch/1.0.0/template/images/offline.png" /></div>&nbsp;' +
      transferOnlineAndOffline(offline.split(split)[1]);

  } else {
    return '<div style="float:left;"><img src="/dcnwebsite/oam-app/themes/default/eview_modules/deviceCapacity/switchAndVSwitch/1.0.0/template/images/online.png" /></div>&nbsp;' +
      transferOnlineAndOffline(online.split(split)[1]);

  };
}
adjustQuota_customEditor = function (event) {
  var colId = event.colId;
  var rowObj = event.rowData;
  var id = "quotaEditor_" + rowObj.rowid + colId;
  return '<div><img  class="fabircQuotaEditor pointer" id="' + id + '" src="/dcnwebsite/oam-app/themes/default/eview_modules/deviceCapacity/switchAndVSwitch/1.0.0/template/images/adjust_quota.png" /></div>   ';
}



/*
switch vswitch 公用
*/
function makeFabricRowMap(dataRow) {
  var map = {};
  map.expandrow = {
    expanded: false
  };
  map["rowid"] = dataRow["id"];
  map["deviceName"] = dataRow["deviceName"];
  map["status"] = dataRow["status"];
  map["checkbox"] = {
    checked: false
  };



  map["ipAddress"] = dataRow["ipAddress"];
  map["deviceModel"] = dataRow["fabricDeviceCapacitySpecDto"].deviceModel;


  map.vrf = getUsagePercentage(dataRow["fabricDeviceCapacityUsageDto"].Vrf, dataRow["fabricDeviceCapacitySpecDto"].Vrf, 80);
  map.arp = getUsagePercentage(dataRow["fabricDeviceCapacityUsageDto"].Arp, dataRow["fabricDeviceCapacitySpecDto"].Arp, 80);
  map.hostRoute = getUsagePercentage(dataRow["fabricDeviceCapacityUsageDto"].HostRoute, dataRow["fabricDeviceCapacitySpecDto"].HostRoute, 80);
  map.bd = getUsagePercentage(dataRow["fabricDeviceCapacityUsageDto"].Bd, dataRow["fabricDeviceCapacitySpecDto"].Bd, 80);
  //展开项里的
  map.role = dataRow.role;
  map.location = dataRow.location;

  map.arpUsage = dataRow["fabricDeviceCapacityUsageDto"].Arp;
  map.hostRouteUsage = dataRow["fabricDeviceCapacityUsageDto"].HostRoute;
  map.vTableUsage = dataRow["fabricDeviceCapacityUsageDto"].vTable;
  map.vTableSpec = dataRow["fabricDeviceCapacitySpecDto"].vTable;

  var arpStr = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.arp");
  var hostRouteStr = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.hostRoute");
  var sumUsageStr = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.sumUsage");
  var sumSpec = iemp.i18n.translate("ac.oam.dcnwebsite/oam-app.deviceCapacity.spec");
  map.arpAndRouteTips = arpStr + ":" + dataRow["fabricDeviceCapacityUsageDto"].Arp + " " + hostRouteStr + ":" + dataRow["fabricDeviceCapacityUsageDto"].HostRoute +
    " " + sumUsageStr + ": " + dataRow["fabricDeviceCapacityUsageDto"].vTable + " " + sumSpec + ":" + dataRow["fabricDeviceCapacitySpecDto"].vTable;
  return map;
}



function confirmDialog(message, callbackFunc) {

  iemp.i18n.pageinfo.load("dcnwebsite/oam-app", "common");
  var options = {
    content: message,
    callback: callbackFunc,
    buttons: [{
      label: iemp.i18n.pageinfo.translate("ac.dc.oam.OK"),
      'default': false
    }]

  };
  new eview.widgets.MessageDialog.confirm(options);
}


function getArgs() {
  var win = window.location;
  var href = win.href;
  var query = href.split('?')[1];
  var pairs = query.split("&"); //在逗号处断开
  var args = {};
  for (var i = 0; i < pairs.length; i++) {
    var pos = pairs[i].indexOf('='); //查找name=value
    if (pos == -1) { //如果没有找到就跳过
      continue;
    }
    var argname = pairs[i].substring(0, pos); //提取name
    var value = pairs[i].substring(pos + 1); //提取value
    args[argname] = value; //存为属性
  }
  return args;

}
