function eviewTableHelperCapacity(scope_param, moduleName) {
    var helper = {};
    helper.scope = scope_param;

    helper.eview_table = null;

    helper.DEFAULT_PAGEINDEX = 1;
    helper.DEFAULT_PAGESIZE = 20
    helper.orderRules = {};
    helper.queryConditions = {};


    helper.queryConditionsCollector;

    helper.rowDataTransfer;

    helper.url;

    var switchCapacityQueryParam = null;

    var loadingMsg = '<img src="/dcnwebsite/oam-app/common/images/table_loading.gif"/>';

    iemp.i18n.pageinfo.load("dcnwebsite/oam-app", "common");
    var emptyMsg = iemp.i18n.pageinfo.translate("ac.dc.oam.noRecords");



    helper.getScope = function () {
        return helper.scope;
    }


    helper.scope[moduleName + '_createHandler'] = function (event) {
        var tableObj = event.target;
        helper.eview_table = tableObj;
        //排序
        $.each(tableObj.headers, function (i, column) {
            if (column.sortable && helper.orderRules[column.id] !== undefined) {
                tableObj.addSortHandler(column.id, function (colId, curPage, displayLength, sortOrder) {
                    helper.queryData();
                });
            }
        });

        if (helper.eview_table.paginationControl && helper.eview_table.paginationControl.opts) {
            helper.eview_table.paginationControl.opts.curPage = 0; //simple分页初始化时未-1，会触发换页函数
        }
        helper.queryData();
    };

    //分页
    helper.scope.paginationHandler = function (event) {

        helper.queryData();
    }

    //搜索
    helper.scope.tableSearch = function (event) {

        helper.queryData();
    }

    //分页，排序的参数结构定义
    helper.queryConfig = {
        "orderName": "orderName",
        "sortMode": "sortMode",
        "pageNum": "pageNum",
        "limit": "limit",
        "asc": 0,
        "desc": 1

    }


    function setValueByChain(chainStr, val) {
        var obj = val;
        $.each(chainStr.split('.').reverse(), function (index, item) {
            var temp = {};
            temp[item] = obj;
            obj = temp;
        });

        return obj;
    }

    //请求后台数据
    helper.queryData = function () {
        if (!helper.eview_table) {
            return;
        }

        if (!helper.url) {
            helper.createData && loadDataForTable(helper.createData());
            return;
        }

        $.extend(true, helper.queryConfig, helper.customQueryConfig);

        helper.queryConditionsCollector && helper.queryConditionsCollector(helper.queryConditions);

        var queryParam = helper.queryConditions;

        if (helper.eview_table.options.enablePagination && helper.eview_table.pageOpt) {

            $.extend(true, queryParam, setValueByChain(helper.queryConfig["pageNum"], (helper.eview_table.pageOpt.curPage + 1) || helper.DEFAULT_PAGEINDEX));
            $.extend(true, queryParam, setValueByChain(helper.queryConfig["limit"], helper.eview_table.pageOpt.displayLength || helper.DEFAULT_PAGESIZE));

        }

        if (helper.eview_table.attr('sort-column')) {
            if (helper.orderRules[helper.eview_table.attr('sort-column')[0]] !== undefined) {
                $.extend(true, queryParam, setValueByChain(helper.queryConfig["orderName"], helper.orderRules[helper.eview_table.attr('sort-column')[0]]));
                $.extend(true, queryParam, setValueByChain(helper.queryConfig["sortMode"], helper.queryConfig[helper.eview_table.attr('sort-column')[1]]));
            }
        }
        // 修改table tablehelper,此为进行字段排序，升序和降序
        if (queryParam.orderValue && 1 === queryParam.orderValue) {
            queryParam.orderValue = '-' + queryParam.orderName;

        } else {
            //不存在也取正
            queryParam.orderValue = queryParam.orderName;
        }


        helper.eview_table.clearTable();
        $('#' + helper.eview_table.attr('id') + '_pagination_wrapper').hide();
        helper.eview_table.attr('empty-table-msg', loadingMsg);


        var ajax_id = moduleName + '_query_get_table_data';
        var ajax_type = 'post';
        var ajax_url = helper.url;

        if (helper.url === "/acdcn/ui/oamservice/fabric/device/capacity/spec") {
            delete(queryParam.orderName);
            delete(queryParam.queryName);
        }


        var ajax_param = JSON.stringify(queryParam);

        switchCapacityQueryParam = queryParam;

        if (helper.ajaxType === 'get' || helper.url.indexOf('/debug/') > 0) {
            ajax_type = 'get';
            ajax_param = '';
            if (ajax_url.indexOf("?") < 0 && Object.getOwnPropertyNames(queryParam).length > 0) {
                ajax_url += '?';
            }
            $.each(queryParam, function (name, value) {
                ajax_url += '&' + name + '=' + value;
            });

        }
        iemp.abort(ajax_id);
        iemp.ajax[ajax_id] = iemp.external[ajax_type]({
            url: ajax_url,
            async: true,
            dataType: "json",
            data: ajax_param,
            success: function (data) {
                //交换机和虚拟交换机数据提前处理
                dealWithSwitchAndVswitchCapacityDate(helper, data, switchCapacityQueryParam);
                helper.formatNorthData && loadDataForTable(helper.formatNorthData(data));

                //交换机和虚拟交换机循环掉接口
                switchAndVswitchCapacitySecondQuery(helper, data, switchCapacityQueryParam);
            },
            error: function (data) {
                if (data.statusText !== "abort") {
                    helper.eview_table.attr('empty-table-msg', emptyMsg);
                    if (helper.eview_table.pageOpt) {
                        helper.eview_table.pageOpt.curPage = 0;
                    }
                }
            }
        });
    }


    function dealWithSwitchAndVswitchCapacityDate(helper, data, switchCapacityQueryParam) {
        if (helper.url === "/acdcn/ui/oamservice/fabric/device/capacity/device" && data && data.deviceList && data.deviceList.length) {

            $.each(data.deviceList || [], function (index, item) {
                item.fabricDevice = {};
                item.fabricDevice.deviceModel = item.deviceModel;
                item.fabricDevice.deviceVersion = item.deviceVersion;
                item.fabricDevice.groupId = item.groupId;
                item.fabricDevice.id = item.id;
                item.fabricDevice.location = item.location;
                item.fabricDevice.manageIp = item.manageIp;
                item.fabricDevice.manageMac = item.manageMac;
                item.fabricDevice.name = item.name;
                item.fabricDevice.operateStatus = item.operateStatus;
                item.fabricDevice.role = item.role;

                item.fabricDeviceCapacitySpec = null;
                item.fabricDeviceCapacityUsage = null;
                item.slotAndChipInfoList = null;
                item.errorMsg = null;


            });
        }
    }

    function switchAndVswitchCapacitySecondQuery(helper, data, switchCapacityQueryParam) {
        if (helper.url === "/acdcn/ui/oamservice/fabric/device/capacity/device" && data && data.deviceList && data.deviceList.length) {

            $.each(data.deviceList, function (index, item) {
                var ajax_param;
                var ajax_id = item.id + '_query_get_table_data';
                var ajax_type = 'post';
                var ajax_url = "/acdcn/ui/oamservice/fabric/device/capacity/useage";
                if (helper.ajaxType === 'post' || helper.url.indexOf('/debug/') > 0) {
                    ajax_type = 'get';
                    ajax_param = '';
                    ajax_url += '?';
                    $.each(item, function (name, value) {
                        if (name === "id") {
                            name = "deviceId";
                            ajax_url += '&' + name + '=' + value;
                        }
                        if (name === "groupId" || name === "deviceModel") {
                            ajax_url += '&' + name + '=' + value;
                        }

                    });

                    ajax_url += '&' + "fabricId" + '=' + switchCapacityQueryParam.fabricId;
                    ajax_url += '&' + "deviceType" + '=' + switchCapacityQueryParam.deviceType;
                }

                iemp.abort(ajax_id);
                iemp.ajax[ajax_id] = iemp.external[ajax_type]({
                    url: ajax_url,
                    async: true,
                    dataType: "json",
                    data: ajax_param,
                    success: function (msg) {

                        item.fabricDeviceCapacitySpec = msg.fabricDeviceCapacity.fabricDeviceCapacitySpec;
                        item.fabricDeviceCapacityUsage = msg.fabricDeviceCapacity.fabricDeviceCapacityUsage;
                        item.slotAndChipInfoList = msg.fabricDeviceCapacity.slotAndChipInfoList;
                        item.errorMsg = msg.errorMsg;
                        if (item.errorMsg && item.errorMsg.toLowerCase().indexOf("fail") >= 0 && iemp.i18n.language === "zh_CN") {
                            item.errorMsg = "南向操作失败";
                        }
                        if (item.errorMsg && item.errorMsg.toLowerCase().indexOf("fail") >= 0 && iemp.i18n.language === "en_US") {
                            item.errorMsg = "South operate fail";
                        }
                        helper.formatNorthData && loadDataForTable(helper.formatNorthData(data));

                    },
                    error: function (data) {
                        
                    }
                });



            });

        }
    }

    //表格加载数据
    function loadDataForTable(data) {
        if (!data || !data.dataList || (helper.eview_table.options.enablePagination && parseInt(data.dataCount) + '' === 'NaN')) {
            helper.eview_table.attr('empty-table-msg', emptyMsg);
            if (helper.eview_table.pageOpt) {
                helper.eview_table.pageOpt.curPage = 0;
            }
            if (helper.eview_table.options.pagingStyle === 'scroll_rec') {
                helper.eview_table.attr('display-length', 1);
            }

            $('.eviewTable_PagePaneContainer').css('display', $('.eviewTable_PagePaneScroll').css('display'));

            return;
        }
        var datalist = data.dataList;

        var dataset = [];

        if (datalist && helper.rowDataTransfer) {
            for (var i = 0; i < datalist.length; i++) {
                var dataRow = datalist[i];
                var transferedData = helper.rowDataTransfer(dataRow);
                if (transferedData instanceof Array) {
                    $.each(transferedData, function (index, item) {
                        dataset.push(escapeHtmlRow(item));
                    });
                } else {
                    dataset.push(escapeHtmlRow(transferedData));
                }
            }
        }

        var totalRecords = Math.max(data.dataCount, datalist.length);
        if (totalRecords) {
            helper.eview_table.attr("total-records", totalRecords);
        }
        helper.doBeforeSetDataset && helper.doBeforeSetDataset(totalRecords);
        helper.eview_table.attr("dataset", dataset);
        helper.doAfterSetDataset && helper.doAfterSetDataset(totalRecords);

        if (dataset.length === 0) {
            helper.eview_table.attr("total-records", 0);
            helper.eview_table.attr('empty-table-msg', emptyMsg);
            if (helper.eview_table.pageOpt) {
                helper.eview_table.pageOpt.curPage = 0;
            }
        } else {
            $.each(helper.eview_table.getDisplayedRows(), function (i, row) {
                helper.toDoAfterTableLoad && helper.toDoAfterTableLoad(row);
            });
        }

    }

    function escapeHtmlRow(rowData) {
        if (!BRANCH.escapeHtml) {
            return rowData;
        }
        $.each(rowData, function (key, value) {
            if (Object.prototype.toString.call(value) === "[object String]") {
                rowData[key] = BRANCH.escapeHtml(value);
            }
        });
        return rowData;
    }

    helper.scope.tableListeners = {
        change: function (evtObj) {
            if (helper.eview_table.options.pagingStyle === 'scroll_rec') {
                helper.eview_table.attr('display-length', Math.min(evtObj.data.length, 10));
            }

            $('.eviewTable_PagePaneContainer').css('display', $('.eviewTable_PagePaneScroll').css('display'));

        }
    };

    return helper;
}



function unique(arr, key) {
    var result = [],
        hash = {};
    for (var i = 0, elem; i < arr.length; i++) {
        elem = key ? arr[i][key] : arr[i];
        if (!hash[elem]) {
            result.push(arr[i]);
            hash[elem] = true;
        }
    }
    return result;

}
