
iemp.i18n.pageinfo.load("dcnwebsite/oam-app", "common");
function eviewTableHelper(scope_param, moduleName) {
  var helper = {};
  helper.scope = scope_param;

  helper.eview_table = null;

  helper.DEFAULT_PAGEINDEX = 1;
  helper.DEFAULT_PAGESIZE = 20
  helper.orderRules = {};
  helper.queryConditions = {};

  helper.queryConditionsCollector;

  helper.rowDataTransfer;

  helper.url;
  var emptyMsg = iemp.i18n.pageinfo.translate("ac.dc.oam.noRecords");
  var loadingMsg = '<img src="/dcnwebsite/oam-app/common/images/table_loading.gif"/>';

  helper.loadingTable = function () {
    helper.eview_table.attr('empty-table-msg', loadingMsg);
    helper.eview_table.attr("total-records", 0);
    if (helper.eview_table.pageOpt) {
      helper.eview_table.pageOpt.curPage = 0;
    }
  }

  helper.getScope = function () {
    return helper.scope;
  }


  helper.scope[moduleName + '_createHandler'] = function (event) {
    var tableObj = event.target;
    helper.eview_table = tableObj;
    //排序
    $.each(tableObj.headers, function (i, column) {
      if (column.sortable && helper.orderRules[column.id] !== undefined) {
        tableObj.addSortHandler(column.id, function (colId, curPage, displayLength, sortOrder) {
          helper.queryData();
        });
      }
    });

    if (helper.eview_table.paginationControl && helper.eview_table.paginationControl.opts) {
      helper.eview_table.paginationControl.opts.curPage = 0; //simple分页初始化时未-1，会触发换页函数
    }
    helper.queryData();
  };

  //分页
  helper.scope.paginationHandler = function (event) {
    sessionStorage.setItem("logicSwitchAlp_pageSize", event.displayLength);
    sessionStorage.setItem("logicSwitchAlp_pageIndex", event.currentPage);
    helper.queryData();
  }

  //搜索
  helper.scope.tableSearch = function (event) {

    helper.queryData();
  }

  //分页，排序的参数结构定义
  helper.queryConfig = {
    "orderName": "orderName",
    "sortMode": "sortMode",
    "pageNum": "pageNum",
    "limit": "limit",
    "asc": 0,
    "desc": 1

  }

  function setValueByChain(chainStr, val) {
    var obj = val;
    $.each(chainStr.split('.').reverse(), function (index, item) {
      var temp = {};
      temp[item] = obj;
      obj = temp;
    });

    return obj;
  }

  //请求后台数据
  helper.queryData = function () {
    if (!helper.eview_table) {
      return;
    }

    if (!helper.url) {
      helper.createData && loadDataForTable(helper.createData());
      return;
    }
    $.extend(true, helper.queryConfig, helper.customQueryConfig);

    helper.queryConditionsCollector && helper.queryConditionsCollector(helper.queryConditions);

    var queryParam = helper.queryConditions;

    if (helper.eview_table.options.enablePagination && helper.eview_table.pageOpt) {

      $.extend(true, queryParam, setValueByChain(helper.queryConfig["pageNum"], (helper.eview_table.pageOpt.curPage + 1) || helper.DEFAULT_PAGEINDEX));
      $.extend(true, queryParam, setValueByChain(helper.queryConfig["limit"], helper.eview_table.pageOpt.displayLength || helper.DEFAULT_PAGESIZE));

    }

    if (helper.eview_table.attr('sort-column')) {
      if (helper.orderRules[helper.eview_table.attr('sort-column')[0]] !== undefined) {
        $.extend(true, queryParam, setValueByChain(helper.queryConfig["orderName"], helper.orderRules[helper.eview_table.attr('sort-column')[0]]));
        $.extend(true, queryParam, setValueByChain(helper.queryConfig["sortMode"], helper.queryConfig[helper.eview_table.attr('sort-column')[1]]));
      }
    }

    helper.eview_table.clearTable();
    $('#' + helper.eview_table.attr('id') + '_pagination_wrapper').hide();
    helper.eview_table.attr('empty-table-msg', loadingMsg);


    var ajax_id = moduleName + '_query_get_table_data';
    var ajax_type = 'post';
    var ajax_url = helper.url;
    var ajax_param = JSON.stringify(queryParam);

    if (helper.ajaxType === 'get' || helper.url.indexOf('/debug/') > 0) {
      ajax_type = 'get';
      ajax_param = '';
      if (ajax_url.indexOf("?") < 0 && Object.getOwnPropertyNames(queryParam).length > 0) {
        ajax_url += '?';
      }
      $.each(queryParam, function (name, value) {
        ajax_url += '&' + name + '=' + value;
      });

    }
    const deferred = $.Deferred();
    iemp.ajax[ajax_id] = iemp.external[ajax_type]({
      url: ajax_url,
      async: true,
      dataType: "json",
      data: ajax_param,
      success: function (data) {
        scope_param.createTunnel && scope_param.createTunnel.attr("disable", false, true);
        helper.formatNorthData && loadDataForTable(helper.formatNorthData(data));
        deferred.resolve(data);
      },
      error: function (data) {
        deferred.reject(data);
        if (data.statusText !== "abort") {
          helper.eview_table.attr('empty-table-msg', emptyMsg);
          if (helper.eview_table.pageOpt) {
            helper.eview_table.pageOpt.curPage = 0;
          }
        }
        if (moduleName === "portSelect" && (JSON.parse(data.responseText)["errors"]["error"][0]["error-info"]["error-code"] === "0x00c80009" || JSON.parse(data.responseText)["errors"]["error"][0]["error-info"]["error-code"] === "0x00c8003b")) {
          return;
        }
        BRANCH.showExceptionMessage(JSON.parse(data.responseText)["errors"]["error"][0]["error-info"]);
      }
    });
    return deferred.promise();
  }

  //表格加载数据
  function loadDataForTable(data) {
    if (!data || !data.dataList || (helper.eview_table.options.enablePagination && parseInt(data.dataCount) + '' === 'NaN')) {
      helper.eview_table.attr('empty-table-msg', emptyMsg);
      if (helper.eview_table.pageOpt) {
        helper.eview_table.pageOpt.curPage = 0;
      }
      if (helper.eview_table.options.pagingStyle === 'scroll_rec') {
        helper.eview_table.attr('display-length', 1);
      }

      $('.eviewTable_PagePaneContainer').css('display', $('.eviewTable_PagePaneScroll').css('display'));

      return;
    }
    var datalist = data.dataList;

    var dataset = [];

    if (datalist && helper.rowDataTransfer) {
      for (var i = 0; i < datalist.length; i++) {
        var dataRow = datalist[i];
        var transferedData = helper.rowDataTransfer(dataRow);
        if (transferedData instanceof Array) {
          $.each(transferedData, function (index, item) {
            dataset.push(escapeHtmlRow(item));
          });
        } else {
          dataset.push(escapeHtmlRow(transferedData));
        }
      }
    }

    var totalRecords = Math.max(data.dataCount, datalist.length);
    if (totalRecords) {
      helper.eview_table.attr("total-records", totalRecords);
    }
    helper.doBeforeSetDataset && helper.doBeforeSetDataset(totalRecords);
    helper.eview_table.attr("dataset", dataset);
    helper.doAfterSetDataset && helper.doAfterSetDataset(totalRecords);

    if (dataset.length === 0) {
      helper.eview_table.attr("total-records", 0);
      helper.eview_table.attr('empty-table-msg', emptyMsg);
      if (helper.eview_table.pageOpt) {
        helper.eview_table.pageOpt.curPage = 0;
      }
    } else {
      $.each(helper.eview_table.getDisplayedRows(), function (i, row) {
        helper.toDoAfterTableLoad && helper.toDoAfterTableLoad(row);
      });
    }

  }

  function escapeHtmlRow(rowData) {
    if (!BRANCH.escapeHtml) {
      return rowData;
    }
    $.each(rowData, function (key, value) {
      if (Object.prototype.toString.call(value) === "[object String]") {
        rowData[key] = BRANCH.escapeHtml(value);
      }
    });
    return rowData;
  }

  helper.scope.tableListeners = {
    change: function (evtObj) {
      if (helper.eview_table.options.pagingStyle === 'scroll_rec') {
        helper.eview_table.attr('display-length', Math.min(evtObj.data.length, 10));
      }

      $('.eviewTable_PagePaneContainer').css('display', $('.eviewTable_PagePaneScroll').css('display'));

    }
  };

  return helper;
}



function unique(arr, key) {
  var result = [],
    hash = {};
  for (var i = 0, elem; i < arr.length; i++) {
    elem = key ? arr[i][key] : arr[i];
    if (!hash[elem]) {
      result.push(arr[i]);
      hash[elem] = true;
    }
  }
  return result;

}
