var UNDEFINED = "undefined";

//获取公共路径
function getSrcRootFromModule(module) {
    var str = module.id.split("/");
    var src = "";
    for (var i = 1; i < 3; i++) {
        src = src + "/" + str[i];
    }
    return src;
}

function getSrcFromWindowLocation() {
    var str = window.location.pathname.split("/");
    var src = "/" + str[1] + "-app/common/images/";
    return src;
}

//格式化标准时间
function getFormatDate(param) {
    var date, seperator1, seperator2;
    date = param.dateMilliseconds;
    seperator1 = param.seperator_date;
    seperator2 = param.seperator_time;
    var month = addZero(date.getMonth() + 1);
    var day = addZero(date.getDate());
    var hour = addZero(date.getHours());
    var minute = addZero(date.getMinutes());
    var second = addZero(date.getSeconds());
    var currentdate = date.getFullYear() + seperator1 + month + seperator1 + day + " " + hour + seperator2 + minute + seperator2 + second;
    return currentdate;
}

//小于10在前补0
function addZero(number) {
    if (number >= 0 && number <= 9) {
        number = "0" + number;
    }
    return number;
}

function commonEnum() {
    var commonEnum = {};
    if (typeof operateType === UNDEFINED) {　　　　　　　　　　　
        var operateType = {};　　　　　　　　　　　
        operateType.QUERY = "query";　　　　　　　　　　　
        operateType.DEL = "del";　　　　　　　　　　　
        operateType.ADD = "add";　　　　　　　　　　　
        operateType.UPDATE = "update";
        operateType.BREAK = "break";
        commonEnum.operateType = operateType;
    }

    if (typeof ajaxType === UNDEFINED) {
        var ajaxType = {};
        ajaxType.GET = "get";
        ajaxType.POST = "post";
        ajaxType.DEL = "del";
        ajaxType.PUT = "put";
        commonEnum.ajaxType = ajaxType;
    }
    return commonEnum;
}

function commonAjaxPortMirring(param, callback) {
    var actionName = param.ajaxType + param.id;
    iemp.abort(actionName);
    param.$cover.css("display", "block");
    iemp.ajax[actionName] = iemp.external[param.ajaxType]({
        url: param.url,
        async: true,
        dataType: param.dataType === "text"?"text":"json",
        data: JSON.stringify(param.params),
        success: function (data) {
            param.$cover.css("display", "none");
            if (callback && param.operateType === commonEnum().operateType.QUERY) {
                callback(param.scope, data);
                return;
            }
            if (callback && (param.operateType === commonEnum().operateType.BREAK) && (param.id === 'loopInfoDetail')) {
                param.$repairState.text(" ");
                callback("prompt", param.dialogMsg);
                return;
            }
            if (callback && (param.operateType === commonEnum().operateType.BREAK) && (param.id !== 'loopInfoDetail')) {
                callback(param.$looInfoBody, param.$repairState, param.repairBtnText_allPortSuccess, param.repairBtnText_success);
                return;
            }
            callback && callback();
        },
        error: function (data) {
            param.$cover.css("display", "none");
            if (param.operateType === commonEnum().operateType.QUERY) {
                return;
            }

            if (param.operateType === commonEnum().operateType.BREAK) {
                param.$repairState.text(param.repairBtnText_fail);
                return;
            }
            BRANCH.errorReport(data, iemp.i18n.translate("ac.dcn.oam.loopDetection.loopShowByFbaricId.unknowError"));
        }
    });
}

function formateId(uuid) {
    return uuid.replace(/\-/g, '_');
};

/*清空勾选*/
function resetCheck($looInfoBody, $repairState, repairBtnText_allPortSuccess, repairBtnText_success) {
    $looInfoBody.find(".checkbox_true_full").each(function () {
        $(this).parent().remove();
    });
    if ($looInfoBody.find(".deviceLi").length === 0) {
        $repairState.text(repairBtnText_allPortSuccess);
    } else {
        $repairState.text(repairBtnText_success);
    }
};
