
const interval = ':&emsp;';
const fontGrayBegin = '<font color="gray" >';
const fontGrayEnd = '</font>';
const spanTitleBegin = '<span>';
const spanContentBegin = '<span class="autoToolTip" >';
const spanEnd = '</span>';


function appendVMDetails(detailsDiv, userParams) {
  detailsDiv.empty();
  detailsDiv.append(


    spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.vmIp') + fontGrayEnd + spanEnd +
    spanContentBegin + window.BRANCH.escapeHtml(userParams.vmIp) + spanEnd +

    spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.hostName') + fontGrayEnd + spanEnd +
    spanContentBegin + (window.BRANCH.escapeHtml(userParams.hostName) ? window.BRANCH.escapeHtml(userParams.hostName) : '- -') + spanEnd +

    spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.vmMac') + fontGrayEnd + spanEnd +
    spanContentBegin + window.BRANCH.escapeHtml(userParams.vmMac) + spanEnd,
  );

  detailsDiv.append(

    spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.tenantName') + fontGrayEnd + spanEnd +
    spanContentBegin + window.BRANCH.escapeHtml(userParams.tenantName) + spanEnd,

  );
  detailsDiv.find('.deviceDetails_content').each(function a() {
    const _text = $(this).text();
    $(this).attr('title', _text);
  });
}
window.appendVMDetails = appendVMDetails;

function appendportErspanDetails(detailsDiv, userParams, bmIp) {
  detailsDiv.empty();
  let contentStr = '';
  if (bmIp === 1) {
    contentStr = '';
    let portInfo = '';
    contentStr += `${spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.deviceIp') + interval + fontGrayEnd + spanEnd +
      spanContentBegin + window.BRANCH.escapeHtml(userParams[0].deviceIp) + spanEnd}`;
    userParams.forEach((value, index) => {
      portInfo += (userParams.length - 1 === index) ? `${value.portName}` : `${value.portName}、`;
    });
    contentStr += spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.portName') + interval + fontGrayEnd + spanEnd +
      spanContentBegin + window.BRANCH.escapeHtml(portInfo) + spanEnd;
  } else {
    contentStr = `${spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.bmIp') + interval + fontGrayEnd + spanEnd +
      spanContentBegin + window.BRANCH.escapeHtml(userParams.bmIp) + spanEnd +

      spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.deviceIp') + interval + fontGrayEnd + spanEnd +
      spanContentBegin + window.BRANCH.escapeHtml(userParams.deviceIp) + spanEnd +

      spanTitleBegin + fontGrayBegin + iemp.i18n.translate('ac.oam.portMirroring.portName') + interval + fontGrayEnd + spanEnd +
      spanContentBegin + window.BRANCH.escapeHtml(userParams.portName) + spanEnd
    }`;
  }
  detailsDiv.append(

    contentStr,
  );
}
window.appendportErspanDetails = appendportErspanDetails;

function commonAjaxPortMirring(param, callback) {
  const actionName = param.ajaxType + param.id;
  iemp.abort(actionName);
  iemp.loading();
  iemp.ajax[actionName] = iemp.external[param.ajaxType]({
    url: param.url,
    async: true,
    dataType: 'json',
    data: JSON.stringify(param.params),
    success(data) {
      if (callback && param.operateType === 'query') {
        callback(param.scope, data);
        iemp.ending();
        return;
      }
      // 非查询
      if (callback) callback();
      iemp.ending();
    },
    error(data) {
      iemp.ending();
      if (param.operateType === 'query') {
        return;
      }
      window.BRANCH.showExceptionMessage(JSON.parse(data.responseText).errors.error[0]['error-info']);
    },
  });
}
window.commonAjaxPortMirring = commonAjaxPortMirring;
function ipValidatePortMirring(ipValue) {
  const validationReturnMap = {};
  const filter = /^([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])$/;
  const filterIpv6 = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
  const condition = filter.test(ipValue) || filterIpv6.test(ipValue);
  validationReturnMap.validationResult = condition;
  validationReturnMap.validationErrorMsg = iemp.i18n.translate('ac.oam.portMirroring.ipConfirm');
  return validationReturnMap;
}
window.ipValidatePortMirring = ipValidatePortMirring;
function ipValidateVmMirring(ipValue) {
  const validationReturnMap = {};
  const filterIpv4 = /^([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])$/;
  const filterIpv6 = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
  const condition = filterIpv4.test(ipValue) || filterIpv6.test(ipValue);
  validationReturnMap.validationResult = condition;
  validationReturnMap.validationErrorMsg = iemp.i18n.translate('ac.oam.portMirroring.vmIpConfirm');
  return validationReturnMap;
}
window.ipValidateVmMirring = ipValidateVmMirring;
function idIPv4OrIPv6(ipValue) { // 判断是都是IPv4或者IPv6
  const validationReturnMap = {};
  let condition = false;
  const filter1 = /^([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])$/;
  const condition1 = filter1.test(ipValue);
  const condition2 = window.isIPv6(ipValue);

  if (condition1 == true || condition2 == true) {
    condition = true;
  }
  validationReturnMap.validationResult = condition;
  validationReturnMap.validationErrorMsg = iemp.i18n.translate('ac.oam.portMirroring.ipConfirm');
  return validationReturnMap;
}
window.idIPv4OrIPv6 = idIPv4OrIPv6;
function nameValidate(name) {
  const validationReturnMap = {};
  let condition;
  if (name.trim().toString() === '') {
    condition = false;
  } else {
    condition = true;
  }
  validationReturnMap.validationResult = condition;
  validationReturnMap.validationErrorMsg = iemp.i18n.pageinfo.translate('ac.oam.portMirroring.nameConfirm1');
  return validationReturnMap;
}
window.nameValidate = nameValidate;

function mirroringNameValidate(mirroringName) {
  const validationReturnMap = {};
  const filter = /^[a-zA-Z0-9~!@#$%^&*()_+-=[\]:]{1,32}$/;
  let condition = filter.test(mirroringName);
  if ((mirroringName.indexOf('/') >= 0) || (mirroringName.indexOf('<') >= 0) || (mirroringName.indexOf(';') >= 0) || (mirroringName.indexOf('.') >= 0) || (mirroringName.indexOf(',') >= 0)) {
    condition = false;
  }
  validationReturnMap.validationResult = condition;
  validationReturnMap.validationErrorMsg = iemp.i18n.translate('ac.oam.portMirroring.nameConfirm');
  return validationReturnMap;
}
window.mirroringNameValidate = mirroringNameValidate;

function vmMirroringNameValidate(mirroringName) {
  const validationReturnMap = {};
  const filter = /^[a-zA-Z0-9_]{1,32}$/;
  let condition = filter.test(mirroringName);
  if ((mirroringName.indexOf('/') >= 0) || (mirroringName.indexOf('<') >= 0) || (mirroringName.indexOf(';') >= 0) || (mirroringName.indexOf('.') >= 0) || (mirroringName.indexOf(',') >= 0)) {
    condition = false;
  }
  validationReturnMap.validationResult = condition;
  validationReturnMap.validationErrorMsg = iemp.i18n.translate('ac.oam.portMirroring.vmNameConfirm');
  return validationReturnMap;
}
window.vmMirroringNameValidate = vmMirroringNameValidate;


function confirmDialog(message, callbackFunc) {
  const options = {
    content: message,
    callback: callbackFunc,
    buttons: [{
      label: iemp.i18n.translate('ac.oam.portMirroring.ok'),
      default: false,

    }],

  };
  new eview.widgets.MessageDialog.confirm(options);
}
window.confirmDialog = confirmDialog;
function deleteConfirmDialog(callbackFunc) {
  const options = {
    content: iemp.i18n.translate('ac.oam.portMirroring.beforeDeleteConfirm'),
    focusedIndex: 1,
    callback(event) {
      if (event.id == 'yes') {
        if (callbackFunc) callbackFunc();
      }
    },
  };
  new eview.widgets.MessageDialog.confirm(options);
}
window.deleteConfirmDialog = deleteConfirmDialog;
