//根据传递过来的1533021708406 转换为对应的时区
function getDateByServiceNumDate(serNumDate) {
  if (serNumDate && serNumDate != null && serNumDate != "") {
    var serNumDateLong = new Date(parseInt(serNumDate));
    Date.prototype.Format = function (fmt) {
      var o = {
        "M+": this.getMonth() + 1, //月份
        "d+": this.getDate(), //日
        "h+": this.getHours(), //小时
        "m+": this.getMinutes(), //分
        "s+": this.getSeconds(), //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds() //毫秒
      };
      if (/(y+)/.test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
      }
      for (var k in o) {
        if (new RegExp("(" + k + ")").test(fmt)) {
          fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        }
      }
      return fmt;
    }
    return serNumDateLong.Format("yyyy-MM-dd hh:mm:ss");
  }
  return serNumDate;
}
//将服务端的零时区时间转换为本地时区的时间
function getDateByServiceDate(serDate) {
  if (serDate && serDate != null && serDate != "") {
    var gmt = Number(new Date().toString().split("GMT")[1].substring(0, 3));
    var localTime = new Date(new Date((serDate.split("T")[0] + " " + serDate.split("T")[1].split(".")[0]).replace(new RegExp('-', 'gm'), '/')).getTime() + gmt * 1000 * 60 * 60);
    var outTime = localTime.getFullYear() + "-" + (localTime.getMonth() + 1) + "-" + localTime.getDate() + " " + (localTime.getHours() < 10 ? ("0" + localTime.getHours()) : localTime.getHours()) + ":" + (localTime.getMinutes() < 10 ? ("0" + localTime.getMinutes()) : localTime.getMinutes()) + ":" + (localTime.getSeconds() < 10 ? ("0" + localTime.getSeconds()) : localTime.getSeconds());
    return outTime;
  }
  return serDate;
}

//将例如：2018-07-13 09:26:34 转换对应夏令区
function getIsSummerDate(utcDate) {
  if (utcDate && utcDate != null && utcDate != "") {
    if (getIsSummer()) {
      var nowDate = new Date();
      nowDate = new Date(utcDate);
      var tz = nowDate.getTimezoneOffset();
      nowDate = new Date(nowDate.getTime());
      var outDataStr = nowDate.getFullYear() + "-"
        + ((nowDate.getMonth() + 1) >= 10 ? ((nowDate.getMonth() + 1)) : ("0" + ((nowDate.getMonth() + 1)))) + "-"
        + (nowDate.getDate() >= 10 ? nowDate.getDate() : ("0" + nowDate.getDate())) + " ";
      outDataStr = outDataStr + (nowDate.getHours() < 10 ? "0" + nowDate.getHours() : nowDate.getHours());
      outDataStr += ":";
      outDataStr = outDataStr + (nowDate.getMinutes() < 10 ? "0" + nowDate.getMinutes() : nowDate.getMinutes());
      outDataStr += ":";
      outDataStr = outDataStr + (nowDate.getSeconds() < 10 ? "0" + nowDate.getSeconds() : nowDate.getSeconds());
      return outDataStr + " DTS";
    } else {
      return utcDate;
    }
  }
  return utcDate;
}


//判断是否夏令区
function getIsSummer() {
  var d1 = new Date(new Date().getFullYear(), 0, 1);
  var d2 = new Date(new Date().getFullYear(), 6, 1);
  if (d1.getTimezoneOffset() != d2.getTimezoneOffset()) {
    return true;
  }
  else {
    return false;
  }
}

//本地时间进行UTC格式零时区转换。
function getUTCDateByCurrentDate() {
  var utcDate = new Date().toISOString();
  return utcDate;
}

//将本地值格式，例如：2018-07-13 09:26:34 进行UTC格式转换 2018-07-13T01:26:34+08:00
function getUTCDateByDealDate(time) {
  var nowDate = new Date();
  if (time && null != time && "" != time && time.length > 18) {
    nowDate = new Date(time);
  }
  var tz = nowDate.getTimezoneOffset();
  nowDate = new Date(nowDate.getTime() - 60 * tz * 1e3);
  var outDataStr = nowDate.getFullYear() + "-"
    + ((nowDate.getMonth() + 1) >= 10 ? ((nowDate.getMonth() + 1)) : ("0" + ((nowDate.getMonth() + 1)))) + "-"
    + (nowDate.getDate() >= 10 ? nowDate.getDate() : ("0" + nowDate.getDate())) + "T";
  outDataStr = outDataStr + (nowDate.getHours() < 10 ? "0" + nowDate.getHours() : nowDate.getHours());
  outDataStr += ":";
  outDataStr = outDataStr + (nowDate.getMinutes() < 10 ? "0" + nowDate.getMinutes() : nowDate.getMinutes());
  outDataStr += ":";
  outDataStr = outDataStr + (nowDate.getSeconds() < 10 ? "0" + nowDate.getSeconds() : nowDate.getSeconds());
  var dateStr = nowDate + "";
  if (dateStr.indexOf("(") === -1) {
    dateStr = dateStr + " (";
  }
  var endIndex = dateStr.indexOf("(");
  var gmtz = dateStr.substring(endIndex - 6, endIndex);
  gmtz = gmtz.substring(0, 3) + ":" + gmtz.substring(3, 5);
  outDataStr += gmtz;
  return outDataStr;
}
