#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    check_cps_status
#  Description: 安装插件前检测cps状态
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

EASYSUITE_LOG='/var/log/neutron/easysuite_install.log'
SCRIPT_NAME=$(basename $0)
LOG_PRINT="eval echo \`date +\"%Y-%m-%d %T\"\` \"[$SCRIPT_NAME]\"  [INFO] :"

echo "Begin to check cps-server is ready or not."
$LOG_PRINT  "Begin to check cps-server is ready or not." >> $EASYSUITE_LOG

echo "es_input: os_password"
read os_password

#source environment path
source set_env<<EOF > /dev/null 2>&1
1
$os_password
EOF

echo "Exec cps commit."
$LOG_PRINT  "Exec cps commit." >> $EASYSUITE_LOG
cps commit
if [ $? != 0 ];then
    $LOG_PRINT  "Exec cps commit failed, cps is not ready now." >> $EASYSUITE_LOG
    exit 1
fi
sleep 20

which expect
if [ $? != 0 ];then
    echo "There is no expect tool, skip use fs_check_status check cps status."
    $LOG_PRINT  "There is no expect tool, skip use fs_check_status check cps status." >> $EASYSUITE_LOG
    exit 0
fi

which fs_check_status
if [ $? != 0 ];then
    echo "There is no fs_check_status tool, skip use fs_check_status check cps status."
    $LOG_PRINT  "There is no fs_check_status tool, skip use fs_check_status check cps status." >> $EASYSUITE_LOG
    exit 0
fi

echo "Use fs_check_status to check cps."
$LOG_PRINT  "Use fs_check_status to check cps." >> $EASYSUITE_LOG
expect /root/easysuite_install/ac_fs_check_status.exp  $os_password >/root/easysuite_install/fs_check_status_result

cps_falut_status=$(cat /root/easysuite_install/fs_check_status_result | grep cps | grep fault)
if [ -n "$cps_falut_status" ]; then
    echo "Exist cps service is fault now."
    $LOG_PRINT  "Exist cps service is fault now." >> $EASYSUITE_LOG
    exit 1
fi

echo "Cps is OK now."
$LOG_PRINT  "Cps is OK now." >> $EASYSUITE_LOG