#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    check_python_version
#  Description: openstack环境检查python版本号
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

ops_version=$1
createcheckfile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/etc/check_ops_result.sh
 
   chmod 755 /etc/check_ops_result.sh
}

getcheckresult()
{
   if [ "$1" -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /etc/check_ops_result.sh
   ">/etc/check_ops_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /etc/check_ops_result.sh
   ">/etc/check_ops_result.sh
   fi
   chmod 755 /etc/check_ops_result.sh > /dev/null 2>&1
}

main_process()
{
    createcheckfile
    echo "****Check python version****"
    python_version=$(python -c "import sys; print ('python-%s.%s.%s' % (sys.version_info.major, sys.version_info.minor, sys.version_info.micro))")
    if [ -z "${python_version}" ];then
        echo "Error: Failed to get python version"
        echo "The recommended python version is 'python2.7.5-58.el7.x86_64', OpenStack Wallaby recommended python version is 'python-3.6.8'"
        return 1
    fi
    if [ "${ops_version}" == "Wallaby" ]; then
        down_python="python-3.6.8"
        if ([[ $python_version < $down_python ]]); then
            echo "Error: The python version should not be lower than ${down_python}, please upgrade the python version"
            echo "The current python version is ${python_version}, recommended python version is ${down_python}"
            return 1
        fi
        echo "The python version is ok"
        return 0
    else
        if [[ "${python_version}" =~ "python-3" ]]; then
            echo "The python version is ok"
            return 0
        fi
        down_python="python-2.7.5-34"
        up_version="python-2.7.5-46"
        python_version=`rpm -qa | grep "python-2.7.5"`
        if ([[ $python_version < $up_version ]] || [[ $python_version == $up_version* ]]) && ([[ $python_version > $down_python ]] || [[ $python_version == $down_python* ]]); then
            echo "ERROR: The python version cannot be within the range of python-2.7.5-34 to python-2.7.5-46, please upgrade the python version"
            echo "The current python version is $python_version, recommended python version is 'python2.7.5-58.el7.x86_64'"
            return 1
        fi
        echo "The python version is ok"
        return 0
    fi
}

main_process
getcheckresult $?
exit $?
