#!/bin/bash
tenant="NCECOMMONE"
tmp=$(ps -ef |grep DCNOpenEMService|grep -i tomcat | awk -F -DTOMCAT_LOG_DIR=/opt/oss/log/ '{print $2}' | awk '{print $1}'| awk -F / '{print $1}')
if [ ! -z $tmp ] ;then
    tenant=$tmp
fi
APP_ROOT=/opt/oss/${tenant}/apps/AuthService/envs/
cp -r /opt/install_pm/starter  /opt/oss/${tenant}/apps/AuthService
cd $APP_ROOT
set -a
sed -i 's/Domain.Mode=multi-domain/#Domain.Mode=multi-domain/g' env.properties
. ./env.properties
export APP_NAME
export APP_CONF_FILE
export APP_ROOT
export OSS_ROOT
export _LEGACY_APP_SHARE_DIR
export OSS_LANG
export _APP_LOG_DIR
export _APP_TMP_DIR
export _APP_SHARE_DIR
export CIPHER_ROOT
export ENGTOOLPATH=$APP_ROOT/rtsp/DBups/engr/tools

sed -i 's/#Domain.Mode=multi-domain/Domain.Mode=multi-domain/g' env.properties

export ENGTOOLPATH=$APP_ROOT/rtsp/DBups/engr/tools
if [ -f $ENGTOOLPATH/dbtools/getDbtypeByPath.sh ];then
    echo [INFO]  "Get DBTYPE by execute: $ENGTOOLPATH/dbtools/getDbtypeByPath.sh $APP_ROOT/envs/upgrade.properties"  >> $_APP_LOG_DIR/install.log
    DBTYPE=`$ENGTOOLPATH/dbtools/getDbtypeByPath.sh $APP_ROOT/envs/upgrade.properties` >> $_APP_LOG_DIR/install.log
fi

DBTYPE=zenith

if [ -z $DBTYPE ];then
    echo "DBTYPE is null or empty,please check." >> $_APP_LOG_DIR/install.log
    exit 1
elif [ "$DBTYPE"x = "zenith"x ] || [ "$DBTYPE"x = "mysql"x ];then
    echo [INFO] $ENGTOOLPATH/start_DBups.sh $DBTYPE >> $_APP_LOG_DIR/install.log
    $ENGTOOLPATH/start_DBups.sh $DBTYPE >> $_APP_LOG_DIR/install.log 2>&1
    if [ $? -ne 0 ] ;then
        echo "Execute $ENGTOOLPATH/start_DBups.sh $DBTYPE failed, please check." >> $_APP_LOG_DIR/install.log
        exit 1
    else
        echo "SUCCESS"
    fi
fi
starter_name="portmirrorauth"

$ENGTOOLPATH/start_DBupsForModule.sh -dbtype $DBTYPE -mod_root $APP_ROOT/starter/${starter_name} -mod_name ${starter_name} -mod_version $MODULE_VERSION -mod_conf_file $MODULE_CONF_FILE

rm -rf /opt/oss/${tenant}/apps/AuthService/starter