#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_acmonitor
#  Description: װacmonitor
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
#
echo "es_input: ac_cluster_ip_list" 
read ac_cluster_ip_list
echo "es_input: ac_cluster_ip_list_1" 
read ac_cluster_ip_list_1
echo "es_input: cluster_name" 
read cluster_name
echo "es_input: cni_type" 
read cni_type
echo "es_input: calico_without_etcd"
read calico_without_etcd
echo "es_input: store_endpoints" 
read store_endpoints
echo "es_input: base_image" 
read base_image
echo "es_input: cni_requeue_max_times" 
read cni_requeue_max_times
echo "es_input: pod_requeue_max_times" 
read pod_requeue_max_times
echo "es_input: pod_workers" 
read pod_workers
echo "es_input: start_mode" 
read start_mode
#Ǳ
echo "es_input: readtimeout" 
read readtimeout
echo "es_input: readheadertimeout" 
read readheadertimeout
echo "es_input: writetimeout" 
read writetimeout
echo "es_input: timeout" 
read timeout
echo "es_input: idletimeout" 
read idletimeout
echo "es_input: keepalive" 
read keepalive
echo "es_input: log_max_backups" 
read log_max_backups
echo "es_input: log_max_size" 
read log_max_size
echo "es_input: log_dir" 
read log_dir
echo "es_input: log_name" 
read log_name
echo "es_input: log_level" 
read log_level
echo "es_input: enable_log_stdout" 
read enable_log_stdout
echo "es_input: heart_beat" 
read heart_beat
echo "es_input: network_workers" 
read network_workers
echo "es_input: ac_retry" 
read ac_retry
echo "es_input: etcd_retry" 
read etcd_retry
echo "es_input: cni_retry" 
read cni_retry
echo "es_input: k8s_client_qps" 
read k8s_client_qps
echo "es_input: k8s_client_burst" 
read k8s_client_burst
echo "es_input: sync_duration" 
read sync_duration
echo "es_input: etcd_timeout" 
read etcd_timeout
echo "es_input: etcd_dial_timeout" 
read etcd_dial_timeout
#û
echo "es_input: ac_north_user"
read ac_north_user
echo "es_input: ac_north_passwd"
read ac_north_passwd
echo "es_input: acmonitor_cert_passwd"
read acmonitor_cert_passwd
#ڵַ
echo "es_input: host_ip"
read host_ip
echo "es_input: host_ip2"
read host_ip2
echo "es_input: host_ip3"
read host_ip3
echo "es_input: host_ip4"
read host_ip4
echo "es_input: host_ip5"
read host_ip5


BASE_DIR=$(cd $(dirname $0);pwd)
CERTIFICATE_SECRETE_YAML="acmonitor-certificate-secrets.yaml"
acmonitor_cfg_file="acmonitor-cfg.yaml"
acmonitor_yaml="acmonitor.yaml"
acmonitor_secret=acmonitor-secrets.yaml
tmpfile="xxx_$acmonitor_cfg_file"
certfile="bin/trust.cer"


function install_acmonitor()
{
    get_install_path
	
    install_acmonitor_plugin  

    gen_yaml
    
}
#---------------------------------------------------------------------------
#  Function:    get_install_path
#  Description: ȡװ·
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function get_install_path()
{
    #software install dir

    INSTALL_PATH="/root"
    echo "INSTALL_PATH: ${INSTALL_PATH}"
    echo "INSTALL_PLUGIN_HOME=${INSTALL_PATH}" >> /etc/profile
    echo "export INSTALL_PLUGIN_HOME" >> /etc/profile  
    source /etc/profile
}
#---------------------------------------------------------------------------
#  Function:    install_calico_etcd
#  Description: װcalico-etcd(etcdcalico)
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function install_calico_etcd()
{
    echo "Install calico-etcd begin." >>es_install_log.txt
    cd ${INSTALL_PATH}/acmonitor_setup/
    ETCD_IMG="etcd-v3.3.13.tar"
    if [ ! -e "${ETCD_IMG}" ]; then
        echo "Installing calico-etcd failed, because ${ETCD_IMG} does not exist." >>es_install_log.txt
        exit 1
    fi
    ETCD_YAML="calico-etcd.yaml"
    if [ ! -e "${ETCD_YAML}" ]; then
        echo "Installing calico-etcd failed, because ${ETCD_YAML} does not exist." >>es_install_log.txt
        exit 1
    fi
    docker load -i ${ETCD_IMG}
    kubectl create -f ${ETCD_YAML}
    echo "Install calico-etcd end." >>es_install_log.txt
}
function install_acmonitor_plugin()
{
    echo "Installing install_acmonitor_plugin begin."
    #ѹļ޸ļacmonitor-cfg.yaml
    echo "..........step1:Stop Acmonitor.........."
    cd ${INSTALL_PATH}/acmonitor_setup/
    bash stop.sh >/dev/null 2>&1
    echo "..........step2:Generate configuration file.........."
    cd ${INSTALL_PATH}/acmonitor_setup/
    #д
    echo  'register_conf: ' > acmonitor-cfg.yaml
    echo  '  ac_cluster_ip_list: ' >> acmonitor-cfg.yaml
    echo  '  - '${ac_cluster_ip_list} >> acmonitor-cfg.yaml
    if [ ! -z "${ac_cluster_ip_list_1}" ]; then
        echo  '  - '${ac_cluster_ip_list_1} >> acmonitor-cfg.yaml
    fi
    echo '  ac_port: 18002' >>acmonitor-cfg.yaml
    echo '  ac_north_user: ' >>acmonitor-cfg.yaml
    echo '  ac_north_passwd: ' >>acmonitor-cfg.yaml
    echo '  cluster_name: '${cluster_name} >>acmonitor-cfg.yaml
    echo '  store_endpoints: ' >>acmonitor-cfg.yaml
    echo  '  - '${store_endpoints} >> acmonitor-cfg.yaml
    echo  'sys_settings: ' >> acmonitor-cfg.yaml
    echo '  start_mode: '${start_mode} >>acmonitor-cfg.yaml
    echo '  cni_type: '${cni_type} >>acmonitor-cfg.yaml
    echo '  calico_without_etcd: '${calico_without_etcd} >>acmonitor-cfg.yaml
    if [ "${cni_type}" == "calico" ] && [ "${calico_without_etcd}" == "true" ]; then
        echo 'Create calico-etcd first.' >>es_install_log.txt
        echo 'If you run it on the OpenShift, make sure etcd image has been pulled to registry and calico-etcd.yaml is valid.' >>es_install_log.txt
        install_calico_etcd
    fi
    echo '  cni_requeue_max_times: '${cni_requeue_max_times} >>acmonitor-cfg.yaml
    echo '  pod_requeue_max_times: '${pod_requeue_max_times} >>acmonitor-cfg.yaml
    echo '  pod_workers: '${pod_workers} >>acmonitor-cfg.yaml
    #дǱ
    declare -A webmap=(["read_tiemout"]=${readtimeout} ["read_header_timeout"]=${readheadertimeout} ["write_timeout"]=${writetimeout} ["idle_timeout"]=${idletimeout} ["timeout"]=${timeout} ["keepalive"]=${keepalive})
    declare -A logmap=(["log_max_backups"]=${log_max_backups} ["log_max_size"]=${log_max_size} ["log_dir"]=${log_dir} ["log_name"]=${log_name} ["log_level"]=${log_level} ["enable_log_stdout"]=${enable_log_stdout})
    declare -A sysmap=(["heartbeat"]=${heart_beat} ["network_workers"]=${network_workers} ["ac_retry"]=${ac_retry} ["etcd_retry"]=${etcd_retry} ["cni_retry"]=${cni_retry} ["k8s_client_qps"]=${k8s_client_qps} ["k8s_client_burst"]=${k8s_client_burst} ["sync_duration"]=${sync_duration} ["etcd_timeout"]=${etcd_timeout} ["etcd_dial_timeout"]=${etcd_dial_timeout})
    arr_web_name=('read_tiemout' 'read_header_timeout' 'write_timeout' 'idle_timeout' 'timeout' 'keepalive')
    arr_log_name=('log_max_backups' 'log_max_size' 'log_dir' 'log_name' 'log_level' 'enable_log_stdout' )
    arr_sys_name=('heartbeat' 'network_workers' 'ac_retry' 'etcd_retry' 'cni_retry' 'k8s_client_qps' 'k8s_client_burst' 'sync_duration' 'etcd_timeout' 'etcd_dial_timeout')
    
    flag_sys=$(echo ${sysmap[@]})
    if [ -n "$flag_sys" ]; then
        for v in ${arr_sys_name[@]}; do
            flag_sys_value=$(echo ${sysmap[$v]})
            if [ -n "$flag_sys_value" ]; then
                echo '  '$v:' '${sysmap[$v]} >>acmonitor-cfg.yaml
            fi
        done
    fi

    flag_web=$(echo ${webmap[@]})
    if [ -n "$flag_web" ]; then
        echo  'web_settings:' >> acmonitor-cfg.yaml
        for v in ${arr_web_name[@]}; do
            flag_web_value=$(echo ${webmap[$v]})
            if [ -n "$flag_web_value" ]; then
                echo '  '$v:' '${webmap[$v]} >>acmonitor-cfg.yaml
            fi
        done
    fi

    
    flag_log=$(echo ${logmap[@]})
    if [ -n "$flag_log" ]; then
        echo  'log_settings:' >> acmonitor-cfg.yaml
        for v in ${arr_log_name[@]}; do
            flag_log_value=$(echo ${logmap[$v]})
            if [ -n "$flag_log_value" ]; then
                echo '  '$v:' '${logmap[$v]} >>acmonitor-cfg.yaml
            fi
        done
    fi
    
}

function gen_yaml(){
    cd ${INSTALL_PATH}/acmonitor_setup/

    rm -rf $tmpfile
    cp $acmonitor_cfg_file $tmpfile

    bin/account_tools -encryption-type certificate -config-file  acmonitor-cfg.yaml -password=${acmonitor_cert_passwd}	
    bin/account_tools -config-file $tmpfile -cert-file $certfile -username=${ac_north_user} -password=${ac_north_passwd}
    echo '---' > $acmonitor_yaml
    cat $acmonitor_secret tpl/acmonitor-tpl.yaml >> $acmonitor_yaml

    sed -i 's/^/    /' $tmpfile
    sed -i "/__ACMONITOR__/ r $tmpfile" $acmonitor_yaml
    sed -i '/__ACMONITOR__/d' $acmonitor_yaml

    tag=$(ls images/ | grep "acmonitor.*tar" | head -n 1 | sed 's/^acmonitor-//g' | sed 's/.tar$//g')
    sed -i "s/__IMAGE_TAG__/$tag/g" $acmonitor_yaml
    
    oc version > /dev/null 2>&1
    if [ $? -eq 0 ];then
        sed -i 's/__RUN_POD_ON_MASTER__/\"true\"/' $acmonitor_yaml
    else
        sed -i 's/__RUN_POD_ON_MASTER__/\"\"/' $acmonitor_yaml
    fi

    rm $tmpfile $acmonitor_secret
}

function check_result()
{
ips=(${host_ip} ${host_ip2} ${host_ip3} ${host_ip4} ${host_ip5})
for ((i=1;i<=5;i++)); do
sleep 30
    index=0
    for ip in ${ips[@]}; do
        if [ -n "$ip" ]; then
            result=$(kubectl  get pods -n kube-system --all-namespaces -owide | grep acmonitor | grep $ip | awk '{print $4}')
            if [ "${result}" != "Running" ]; then
                echo $ip:$result
            else
                let index++
            fi
        fi
    done
    if [ "$index" == ${#ips[*]} ]; then
        echo install success!!!
        return 0
    fi
    if [ "$i" == 5 ]; then
        echo Error : install failed
        return 1
    fi
done
}
getcheckresult()
{
   if [ "$1" -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /root/scripts_plugin/check_install_acmonitor_result.sh
   ">/root/scripts_plugin/check_install_acmonitor_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /root/scripts_plugin/check_install_acmonitor_result.sh
   ">/root/scripts_plugin/check_install_acmonitor_result.sh
   fi
   chmod 755 /root/scripts_plugin/check_install_acmonitor_result.sh > /dev/null 2>&1
}        
#main
install_acmonitor
kubectl apply -f ${INSTALL_PATH}/acmonitor_setup/$CERTIFICATE_SECRETE_YAML > /dev/null 2>&1
kubectl apply -f ${INSTALL_PATH}/acmonitor_setup/$acmonitor_yaml > /dev/null 2>&1
#У
check_result
getcheckresult $?
exit $?