#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境安装AC-DCN插件参数
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

EASYSUITE_LOG='/var/log/neutron/easysuite_install.log'
SCRIPT_NAME=$(basename $0)
LOG_PRINT="eval echo \`date +\"%Y-%m-%d %T\"\` \"[$SCRIPT_NAME]\"  [INFO] :"

#param from cmd
hwac_json_rpc_ip=$1
ops_name=$2
physical_net=$3
enable_security_group=$4

echo "es_input: ac_user" 
read ac_user
echo "es_input: ac_user_psw" 
read ac_user_psw
echo "es_input: keystone_psw" 
read keystone_psw
echo "es_input: os_password" 
read os_password

ac_user=${ac_user}
ac_user_psw=${ac_user_psw}
keystone_psw=${keystone_psw}
os_password=${os_password}

#source environment path
source set_env<<EOF > /dev/null 2>&1
1
$os_password
EOF

$LOG_PRINT  "Begin to add host-role controller-plugin"  >> $EASYSUITE_LOG
cd /root
CONTROLLER_ID=$(cat /etc/uuid)
plugin_role=$(cps host-role-list ${CONTROLLER_ID} | grep controller-plugin)

#配置角色
if [ "${plugin_role}" ]; then
    cps role-host-delete --host $CONTROLLER_ID controller-plugin
    cps commit
	sleep 40
fi
cps role-host-add --host $CONTROLLER_ID controller-plugin
cps commit
sleep 50

#修改配置文件
echo "starting to modify basic config files.........."
$LOG_PRINT  "starting to modify basic config files." >> $EASYSUITE_LOG

bak_conf="/etc/neutron/huawei_driver_config_easysuite.ini"
if [ ! -e "$bak_conf" ]; then
    cp /etc/neutron/huawei_driver_config.ini /root/easysuite_install/huawei_driver_config_easysuite.ini
fi

cd /etc/neutron
chmod 600 huawei_driver_config.ini
chown openstack huawei_driver_config.ini
chgrp openstack huawei_driver_config.ini

check_config=$(grep -n "huawei_driver_config.ini" /etc/neutron/neutron-server/SetState.sh)
if [ "$check_config" = "" ];then
    sed -i "/.*--config-file=.*/s/$/& --config-file=\/etc\/neutron\/huawei_driver_config.ini/g" /etc/neutron/neutron-server/SetState.sh
fi


cd /etc/neutron
$LOG_PRINT  "Encrypt ac user password." >> $EASYSUITE_LOG
AC_USER_PSW=${ac_user_psw}
PASSWORD=$(python /root/networking-huawei/tools/encode.py "${AC_USER_PSW}" account_passwd)

$LOG_PRINT  "Encrypt keystone password." >> $EASYSUITE_LOG
KEYSTONE_PASSWD=${keystone_psw}
KEYSTONE_PASSWD=$(python /root/networking-huawei/tools/encode.py "${KEYSTONE_PASSWD}" keystone_auth_passwd)

ZK_SERVICE_CACHE_PARSER_FILE='/usr/bin/install_tool/zk_cache_cfg_parser.py'
DC_ADMIN_NAME=$(python $ZK_SERVICE_CACHE_PARSER_FILE -s cps -t cps-web -c dc_admin_name)
OS_AUTH_URL=$(python $ZK_SERVICE_CACHE_PARSER_FILE -s cps -t cps-web -c os_internal_url)
if [[ -n $(echo $OS_AUTH_URL | grep '2.0') ]]; then
    OS_AUTH_URL=$(echo ${OS_AUTH_URL%/*})
fi
EXTERNAL_OM_IP=$(ip a | grep external_om | grep inet | grep -v secondary | awk '{print $2}')
EXTERNAL_OM_IP=$(echo ${EXTERNAL_OM_IP%/*})

if [[ $(cat /etc/hostos.version) =~ ((6\.5\.RC1)|V100R006C30SPC[1-2]|(6\.5\.1)|(8\.0)|(21\.)) ]]; then
    $LOG_PRINT  "Configure huawei_driver_config with cps command." >> $EASYSUITE_LOG
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_agent_config.rpc_server_ip=$hwac_json_rpc_ip
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.ac_auth_username=$ac_user
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.ac_auth_password=${ac_user_psw}
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.cloud_name=$ops_name
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.physical_network=$physical_net
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.keystone_passwd=${keystone_psw}
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.enable_security_group=$enable_security_group
    if [[ $(cat /etc/hostos.version) =~ (6\.5\.RC1) ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere6.5'
    elif [[ $(cat /etc/hostos.version) =~ V100R006C30SPC[1-2] ]];then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere6.3.1'
    elif [[ $(cat /etc/hostos.version) =~ (6\.5\.1) ]];then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere6.5.1'
    elif [[ $(cat /etc/hostos.version) =~ (8\.0\.3) ]];then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere8.0.3'
    elif [[ $(cat /etc/hostos.version) =~ (8\.0) ]];then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere8.0.0'
    elif [[ $(cat /etc/hostos.version) =~ (21\.) ]];then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere21.0'
    fi
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_agent_config.host_ip=$EXTERNAL_OM_IP
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.keystone_tenant=dc_system_${DC_ADMIN_NAME}
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.keystone_user=${DC_ADMIN_NAME}_admin
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.auth_url=${OS_AUTH_URL}
else
    $LOG_PRINT  "Modify huawei_driver_config.ini direct." >> $EASYSUITE_LOG
    HWAC_JSON_RPC_IP="${hwac_json_rpc_ip}"
    sed -i "s/#\{0,1\}\(rpc_server_ip =\).*/\1 $HWAC_JSON_RPC_IP/" huawei_driver_config.ini
    
    AC_USER="${ac_user}"
    sed -i "s/#\{0,1\}\(ac_auth_username =\).*/\1 $AC_USER/" huawei_driver_config.ini
    
    sed -i "s#\#\{0,1\}\(ac_auth_password =\).*#\1 $PASSWORD#g" huawei_driver_config.ini
    
    OPS_NAME="${ops_name}"
    sed -i "s/#\{0,1\}\(cloud_name =\).*/\1 $OPS_NAME/" huawei_driver_config.ini
    
    PHYSICAL_NET="${physical_net}"
    sed -i "s/#\{0,1\}\(physical_network =\).*/\1 $PHYSICAL_NET/" huawei_driver_config.ini
    
    sed -i "s#\#\{0,1\}\(keystone_passwd =\).*#\1 $KEYSTONE_PASSWD#g" huawei_driver_config.ini
    
    ENABLE_SECURITY_GROUP="${enable_security_group}"
    if [ -n "${enable_security_group}" ]; then
        sed -i "s#\#\{0,1\}\(enable_security_group =\).*#\1 $ENABLE_SECURITY_GROUP#g" huawei_driver_config.ini
    fi
fi
$LOG_PRINT  "Exec cps commit." >> $EASYSUITE_LOG
cps commit
sleep 5

echo "change basic config files end."
$LOG_PRINT  "Change basic config with huawei_drive_config end." >> $EASYSUITE_LOG