#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境安装AC-DCN插件参数
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

EASYSUITE_LOG='/var/log/neutron/easysuite_install.log'
SCRIPT_NAME=$(basename $0)
LOG_PRINT="eval echo \`date +\"%Y-%m-%d %T\"\` \"[$SCRIPT_NAME]\"  [INFO] :"
PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
API_EXROUTE_CUSTOM=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute_custom

#param from cmd
neutron_sync_type=$1
neutron_sync_time=$2
neutron_sync_enable_white_list=$3
f5_host_mappings=$4
network_black_list=$5
network_white_list=$6
primary_interface=$7
vpc_peering=$8
logical_hostnames=$9
vcenter_host_mappings=${10}
vcenter_cluster_mappings=${11}
vcenter_network_mappings=${12}
vhost_user=${13}
security_group_sync_times=${14}
public_service_networks=${15}
default_public_service_network=${16}
enable_ce1800v_dhcp=${17}
is_enable_vpc_connection=${18}
is_enable_trunk=${19}
is_enable_bgp_route=${20}
is_enable_bgpneighbor=${21}
is_enable_custom_vpc_connection=${22}
is_enable_exroute_custom=${23}
is_enable_external_whitelist=${24}
is_enable_flow_mirror=${25}

echo "es_input: os_password" 
read os_password
os_password=${os_password}

neutron_sync_type=${neutron_sync_type:18}
neutron_sync_time=${neutron_sync_time:18}
neutron_sync_enable_white_list=${neutron_sync_enable_white_list:31}
f5_host_mappings=${f5_host_mappings:17}
network_black_list=${network_black_list:19}
network_white_list=${network_white_list:19}
primary_interface=${primary_interface:18}
vpc_peering=${vpc_peering:12}
logical_hostnames=${logical_hostnames:18}
vcenter_host_mappings=${vcenter_host_mappings:22}
vcenter_cluster_mappings=${vcenter_cluster_mappings:25}
vcenter_network_mappings=${vcenter_network_mappings:25}
vhost_user=${vhost_user:11}
security_group_sync_times=${security_group_sync_times:26}
public_service_networks=${public_service_networks:24}
default_public_service_network=${default_public_service_network:31}
enable_ce1800v_dhcp=${enable_ce1800v_dhcp:20}
is_enable_vpc_connection=${is_enable_vpc_connection:26}
is_enable_trunk=${is_enable_trunk:16}
is_enable_bgp_route=${is_enable_bgp_route:20}
is_enable_bgpneighbor=${is_enable_bgpneighbor:22}
is_enable_custom_vpc_connection=${is_enable_custom_vpc_connection:32}
is_enable_exroute_custom=${is_enable_exroute_custom:25}
is_enable_external_whitelist=${is_enable_external_whitelist:29}
is_enable_flow_mirror=${is_enable_flow_mirror:22}

source set_env<<EOF > /dev/null 2>&1
1
$os_password
EOF


#修改配置文件
echo "starting to modify other config.........."
$LOG_PRINT  "Starting to modify other config in huawei_driver_config" >> $EASYSUITE_LOG

cd /etc/neutron

if [[ $(cat /etc/hostos.version) =~ ((6\.5\.RC1)|V100R006C30SPC[1-2]|(6\.5\.1)|(8\.0)) ]]; then
    $LOG_PRINT  "Configure huawei_driver_config with cps command." >> $EASYSUITE_LOG
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.f5_host_mappings=$f5_host_mappings
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.network_black_list=$network_black_list
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.network_white_list=$network_white_list
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.primary_interface=$primary_interface
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.vpc_peering=$vpc_peering
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.neutron_sync_type=$neutron_sync_type
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.neutron_sync_time=$neutron_sync_time
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.neutron_sync_enable_white_list=$neutron_sync_enable_white_list
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.logical_hostnames=$logical_hostnames
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.vcenter_host_mappings=$vcenter_host_mappings
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.vcenter_cluster_mappings=$vcenter_cluster_mappings
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.vcenter_network_mappings=$vcenter_network_mappings
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.vhost_user=$vhost_user
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.security_group_sync_times=$security_group_sync_times
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.public_service_networks=$public_service_networks
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.default_public_service_network=$default_public_service_network
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.enable_ce1800v_dhcp=$enable_ce1800v_dhcp
else
    $LOG_PRINT  "Modify huawei_driver_config.ini direct." >> $EASYSUITE_LOG
    F5_HOST_MAPPINGS="${f5_host_mappings}"
    if [ -n "${f5_host_mappings}" ]; then
        sed -i "s#\#\{0,1\}\(f5_host_mappings =\).*#\1 $F5_HOST_MAPPINGS#g" huawei_driver_config.ini
    fi
    NETWORK_BLACK_LIST="${network_black_list}"
    if [ -n "${network_black_list}" ]; then
        sed -i "s#\#\{0,1\}\(network_black_list =\).*#\1 $NETWORK_BLACK_LIST#g" huawei_driver_config.ini
    fi
    NETWORK_WHITE_LIST="${network_white_list}"
    if [ -n "${network_white_list}" ]; then
        sed -i "s#\#\{0,1\}\(network_white_list =\).*#\1 $NETWORK_WHITE_LIST#g" huawei_driver_config.ini
    fi
    PRIMARY_INTERFACE="${primary_interface}"
    if [ -n "${primary_interface}" ]; then
        sed -i "s#\#\{0,1\}\(primary_interface =\).*#\1 $PRIMARY_INTERFACE#g" huawei_driver_config.ini
    fi
    VPC_PEERING="${vpc_peering}"
    if [ -n "${vpc_peering}" ]; then
        sed -i "s#\#\{0,1\}\(vpc_peering =\).*#\1 $VPC_PEERING#g" huawei_driver_config.ini
    fi
    NEUTRON_SYNC_TYPE="${neutron_sync_type}"
    if [ -n "${neutron_sync_type}" ]; then
        sed -i "s#\#\{0,1\}\(neutron_sync_type =\).*#\1 $NEUTRON_SYNC_TYPE#g" huawei_driver_config.ini
    fi
    NEUTRON_SYNC_TIME="${neutron_sync_time}"
    if [ -n "${neutron_sync_time}" ]; then
        sed -i "s#\#\{0,1\}\(neutron_sync_time =\).*#\1 $NEUTRON_SYNC_TIME#g" huawei_driver_config.ini
    fi   
    NEUTRON_SYNC_ENABLE_WHITE_LIST="${neutron_sync_enable_white_list}"
    if [ -n "${neutron_sync_enable_white_list}" ]; then
        sed -i "s#\#\{0,1\}\(neutron_sync_enable_white_list =\).*#\1 $NEUTRON_SYNC_ENABLE_WHITE_LIST#g" huawei_driver_config.ini
    fi
    LOGICAL_HOSTNAMES="${logical_hostnames}"
    if [ -n "${logical_hostnames}" ]; then
        sed -i "s#\#\{0,1\}\(logical_hostnames =\).*#\1 $LOGICAL_HOSTNAMES#g" huawei_driver_config.ini
    fi
    VCENTER_HOST_MAPPINGS="${vcenter_host_mappings}"
    if [ -n "${vcenter_host_mappings}" ]; then
        sed -i "s#\#\{0,1\}\(vcenter_host_mappings =\).*#\1 $VCENTER_HOST_MAPPINGS#g" huawei_driver_config.ini
    fi    
    VCENTER_CLUSTER_MAPPINGS="${vcenter_cluster_mappings}"
    if [ -n "${vcenter_cluster_mappings}" ]; then
        sed -i "s#\#\{0,1\}\(vcenter_cluster_mappings =\).*#\1 $VCENTER_CLUSTER_MAPPINGS#g" huawei_driver_config.ini
    fi
    VCENTER_NETWORK_MAPPINGS="${vcenter_network_mappings}"
    if [ -n "${vcenter_network_mappings}" ]; then
        sed -i "s#\#\{0,1\}\(vcenter_network_mappings =\).*#\1 $VCENTER_NETWORK_MAPPINGS#g" huawei_driver_config.ini
    fi
    VHOST_USER="${vhost_user}"
    if [ -n "${vhost_user}" ]; then
        sed -i "s#\#\{0,1\}\(vhost_user =\).*#\1 $VHOST_USER#g" huawei_driver_config.ini
    fi
    SECURITY_GROUP_SYNC_TIMES="${security_group_sync_times}"
    if [ -n "${security_group_sync_times}" ]; then
        sed -i "s#\#\{0,1\}\(security_group_sync_times =\).*#\1 $SECURITY_GROUP_SYNC_TIMES#g" huawei_driver_config.ini
    fi
    PUBLIC_SERVICE_NETWORKS="${public_service_networks}"
    if [ -n "${public_service_networks}" ]; then
        sed -i "s#\#\{0,1\}\(public_service_networks =\).*#\1 $PUBLIC_SERVICE_NETWORKS#g" huawei_driver_config.ini
    fi
    DEFAULT_PUBLIC_SERVICE_NETWORK="${default_public_service_network}"
    if [ -n "${default_public_service_network}" ]; then
        sed -i "s#\#\{0,1\}\(default_public_service_network =\).*#\1 $DEFAULT_PUBLIC_SERVICE_NETWORK#g" huawei_driver_config.ini
    fi
    ENABLE_CE1800V_DHCP="${enable_ce1800v_dhcp}"
    if [ -n "${enable_ce1800v_dhcp}" ]; then
        sed -i "s#\#\{0,1\}\(enable_ce1800v_dhcp =\).*#\1 $ENABLE_CE1800V_DHCP#g" huawei_driver_config.ini
    fi
fi

cd /etc/neutron

current_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
update_service_plugins=${current_service_plugins// /}

exists_api_extensions_path=`sed '/^api_extensions_path =/!d;s/.*=//' /etc/neutron/neutron.conf`
update_ext_api=${exists_api_extensions_path// /}


# confirm to config trunk plugin
if [ "$is_enable_trunk" == "true" ]; then
    if [[ $current_service_plugins =~ trunk ]]; then
       echo -e "\033[31m trunk plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,trunk
    fi
fi

# confirm to config huawei_ac_bgp_route plugin
if [ "$is_enable_bgp_route" == "true" ]; then
    if [[ $current_service_plugins =~ huawei_ac_bgp_route ]]; then
       echo -e "\033[31m bgp route plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_bgp_route
    fi
fi

# confirm to config huawei_ac_bgpneighbor plugin
if [ "$is_enable_bgpneighbor" == "true" ]; then
    if [[ $current_service_plugins =~ huawei_ac_bgpneighbor ]]; then
       echo -e "\033[31m bgpneighbor plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_bgpneighbor
    fi
fi

# confirm to config huawei_ac_custom_vpc_connection plugin
if [ "$is_enable_custom_vpc_connection" == "true" ]; then
    if [[ $current_service_plugins =~ huawei_ac_custom_vpc_connection ]]; then
       echo -e "\033[31m custom vpc connection already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_custom_vpc_connection
    fi
fi

# confirm to config exroute_custom plugin
if [ "$is_enable_exroute_custom" == "true" ]; then
    if [[ $exists_api_extensions_path =~ exroute_custom ]]; then
       echo -e "\033[31m exroute custom already install \033[0m"
    else
        update_ext_api=$update_ext_api:$API_EXROUTE_CUSTOM
    fi
fi

# confirm to config huawei_ac_external_whitelist plugin
if [ "$is_enable_external_whitelist" == "true" ]; then
    if [[ $current_service_plugins =~ huawei_ac_external_whitelist ]]; then
       echo -e "\033[31m external whitelist plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_external_whitelist
    fi
fi

# confirm to config huawei_ac_flow_mirror plugin
if [ "$is_enable_flow_mirror" == "true" ]; then
    if [[ $current_service_plugins =~ huawei_ac_flow_mirror ]]; then
       echo -e "\033[31m flow mirror plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_flow_mirror
    fi
fi

if [ $current_service_plugins != $update_service_plugins ]; then
    cps template-params-update --service neutron neutron-server --parameter service_plugins=$update_service_plugins
fi

if [ $exists_api_extensions_path != $update_ext_api ]; then
    cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$update_ext_api
fi

$LOG_PRINT  "Exec cps commit." >> $EASYSUITE_LOG
cps commit
sleep 5

echo "change other config end."
$LOG_PRINT  "Change other config with huawei_drive_config end."  >> $EASYSUITE_LOG
