#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: 安装openstatck
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
echo "es_input: openstack_db_user" 
read openstack_db_user
echo "es_input: openstack_db_password" 
read openstack_db_password
echo "es_input: ac_user" 
read ac_user
echo "es_input: ac_user_psw" 
read ac_user_psw
echo "es_input: keystone_uname" 
read keystone_uname
echo "es_input: keystone_psw" 
read keystone_psw

ops_db_username=${openstack_db_user}
ops_db_psw=${openstack_db_password}
username=${ac_user}
password=${ac_user_psw}
keystone_user=${keystone_uname}
keystone_passwd=${keystone_psw}

rpc_server_ip=$1
node_ip=$2
ops_version=$3
cloud_name=$4
enable_snat=$5
enable_security_group=$6
keystone_tenant=$7
auth_url=$8
enable_firewall=$9   
enable_vpn=${10}
enable_qos=${11}
enable_dnat=${12}
enable_vpc_connection=${13}
enable_snat_plugin=${14}
enable_bgp_route=${15}
physical_network=${16}
vhost_user=${17}
enable_ce1800v_dhcp=${18}
security_group_sync_times=${19}
auth_url=${auth_url:13}
vhost_user=${vhost_user:11}
enable_ce1800v_dhcp=${enable_ce1800v_dhcp:20}
security_group_sync_times=${security_group_sync_times:26}
enable_firewall_rule=${20}
enable_l2br=${21}

PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")

function install_openstatck()
{
    get_install_path

    install_openstatck_plugin   
}

#---------------------------------------------------------------------------
#  Function:    get_install_path
#  Description: 获取安装路径
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function get_install_path()
{
    #software install dir

    INSTALL_PATH="/root"
    echo "INSTALL_PATH: ${INSTALL_PATH}"
    echo "INSTALL_PLUGIN_HOME=${INSTALL_PATH}" >> /etc/profile
    echo "export INSTALL_PLUGIN_HOME" >> /etc/profile  
    source /etc/profile
}

#---------------------------------------------------------------------------
#  Function:    change_mode_and_owner
#  Description: 修改python文件权限和属主
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function change_mode_and_owner()
{
    for file in $(ls $1)
    do
        if [ -d "$1""/""$file" ]; then
            chmod 500 $1"/"$file
            chown neutron:neutron $1"/"$file
            change_mode_and_owner $1"/"$file
        else
            chmod 400 $1"/"$file
            chown neutron:neutron $1"/"$file
        fi
    done
}

#---------------------------------------------------------------------------
#  Function:    change_mode_and_owner_read
#  Description: 修改python文件权限和属主
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function change_mode_and_owner_read()
{
    for file in $(ls $1)
    do
        if [ -d "$1""/""$file" ]; then
            change_mode_and_owner_read $1"/"$file
        else
            chmod 444 $1"/"$file
            chown neutron:neutron $1"/"$file
        fi
    done
}

function fix_plugin_db(){
    DB_USERNAME="${ops_db_username}" #OpenStack数据库用户名
    ops_db_psw=${ops_db_psw}
    DB_PASSWORD="${ops_db_psw}" #Openstack数据库密码
    modify_action="ALTER "
    modify_target="TABLE "
    db_modify_sql=${modify_action}${modify_target}"neutron.huawei_ac_plugin MODIFY COLUMN data LONGBLOB;"
    mysql -u$DB_USERNAME -p$DB_PASSWORD -e "${db_modify_sql}"
}

#---------------------------------------------------------------------------
#  Function:    install_openstatck_plugin
#  Description: 安装openstatck_plugin
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function install_openstatck_plugin()
{
    echo "Installing install_openstatck_plugin begin."
    #解压文件并执行set.py脚本
    echo "..........step1:Execute install script.........."
    cd $INSTALL_PATH
    PLUG_PKG="networking-huawei.tar.gz"
    if [ ! -e "${PLUG_PKG}" ]; then
        echo "Installing install_openstatck_plugin failed, because ${PLUG_PKG} does not exist."
        exit 1
    fi
    tar -zxvf $PLUG_PKG -C "${INSTALL_PATH}" >/dev/null 2>&1
    chmod 500 ${INSTALL_PATH}/networking-huawei/tools/modify_controller_account.py
    chmod 500 ${INSTALL_PATH}/networking-huawei/tools/modify_pwd_keystone.py
    chmod 500 ${INSTALL_PATH}/networking-huawei/tools/modify_pwd.py
    mkdir -p ${INSTALL_PATH}/networking-huawei/tools/certs
    cd ${INSTALL_PATH}/networking-huawei
    if [ $ops_version == "Wallaby" ]; then
      python setup.py install --prefix=/usr 1>/dev/null
    else
      python setup.py install 1>/dev/null
    fi

    EGG_VERSION=$(grep '^Version' $INSTALL_PATH/networking-huawei/networking_huawei.egg-info/PKG-INFO | awk '{print $2}')
    PYTHON_VERSION=$(python -c "import sys; print ('py%s.%s' % (sys.version_info.major, sys.version_info.minor))")
    NETWORKING_HUAWEI=$PYTHON_PATH/networking_huawei
    NETWORKING_HUAWEI_EGG=$PYTHON_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info

    #修改python文件权限为400，属主为neutron
    change_mode_and_owner $NETWORKING_HUAWEI
    change_mode_and_owner_read $NETWORKING_HUAWEI_EGG

    OPS_VERSION="${ops_version}"
    cd ${INSTALL_PATH}/networking-huawei/
    oslo-config-generator --config-file ${INSTALL_PATH}/networking-huawei/etc/oslo-config-generator/huawei_driver.ini >/dev/null 2>&1
    mv ${INSTALL_PATH}/networking-huawei/etc/huawei_driver_config.ini.sample /etc/neutron/huawei_driver_config.ini
    sed -i "s/#\(OPS_version =\).*/\1 $OPS_VERSION/" /etc/neutron/huawei_driver_config.ini
    #升级数据库
    echo "..........step2:Upgrade database.........."
    cd ${INSTALL_PATH}
    neutron-db-manage upgrade head >/dev/null 2>&1
    neutron-db-manage --subproject networking-huawei upgrade head >/dev/null 2>&1
    fix_plugin_db >/dev/null 2>&1

    function kilo_neutron_db()
    {
        cd /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions
        head_version=$(cat HEAD | head -1)
        ORG_VERSION=$(neutron-db-manage history | grep "fd3d34c9969e," | awk '{print $1}')
        if [ -z "$ORG_VERSION" ]; then
            sed -i "s/.*\(down_revision =\).*/\1 '$head_version'/" /root/networking-huawei/networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/c4818a243f6f_huawei_ac_mechanisam_driver.py
            cp -f /root/networking-huawei/networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/* /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions
        else
            awk 'BEGIN { cmd="cp -ri /root/networking-huawei/networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/* /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions/"; print "n" |cmd; }'
        fi
        if [ -e /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions/270980b1080d_initial_branch.py ];then
            rm -rf /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions/270980b1080d_initial_branch.py
        fi
        echo 'k8b9f89d309f' > HEAD
        neutron-db-manage --config-file /etc/neutron/neutron.conf upgrade head
    }
    if [[ "${ops_version}" == "Kilo" ]]; then
        kilo_neutron_db >/dev/null 2>&1
    fi

    #生成配置文件
    echo "..........step3:Generate configuration file.........."
    sed -i '/^#.*value)$/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^# From networking_huawei.ac_config/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#$/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#token_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#token_retry.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_interval.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_interval.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_count.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_count.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#ac_detect_period.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#ac_detect_period.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#rpc_server_base_ip.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#rpc_server_base_ip.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#enable_cert.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#enable_cert.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#logical_hostnames.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#logical_hostnames.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_host_mappings.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_host_mappings.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_cluster_mappings.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_cluster_mappings.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_network_mappings.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_network_mappings.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#primary_interface.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#primary_interface.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vpc_peering.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vpc_peering.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#timeout_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#timeout_retry.*/d' /etc/neutron/huawei_driver_config.ini
    
    #修改配置文件权限为600，属主为neutron
    chmod 600 /etc/neutron/huawei_driver_config.ini
    chown neutron:neutron /etc/neutron/huawei_driver_config.ini
    
    #拷贝白名单文件到配置目录
    cp -f ${INSTALL_PATH}/networking-huawei/tools/whitelist_sample.ini /etc/neutron/whitelist.ini
    
    #change config file mode to 600
    chmod 600 /etc/neutron/whitelist.ini

    #change config file owner to neutron
    chown neutron:neutron /etc/neutron/whitelist.ini
    
    #修改配置文件
    echo "..........step4:Modify configuration file.........."
    cd /etc/neutron/

    RPC_SERVER_IP="${rpc_server_ip}"
    sed -i "s/#\(rpc_server_ip =\).*/\1 $RPC_SERVER_IP/" huawei_driver_config.ini
      
    NODE_IP="${node_ip}"
    sed -i "s/#\(host_ip =\).*/\1 $NODE_IP/" huawei_driver_config.ini
   
    USERNAME="${username}"
    sed -i "s/#\(ac_auth_username =\).*/\1 $USERNAME/" huawei_driver_config.ini
    
    password=${password}
    PASSWORD=$(python ${INSTALL_PATH}/networking-huawei/tools/encode.py "${password}" account_passwd)

    sed -i "s#\#\(ac_auth_password =\).*#\1 $PASSWORD#g" huawei_driver_config.ini

    WEBSOCKET_KEY_PASSWORD=$(cat ${INSTALL_PATH}/networking-huawei/tools/networking_huawei_config.txt | grep websocket_key_password | awk -F ' = ' '{print $2}'| sed s/[[:space:]]//g)
    sed -i "s/#\(websocket_key_password =\).*/\1 $WEBSOCKET_KEY_PASSWORD/" huawei_driver_config.ini

    PHYSICAL_NETWORK="${physical_network}"
    sed -i "s/#\(physical_network =\).*/\1 $PHYSICAL_NETWORK/" huawei_driver_config.ini

    CLOUD_NAME="${cloud_name}"
    sed -i "s/#\(cloud_name =\).*/\1 $CLOUD_NAME/" huawei_driver_config.ini
   
    ENABLE_SNAT="${enable_snat}"
    sed -i "s/#\(enable_snat =\).*/\1 $ENABLE_SNAT/" huawei_driver_config.ini

    ENABLE_SECURITY_GROUP="${enable_security_group}"
    sed -i "s/#\(enable_security_group =\).*/\1 $ENABLE_SECURITY_GROUP/" huawei_driver_config.ini
    
    KEYSTONE_TENANT="${keystone_tenant}"
    sed -i "s/#\(keystone_tenant =\).*/\1 $KEYSTONE_TENANT/" huawei_driver_config.ini
    
    KEYSTONE_USER="${keystone_user}"
    sed -i "s/#\(keystone_user =\).*/\1 $KEYSTONE_USER/" huawei_driver_config.ini
    
    keystone_passwd=${keystone_passwd}
    KEYSTONE_PASSWD=$(python ${INSTALL_PATH}/networking-huawei/tools/encode.py "${keystone_passwd}" keystone_auth_passwd)
    sed -i "s#\#\(keystone_passwd =\).*#\1 $KEYSTONE_PASSWD#g" huawei_driver_config.ini

    AUTH_URL="${auth_url}"
	if [ -n "${auth_url}" ]; then
        sed -i "s#\#\{0,1\}\(auth_url =\).*#\1 $AUTH_URL#g" huawei_driver_config.ini
    fi  

    VHOST_USER="${vhost_user}"
	if [ -n "${vhost_user}" ]; then
        sed -i "s#\#\{0,1\}\(vhost_user =\).*#\1 $VHOST_USER#g" huawei_driver_config.ini
    fi

    ENABLE_CE1800V_DHCP="${enable_ce1800v_dhcp}"
	if [ -n "${enable_ce1800v_dhcp}" ]; then
        sed -i "s#\#\{0,1\}\(enable_ce1800v_dhcp =\).*#\1 $ENABLE_CE1800V_DHCP#g" huawei_driver_config.ini
    fi

    SECURITY_GROUP_SYNC_TIMES="${security_group_sync_times}"
    sed -i "s#\#\(security_group_sync_times =\).*#\1 $SECURITY_GROUP_SYNC_TIMES#g" huawei_driver_config.ini

    
    # 修改启动文件
    echo "..........step5:Modify boot file.........."
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "neutron-server.service does not exist."
        return 1
    fi
    
    cp neutron-server.service  backup_neutron-server.service.backup
    
    signal=$(grep "^KillSignal[[:space:]]*=" /usr/lib/systemd/system/neutron-server.service)
    if [ -n "$signal" ]; then
        sed -i "s/.*\(KillSignal=\).*/\1SIGKILL/" /usr/lib/systemd/system/neutron-server.service
    else
        sed -i 'N;/\[Service\]/a\KillSignal=SIGKILL' /usr/lib/systemd/system/neutron-server.service
    fi

    NEUTRON_SERVER_SERVICE=/usr/lib/systemd/system/neutron-server.service
    EXEC_STOP="ps -ef | grep -w neutron-server | grep -w huawei_driver_config.ini | grep -v grep | awk '{if(\$2 != \" \"){print \"kill -9 \"\$2} else{exit}}' | sh"
    grep ExecStop $NEUTRON_SERVER_SERVICE
    if [ $? -eq 0 ]; then
        sed -i "s/.*\(ExecStop=\).*/\1$EXEC_STOP/" $NEUTRON_SERVER_SERVICE
    else
        sed -i "N;/\[Service\]/a\ExecStop=$EXEC_STOP" $NEUTRON_SERVER_SERVICE
    fi
    
    cat neutron-server.service | grep ^ExecStart | grep -v /etc/neutron/huawei_driver_config.ini
    if [ $? -eq 0 ]; then
        sed -i "s/\(^ExecStart.*\)/\1 --config-file \/etc\/neutron\/huawei_driver_config.ini/g" neutron-server.service
    fi
    
    #使能华为插件
    echo "..........step6:Enable HUAWEI plug-in.........."
    cd /etc/neutron/plugins/ml2/
    if [ ! -f ml2_conf.ini ]; then
        echo "ml2_conf.ini does not exist."
        return 1
    fi
    cp ml2_conf.ini  backup_ml2_conf.backup
    mech_drivers=$(cat ml2_conf.ini | grep ^mechanism_drivers)
    if [ -n "$mech_drivers" ]; then
        old_mech_drivers=$(echo $mech_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g)
        if [[ ! "$old_mech_drivers" =~ huawei_ac_ml2 ]]; then
            sed -i "s/^mechanism_drivers[[:space:]]*=.*/mechanism_drivers = huawei_ac_ml2,$old_mech_drivers/g" ml2_conf.ini
        fi
    else 
        sed -i "3a\mechanism_drivers = huawei_ac_ml2,openvswitch" ml2_conf.ini
    fi
    
    cd /etc/neutron/
    if [ ! -f neutron.conf ]; then
        echo "neutron.conf does not exist."
        return 1
    fi
    cp neutron.conf backup_neutron.backup
    sed -i "/^vlan_transparent/d" neutron.conf
    sed -i '/^api_extensions_path/d' neutron.conf
    service_plugins=$(grep "^service_plugins[[:space:]]*=" neutron.conf)
    old_service_plugin=$(echo $service_plugins | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    old_plugin_string=${old_service_plugin//,/ }
    old_plugin_array=($old_plugin_string)

    plugins_str="service_plugins = huawei_ac_router,huawei_ac_ext,huawei_ac_sync_result,huawei_ac_compare_result"
    extensions_path_str="api_extensions_path = ${PYTHON_PATH}/networking_huawei/drivers/ac/extensions/exroute:${PYTHON_PATH}/networking_huawei/drivers/ac/extensions/sync"

    ENABLE_VPN="${enable_vpn}"
    if [[ "${ENABLE_VPN}" == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_ipsecvpn'
        if [[ "${ops_version}" != "Kilo" ]]; then
            extensions_path_str=${extensions_path_str}":${PYTHON_PATH}/neutron_vpnaas/extensions"
        fi
    fi

    ENABLE_FIREWALL="${enable_firewall}"
    if [[ "${ENABLE_FIREWALL}" == "true" ]] && [[ "${ops_version}" != "Wallaby" ]]; then
        plugins_str=${plugins_str}',huawei_ac_fwaas'
        if [[ "${ops_version}" != "Kilo" ]]; then
            extensions_path_str=${extensions_path_str}':/usr/lib/python2.7/site-packages/neutron_fwaas/extensions'
        fi
    fi

    ENABLE_QOS="${enable_qos}"
    if [[ "${ENABLE_QOS}" == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_qos'
        notification_drivers_str=${notification_drivers_str}',huawei_ac_qos_driver'
        extent_drivers=$(cat /etc/neutron/plugins/ml2/ml2_conf.ini | grep "^extension_drivers")
        if [ -n "$extent_drivers" ]; then
            old_extent_drivers=$(echo $extent_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g)
            if [[ ! "$old_extent_drivers" =~ qos ]]; then
                sed -i "s/^extension_drivers[[:space:]]*=.*/extension_drivers = qos,$old_extent_drivers/g" /etc/neutron/plugins/ml2/ml2_conf.ini
            fi
        else
            sed -i "/^\[ml2\]/a\extension_drivers = qos" /etc/neutron/plugins/ml2/ml2_conf.ini
        fi
        cat neutron.conf | grep "^\[qos\]"
        if [ $? -eq 0 ]; then
            notify_drivers=$(cat neutron.conf | grep "^notification_drivers")
            if [ -n "$notify_drivers" ]; then
                old_notify_drivers=$(echo $notify_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g)
                if [[ ! "$old_notify_drivers" =~ huawei_ac_qos_driver ]]; then
                    sed -i "s/^notification_drivers[[:space:]]*=.*/notification_drivers = huawei_ac_qos_driver,$old_notify_drivers/g" neutron.conf
                fi
            else
                sed -i "/^\[qos\]/a\notification_drivers = huawei_ac_qos_driver,message_queue" neutron.conf
            fi
        else
            echo >> neutron.conf
            echo "[qos]" >> neutron.conf
            notify_drivers=$(cat neutron.conf | grep "^notification_drivers")
            if [ -n "$notify_drivers" ]; then
                old_notify_drivers=$(echo $notify_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g)
                if [[ ! "$old_notify_drivers" =~ huawei_ac_qos_driver ]]; then
                    sed -i "s/^notification_drivers[[:space:]]*=.*/notification_drivers = huawei_ac_qos_driver,$old_notify_drivers/g" neutron.conf
                fi
            else
                sed -i "/^\[qos\]/a\notification_drivers = huawei_ac_qos_driver,message_queue" neutron.conf
            fi
        fi
    fi

	ENABLE_FIREWALL_RULE="${enable_firewall_rule}"
    if [[ "${ENABLE_FIREWALL_RULE}" == "true" ]] && [[ "${ops_version}" != "Wallaby" ]]; then
        extent_drivers=$(grep "^extension_drivers[[:space:]]*=" /etc/neutron/plugins/ml2/ml2_conf.ini)
        if [ -n "$extent_drivers" ]; then
            old_extent_drivers=$(echo $extent_drivers | cut -d "=" -f 2 | sed s/[[:space:]]//g)
            if [[ ! "$old_extent_drivers" =~ huawei_ac_firewall_rule ]]; then
                sed -i "s/^extension_drivers[[:space:]]*=.*/extension_drivers = $old_extent_drivers, huawei_ac_firewall_rule/g" /etc/neutron/plugins/ml2/ml2_conf.ini
            fi
        else
            sed -i "/^\[ml2\]/a\extension_drivers = huawei_ac_firewall_rule" /etc/neutron/plugins/ml2/ml2_conf.ini
        fi
    fi

    ENABLE_DNAT="${enable_dnat}"
    if [[ "${ENABLE_DNAT}" == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_dnat'
    fi

    ENABLE_VPC_CONNECTION="${enable_vpc_connection}"
    if [[ "${ENABLE_VPC_CONNECTION}" == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_vpc_connection'
    fi

    ENABLE_SNAT_PLUGIN="${enable_snat_plugin}"
    if [[ "${ENABLE_SNAT_PLUGIN}" == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_snat'
    fi

    ENABLE_BGP_ROUTE="${enable_bgp_route}"
    if [[ "${ENABLE_BGP_ROUTE}" == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_bgp_route'
    fi

    ENABLE_L2BR="${enable_l2br}"
    if [[ ${ENABLE_L2BR} == "true" ]]; then
        plugins_str=${plugins_str}',huawei_ac_l2br'
    fi

  declare -A PORT_FORWARDING_DICT
  PORT_FORWARDING_DICT=(["Rocky"]="Rocky" ["Train"]="Train" ["Wallaby"]="Wallaby")
	if [[  -n ${PORT_FORWARDING_DICT[${ops_version}]} ]]; then
        plugins_str=${plugins_str}',huawei_ac_portforwarding'
    fi

    cd /etc/neutron/
    add_service_plugin=""
    for(( i=0;i<${#old_plugin_array[@]};i++))do
        huawei_config=${old_plugin_array[i]}
        if [[ ! "${plugins_str}" =~ "${huawei_config}" ]]; then
            if [[ ! "${huawei_config}" =~ (firewall|vpnaas) ]] && [[ ! "${huawei_config}" =~ "huawei" ]]; then
                add_service_plugin=${add_service_plugin}",${huawei_config}"
            fi
        fi
    done

    if [ -n "${add_service_plugin}" ]; then
        plugins_str=${plugins_str}"${add_service_plugin}"
    fi

    cat neutron.conf | grep ^service_plugins
    if [ $? -eq 0 ]; then
        sed -i "s/^service_plugins.*/${plugins_str}/g" neutron.conf
    else
        sed -i "4a${plugins_str}" neutron.conf
    fi
    sed -i '/^service_plugins.*/a\vlan_transparent = True' neutron.conf
    sed -i "/^service_plugins.*/a${extensions_path_str}" neutron.conf
 
    #重启neutron-server
    echo "..........step7:Restart neutron-server.........."
    cd /root/
    setenforce 0 >/dev/null 2>&1
    systemctl daemon-reload
    if [ "$OPS_VERSION" = "Newton" -o $OPS_VERSION = "Ocata" ]; then
        ps -ef | grep -w neutron-server | grep -w huawei_driver_config.ini | grep -v grep | awk '{if($2 != " "){print "kill -9 "$2} else{exit}}' | /usr/bin/sh
        systemctl start neutron-server.service
    else
        systemctl restart neutron-server.service
    fi
    if [ -e "${INSTALL_PATH}"/networking-huawei/build  ];then 
        rm -rf ${INSTALL_PATH}/networking-huawei/build 
    fi
    if [ -e "${INSTALL_PATH}"/networking-huawei/networking_huawei.egg-info ];then 
        rm -rf ${INSTALL_PATH}/networking-huawei/networking_huawei.egg-info
    fi
    
    echo "Installing install_openstatck_plugin end."
}
function clean_openstatck_plugin()
{
    echo "Clean_openstatck_plugin before install"
    echo "Clean_openstatck_plugin begin."
    if [ -e ${PYTHON_PATH}/networking_huawei ];then
        rm -rf ${PYTHON_PATH}/networking_huawei
    fi
    EGG_VERSION=$(grep '^Version' $INSTALL_PATH/PKG-INFO | awk '{print $2}')
    PYTHON_VERSION=$(python -c "import sys; print ('py%s.%s' % (sys.version_info.major, sys.version_info.minor))")
    NETWORKING_HUAWEI_EGG=$PYTHON_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info
    if [ -e ${NETWORKING_HUAWEI_EGG} ];then
        rm -rf ${NETWORKING_HUAWEI_EGG}
    fi
    if [ -e /etc/neutron/huawei_driver_config.ini ];then
        rm -f /etc/neutron/huawei_driver_config.ini
    fi
    if [ -e /etc/neutron/whitelist.ini ];then
        rm -f /etc/neutron/whitelist.ini
    fi
    if [ -e /root/networking-huawei/ ];then
        rm -rf /root/networking-huawei/
    fi
    # 修改启动文件
    echo "..........step1:Modify boot file.........."
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "neutron-server.service does not exist."
    fi
    if [ ! -f backup_neutron-server.service.backup ]; then
        echo "backup_neutron-server.service.backup does not exist."
    else
        cp -f backup_neutron-server.service.backup neutron-server.service
        rm -f backup_neutron-server.service.backup
    fi
    
    #卸载华为插件
    function rollback_config()
    {
        current_file=$1
        config_name=$2
        huawei_config_lists=$3
        rollback_config_lists=$4
        OLD_IFS="$IFS"
        IFS=" "
        huawei_config_list=($huawei_config_lists)
        rollback_config_list=($rollback_config_lists)
        IFS="$OLD_IFS"
        seperator=$5
        label=$6
        current_config=$(sed "/^$config_name[[:space:]]*=/!d;s/.*=//" $current_file)
        new_config=$(echo $current_config | sed -e "s/[[:space:]]//g")
        new_config=$(echo $new_config | sed -e "s|^$seperator||" | sed -e "s|$seperator$||")
        ##remove huawei config
        for(( i=0;i<${#huawei_config_list[@]};i++))do
            huawei_config=${huawei_config_list[i]}
            rollback_to=${rollback_config_list[i]}
            if [[ "$rollback_to" != "" ]];then
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$seperator|$rollback_to$seperator|g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$seperator|$seperator$rollback_to$seperator|g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$|$seperator$rollback_to|g")
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$|$rollback_to|g")
            else
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$seperator||g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$seperator|$seperator|g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$||g")
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$||g")
            fi
        done
        new_config=$(echo $new_config | sed -e "s/^$seperator//" | sed -e "s/$seperator$//")
        ##write into config file
        if [[ -n "$current_config" ]]; then
            if [[ -n "$new_config" ]]; then
                sed -i "s#^$config_name[[:space:]]*=.*#$config_name = $new_config#g" $current_file
            else
                sed -i "s#^$config_name[[:space:]]*=.*#\#$config_name = #g" $current_file
            fi
        else
            if [[ -n "$new_config" ]]; then
                new_config=$(echo $new_config | sed 's#/#\\/#g')
                sed -i "/^\[${label}\]/a $config_name = $new_config" $current_file
            fi
        fi
        echo "original config is: $current_config"
        echo "rollback config to: $new_config"
        echo ""
    }
    
    ML2_CONF_CUR=/etc/neutron/plugins/ml2/ml2_conf.ini
    NEUTRON_CONF_CUR=/etc/neutron/neutron.conf
    ##mechanism_drivers
    echo "  unable huawei mechanism drivers"
    mechanism_drivers_name=mechanism_drivers
    huawei_mechanism_list=(huawei_ac_ml2)
    rollback_mechanism_list=("")
    rollback_config $ML2_CONF_CUR $mechanism_drivers_name "${huawei_mechanism_list[*]}" "${rollback_mechanism_list[*]}" ',' 'ml2'
    
    ##extension_drivers
    echo "  unable huawei extension_drivers"
    extension_drivers_name=extension_drivers
    huawei_extension_drivers_list=(huawei_ac_binding huawei_ac_status_port huawei_ac_status_firewall_policy)
    rollback_extension_list=("" "" "")
    rollback_config $ML2_CONF_CUR $extension_drivers_name "${huawei_extension_drivers_list[*]}" "${rollback_extension_list[*]}" ',' 'ml2'
    
    ##policy_drivers
    echo "  unable huawei policy_drivers"
    policy_drivers_name=policy_drivers
    huawei_policy_drivers_list=(huawei_ac_gbp)
    rollback_policy_list=("")
    rollback_config $NEUTRON_CONF_CUR $policy_drivers_name "${huawei_policy_drivers_list[*]}" "${rollback_policy_list[*]}" ',' 'group_policy'
    
    ##service_plugins
    echo "  unable huawei service_plugins"
    service_plugins_name=service_plugins
    huawei_service_plugins_list=(huawei_ac_router huawei_ac_ext huawei_ac_fwaas huawei_ac_ipsecvpn huawei_ac_qos huawei_ac_dnat huawei_ac_vpc_connection huawei_ac_bgp_route huawei_ac_l2br huawei_ac_snat)
    rollback_service_list=(router "" firewall vpnaas "" "" "" "" "" "")
    rollback_config $NEUTRON_CONF_CUR $service_plugins_name "${huawei_service_plugins_list[*]}" "${rollback_service_list[*]}" ',' 'DEFAULT'
    
    ##api_extensions_path
    echo "  unable huawei api_extensions_path"
    api_extensions_path_name=api_extensions_path
    api_exroute=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute
    api_sync=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync
    api_fwaas=$PYTHON_PATH/neutron_fwaas/extensions
    api_vpnaas=$PYTHON_PATH/neutron_vpnaas/extensions
    huawei_ac_extensions_path_list=($api_exroute $api_sync $api_fwaas $api_vpnaas)
    rollback_extensions_path_list=("" "" "" "")
    rollback_config $NEUTRON_CONF_CUR $api_extensions_path_name "${huawei_ac_extensions_path_list[*]}" "${rollback_extensions_path_list[*]}" ':' 'DEFAULT'
    
    ##notification_drivers
    echo "  unable huawei notification_drivers"
    notification_drivers_name=notification_drivers
    huawei_notification_drivers_list=(huawei_ac_qos_driver)
    rollback_notification_list=("")
    rollback_config $NEUTRON_CONF_CUR $notification_drivers_name "${huawei_notification_drivers_list[*]}" "${rollback_notification_list[*]}" ',' 'qos'
    
    if [ -e /etc/neutron/plugin.ini ];then
        rm -f /etc/neutron/plugin.ini
    fi
    ln -s /etc/neutron/plugins/ml2/ml2_conf.ini /etc/neutron/plugin.ini

    systemctl daemon-reload
    systemctl stop neutron-server.service
    $(ps -ef|grep neutron | grep -v grep | awk '{print $2}'|xargs -r kill -9 )
    echo "Clean_openstatck_plugin end."
}

#main
clean_openstatck_plugin
install_openstatck

