create table if not exists tab_dcn_oam_portmirror (
	mirror_id nvarchar2(256) not null,
	mirror_name nvarchar2(256),
	device_id nvarchar2(256),
	mirror_port nvarchar2(64),
	observe_port nvarchar2(64),
	observe_index bigint,
	mirror_direction integer,
	mirror_type integer,
	src_ip nvarchar2(32),
	remote_ip nvarchar2(32),
	description nvarchar2(256),
	create_time bigint,
	update_time bigint,
	constraint pk_dcn_oam_portmirror primary key (mirror_id)
);
drop index if exists idx_dcn_oam_portmirror_mirror_name;
create index idx_dcn_oam_portmirror_mirror_name on  tab_dcn_oam_portmirror (mirror_name);
drop index if exists idx_dcn_oam_portmirror_device_id;
create index idx_dcn_oam_portmirror_device_id on  tab_dcn_oam_portmirror (device_id);


create table if not exists tab_dcn_oam_service_vmmirror
(
	mirror_id nvarchar2(256) not null,
	mirror_name nvarchar2(256),
	host_name nvarchar2(256),
	host_ip nvarchar2(32),
	vm_ip nvarchar2(32),
	vm_mac nvarchar2(256),
	neutron_port_id nvarchar2(256),
	tenant_name nvarchar2(256),
	tenant_id nvarchar2(256),
	mirror_direction integer,
	remote_ip nvarchar2(32),
	description nvarchar2(256),
	device_type integer,
	create_time bigint,
	update_time bigint,
	constraint pk_dcn_oam_service_vmmirror primary key (mirror_id)
);

drop index if exists idx_dcn_oam_service_vmmirror_mirror_name;
create index idx_dcn_oam_service_vmmirror_mirror_name on  tab_dcn_oam_service_vmmirror (mirror_name);
drop index if exists idx_dcn_oam_service_vmmirror_vm_mac_tenant_id;
create index idx_dcn_oam_service_vmmirror_vm_mac_tenant_id on  tab_dcn_oam_service_vmmirror (vm_mac,tenant_id);
drop index if exists idx_dcn_oam_service_vmmirror_vm_mac_host_name_tenant_id;
create index idx_dcn_oam_service_vmmirror_vm_mac_host_name_tenant_id on  tab_dcn_oam_service_vmmirror (vm_mac,host_name,tenant_id);


create table if not exists tab_dcn_oam_service_vmmirror_device (
	id nvarchar2(256) not null,
	device_ip nvarchar2(32),
	device_name nvarchar2(256),
	device_id nvarchar2(256),
	device_type integer,
	mirror_port nvarchar2(64),
	observe_port nvarchar2(64),
	observe_index bigint,
	vm_mirror_id nvarchar2(256),
	constraint pk_dcn_oam_service_vmmirror_device primary key (id)
);

drop index if exists idx_dcn_oam_service_vmmirror_device_device_id;
create index idx_dcn_oam_service_vmmirror_device_device_id on  tab_dcn_oam_service_vmmirror_device (device_id);


create table if not exists tab_dcn_oam_service_vmmirror_quintuple (
	id nvarchar2(256) not null,
	src_ip nvarchar2(256),
	src_mask nvarchar2(256),
	src_port_or_type nvarchar2(256),
	dest_ip nvarchar2(256),
	dest_mask nvarchar2(256),
	dest_port_or_code integer,
	protocol integer,
	ip_type integer,
    vm_mirror_id nvarchar2(256),
	constraint pk_dcn_oam_service_vmmirror_quintuple primary key (id)
);


create table if not exists tab_dcn_oam_mirror_capacity (
	id nvarchar2(64) not null,
	status boolean,
	constraint pk_dcn_oam_mirror_capacity primary key (id)
);



create table if not exists tab_dcn_oam_observeport (
	port_id nvarchar2(256) not null,
	port_name nvarchar2(256) not null,
	device_id nvarchar2(256) not null,
	observe_index bigint,
	src_ip nvarchar2(32),
	remote_ip nvarchar2(32),
	tunnel_id integer,
	create_time bigint,
	update_time bigint,
	constraint pk_dcn_oam_observeport primary key (port_id)
);

drop index if exists idx_dcn_oam_observeport_port_name;
create index idx_dcn_oam_observeport_port_name on  tab_dcn_oam_observeport (port_name);
drop index if exists idx_dcn_oam_observeport_device_id;
create index idx_dcn_oam_observeport_device_id on  tab_dcn_oam_observeport (device_id);


create table if not exists tab_dcn_oam_mirrortask (
	mirror_id nvarchar2(256) not null,
	mirror_name nvarchar2(256) not null,
	erspan_id integer,
	flow_type integer,
	mirror_direction integer,
	filter_type integer,
	description nvarchar2(256) not null,
	create_time bigint,
	update_time bigint,
	constraint pk_dcn_oam_mirrortask primary key (mirror_id)
);



create table if not exists tab_dcn_oam_mirrorportbonding (
	id nvarchar2(256) not null,
	mirror_port_name nvarchar2(256) not null,
	device_id nvarchar2(256) not null,
	observe_port_id nvarchar2(256) not null,
	mirror_id nvarchar2(256) not null,
	constraint pk_dcn_oam_mirrorportbonding primary key (id)
);
drop index if exists idx_tab_dcn_oam_mirrorportbonding_mirror_id;
create index idx_tab_dcn_oam_mirrorportbonding_mirror_id on  tab_dcn_oam_mirrorportbonding (mirror_id);



create table if not exists tab_dcn_oam_mirrorfilter (
	id nvarchar2(256) not null,
	filter_value nvarchar2(256) not null,
	filter_type integer,
	mirror_id nvarchar2(256) not null,
	constraint pk_dcn_oam_mirrorfilter_filter_id primary key (id)
);

drop index if exists idx_tab_dcn_oam_mirrorfilter_mirror_id;
create index idx_tab_dcn_oam_mirrorfilter_mirror_id on  tab_dcn_oam_mirrorfilter (mirror_id);
drop index if exists idx_tab_dcn_oam_mirrorfilter_filter_value;
create index idx_tab_dcn_oam_mirrorfilter_filter_value on  tab_dcn_oam_mirrorfilter (filter_value);

create table if not exists tab_dcn_oam_mirror_ne_cfg(
	ne_cfg_id nvarchar2(256) not null,
	mirror_port_name nvarchar2(256) not null,
	device_id nvarchar2(256) not null,
	observe_index bigint,
	mirror_id nvarchar2(256) not null,
	erspan_id bigint,
	mirror_direction integer,
	match_src_ip nvarchar2(256),
	match_src_ip_mask nvarchar2(256),
	match_dest_ip nvarchar2(256),
	match_dest_ip_mask nvarchar2(256),
	match_vlan integer,
	match_vni integer,
	constraint pk_dcn_oam_mirror_ne_cfg primary key (ne_cfg_id)
);
drop index if exists idx_tab_dcn_oam_mirror_ne_cfg_mirror_id;
create index idx_tab_dcn_oam_mirror_ne_cfg_mirror_id on  tab_dcn_oam_mirror_ne_cfg (mirror_id);
