#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
###########################################################################
#
#
# Description: port mirror install
#
# History: 2018/07/31 Created
#
#
###########################################################################

echo "----------[START] port mirror install START----------"
is_backup_site=$1

DIR_SHARE=/opt/oss/share
if [ ! -d /opt/oss/share ]; then
    DIR_SHARE=/opt/share
fi
tenant="NCECOMMONE"
if [ -d "/opt/oss/NCE" ] ; then
	tenant="NCE"
fi

DCNOAM_SERVICE_PATH=/opt/oss/${tenant}/apps/DCNOAMService
DCNOPENEM_SERVICE_PATH=/opt/oss/${tenant}/apps/DCNOpenEMService
DCN_SERVICE_PATH=/opt/oss/${tenant}/apps/DCNService
if [[ ! -d "${DCNOAM_SERVICE_PATH}" ]]
then
    echo "[WARNING] This is not ac node."
    exit 0
fi

INSTALL_PATH=$(dirname $(readlink -f "$0"))

MIRROR_BUNDLE_PATH_SRC=${INSTALL_PATH}/bundle
MIRROR_BUNDLE_PATH_DST=${DCNOAM_SERVICE_PATH}/controller/system/com/huawei/sdn/acdcn/
MIRROR_WEBSITE_PATH_DST=/opt/oss/${tenant}/apps/DCNWebSite/webapps/dcnwebsite

MIRROR_BUNDLE_VERSION=$(basename ${MIRROR_BUNDLE_PATH_SRC}/oam-model-api/*/*)
echo "$MIRROR_BUNDLE_VERSION"
FEATURE_PATH=${DCNOAM_SERVICE_PATH}/lib/${MIRROR_BUNDLE_VERSION}
if [[ ! -f "${FEATURE_PATH}" ]]
then
    echo "[ERROR] ac version is wrong or there is no oam feature." >&2
    echo "[ERROR] The expected version of AC is [${MIRROR_BUNDLE_VERSION}]" >&2
    echo "[ERROR] The expected oam feature path is [${FEATURE_PATH}] " >&2
    exit 1
fi


cd ${MIRROR_BUNDLE_PATH_SRC}

cp -rf oam-mirror-model-api/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
cp -rf component-oam-mirror-api/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
cp -rf component-oam-mirror-service/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
cp -rf northbound-oam-app-restful-plugin/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
cp -rf oam-mirror-ui-plugin/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
cp -rf oam-service-mirror/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
cp -rf oam-service-mirror-dao/*/*.jar ${DCNOAM_SERVICE_PATH}/lib
chown -R ossuser:ossgroup ${DCNOAM_SERVICE_PATH}/lib
chmod -R 400 ${DCNOAM_SERVICE_PATH}/lib/*.jar

cp -rf oam-mirror-model-api/*/*.jar ${DCNOPENEM_SERVICE_PATH}/lib
cp -rf ovs-mirror-api/*/*.jar ${DCNOPENEM_SERVICE_PATH}/lib
cp -rf ovs-mirror-dao/*/*.jar ${DCNOPENEM_SERVICE_PATH}/lib
cp -rf ovscfg-mirror/*/*.jar ${DCNOPENEM_SERVICE_PATH}/lib
cp -rf ovs-mirror-model/*/*.jar ${DCNOPENEM_SERVICE_PATH}/lib
cp -rf oam-mirror-model-service/*/*.jar ${DCNOPENEM_SERVICE_PATH}/lib
chown -R ossuser:ossgroup ${DCNOPENEM_SERVICE_PATH}/lib
chmod -R 400 ${DCNOPENEM_SERVICE_PATH}/lib/*.jar


cp -rf neutron-mirror-data-model/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf neutron-mirror-dao/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf neutron-mirror-service/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf neutron-mirror-restful-plugin/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf component-oam-mirror-api/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf oam-model-api/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf oam-service-model/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf oam-mirror-model-api/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf component-oam-service-api/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf rest-services-huawei-ac-iapi-oam-service-tap-service-client/*/*.jar ${DCN_SERVICE_PATH}/lib
cp -rf rest-services-huawei-ac-iapi-oam-service-vm-mirror-client/*/*.jar ${DCN_SERVICE_PATH}/lib
chown -R ossuser:ossgroup ${DCN_SERVICE_PATH}/lib
chmod -R 400 ${DCN_SERVICE_PATH}/lib/*.jar

cp -rf ${MIRROR_BUNDLE_PATH_SRC}/webroot/portMirroring-app ${MIRROR_WEBSITE_PATH_DST}
chown -R ossuser:ossgroup ${MIRROR_WEBSITE_PATH_DST}
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.svg" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.png" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.PNG" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.gif" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.js" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.htm" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.html" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.jpg" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.css" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.jpeg" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.bmp" -exec chmod 440 {} \;
find ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app -name "*.properties" -exec chmod 640 {} \;


#操作日志
cp -rf ${MIRROR_BUNDLE_PATH_SRC}/controller/configuration/omsys/operation-logs/*Port* ${DCNOAM_SERVICE_PATH}/controller/configuration/omsys/operation-logs/
cp -rf ${MIRROR_BUNDLE_PATH_SRC}/controller/configuration/omsys/operation-logs/*Neutron* ${DCN_SERVICE_PATH}/controller/configuration/omsys/operation-logs/
chown -R ossuser:ossgroup ${DCNOAM_SERVICE_PATH}/controller/configuration/omsys/operation-logs/*
chown -R ossuser:ossgroup ${DCN_SERVICE_PATH}/controller/configuration/omsys/operation-logs/*
find ${DCNOAM_SERVICE_PATH}/controller/configuration/omsys/operation-logs -name "*.xml" -exec chmod 640 {} \;
find ${DCN_SERVICE_PATH}/controller/configuration/omsys/operation-logs -name "*.xml" -exec chmod 640 {} \;

#权限点文件
cp -rf ${MIRROR_BUNDLE_PATH_SRC}/etc/authconf/auth/oam* ${DCNOAM_SERVICE_PATH}/etc/authconf/auth/
cp -rf ${MIRROR_BUNDLE_PATH_SRC}/etc/authconf/auth/neutron* ${DCN_SERVICE_PATH}/etc/authconf/auth/
chown -R ossuser:ossgroup ${DCNOAM_SERVICE_PATH}/etc/authconf/auth/*
chmod -R 640 ${DCNOAM_SERVICE_PATH}/etc/authconf/auth/*.json
chown -R ossuser:ossgroup ${DCN_SERVICE_PATH}/etc/authconf/auth/*
chmod -R 640 ${DCN_SERVICE_PATH}/etc/authconf/auth/*.json

#替换context.xml文
grep "acdcn.oam.mirror.ui"  ${DCNOAM_SERVICE_PATH}/webapps/ROOT/WEB-INF/web.xml
if [[ $? != 0 ]]
then
	sed -i '/Restconf yang end/a\<!-- oam plugin -->\n<servlet>\n<servlet-name>dc oam plugin Servlet</servlet-name>\n<servlet-class>org.glassfish.jersey.servlet.ServletContainer</servlet-class>\n<init-param>\n<param-name>jersey.config.server.provider.packages</param-name>\n<param-value>com.huawei.sdn.acdcn.oam.mirror.ui</param-value>\n</init-param>\n<init-param>\n<param-name>jersey.config.server.provider.classnames</param-name>\n<param-value>org.glassfish.jersey.jackson.JacksonFeature</param-value>\n</init-param>\n<load-on-startup>1</load-on-startup>\n<async-supported>true</async-supported>\n</servlet>\n<servlet-mapping>\n<servlet-name>dc oam plugin Servlet</servlet-name>\n<url-pattern>/acdcn/ui/oamapp/mirror/*</url-pattern>\n</servlet-mapping>\n<!-- oam plugin -->' ${DCNOAM_SERVICE_PATH}/webapps/ROOT/WEB-INF/web.xml
fi
cp -rf ${INSTALL_PATH}/openemservice_plugin_applicationContext.xml ${DCNOPENEM_SERVICE_PATH}/webapps/ROOT/WEB-INF/classes/spring/
chown -R ossuser:ossgroup ${DCNOPENEM_SERVICE_PATH}/webapps/ROOT/WEB-INF/classes/spring/*
chmod 640 ${DCNOPENEM_SERVICE_PATH}/webapps/ROOT/WEB-INF/classes/spring/openemservice_plugin_applicationContext.xml
cp -rf ${INSTALL_PATH}/dcnservice_plugin_applicationContext.xml ${DCN_SERVICE_PATH}/webapps/ROOT/WEB-INF/classes/spring/
chown -R ossuser:ossgroup ${DCN_SERVICE_PATH}/webapps/ROOT/WEB-INF/classes/spring/*
chmod 640 ${DCN_SERVICE_PATH}/webapps/ROOT/WEB-INF/classes/spring/dcnservice_plugin_applicationContext.xml



#openapi
if [ -d "${DIR_SHARE}/manager/DeployAgent/svcs-pub/${tenant}-Product-APIManagementService-apimanagementservice/" ]
then
	DCNOAMService_yaml_name=DCNService-mirror-serviceapis-conf.yaml
    DCNOAMService_pub_path=/opt/oss/${tenant}/apps/DCNOAMService/pub/openapi
    cd ${DIR_SHARE}/manager/DeployAgent/svcs-pub/${tenant}-Product-APIManagementService-apimanagementservice/DCNOAMService*;
    cp -rf ${MIRROR_BUNDLE_PATH_SRC}/pub/openapi/DCNService-mirror-serviceapis-conf.yaml  ${DCNOAMService_pub_path}
    chown -R ossuser:ossgroup ${DCNOAMService_pub_path}/${DCNOAMService_yaml_name}
    chmod -R 640 ${DCNOAMService_pub_path}/${DCNOAMService_yaml_name}
    mirror_api_path=${DCNOAMService_pub_path}/${DCNOAMService_yaml_name}
    su - ossuser -c "/opt/oss/${tenant}/apps/APIManagementService/bin/apiHandler.sh  -f ${mirror_api_path}" 

    DCNService_yaml_name=DCNService-neutron-mirror-serviceapis-conf.yaml
    DCNService_pub_path=/opt/oss/${tenant}/apps/DCNService/pub/openapi
    cd ${DIR_SHARE}/manager/DeployAgent/svcs-pub/${tenant}-Product-APIManagementService-apimanagementservice/DCNService*;
    cp -rf ${MIRROR_BUNDLE_PATH_SRC}/pub/openapi/DCNService-neutron-mirror-serviceapis-conf.yaml  ${DCNService_pub_path}
    chown -R ossuser:ossgroup ${DCNService_pub_path}/${DCNService_yaml_name}
    chmod -R 640 ${DCNService_pub_path}/${DCNService_yaml_name}
    mirror_api_path2=${DCNService_pub_path}/${DCNService_yaml_name}
    su - ossuser -c "/opt/oss/${tenant}/apps/APIManagementService/bin/apiHandler.sh  -f ${mirror_api_path2}"
fi

su ossadm -c "source /opt/oss/manager/agent/bin/engr_profile.sh && export SSL_ROOT=/opt/oss/manager/etc/ssl && python ${INSTALL_PATH}/portmirror_i18n.py && python ${INSTALL_PATH}/portmirror_permissions.py && python ${INSTALL_PATH}/portmirror_permissions_user_add.py"

#非容灾备站点的情况下重启服务
if [[ ${is_backup_site} == "backup_site_disable" ]]; then
	su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -app DCNOAMService"
	if [ $? -ne 0 ];then
		echo "The DCNOAMService stop failed.">&2
		exit 1
	fi

	su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd startapp -app DCNOAMService"
	if [ $? -ne 0 ];then
		echo "The DCNOAMService start failed.">&2
	fi

	count=0
	while true
	do
		process=$(ps -ef | grep DCNOAMService | grep -i tomcat | awk '{print $2}')
		echo "new DCNOAMService process id:${process}"
		if [ -n "$process" ]
		then
		echo "----------[SUCCESS] port mirror install END----------"
		break
		elif [ "${count}" == 360 ]
		then
		echo "30 minutes later, the DCNOAMService process is still not up.">&2
		exit 1
		fi
		
		count=$(expr $count + 1)
		sleep 5s
	done

	su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -app DCNOpenEMService"
	if [ $? -ne 0 ];then
		echo "The DCNOpenEMService stop failed.">&2
		exit 1
	fi

	su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd startapp -app DCNOpenEMService"
	if [ $? -ne 0 ];then
		echo "The DCNOpenEMService start failed.">&2
	fi

	count=0
	while true
	do
		process=$(ps -ef | grep DCNOpenEMService | grep -i tomcat | awk '{print $2}')
		echo "new DCNOpenEMService process id:${process}"
		if [ -n "$process" ]
		then
		echo "----------[SUCCESS] port mirror install END----------"
		break
		elif [ "${count}" == 360 ]
		then
		echo "30 minutes later, the DCNOpenEMService process is still not up.">&2
		exit 1
		fi
		
		count=$(expr $count + 1)
		sleep 5s
	done

	su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -app DCNService"
	if [ $? -ne 0 ];then
		echo "The DCNService stop failed.">&2
		exit 1
	fi

	su - ossadm -c "/opt/oss/manager/agent/bin/ipmc_adm -cmd startapp -app DCNService"
	if [ $? -ne 0 ];then
		echo "The DCNService start failed.">&2
	fi

	count=0
	while true
	do
		process=$(ps -ef | grep DCNService | grep -i tomcat | awk '{print $2}')
		echo "new DCNService process id:${process}"
		if [ -n "$process" ]
		then
		echo "----------[SUCCESS] port mirror install END----------"
		exit 0
		elif [ "${count}" == 240 ]
		then
		echo "20 minutes later, the DCNService process is still not up.">&2
		exit 1
		fi	
		count=$(expr $count + 1)
		sleep 5s
	done
fi