'''
IR_entlinkmgmt.py
'''
import os
import sys
import time
import datetime
from util import httpclient
import portmirror_permissions_common_util

sys.path.append(os.path.abspath(".."))

SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
REQ_EMPTY = 5
LINK_IR = '/rest/plat/priv/v1/static-operations/resources'
INPUT_PARAM = {
    "resources": {
        "zh_CN": [
            {
                "id": "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image",
                "name": u"\u955c\u50cf",
                "description": u"\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror",
                "name": u"\u7aef\u53e3\u955c\u50cf",
                "description": u"\u7aef\u53e3\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror",
                "name": u"\u865a\u62df\u673a\u955c\u50cf",
                "description": u"\u865a\u62df\u673a\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.get:read",
                "name": u"\u67e5\u8be2\u7aef\u53e3\u955c\u50cf",
                "description": u"\u67e5\u8be2\u7aef\u53e3\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.create:create",
                "name": u"\u521b\u5efa\u7aef\u53e3\u955c\u50cf",
                "description": u"\u521b\u5efa\u7aef\u53e3\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.update:update",
                "name": u"\u4fee\u6539\u7aef\u53e3\u955c\u50cf",
                "description": u"\u4fee\u6539\u7aef\u53e3\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.delete:delete",
                "name": u"\u5220\u9664\u7aef\u53e3\u955c\u50cf",
                "description": u"\u5220\u9664\u7aef\u53e3\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.get:read",
                "name": u"\u67e5\u8be2\u865a\u62df\u673a\u955c\u50cf",
                "description": u"\u67e5\u8be2\u865a\u62df\u673a\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.create:create",
                "name": u"\u521b\u5efa\u865a\u62df\u673a\u955c\u50cf",
                "description": u"\u521b\u5efa\u865a\u62df\u673a\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.delete:delete",
                "name": u"\u5220\u9664\u865a\u62df\u673a\u955c\u50cf",
                "description": u"\u5220\u9664\u865a\u62df\u673a\u955c\u50cf"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port",
                "name": u"\u955c\u50cf\u89c2\u5bdf\u53e3",
                "description": u"\u955c\u50cf\u89c2\u5bdf\u53e3"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.get:read",
                "name": u"\u67e5\u8be2\u955c\u50cf\u89c2\u5bdf\u53e3",
                "description": u"\u67e5\u8be2\u955c\u50cf\u89c2\u5bdf\u53e3"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:create",
                "name": u"\u521b\u5efa\u955c\u50cf\u89c2\u5bdf\u53e3",
                "description": u"\u521b\u5efa\u955c\u50cf\u89c2\u5bdf\u53e3"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:delete",
                "name": u"\u5220\u9664\u955c\u50cf\u89c2\u5bdf\u53e3",
                "description": u"\u5220\u9664\u955c\u50cf\u89c2\u5bdf\u53e3"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task",
                "name": u"\u955c\u50cf\u4efb\u52a1",
                "description": u"\u955c\u50cf\u4efb\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.get:read",
                "name": u"\u67e5\u8be2\u955c\u50cf\u4efb\u52a1",
                "description": u"\u67e5\u8be2\u955c\u50cf\u4efb\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.getid:read",
                "name": u"\u5355\u4e2a\u67e5\u8be2\u955c\u50cf\u4efb\u52a1",
                "description": u"\u5355\u4e2a\u67e5\u8be2\u955c\u50cf\u4efb\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.create:create",
                "name": u"\u521b\u5efa\u955c\u50cf\u4efb\u52a1",
                "description": u"\u521b\u5efa\u955c\u50cf\u4efb\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.delete:delete",
                "name": u"\u5220\u9664\u955c\u50cf\u4efb\u52a1",
                "description": u"\u5220\u9664\u955c\u50cf\u4efb\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight",
                "name": u"\u0066\u0061\u0062\u0072\u0069\u0063\u0020"
                        u"\u0069\u006e\u0073\u0069\u0067\u0068\u0074",
                "description": u"\u0066\u0061\u0062\u0072\u0069\u0063\u0020"
                                u"\u0069\u006e\u0073\u0069\u0067\u0068\u0074"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.status.get:create",
                "name": u"\u67e5\u8be2\u0066\u0061\u0062\u0072\u0069\u0063\u0020"
                        u"\u0069\u006e\u0073\u0069\u0067\u0068\u0074\u914d\u7f6e",
                "description": u"\u67e5\u8be2\u0066\u0061\u0062\u0072\u0069"
                                u"\u0063\u0020\u0069\u006e\u0073"
                                u"\u0069\u0067\u0068\u0074\u914d\u7f6e"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.create:create",
                "name": u"\u521b\u5efa\u0066\u0061\u0062\u0072\u0069\u0063"
                        u"\u0020\u0069\u006e\u0073\u0069\u0067\u0068\u0074\u914d\u7f6e",
                "description": u"\u521b\u5efa\u0066\u0061\u0062\u0072"
                                u"\u0069\u0063\u0020\u0069\u006e"
                                u"\u0073\u0069\u0067\u0068\u0074\u914d\u7f6e"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror",
                "name": u"\u89c2\u5bdf\u53e3\u670d\u52a1",
                "description": u"\u89c2\u5bdf\u53e3\u670d\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.create:create",
                "name": u"\u521b\u5efa\u89c2\u5bdf\u53e3\u670d\u52a1",
                "description": u"\u521b\u5efa\u89c2\u5bdf\u53e3\u670d\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.delete:delete",
                "name": u"\u5220\u9664\u89c2\u5bdf\u53e3\u670d\u52a1",
                "description": u"\u5220\u9664\u89c2\u5bdf\u53e3\u670d\u52a1"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.get:read",
                "name": u"\u67e5\u8be2\u89c2\u5bdf\u53e3\u670d\u52a1",
                "description": u"\u67e5\u8be2\u89c2\u5bdf\u53e3\u670d\u52a1"
            }
        ],
        "en_US": [
            {
                "id": "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image",
                "name": "Image",
                "description": "Image"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror",
                "name": "portmirror",
                "description": "portmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror",
                "name": "vmmirror",
                "description": "vmmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.get:read",
                "name": "query portmirror",
                "description": "query portmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.create:create",
                "name": "create portmirror",
                "description": "create portmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.update:update",
                "name": "update portmirror",
                "description": "update portmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.delete:delete",
                "name": "delete portmirror",
                "description": "delete portmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.get:read",
                "name": "query vmmirror",
                "description": "query vmmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.create:create",
                "name": "create vmmirror",
                "description": "create vmmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.delete:delete",
                "name": "delete vmmirror",
                "description": "delete vmmirror"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port",
                "name": "erspan observe port",
                "description": "erspan observe port"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.get:read",
                "name": "query erspan observe port",
                "description": "query erspan observe port"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:create",
                "name": "create erspan observe port",
                "description": "create erspan observe port"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:delete",
                "name": "delete erspan observe port",
                "description": "delete erspan observe port"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task",
                "name": "erspan mirror task",
                "description": "erspan mirror task"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.get:read",
                "name": "query erspan mirror task",
                "description": "query erspan mirror task"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.getid:read",
                "name": "sigle query erspan mirror task",
                "description": "single query erspan mirror task"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.create:create",
                "name": "create erspan mirror task",
                "description": "create erspan mirror task"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.delete:delete",
                "name": "delete erspan mirror task",
                "description": "delete erspan mirror task"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight",
                "name": "fabric insight",
                "description": "fabric insight"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.status.get:create",
                "name": "query fabric insight config",
                "description": "query fabric insight config"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.create:create",
                "name": "create fabric insight config",
                "description": "create fabric insight config"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror",
                "name": "Observing port service",
                "description": "Observing port service"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.create:create",
                "name": "Create Observing port service",
                "description": "Create Observing port service"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.delete:delete",
                "name": "Delete Observing port service",
                "description": "Delete Observing port service"
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.get:read",
                "name": "Query Observing port service",
                "description": "Query Observing port service"
            }
        ]
    }
}


def getdcnsdata(connection):
    '''
    get common link data
    '''
    response = connection.post(LINK_IR, INPUT_PARAM)
    http_status = response[0]
    retry_flag = 1
    while http_status != 200 and retry_flag <= 30:
        response = connection.post(LINK_IR, INPUT_PARAM)
        http_status = response[0]
        time.sleep(6)
        retry_flag = retry_flag + 1
    if http_status == 200:
        print("Successful query PortMirror links,status code:%s", http_status)
    else:
        print("Failed to call the PortMirror, status code: %s", repr(http_status))


def main():
    '''main funtion'''
    http_connection = portmirror_permissions_common_util.getconnection()
    getdcnsdata(http_connection)
    return SUCCESS


main()
