'''
IR_entlinkmgmt.py
'''
import json
import math
import os
import sys
import time
import datetime
from urllib import parse
from util import httpclient
import portmirror_permissions_common_util 
sys.path.append(os.path.abspath(".."))


SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
REQ_EMPTY = 5
LINK_IR = '/rest/plat/priv/v1/static-operations'


def getdcnsdata(connection):
    '''
    get common link data
    '''
    input_param = {
    "resources": {
        "zh_CN": [
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig",
                "name": "\u0042\u0047\u0050\u914d\u7f6e",
                "description": "\u0042\u0047\u0050\u914d\u7f6e"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.get:read",
                "name": "\u83b7\u53d6\u0042\u0047\u0050\u914d\u7f6e",
                "description": "\u83b7\u53d6\u0042\u0047\u0050\u914d\u7f6e"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.update:update",
                "name": "\u66f4\u65b0\u0042\u0047\u0050\u914d\u7f6e",
                "description": "\u66f4\u65b0\u0042\u0047\u0050\u914d\u7f6e"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.create:create",
                "name": "\u521b\u5efa\u0042\u0047\u0050\u914d\u7f6e",
                "description": "\u521b\u5efa\u0042\u0047\u0050\u914d\u7f6e"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.delete:delete",
                "name": "\u5220\u9664\u0042\u0047\u0050\u914d\u7f6e",
                "description": "\u5220\u9664\u0042\u0047\u0050\u914d\u7f6e"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.peerInfo",
                "name": "\u5bf9\u7b49\u4f53\u4fe1\u606f",
                "description": "\u5bf9\u7b49\u4f53\u4fe1\u606f"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.peerInfo.get:read",
                "name": "\u83b7\u53d6\u5bf9\u7b49\u4f53\u4fe1\u606f",
                "description": "\u83b7\u53d6\u5bf9\u7b49\u4f53\u4fe1\u606f"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.routingInfo",
                "name": "\u8def\u7531\u67e5\u8be2",
                "description": "\u8def\u7531\u67e5\u8be2"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.routingInfo.get:read",
                "name": "\u8def\u7531\u4fe1\u606f\u67e5\u8be2",
                "description": "\u8def\u7531\u4fe1\u606f\u67e5\u8be2"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.grQuery",
                "name": "\u0047\u0052\u4fe1\u606f\u67e5\u8be2",
                "description": "\u0047\u0052\u4fe1\u606f\u67e5\u8be2"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.grQuery.get:read",
                "name": "\u83b7\u53d6\u0047\u0052\u4fe1\u606f",
                "description": "\u83b7\u53d6\u0047\u0052\u4fe1\u606f"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.query",
                "name": "\u865a\u62df\u4ea4\u6362\u673a\u8bca\u65ad\u67e5\u8be2",
                "description": "\u865a\u62df\u4ea4\u6362\u673a\u8bca\u65ad\u67e5\u8be2"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.query.get:read",
                "name": "\u83b7\u53d6\u63a7\u5236\u5668\u8bca\u65ad\u4fe1\u606f",
                "description": "\u83b7\u53d6\u63a7\u5236\u5668\u8bca\u65ad\u4fe1\u606f"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.recover",
                "name": "\u865a\u62df\u4ea4\u6362\u673a\u8bca\u65ad\u6062\u590d",
                "description": "\u865a\u62df\u4ea4\u6362\u673a\u8bca\u65ad\u6062\u590d"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.recover.update:update",
                "name": "\u6267\u884c\u63a7\u5236\u5668\u6062\u590d\u52a8\u4f5c",
                "description": "\u6267\u884c\u63a7\u5236\u5668\u6062\u590d\u52a8\u4f5c"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query",
                "name": "Flow Tracing",
                "description": "Flow Tracing"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query.vm.get:read",
                "name": "\u67e5\u8be2\u006f\u0070\u0065\u006e\u0066\u006c\u006f\u0077\u0020\u0074\u0072\u0061\u0063\u0065\u7684\u6e90\u548c\u76ee\u7684\u865a\u673a\u4fe1\u606f",
                "description": "\u67e5\u8be2\u006f\u0070\u0065\u006e\u0066\u006c\u006f\u0077\u0020\u0074\u0072\u0061\u0063\u0065\u7684\u6e90\u548c\u76ee\u7684\u865a\u673a\u4fe1\u606f"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query.route.get:read",
                "name": "\u67e5\u8be2\u006f\u0070\u0065\u006e\u0066\u006c\u006f\u0077\u0020\u0074\u0072\u0061\u0063\u0065\u7684\u6e90\u548c\u76ee\u7684\u8def\u7531\u4fe1\u606f",
                "description": "\u67e5\u8be2\u006f\u0070\u0065\u006e\u0066\u006c\u006f\u0077\u0020\u0074\u0072\u0061\u0063\u0065\u7684\u6e90\u548c\u76ee\u7684\u8def\u7531\u4fe1\u606f"
            }
        ],
        "en_US": [
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig",
                "name": "Bpg Configuration",
                "description": "Bpg Configuration"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.get:read",
                "name": "get bgp configuration",
                "description": "get bgp configuration"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.update:update",
                "name": "update bgp configuration",
                "description": "update bgp configuration"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.create:create",
                "name": "create bgp configuration",
                "description": "create bgp configuration"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.delete:delete",
                "name": "delete bgp configuration",
                "description": "delete bgp configuration"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.peerInfo",
                "name": "Peer Information",
                "description": "Peer Information"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.peerInfo.get:read",
                "name": "get peer information",
                "description": "get peer information"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.routingInfo",
                "name": "Route Information",
                "description": "Route Information"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.routingInfo.get:read",
                "name": "get route information",
                "description": "get route information"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.grQuery",
                "name": "Query GR Information",
                "description": "Query GR Information"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.bgp.service.grQuery.get:read",
                "name": "get GR information",
                "description": "get GR information"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.query",
                "name": "get controller diagnose info",
                "description": "get controller diagnose info"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.query.get:read",
                "name": "get controller diagnose info",
                "description": "get controller diagnose info"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.recover",
                "name": "execute controller diagnose action",
                "description": "execute controller diagnose action"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.recover.update:update",
                "name": "execute controller diagnose action",
                "description": "execute controller diagnose action"
            },
			{
                "id": "DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query",
                "name": "Flow Tracing",
                "description": "Flow Tracing"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query.vm.get:read",
                "name": "query openflow trace source or destination of vms",
                "description": "query openflow trace source or destination of vms"
            },
            {
                "id": "DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query.route.get:read",
                "name": "query openflow trace source or destination of remote routes",
                "description": "query openflow trace source or destination of remote routes"
            }
        ]
    }
}
    
    lt = ["DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.get:read","DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.update:update","DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.create:create","DCNService:com.huawei.dc.tenant.bgp.service.bgpConfig.delete:delete","DCNService:com.huawei.dc.tenant.bgp.service.peerInfo.get:read","DCNService:com.huawei.dc.tenant.bgp.service.routingInfo.get:read","DCNService:com.huawei.dc.tenant.bgp.service.grQuery.get:read","DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.query.get:read","DCNService:com.huawei.dc.tenant.hostservice.vswitch.diagnose.recover.update:update","DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query.vm.get:read","DCNService:com.huawei.dc.tenant.hostservice.openflow.trace.query.route.get:read"]
    string1 = parse.quote(json.dumps(lt))
    url = LINK_IR + '?operIds='+string1
    print(url)
    code,result = connection.delete(url)
    http_status = code
    retry_flag = 1
    while http_status != 200 and retry_flag <= 30:
        code,result  = connection.delete(url)
        http_status = code
        time.sleep(6)
        retry_flag = retry_flag + 1
    if http_status == 200:
        print("Successful query BGP links,status code:%s", http_status)
    else:
        print("Failed to call the dcn interface, status code: %s", repr(http_status))

def main():
    '''main funtion'''
    http_connection = portmirror_permissions_common_util.getconnection()
    res = getdcnsdata(http_connection)
    return SUCCESS


main()
