'''
IR_entlinkmgmt.py
'''
import json
import os
import sys
import time
import datetime
from util import httpclient
from util import common


sys.path.append(os.path.abspath(".."))

SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
REQ_EMPTY = 5
LINK_IR = '/rest/plat/priv/v2/operation-sets/default-operset'
COMMON_PARAM = [{
        "id": "auth:role:sysadmin",
        "permissions": [
            "DCNService:com.huawei.sdn.acdcn.portmirror.get:read",
            "DCNService:com.huawei.sdn.acdcn.portmirror.update:update",
            "DCNService:com.huawei.sdn.acdcn.portmirror.create:create",
            "DCNService:com.huawei.sdn.acdcn.portmirror.delete:delete",
            "DCNService:com.huawei.sdn.acdcn.mirror.get:read",
            "DCNService:com.huawei.sdn.acdcn.mirror.create:create",
            "DCNService:com.huawei.sdn.acdcn.mirror.delete:delete",
            "DCNService:com.huawei.sdn.acdcn.vmmirror.get:read",
            "DCNService:com.huawei.sdn.acdcn.vmmirror.create:create",
            "DCNService:com.huawei.sdn.acdcn.vmmirror.delete:delete",
            "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.create:create",
            "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.status.get:create"
        ]
    },
    {
        "id": "auth:role:northbound:interface:operator",
        "permissions": [
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.get:read",
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:create",
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:delete",
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.get:read",
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.create:create",
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.delete:delete",
            "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.getid:read"
        ]
    }]


def get_route_id_generator():
    """get route id"""
    return httpclient.RouteIDGenerator()


class CommonHttpClientPatch(httpclient.CommonHttpClient):
    """common httpClient patch method"""
    def __init__(self, http_ip, port, is_https=True, gzip=True):
        httpclient.CommonHttpClient.__init__(self, http_ip, port, is_https, gzip)

    def patch(self, url, json_obj=None):
        """patch method"""
        if json_obj is None:
            json_obj = {}
        self._try_connect()
        status = 600
        result = ''
        body_str = json.dumps(json_obj)
        headers = {}
        headers['Content-Type'] = "application/json"
        headers['Accept'] = "application/json"
        headers['x-request-id'] = get_route_id_generator().generate_router_id()
        headers.update(self.get_sia_header(url))
        headers.update(self.json_header)
        self.conn.request('PATCH', url, body=body_str, headers=headers)
        response = self.conn.getresponse()
        status = response.status
        result = common.data_bytes_to_str(response.read())
        return status, result

    @classmethod
    def get_bar(cls):
        """test method"""
        return 'bar'


def getlocalip():
    """get local ip"""
    conf_path = "cat /opt/oss/manager/var/agent/managerip.conf \
               |grep localip | awk -F '=' '{print $NF}'"
    local_ip = os.popen(
        "LOCAL_IP=` %s`;echo $LOCAL_IP" % (conf_path)).read()
    local_ip.replace(' ', '')
    _ip = local_ip.replace('\n', '')
    return _ip


def getconnection():
    """get IR connection"""
    _ip = getlocalip()
    http_connection = CommonHttpClientPatch(_ip, 32018, True, False)
    return http_connection


def getdcnsdata(connection, input_param):
    """get common link data"""
    response = connection.patch(LINK_IR, input_param)
    http_status = response[0]
    retry_flag = 1
    while http_status != 200 and retry_flag <= 30:
        response = connection.patch(LINK_IR, input_param)
        http_status = response[0]
        time.sleep(6)
        retry_flag = retry_flag + 1
    if http_status == 200:
        print("Successful query PortMirror links,status code:%s" % http_status)
    else:
        print("Failed to call the PortMirrore, status code: %s" % http_status)
