#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#创建Sybase数据库日志绕接任务
function createsybasedbcron()
{
    #获得数据库安装目录，暂时写成固定的
    dbpath="/opt/sybase"
    dbmonitor_script_path="/opt/oss/manager/tools/dbmonitor"
    
    if [ -d "${dbpath}" -a -n "$(ps -ef |grep -v grep | grep dataserver)" -a -n "$(ps -ef |grep -v grep | grep backupserver)" ]
    then
        . ${dbpath}/SYBASE.sh
        asepath="$SYBASE/$SYBASE_ASE"
        
        #创建/opt/oss/manager/tools/dbmonitor目录放置dblogmonitor.sh脚本
        if [ ! -d "${dbmonitor_script_path}" ]
        then
            mkdir -p ${dbmonitor_script_path} > /dev/null 2>&1
        fi
        tools_path=$(dirname ${dbmonitor_script_path})
        chmod 750 ${dbmonitor_script_path} > /dev/null 2>&1
        chmod 750 ${tools_path} > /dev/null 2>&1
        chown -R ossadm:ossgroup ${tools_path} > /dev/null 2>&1
        
        logger -p local0.info "sek_root.sh;get directory ${asepath} successfully."
        if [ -f "${asepath}/scripts/configureSybase/dblogmonitor.sh" ]
        then
            #复制此脚本到/opt/oss/manager/tools/dbmonitor目录并修改属性
            mv "${asepath}/scripts/configureSybase/dblogmonitor.sh" "${dbmonitor_script_path}/" && chown ossadm:ossgroup "${dbmonitor_script_path}/dblogmonitor.sh" && chmod 500 "${dbmonitor_script_path}/dblogmonitor.sh"
            if [ $? -ne 0 ]
            then
                logger -p local0.info "sek_root.sh;fail to recreate dblogmonitor.sh."
                return 1
            fi
            
            logger -p local0.info "sek_root.sh;recreate dblogmonitor.sh successfully."
            #执行Sybase数据库日志绕接任务
            bash "${dbmonitor_script_path}/dblogmonitor.sh" "install"
            if [ $? -ne 0 ]
            then
                logger -p local0.info "sek_root.sh;fail to create cron task for dblogmonitor.sh."
                return 1
            else
                logger -p local0.info "sek_root.sh;create cron task for dblogmonitor.sh successfully."
                return 0
            fi
        else
            logger -p local0.info "sek_root.sh;fail to get ${asepath}/scripts/configureSybase/dblogmonitor.sh,failed"
            return 1
        fi
    else #非NM节点
        return 0
    fi
}

restart_uniepservice()
{
    if [ -z "${INSTALL_ROOT}" ]
    then
        INSTALL_PATH="/opt/oss"
    else
        INSTALL_PATH="${INSTALL_ROOT}"
    fi
    
    #只在OMP节点执行
    if [ -d "${INSTALL_PATH}/manager/apps/UniEPService" ]
    then
        su - ossadm -c "${INSTALL_PATH}/manager/agent/bin/ipmc_adm -cmd restartapp -app UniEPService"
    fi
    return 0
}

postdo()
{
    #修改su配置，禁用su之前的用户的环境变量
    if [ -f "/etc/default/su" ];then
        sed -i "/ALWAYS_SET_PATH/ s/no/yes/g" /etc/default/su
    fi
    
    #控制文件权限
    chmod 600 /opt/install/telcoos_pubkey.pem
    chmod 600 /opt/install/telcoos_prikey.pem
    find /opt/install -type f -name "*.sh" | xargs -i echo '"{}"' | xargs chmod 550
    find /opt/tools -type f -name "*.sh" | xargs -i echo '"{}"' | xargs chmod 550
    
    for target_dir in "/opt/install" "/opt/SEK" "/opt/NCEICMR"
    do  
        if [ -d "$target_dir" ];then
            find $target_dir -type f -name "*.log" | xargs -i echo '"{}"' | xargs chmod 640
            find $target_dir -type f -name "*.xml" -o -name "*.properties" -o -name "*.conf" -o -name "*.ini" | xargs -i echo '"{}"' | xargs chmod 400
        fi
    done
    
}

main()
{
    createsybasedbcron
    
    restart_uniepservice
    
    cd /opt/tools/setSELinux && bash setSELinuxPolicy.sh
    
    grep "EulerOS" /etc/euleros-release  >/dev/null 2>&1
    if [ $? -eq 0 ];then
    	#禁用root SSH登陆，保持系统默认安全加固
        sed -i "s#^PermitRootLogin.*#PermitRootLogin no#g" /etc/ssh/sshd_config
        systemctl restart sshd.service
    fi
    
    if [ "$1" == "id_sek_select_yes" ]
    then
        if [ -f "/opt/SEK/cmd/RollBackEnv.sh" ];then
            cd /opt/SEK/cmd;bash RollBackEnv.sh
        fi
    fi
    
    #执行后置刷权限
    postdo >/dev/null 2>&1
    
    return 0
}

main $*
exit 0
