#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境卸载插件
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

echo "es_input: os_password" 
read os_password
os_password=${os_password}

source set_env<<EOF
1
$os_password
EOF

PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
PYTHON_VERSION=$(python -c "import sys; print 'py%s.%s' % (sys.version_info.major, sys.version_info.minor)")

echo "uninstall AC-DCN plugin start."
#备份文件
mkdir -p /root/easysuite_install/file_bak
mkdir -p /root/easysuite_install/file_bak/certs
if [ -d "/root/networking-huawei/" ]; then
    tar -zcvPf /root/easysuite_install/file_bak/networking-huawei-root.tar.gz /root/networking-huawei
fi
tar -zcvPf /root/easysuite_install/file_bak/networking-huawei.tar.gz $PYTHON_PATH/networking_huawei
tar -zcvPf /root/easysuite_install/file_bak/networking-huawei-egg-info.tar.gz $PYTHON_PATH/networking_huawei-3.1.0-$PYTHON_VERSION.egg-info
cp -fp /etc/neutron/neutron.conf /root/easysuite_install/file_bak/neutron.conf
if [ -f /etc/neutron/huawei_driver_config.ini ]; then
    cp -fp /etc/neutron/huawei_driver_config.ini /root/easysuite_install/file_bak/huawei_driver_config.ini
fi
cp -fp /etc/neutron/plugins/ml2/ml2_conf.ini /root/easysuite_install/file_bak/ml2_conf.ini
if [ -f /etc/neutron/whitelist.ini ]; then
    cp -fp /etc/neutron/whitelist.ini /root/easysuite_install/file_bak/whitelist.ini
fi
cp -fp /usr/lib/systemd/system/neutron-server.service /root/easysuite_install/file_bak/neutron-server.service
cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/client/ssl_cacert.pem /root/easysuite_install/file_bak/certs
cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/client.cer /root/easysuite_install/file_bak/certs
cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/client_key.pem /root/easysuite_install/file_bak/certs
cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/trust.cer /root/easysuite_install/file_bak/certs

cps package-instance-list | grep NEUTRONACPLUG | sed -n '$p' | awk '{print $2}' > /root/easysuite_install/file_bak/origin_package_version.log

bash /root/easysuite_install/clean_config.sh


#清除角色
CONTROLLER_ID=$(cat /etc/uuid)
plugin_role=$(cps host-role-list ${CONTROLLER_ID} | grep agile-controller-plugin)
if [ "${plugin_role}" ]; then
    cps role-host-delete --host $CONTROLLER_ID agile-controller-plugin
    cps commit
	sleep 40
fi
plugin_role=$(cps host-role-list ${CONTROLLER_ID} | grep controller-plugin)
if [ "${plugin_role}" ]; then
    cps role-host-delete --host $CONTROLLER_ID controller-plugin
    cps commit
	sleep 40
fi


echo "uninstall AC-DCN plugin end."
