#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    clean_openstatck
#  Description: 卸载openstatck插件
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function clean_openstatck_plugin()
{
    echo "Clean_openstatck_plugin begin."
    if [ -e /usr/lib/python2.7/site-packages/networking_huawei ];then
        rm -rf /usr/lib/python2.7/site-packages/networking_huawei
    fi
    if [ -e /usr/lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info ];then
        rm -rf /usr/lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info
    fi
    if [ -e /etc/neutron/huawei_driver_config.ini ];then
        rm -f /etc/neutron/huawei_driver_config.ini
    fi
    if [ -e /etc/neutron/whitelist.ini ];then
        rm -f /etc/neutron/whitelist.ini
    fi
    if [ -e /root/networking-huawei/ ];then
        rm -rf /root/networking-huawei/
    fi
    # 修改启动文件
    echo "..........step1:Modify boot file.........."
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "ERROR:neutron-server.service does not exist."
        return 1
    fi
    if [ ! -f backup_neutron-server.service.backup ]; then
        echo "ERROR:backup_neutron-server.service.backup does not exist."
        return 1
    fi

    cp -f backup_neutron-server.service.backup neutron-server.service
    rm -f backup_neutron-server.service.backup
    
    #卸载华为插件
    echo "..........step2:Uninstall HUAWEI plug-in.........."
    cd /etc/neutron/plugins/ml2/
    if [ ! -f ml2_conf.ini ]; then
        echo "ERROR:ml2_conf.ini does not exist."
        return 1
    fi
    if [ ! -f backup_ml2_conf.backup ]; then
        echo "WARN:backup_ml2_conf.backup does not exist."
    fi  
    cp -f backup_ml2_conf.backup ml2_conf.ini
    rm -f backup_ml2_conf.backup
    cd /etc/neutron/
    if [ ! -f neutron.conf ]; then
        echo "ERROR:neutron.conf does not exist."
        return 1
    fi
    if [ ! -f backup_neutron.backup ]; then
        echo "WARN:backup_neutron.backup does not exist."
    fi
    cp -f backup_neutron.backup neutron.conf
    rm backup_neutron.backup

    systemctl daemon-reload
    systemctl stop neutron-server.service
    $(ps -ef|grep neutron | grep -v grep | awk '{print $2}'|xargs -r kill -9 )
	systemctl start neutron-server.service
    echo "Clean_openstatck_plugin end."
}

#main
clean_openstatck_plugin
