#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
###########################################################################
#
#
# Description: port mirror uninstall
#
# History: 2018/11/29 Created
#
#
###########################################################################

echo "----------[START] port mirror uninstall START----------"
tenant=$(ps -ef |grep DCNOpenEMService|grep karaf.main | awk -F -DTalcLogPath=/opt/oss/log/ '{print $2}' | awk '{print $1}'| awk -F / '{print $1}')
DCN_SERVICE_PATH=/opt/oss/${tenant}/apps/DCNOAMService
DCNOPENEM_SERVICE_PATH=/opt/oss/${tenant}/apps/DCNOpenEMService
if [[ ! -d "${DCN_SERVICE_PATH}" ]]
then
    echo "[WARNING] This is not ac node(by DCNOAMService path)."
    exit 0
fi
if [[ ! -d "${DCNOPENEM_SERVICE_PATH}" ]]
then
    echo "[WARNING] This is not ac node(by DCNOpenEMService path)."
    exit 0
fi
VERSION=$(ls ${DCN_SERVICE_PATH}/controller/system/com/huawei/sdn/acdcn/oam-service-features)
FEATURE_PATH=${DCN_SERVICE_PATH}/controller/system/com/huawei/sdn/acdcn/oam-service-features/${VERSION}
DCNOPENEM_FEATURE_PATH=${DCNOPENEM_SERVICE_PATH}/controller/system/com/huawei/sdn/acdcn/vsw-features/${VERSION}
MIRROR_WEBSITE_PATH_DST=/opt/oss/${tenant}/apps/DCNWebSite/webapps/dcnwebsite

cd ${FEATURE_PATH}
OAM_FEATURE=$(grep -n 'oam-mirror-model-api' oam-service-features-${VERSION}-features.xml)
if [[ -n "${OAM_FEATURE}" ]]
then 
	ROW_S=${OAM_FEATURE%%:*}
	ROW_E=$(expr ${ROW_S} + 6)
	sed -i "${ROW_S},${ROW_E}d" oam-service-features-${VERSION}-features.xml
fi
cd ${DCN_SERVICE_PATH}/controller/system/com/huawei/sdn/acdcn
rm -rf oam-mirror-model-api
rm -rf component-oam-mirror-api
rm -rf component-oam-mirror-service
rm -rf northbound-oam-app-restful-plugin
rm -rf oam-mirror-ui-plugin
rm -rf oam-service-mirror
rm -rf oam-service-mirror-dao

cd ${DCNOPENEM_FEATURE_PATH}
OVS_FEATURE=$(grep -n 'oam-mirror-model-api' vsw-features-${VERSION}-features.xml)
if [[ -n "${OVS_FEATURE}" ]]
then 
	ROW_S=${OVS_FEATURE%%:*}
	ROW_E=$(expr ${ROW_S} + 5)
	sed -i "${ROW_S},${ROW_E}d" vsw-features-${VERSION}-features.xml
fi
cd ${DCNOPENEM_SERVICE_PATH}/controller/system/com/huawei/sdn/acdcn
rm -rf oam-mirror-model-api
rm -rf ovs-mirror-api
rm -rf ovs-mirror-dao
rm -rf ovscfg-mirror
rm -rf ovs-mirror-model
rm -rf oam-mirror-model-service

rm -rf ${MIRROR_WEBSITE_PATH_DST}/portMirroring-app
rm -rf ${DCN_SERVICE_PATH}/controller/configuration/omsys/operation-logs/ObservePort_loginfo.xml
rm -rf ${DCN_SERVICE_PATH}/controller/configuration/omsys/operation-logs/PortMirror_loginfo.xml

rm -rf ${DCN_SERVICE_PATH}/etc/authconf/auth/oam_erspan_policy.json
rm -rf ${DCN_SERVICE_PATH}/etc/authconf/auth/oam_erspan_right.json
rm -rf ${DCN_SERVICE_PATH}/etc/authconf/auth/oam_mirror_policy.json
rm -rf ${DCN_SERVICE_PATH}/etc/authconf/auth/oam_mirror_right.json

rm -rf  /opt/share/${tenant}/AuthService/pub/auth/i18n/dcnservice_oam_mirror_permission_en_US.properties
rm -rf  /opt/share/${tenant}/AuthService/pub/auth/i18n/dcnservice_oam_mirror_permission_zh_CN.properties

cd /opt/share/manager/DeployAgent/svcs-pub/${tenant}-Product-MinAPIGatewayService-minapigatewayservice/DCNOAMService*
rm -rf ./pub/openapi/DCNService-mirror-serviceapis-conf.yaml

count_wait=0
while true
do
	process=$(ps -ef | grep DCNOAMService | grep karaf.main.Main | awk '{print $2}')
    if [ -n "$process" ]
	then
	  echo "kill current DCNOAMService process id:${process}"
      kill -9 $process
	  break
	elif [ "${count_wait}" == 120 ]
	then
	  echo "10 minutes later, current DCNOAMService process is still not up.">&2
	  exit 1
	fi
	count_wait=$(expr $count_wait + 1)
	sleep 5s
done

count=0
while true
do
	process=$(ps -ef | grep DCNOAMService | grep karaf.main.Main | awk '{print $2}')
	echo "new DCNOAMService process id:${process}"
    if [ -n "$process" ]
	then
	echo "----------[SUCCESS] port mirror install END----------"
	break
	elif [ "${count}" == 120 ]
	then
	echo "10 minutes later, the DCNOAMService process is still not up.">&2
	exit 1
	fi
	
	count=$(expr $count + 1)
	sleep 5s
done

count_wait=0
while true
do
	process=$(ps -ef | grep DCNOpenEMService | grep karaf.main.Main | awk '{print $2}')
    if [ -n "$process" ]
	then
	  echo "kill current DCNOpenEMService process id:${process}"
      kill -9 $process
	  break
	elif [ "${count_wait}" == 120 ]
	then
	  echo "10 minutes later, current DCNOpenEMService process is still not up.">&2
	  exit 1
	fi
	count_wait=$(expr $count_wait + 1)
	sleep 5s
done

count=0
while true
do
	process=$(ps -ef | grep DCNOpenEMService | grep karaf.main.Main | awk '{print $2}')
	echo "new DCNOpenEMService process id:${process}"
    if [ -n "$process" ]
	then
	echo "----------[SUCCESS] port mirror install END----------"
	exit 0
	elif [ "${count}" == 120 ]
	then
	echo "10 minutes later, the DCNOpenEMService process is still not up.">&2
	exit 1
	fi
	
	count=$(expr $count + 1)
	sleep 5s
done
