#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    upgrade_acmonitor
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

echo "es_input: ac_north_user"
read ac_north_user
echo "es_input: ac_north_passwd"
read ac_north_passwd

echo "es_input: host_ip"
read host_ip
echo "es_input: host_ip2"
read host_ip2
echo "es_input: host_ip3"
read host_ip3
echo "es_input: host_ip4"
read host_ip4
echo "es_input: host_ip5"
read host_ip5

ACMONITOR_BACKUP="/root/acmonitor_setup_backup/"
BASE_DIR=$(cd $(dirname $0);pwd)
ACMONITOR_YAML="acmonitor.yaml"
BAK_ACMONITOR_YAML=${ACMONITOR_BACKUP}acmonitor_setup/${ACMONITOR_YAML}
CERTIFICATE_SECRETE_YAML="acmonitor-certificate-secrets.yaml"
ACMONITOR_SECRET=acmonitor-secrets.yaml

acmonitor_cfg_file="acmonitor-cfg.yaml"
tmpfile="xxx_$acmonitor_cfg_file"
certfile="bin/trust.cer"


function upgrade_acmonitor()
{
    get_install_path
    backup_acmonitor
    genarate_acmonitor_image
    source ${INSTALL_PATH}/acmonitor_setup/common_util.sh
    genarate_acmonitor_cfg
    gen_ac_monitor_yaml
}

function backup_acmonitor()
{
    rm -fr ${ACMONITOR_BACKUP}acmonitor_setup
    mkdir -p ${ACMONITOR_BACKUP}/acmonitor_setup
    \cp -rf ${INSTALL_PATH}/acmonitor_setup ${ACMONITOR_BACKUP}
}

function get_install_path()
{
    INSTALL_PATH="/root"
    echo "INSTALL_PATH: ${INSTALL_PATH}"
    echo "INSTALL_PLUGIN_HOME=${INSTALL_PATH}" >> /etc/profile
    echo "export INSTALL_PLUGIN_HOME" >> /etc/profile  
    source /etc/profile
}

function genarate_acmonitor_image()
{
    echo "Upgrade acmonitor_plugin begin."
    echo "..........step1:Unzip files.........."
    cd $INSTALL_PATH
    rm -rf ${INSTALL_PATH}/acmonitor_setup
    PLUG_PKG="acmonitor_setup.tar.gz"
    if [ ! -e "${PLUG_PKG}" ]; then
        echo "Installing install_acmonitor_plugin failed, because ${PLUG_PKG} does not exist."
        exit 1
    fi
    tar -zxvf $PLUG_PKG -C "${INSTALL_PATH}" >/dev/null 2>&1
    \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/images/k8sPlugin.key ${INSTALL_PATH}/acmonitor_setup/images/
    \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/images/k8sPlugin.pem ${INSTALL_PATH}/acmonitor_setup/images/
    \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/images/trust.cer ${INSTALL_PATH}/acmonitor_setup/images/
    \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/images/Huawei_Enterprise_Network_Product_CA.cer ${INSTALL_PATH}/acmonitor_setup/images/
    \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/bin/trust.cer ${INSTALL_PATH}/acmonitor_setup/bin/
    [ -f ${ACMONITOR_BACKUP}acmonitor_setup/images/trust.crl ] && \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/images/trust.crl ${INSTALL_PATH}/acmonitor_setup/images/
    cd ${INSTALL_PATH}/acmonitor_setup/images/
    base_image=$(cat ${ACMONITOR_BACKUP}acmonitor_setup/images/Dockerfile|grep -w FROM)
    sed -i "s/^FROM.*/${base_image}/" Dockerfile
    bash build.sh
    if [ $? -ne 0 ];then
        echo "generate acmonitor image failed."
        exit 1
    fi
}

function gen_ac_monitor_yaml(){
    cd ${INSTALL_PATH}/acmonitor_setup/

    rm -rf $tmpfile
    cp $acmonitor_cfg_file $tmpfile
	
    bin/account_tools -config-file $tmpfile -cert-file $certfile -username=${ac_north_user} -password=${ac_north_passwd}
    echo '---' > $ACMONITOR_YAML
    cat $ACMONITOR_SECRET tpl/acmonitor-tpl.yaml >> $ACMONITOR_YAML

    sed -i 's/^/    /' $tmpfile
    sed -i "/__ACMONITOR__/ r $tmpfile" $ACMONITOR_YAML
    sed -i '/__ACMONITOR__/d' $ACMONITOR_YAML

    tag=$(ls images/ | grep "acmonitor.*tar" | head -n 1 | sed 's/^acmonitor-//g' | sed 's/.tar$//g')
    sed -i "s/__IMAGE_TAG__/$tag/g" $ACMONITOR_YAML
    
    oc version > /dev/null 2>&1
    if [ $? -eq 0 ];then
        sed -i 's/__RUN_POD_ON_MASTER__/\"true\"/' $ACMONITOR_YAML
    else
        sed -i 's/__RUN_POD_ON_MASTER__/\"\"/' $ACMONITOR_YAML
    fi

    rm $tmpfile $ACMONITOR_SECRET
    \cp -f ${ACMONITOR_BACKUP}acmonitor_setup/$CERTIFICATE_SECRETE_YAML ${INSTALL_PATH}/acmonitor_setup/
}

function check_result()
{
ips=(${host_ip} ${host_ip2} ${host_ip3} ${host_ip4} ${host_ip5})
for ((i=1;i<=5;i++)); do
sleep 30
    index=0
    for ip in ${ips[@]}; do
        if [ -n "$ip" ]; then
            result=$(kubectl  get pods -n kube-system --all-namespaces -owide | grep acmonitor | grep $ip | awk '{print $4}')
            if [ "${result}" != "Running" ]; then
                echo $ip:$result
            else
                let index++
            fi
        fi
    done
    if [ "$index" == ${#ips[*]} ]; then
        echo install success!!!
        return 0
    fi
    if [ "$i" == 5 ]; then
        echo Error : install failed
        return 1
    fi
done
}

getcheckresult()
{
   if [ "$1" -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /root/scripts_plugin/check_install_acmonitor_result.sh
   ">/root/scripts_plugin/check_install_acmonitor_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /root/scripts_plugin/check_install_acmonitor_result.sh
   ">/root/scripts_plugin/check_install_acmonitor_result.sh
   fi
   chmod 755 /root/scripts_plugin/check_install_acmonitor_result.sh > /dev/null 2>&1
}        
#main
upgrade_acmonitor
kubectl apply -f ${INSTALL_PATH}/acmonitor_setup/$CERTIFICATE_SECRETE_YAML > /dev/null 2>&1
kubectl apply -f ${INSTALL_PATH}/acmonitor_setup/$ACMONITOR_YAML > /dev/null 2>&1
check_result
getcheckresult $?
exit $?