#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境升级AC-DCN插件回滚
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
echo "es_input: os_password" 
read os_password
os_password=${os_password}

source set_env<<EOF
1
$os_password
EOF

DRIVER_CONFIGS=(
"ac_auth_username"
"ac_auth_password"
"cloud_name"
"OPS_version"
"physical_network"
"keystone_tenant"
"keystone_user"
"keystone_passwd"
"auth_url"
"request_timeout"
"ac_response_time"
"neutron_sync_time"
"neutron_sync_type"
"vhost_user"
"security_group_sync_times"
"enable_security_group"
"logical_hostnames"
"vcenter_host_mappings"
"vcenter_cluster_mappings"
"vcenter_network_mappings"
"external_access_mode"
"network_black_list"
"network_white_list"
"network_list_matching"
"primary_interface"
"vpc_peering"
"bare_metal_bond_mode"
"public_service_networks"
"default_public_service_network"
"LB_host_mappings"
"enable_snat"
"enable_ce1800v_dhcp"
"websocket_key_password"
)

PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
PYTHON_VERSION=$(python -c "import sys; print 'py%s.%s' % (sys.version_info.major, sys.version_info.minor)")
DRIVER_PREFIX=huawei_driver_config.huawei_ac_config
AGENT_PREFIX=huawei_driver_config.huawei_ac_agent_config
VERSION_PATH=$PYTHON_PATH/networking_huawei/version.txt
VERSION_PATH_ORG=/root/easysuite_install/file_bak/origin_package_version.log
ORIGIN_CERTS_PATH=/root/easysuite_install/file_bak/certs

echo "rollback AC-DCN plugin start."
#配置角色
CONTROLLER_ID=$(cat /etc/uuid)
if [[ $(grep -c 300R019C00 $VERSION_PATH_ORG) -gt 0 ]]; then
    cps role-host-add --host $CONTROLLER_ID agile-controller-plugin
else
    cps role-host-add --host $CONTROLLER_ID controller-plugin
fi
cps commit
sleep 50
plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
while [ ! "${plugin_role}" ]
do 
    sleep 1
    plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
done

if [[ $(grep -c V300R003C00 $VERSION_PATH) -gt 0 ]]; then
    for config in ${DRIVER_CONFIGS[@]}; do
        cps template-ext-params-del --service neutron neutron-server --parameter $DRIVER_PREFIX.$config > /dev/null
    done
    cps template-ext-params-del --service neutron neutron-server --parameter $AGENT_PREFIX.rpc_server_ip > /dev/null
    cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.__filepath > /dev/null
    cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.__param_rule > /dev/null
fi

#修改配置文件
cp -fp /root/easysuite_install/file_bak/neutron.conf /etc/neutron/neutron.conf
if [ -f /root/easysuite_install/file_bak/huawei_driver_config.ini ]; then
    cp -fp /root/easysuite_install/file_bak/huawei_driver_config.ini /etc/neutron/huawei_driver_config.ini
fi
cp -fp /root/easysuite_install/file_bak/ml2_conf.ini /etc/neutron/plugins/ml2/ml2_conf.ini
if [ -f /root/easysuite_install/file_bak/whitelist.ini ]; then
    cp -fp /root/easysuite_install/file_bak/whitelist.ini /etc/neutron/whitelist.ini
fi
cp -fp /root/easysuite_install/file_bak/neutron-server.service /usr/lib/systemd/system/neutron-server.service

if [[ $(cat /etc/hostos.version) =~ ((6\.5\.RC1)|V100R006C30SPC[1-2]|(6\.5\.1)|(8\.0)) ]]; then
    old_rpc_server_ip=$(grep ^rpc_server_ip /etc/neutron/huawei_driver_config.ini | awk -F = '{print $2}' | sed s/[[:space:]]//g)
    websocket_key_password=$(grep ^websocket_key_password /etc/neutron/huawei_driver_config.ini)
    old_ops_version=$(grep ^OPS_version /etc/neutron/huawei_driver_config.ini | awk -F = '{print $2}' | sed s/[[:space:]]//g)

    if [ "${old_rpc_server_ip}" ]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_agent_config.rpc_server_ip=${old_rpc_server_ip}
    fi

    if [[ $(cat /etc/hostos.version) =~ (8\.0) ]]; then
        if [ "${old_ops_version}" ]; then
            cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=${old_ops_version}
        fi
    fi

    if [ ! "${websocket_key_password}" ]; then
        if [[ $(cat /etc/hostos.version) =~ (8\.0) ]]; then
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password > /dev/null
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key > /dev/null
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_private_key > /dev/null
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert > /dev/null
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert > /dev/null
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.cert_expiration_warning_time > /dev/null
        else
            cps template-ext-params-del --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password > /dev/null
        fi
    fi
    cps commit
fi

#恢复证书文件
OPS_VERSION=$(grep ^OPS_version /etc/neutron/huawei_driver_config.ini | awk -F = '{print $2}' | sed s/[[:space:]]//g)
if [[ ! "${OPS_VERSION}" =~ FusionSphere8.0 ]] && [[ ! "${OPS_VERSION}" =~ FusionSphere21.0 ]]; then
    cp -fp $ORIGIN_CERTS_PATH/ssl_cacert.pem $PYTHON_PATH/networking_huawei/drivers/ac/client
    cp -fp $ORIGIN_CERTS_PATH/client.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
    cp -fp $ORIGIN_CERTS_PATH/client_key.pem $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
    cp -fp $ORIGIN_CERTS_PATH/trust.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
else
    websocket_public_key=`cat $ORIGIN_CERTS_PATH/client.cer`
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$websocket_public_key"
    cps commit
fi

cps host-template-instance-operate --service neutron neutron-server --action stop
sleep 5
cps host-template-instance-operate --service neutron neutron-server --action start
sleep 15

#C00需要重新加载插件
echo -e '1. config service_plugins...' 

bak_conf="/root/networking-huawei/tools/neutron_cps_bak.conf"
if [ ! -e "$bak_conf" ]; then
    cp /etc/neutron/neutron.conf /root/networking-huawei/tools/neutron_cps_bak.conf
fi

PLUGIN_PATH=networking_huawei.drivers.ac.plugins
L3_PLUGINS=$PLUGIN_PATH.l3.ac_l3_router_plugin.HuaweiACL3RouterPlugin
FWAAS_PLUGINS=$PLUGIN_PATH.fwaas.fwaas_plugin.HuaweiACFwaasPlugin
VPNAAS_PLUGINS=$PLUGIN_PATH.vpnaas.vpnaas_plugin.HuaweiIPsecVPNPlugin
SERVICE_PLUGINS=huawei_ac_l2br,huawei_ac_ext,$L3_PLUGINS,$VPNAAS_PLUGINS
current_service_plugins=$(sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf)
current_service_plugins=$(echo $current_service_plugins | sed 's/router,//g' | sed 's/,router//g')
current_service_plugins=$(echo $current_service_plugins | sed 's/vpnaas,//g' | sed 's/,vpnaas//g')
if [[ ! "$current_service_plugins" =~ hs_fwaas_plugin ]] && [[ ! "${OPS_VERSION}" =~ FusionSphere21.0 ]]; then
    current_service_plugins=$(echo $current_service_plugins | sed 's/firewall,//g' | sed 's/,firewall//g' | sed 's/firewall//g')
    SERVICE_PLUGINS=$SERVICE_PLUGINS,$FWAAS_PLUGINS
fi
current_service_plugins=$(echo $current_service_plugins | sed 's/'"$L3_PLUGINS"',//g' | sed 's/,'"$L3_PLUGINS"'//g' | sed 's/'"$L3_PLUGINS"'//g')
current_service_plugins=$(echo $current_service_plugins | sed 's/'"$FWAAS_PLUGINS"',//g' | sed 's/,'"$FWAAS_PLUGINS"'//g' | sed 's/'"$FWAAS_PLUGINS"'//g')
current_service_plugins=$(echo $current_service_plugins | sed 's/'"$VPNAAS_PLUGINS"',//g' | sed 's/,'"$VPNAAS_PLUGINS"'//g' | sed 's/'"$VPNAAS_PLUGINS"'//g')
current_service_plugins=$(echo $current_service_plugins | sed 's/huawei_ac_l2br,//g' | sed 's/,huawei_ac_l2br//g' | sed 's/huawei_ac_l2br//g')
current_service_plugins=$(echo $current_service_plugins | sed 's/huawei_ac_external_whitelist,//g' | sed 's/,huawei_ac_external_whitelist//g' | sed 's/huawei_ac_external_whitelist//g')
current_service_plugins=$(echo $current_service_plugins | sed 's/huawei_ac_ext,//g' | sed 's/,huawei_ac_ext//g' | sed 's/huawei_ac_ext//g')
if [[ "$current_service_plugins" != "" ]]; then
    for plugin in ${current_service_plugins//,/ }; do
        if [[ "$SERVICE_PLUGINS" != *"${plugin}"* ]]; then
            SERVICE_PLUGINS=${SERVICE_PLUGINS}","${plugin}
        fi
    done
fi

cps template-params-update --service neutron neutron-server --parameter service_plugins=$SERVICE_PLUGINS
cps commit

#mechanism_drivers
echo -e '2. config mechanism_drivers...' 
exists_mechanism_drivers=$(sed '/^mechanism_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini)
if [[ "$exists_mechanism_drivers" == *huawei_ac_ml2* ]]
then
    echo "    huawei_ac_ml2 already exists"
else
    cps template-params-update --service neutron neutron-server --parameter mechanism_drivers=huawei_ac_ml2,${exists_mechanism_drivers// /}
    cps commit
fi

current_extension_drivers=$(sed '/^extension_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini)
EXTENSION_DRIVERS=$(echo $current_extension_drivers)
current_extension_arr=${current_extension_drivers//,/}
if [[ ! "${current_extension_arr[@]}" =~ "huawei_ac_binding" ]]; then
    EXTENSION_DRIVERS=${EXTENSION_DRIVERS}",huawei_ac_binding"
    cps template-params-update --service neutron neutron-server --parameter extension_drivers=$EXTENSION_DRIVERS
    cps commit
fi

#notification_drivers
echo -e '3. config notification_drivers...' 
exists_notification_drivers=$(sed '/^notification_drivers =/!d;s/.*=//' /etc/neutron/neutron.conf)
update_nf_drivers=${exists_notification_drivers// /}

if [[ "$exists_notification_drivers" == '' ]]
then
    update_nf_drivers=huawei_ac_qos_driver,message_queue
else
    if [[ "$exists_notification_drivers" == *message_queue* ]]
    then
        echo "    message_queue already exists"
    else
        update_nf_drivers=message_queue,$update_nf_drivers
    fi

    if [[ "$exists_notification_drivers" == *huawei_ac_qos_driver* ]]
    then
        echo "    huawei_ac_qos_driver already exists"
    else
        update_nf_drivers=huawei_ac_qos_driver,$update_nf_drivers
    fi
fi
cps template-params-update --service neutron neutron-server --parameter notification_drivers=$update_nf_drivers
cps commit


#exists_api_extensions_path
echo -e '4. config api_extensions_path...'
api_ext_vpn=/usr/lib/python2.7/site-packages/neutron_vpnaas/extensions
api_ext_fw=/usr/lib/python2.7/site-packages/neutron_fwaas/extensions
api_ext_l2br=/usr/lib/python2.7/site-packages/networking_huawei/drivers/ac/extensions/l2br
api_ext_ex=/usr/lib/python2.7/site-packages/networking_cascading/exroute_extensions
api_ext_sync=/usr/lib/python2.7/site-packages/networking_huawei/drivers/ac/extensions/sync

exists_api_extensions_path=$(sed '/^api_extensions_path =/!d;s/.*=//' /etc/neutron/neutron.conf)
update_ext_api=${exists_api_extensions_path// /}

if [[ "$exists_api_extensions_path" == *"$api_ext_vpn"* ]]
then
    echo "    extensions_path of vpnaas already exists"
else
    update_ext_api=$update_ext_api:$api_ext_vpn
fi

if [[ "$exists_api_extensions_path" == *"$api_ext_fw"* ]]
then
    echo "    extensions_path of fw already exists"
else
    update_ext_api=$update_ext_api:$api_ext_fw
fi

if [[ "$exists_api_extensions_path" == *"$api_ext_l2br"* ]]
then
    echo "    extensions_path of l2br already exists"
else
    update_ext_api=$update_ext_api:$api_ext_l2br
fi

if [[ "$exists_api_extensions_path" == *"$api_ext_ex"* ]]
then
    echo "    extensions_path of exroute already exists"
else
    update_ext_api=$update_ext_api:$api_ext_ex
fi

if [[ "$exists_api_extensions_path" == *"$api_ext_sync"* ]]
then
    echo "    extensions_path of sync already exists"
else
    update_ext_api=$update_ext_api:$api_ext_sync
fi

cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$update_ext_api
cps commit
sleep 3

echo "rollback AC-DCN plugin end."
