#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境升级AC-DCN插件回滚
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
echo "es_input: os_password" 
read os_password
os_password=${os_password}

source set_env<<EOF
1
$os_password
EOF

echo "uninstall AC-DCN plugin start."
#删除角色
CONTROLLER_ID=$(cat /etc/uuid)
plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
if [ "${plugin_role}" ]; then
    cps role-host-delete --host $CONTROLLER_ID controller-plugin
    cps commit
    plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
    while [ "${plugin_role}" ]
    do 
        sleep 1
        plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
    done
fi

cps host-template-instance-operate --service neutron neutron-server --action stop
sleep 5
cps host-template-instance-operate --service neutron neutron-server --action start
sleep 5

echo "uninstall AC-DCN plugin end."
