#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境升级AC-DCN插件
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
echo "es_input: ac_user_psw" 
read ac_user_psw
echo "es_input: keystone_psw" 
read keystone_psw
echo "es_input: os_password" 
read os_password
echo "es_input: is_remote_disaster_recovery"
read is_remote_disaster_recovery
echo "es_input: main_clusters_ip"
read main_clusters_ip
echo "es_input: standby_clusters_ip"
read standby_clusters_ip

ac_user_psw=${ac_user_psw}
keystone_psw=${keystone_psw}
os_password=${os_password}
is_remote_disaster_recovery=${is_remote_disaster_recovery}
main_clusters_ip=${main_clusters_ip}
standby_clusters_ip=${standby_clusters_ip}

new_ac_northbound_ip="${standby_clusters_ip}","${main_clusters_ip}"

sleep 5

source set_env<<EOF > /dev/null 2>&1
1
$os_password
EOF

echo "starting to upgrade AC-DCN plugin.........."

#配置角色
CONTROLLER_ID=$(cat /etc/uuid)
cps role-host-add --host $CONTROLLER_ID controller-plugin
cps commit

sleep 60
plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
while [ ! "${plugin_role}" ]
do 
    sleep 1
    plugin_role=$(cps template-instance-list --service neutron-ac neutron-ac-plugin | grep ${CONTROLLER_ID})
done

#还原配置文件
PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
ORIGIN_CERTS_PATH=/root/easysuite_install/file_bak/certs
ORIGIN_DRIVER_CONFIG=/root/easysuite_install/file_bak/huawei_driver_config.ini
ORIGIN_ML2_CONF=/root/easysuite_install/file_bak/ml2_conf.ini
ORIGIN_NEUTRON_CONF=/root/easysuite_install/file_bak/neutron.conf
ORIGIN_WHITE_LIST=/root/easysuite_install/file_bak/whitelist.ini
CURRENT_DRIVER_CONFIG=/etc/neutron/huawei_driver_config.ini
CURRENT_ML2_CONF=/etc/neutron/plugins/ml2/ml2_conf.ini
CURRENT_NEUTRON_CONF=/etc/neutron/neutron.conf
CURRENT_WHITE_LIST=/etc/neutron/whitelist.ini
AC_USER_PSW=${ac_user_psw}
PASSWORD=$(python /root/networking-huawei/tools/encode.py "${AC_USER_PSW}" account_passwd)
KEYSTONE_PASSWD=${keystone_psw}
KEYSTONE_PASSWD=$(python /root/networking-huawei/tools/encode.py "${KEYSTONE_PASSWD}" keystone_auth_passwd)
EXT_CFG=/etc/huawei/fusionsphere/neutron.neutron-server/cfg/neutron.neutron-server.ext_cfg
TEMP_DRIVER_CONFIG=/root/easysuite_install/file_bak/huawei_driver_config.ini.temp
ERROR_RETRY_INTERVAL_DEFAULT=180
ERROR_RETRY_COUNT_DEFAULT=0
function get_conf_params(){
    params_arr=()
    while read line; do
        if [[ "$line" =~ cfg\..*Opt.* ]]; then
            new_param=$(echo $line | sed "s/.*'\([a-zA-Z0-9_]*\)',.*/\1/")
            params_arr=(${params_arr[*]} $new_param)
        fi
    done < $PYTHON_PATH/networking_huawei/drivers/ac/common/config.py
}

get_conf_params

for param in ${params_arr[@]}; do
    tmp=$(echo $param | sed s/[[:space:]]//g)
    if [[ ! -z "$tmp" && -e "$ORIGIN_DRIVER_CONFIG" ]]; then
        origin_param=$(grep ^$tmp $ORIGIN_DRIVER_CONFIG | awk -F = '{print $2}' | sed s/[[:space:]]//g)
        if [ ! -z "$origin_param" ]; then
            sed -i "s/#\($tmp =\).*/\1 ${origin_param//\//\\/}/" $CURRENT_DRIVER_CONFIG
            sed -i "s/\($tmp =\).*/\1 ${origin_param//\//\\/}/" $CURRENT_DRIVER_CONFIG
        fi
        if [ "$tmp" == 'LB_host_mappings' ]; then
            origin_param=$(grep ^f5_host_mappings $ORIGIN_DRIVER_CONFIG | awk -F = '{print $2}' | sed s/[[:space:]]//g)
            sed -i "s/#\($tmp =\).*/\1 ${origin_param//\//\\/}/" $CURRENT_DRIVER_CONFIG
            sed -i "s/\($tmp =\).*/\1 ${origin_param//\//\\/}/" $CURRENT_DRIVER_CONFIG
        fi
    fi
done

sed -i '/^#timeout_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^#timeout_retry.*/d' /etc/neutron/huawei_driver_config.ini
sed -i '/^timeout_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
sed -i '/^timeout_retry.*/d' /etc/neutron/huawei_driver_config.ini

request_timeout=$(grep "^request_timeout[[:space:]]*=" $CURRENT_DRIVER_CONFIG | cut -d "=" -f 2 | sed s/[[:space:]]//g)
if [ -n "$request_timeout" ]; then
    if [ "$request_timeout" -lt 110 ]; then
        sed -i "s/^request_timeout[[:space:]]*=.*/request_timeout = 110/g" $CURRENT_DRIVER_CONFIG
    fi
fi

enable_ce1800v_dhcp=$(grep "enable_ce1800v_dhcp[[:space:]]*=" $CURRENT_DRIVER_CONFIG)
if [ ! -n "$enable_ce1800v_dhcp" ]; then
    sed -i "\$G" $CURRENT_DRIVER_CONFIG
    sed -i '$a\#enable_ce1800v_dhcp = false' $CURRENT_DRIVER_CONFIG
fi

cp -f $CURRENT_DRIVER_CONFIG $TEMP_DRIVER_CONFIG
ops_version=$(grep ^OPS_version $TEMP_DRIVER_CONFIG | awk -F = '{print $2}' | sed s/[[:space:]]//g)
if [[ "${ops_version}" == "FusionSphere6.1" ]] && [[ $(cat /etc/hostos.version) =~ ((6\.5\.RC1)|(6\.5\.0)|V100R006C30SPC[1-2]|(6\.5\.1)|(8\.0)) ]]; then
    for param in ${params_arr[@]}; do
        tmp=$(echo $param | sed s/[[:space:]]//g)
        echo "111"+$tmp >> /root/easysuite_install/1.txt
        if [[ ! -z "$tmp" ]]; then
            origin_param=$(grep ^$tmp $TEMP_DRIVER_CONFIG | awk -F = '{print $2}' | sed s/[[:space:]]//g)
            echo "222"+$origin_param >> /root/easysuite_install/1.txt
            if [[ "$tmp" == 'rpc_server_ip' ]] && [[ "${is_remote_disaster_recovery}" != "select_yes" ]]; then
                cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_agent_config.rpc_server_ip=$origin_param
            elif [[ "$tmp" == 'OPS_version' ]]; then
                if [[ $(cat /etc/hostos.version) =~ (V100R006C30SPC[1-2]) ]]; then
                cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=FusionSphere6.3.1
                elif [[ $(cat /etc/hostos.version) =~ (6\.5\.0) ]]; then
                    if [[ $(cps productinfo-show |grep solution_scenes | awk '{print $4}') == 'private' ]]; then
                        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=FusionSphere6.5.0Private
                    elif [[ $(cps productinfo-show |grep solution_scenes | awk '{print $4}') == 'NFV' ]]; then
                        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=FusionSphere6.5.0NFVI
                    else
                        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=FusionSphere6.5
                    fi
                elif [[ $(cat /etc/hostos.version) =~ (6\.5\.1) ]]; then
                    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=FusionSphere6.5.1
                elif [[ $(cat /etc/hostos.version) =~ (8\.0) ]]; then
                    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version=FusionSphere8.0.0
                fi
            elif [[ "$tmp" =~ ((ac_auth_password)|(keystone_passwd)|(host_ip)) ]]; then
                continue
            elif [[ $(cat $EXT_CFG | grep huawei_driver_config.huawei_ac_config.$tmp) ]]; then
                echo "333"+$origin_param >> /root/easysuite_install/1.txt
                cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.$tmp=$origin_param
            fi
        fi
    done
    cps commit
fi
if [[ ! $ops_version =~ "FusionSphere6.1" ]] && [[ ! $ops_version =~ "FusionSphere6.3.0" ]]; then
    error_retry_interval_bak=$(cat $ORIGIN_DRIVER_CONFIG|grep '^error_retry_interval'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
    if [[ $error_retry_interval_bak ]];then
        echo "    Exec: cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_interval=$ERROR_RETRY_INTERVAL_DEFAULT"
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_interval=$ERROR_RETRY_INTERVAL_DEFAULT
    fi
    error_retry_count_bak=$(cat $ORIGIN_DRIVER_CONFIG|grep '^error_retry_count'|awk -F = '{print $2}' | sed s/[[:space:]]//g)
    if [[ $error_retry_count_bak ]];then
        echo "    Exec: cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_count=$ERROR_RETRY_COUNT_DEFAULT"
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.error_retry_count=$ERROR_RETRY_COUNT_DEFAULT
    fi
    cps commit
else
    error_retry_interval=$(grep "^error_retry_interval[[:space:]]*=" $CURRENT_DRIVER_CONFIG | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$error_retry_interval" ]; then
        sed -i "s/^error_retry_interval[[:space:]]*=.*/error_retry_interval = 180/g" $CURRENT_DRIVER_CONFIG
    fi

    error_retry_count=$(grep "^error_retry_count[[:space:]]*=" $CURRENT_DRIVER_CONFIG | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$error_retry_count" ]; then
        sed -i "s/^error_retry_count[[:space:]]*=.*/error_retry_count = 0/g" $CURRENT_DRIVER_CONFIG
    fi
fi

ORG_SERVICE_PLUGIN=$(cat $ORIGIN_NEUTRON_CONF|grep "^service_plugin"|awk -F '=' '{print $2}'|awk '$1=$1')
ORG_API_EXTENSIONS_PATH=$(cat $ORIGIN_NEUTRON_CONF|grep "^api_extensions_path"|awk -F '=' '{print $2}'|awk '$1=$1')
if [[ $(cat /etc/hostos.version) =~ ((6\.5\.RC1)|(6\.5\.0)|V100R006C30SPC[1-2]|(6\.5\.1)|(8\.0)) ]]; then
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.ac_auth_password=${ac_user_psw}
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.keystone_passwd=${keystone_psw}
    if [ "${is_remote_disaster_recovery}" == "select_yes" ]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_agent_config.rpc_server_ip=${new_ac_northbound_ip}
    fi
    cps template-params-update --service neutron neutron-server --parameter service_plugins=${ORG_SERVICE_PLUGIN}
    cps template-params-update --service neutron neutron-server --parameter api_extensions_path=${ORG_API_EXTENSIONS_PATH}
    if [[ $(cat /etc/hostos.version) =~ (8\.0) ]];then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.OPS_version='FusionSphere8.0.0'
    fi
    cps commit
else
    sed -i "s#\#\{0,1\}\(ac_auth_password =\).*#\1 $PASSWORD#g" $CURRENT_DRIVER_CONFIG
    sed -i "s#\#\{0,1\}\(keystone_passwd =\).*#\1 $KEYSTONE_PASSWD#g" $CURRENT_DRIVER_CONFIG
    if [ "${is_remote_disaster_recovery}" == "select_yes" ]; then
        sed -i "s#\#\{0,1\}\(rpc_server_ip =\).*#\1 ${new_ac_northbound_ip}#g" $CURRENT_DRIVER_CONFIG
    fi
fi

if [[ -e "$ORIGIN_WHITE_LIST" ]]; then
    cp -af $ORIGIN_WHITE_LIST $CURRENT_WHITE_LIST
    cat $CURRENT_WHITE_LIST|grep 'ipv6-ns-qos-policies' || sed -i  "/external-policy-groups/a\    \'ipv6-ns-qos-policies\': []," $CURRENT_WHITE_LIST
    cat $CURRENT_WHITE_LIST|grep 'tap-services' || sed -i  "/ipv6-ns-qos-policies/a\    \'tap-services\': []," $CURRENT_WHITE_LIST
    cat $CURRENT_WHITE_LIST|grep 'tap-flows' || sed -i  "/ipv6-ns-qos-policies/a\    \'tap-flows\': []," $CURRENT_WHITE_LIST
fi

function get_certs() {
    if [[ ! "${ops_version}" =~ FusionSphere8.0 ]] && [[ ! "${ops_version}" =~ FusionSphere21.0 ]]; then
        cp -fp $ORIGIN_CERTS_PATH/ssl_cacert.pem $PYTHON_PATH/networking_huawei/drivers/ac/client
        cp -fp $ORIGIN_CERTS_PATH/client.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
        cp -fp $ORIGIN_CERTS_PATH/client_key.pem $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
        cp -fp $ORIGIN_CERTS_PATH/trust.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
    else
        websocket_public_key=`cat $ORIGIN_CERTS_PATH/client.cer`
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$websocket_public_key"
        cps commit
    fi
}

get_certs

#修改启动文件
check_config=$(grep -n "huawei_driver_config.ini" /etc/neutron/neutron-server/SetState.sh)
if [ "$check_config" = "" ];then
    sed -i "/.*--config-file=.*/s/$/& --config-file=\/etc\/neutron\/huawei_driver_config.ini/g" /etc/neutron/neutron-server/SetState.sh
fi

echo "upgrade AC-DCN plugin end."
