#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    upgrade_openstatck
#  Description: 升级openstatck
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
echo "es_input: openstack_db_password" 
read openstack_db_password
echo "es_input: ac_user_psw" 
read ac_user_psw
echo "es_input: keystone_psw" 
read keystone_psw

ops_db_psw=${keystone_psw}
password=${ac_user_psw}
keystone_passwd=${openstack_db_password}

PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
PYTHON_VERSION=$(python -c "import sys; print 'py%s.%s' % (sys.version_info.major, sys.version_info.minor)")
ORIGIN_CERTS_PATH=/root/easysuite_install/file_bak/certs

function install_openstatck()
{
    get_install_path

    install_openstatck_plugin   
}

#---------------------------------------------------------------------------
#  Function:    get_install_path
#  Description: 获取安装路径
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function get_install_path()
{
    #software install dir

    INSTALL_PATH="/root"
    echo "INSTALL_PATH: ${INSTALL_PATH}"
    echo "INSTALL_PLUGIN_HOME=${INSTALL_PATH}" >> /etc/profile
    echo "export INSTALL_PLUGIN_HOME" >> /etc/profile  
    source /etc/profile
}

#---------------------------------------------------------------------------
#  Function:    change_mode_and_owner
#  Description: 修改python文件权限和属主
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function change_mode_and_owner()
{
    for file in $(ls $1)
    do
        if [ -d "$1""/""$file" ]; then
            chmod 500 $1"/"$file
            chown neutron:neutron $1"/"$file
            change_mode_and_owner $1"/"$file
        else
            chmod 400 $1"/"$file
            chown neutron:neutron $1"/"$file
        fi
    done
}

#---------------------------------------------------------------------------
#  Function:    change_mode_and_owner_read
#  Description: 修改python文件权限和属主
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function change_mode_and_owner_read()
{
    for file in $(ls $1)
    do
        if [ -d "$1""/""$file" ]; then
            change_mode_and_owner_read $1"/"$file
        else
            chmod 444 $1"/"$file
            chown neutron:neutron $1"/"$file
        fi
    done
}

#---------------------------------------------------------------------------
#  Function:    install_openstatck_plugin
#  Description: 安装openstatck_plugin
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------
function install_openstatck_plugin()
{
    echo "Installing install_openstatck_plugin begin."
    #解压文件并执行set.py脚本
    echo "..........step1:Execute install script.........."
    cd $INSTALL_PATH
    PLUG_PKG="networking-huawei.tar.gz"
    if [ ! -e "${PLUG_PKG}" ]; then
        echo "Installing install_openstatck_plugin failed, because ${PLUG_PKG} does not exist."
        exit 1
    fi
    tar -zxvf $PLUG_PKG -C "${INSTALL_PATH}" >/dev/null 2>&1
    chmod 500 ${INSTALL_PATH}/networking-huawei/tools/modify_controller_account.py
    chmod 500 ${INSTALL_PATH}/networking-huawei/tools/modify_pwd_keystone.py
    chmod 500 ${INSTALL_PATH}/networking-huawei/tools/modify_pwd.py
    mkdir -p ${INSTALL_PATH}/networking-huawei/tools/certs
    cd ${INSTALL_PATH}/networking-huawei
    python setup.py install >/dev/null 2>&1

    EGG_VERSION=$(grep '^Version' $INSTALL_PATH/networking-huawei/networking_huawei.egg-info/PKG-INFO | awk '{print $2}')
    NETWORKING_HUAWEI=$PYTHON_PATH/networking_huawei
    NETWORKING_HUAWEI_EGG=$PYTHON_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info
    
    #修改python文件权限为400，属主为neutron
    change_mode_and_owner $NETWORKING_HUAWEI
    change_mode_and_owner_read $NETWORKING_HUAWEI_EGG
    
    #升级数据库
    echo "..........step2:Upgrade database.........."
    cd ${INSTALL_PATH}
    neutron-db-manage upgrade head >/dev/null 2>&1
    neutron-db-manage --subproject networking-huawei upgrade head >/dev/null 2>&1

    function kilo_neutron_db()
    {
        cd /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions
        cp -rf c4818a243f6f_huawei_ac_mechanisam_driver.py c4818a243f6f_huawei_ac_mechanisam_driver.py.bak
        cp -rf /root/networking-huawei/networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/* /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions
        if [ -e /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions/270980b1080d_initial_branch.py ];then
            rm -rf /usr/lib/python2.7/site-packages/neutron/db/migration/alembic_migrations/versions/270980b1080d_initial_branch.py
        fi
        cp -rf c4818a243f6f_huawei_ac_mechanisam_driver.py.bak c4818a243f6f_huawei_ac_mechanisam_driver.py
        neutron-db-manage --config-file /etc/neutron/neutron.conf upgrade head
    }
    OPS_VERSION=$(sed '/^OPS_version = /!d;s/.*= //'  /etc/neutron/huawei_driver_config.ini)
    if [[ "$OPS_VERSION" = "Kilo" ]]; then
        kilo_neutron_db >/dev/null 2>&1
    fi 
    
    #生成配置文件
    echo "..........step3:Generate configuration file.........."

    sed -i '/^#.*value)$/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^# From networking_huawei.ac_config/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#$/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#token_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#token_retry.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_interval.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_interval.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_count.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#error_retry_count.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#ac_detect_period.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#ac_detect_period.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#rpc_server_base_ip.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#rpc_server_base_ip.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#enable_cert.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#enable_cert.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^enable_cert.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^enable_cert.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#logical_hostnames.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#logical_hostnames.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_host_mappings.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_host_mappings.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_cluster_mappings.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_cluster_mappings.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_network_mappings.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vcenter_network_mappings.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#primary_interface.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#primary_interface.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vpc_peering.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#vpc_peering.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i 's/\#f5_host_mappings/\#LB_host_mappings/g' /etc/neutron/huawei_driver_config.ini
    sed -i 's/f5_host_mappings/LB_host_mappings/g' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#timeout_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^#timeout_retry.*/d' /etc/neutron/huawei_driver_config.ini
    sed -i '/^timeout_retry.*/{n;d}' /etc/neutron/huawei_driver_config.ini
    sed -i '/^timeout_retry.*/d' /etc/neutron/huawei_driver_config.ini

    request_timeout=$(grep "^request_timeout[[:space:]]*=" /etc/neutron/huawei_driver_config.ini | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$request_timeout" ]; then
        if [ "$request_timeout" -lt 110 ]; then
            sed -i "s/^request_timeout[[:space:]]*=.*/request_timeout = 110/g" /etc/neutron/huawei_driver_config.ini
        fi
    fi

    enable_ce1800v_dhcp=$(grep "enable_ce1800v_dhcp[[:space:]]*=" /etc/neutron/huawei_driver_config.ini)
    if [ ! -n "$enable_ce1800v_dhcp" ]; then
        sed -i "\$G" /etc/neutron/huawei_driver_config.ini
        sed -i '$a\#enable_ce1800v_dhcp = false' /etc/neutron/huawei_driver_config.ini
    fi

    websocket_key_password=$(grep "^websocket_key_password" /etc/neutron/huawei_driver_config.ini)
    if [ ! -n "$websocket_key_password" ];then
        sed -i '/^\[huawei_ac_config\]/a\websocket_key_password = cwzeHAtBxmWHQGh7SqIa7A==' /etc/neutron/huawei_driver_config.ini
    fi

    error_retry_interval=$(grep "^error_retry_interval[[:space:]]*=" /etc/neutron/huawei_driver_config.ini | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$error_retry_interval" ]; then
        sed -i "s/^error_retry_interval[[:space:]]*=.*/error_retry_interval = 180/g" /etc/neutron/huawei_driver_config.ini
    fi

    error_retry_count=$(grep "^error_retry_count[[:space:]]*=" /etc/neutron/huawei_driver_config.ini | cut -d "=" -f 2 | sed s/[[:space:]]//g)
    if [ -n "$error_retry_count" ]; then
        sed -i "s/^error_retry_count[[:space:]]*=.*/error_retry_count = 0/g" /etc/neutron/huawei_driver_config.ini
    fi

    #修改配置文件权限为600，属主为neutron
    chmod 600 /etc/neutron/huawei_driver_config.ini
    chown neutron:neutron /etc/neutron/huawei_driver_config.ini
    
    #修改配置文件
    echo "..........step4:Modify configuration file.........."
    cd /etc/neutron/

    password=${password}
    PASSWORD=$(python ${INSTALL_PATH}/networking-huawei/tools/encode.py "${password}" account_passwd)
    sed -i "s#\(ac_auth_password =\).*#\1 $PASSWORD#g" huawei_driver_config.ini
    
    keystone_passwd=${keystone_passwd}
    KEYSTONE_PASSWD=$(python ${INSTALL_PATH}/networking-huawei/tools/encode.py "${keystone_passwd}" keystone_auth_passwd)
    sed -i "s#\(keystone_passwd =\).*#\1 $KEYSTONE_PASSWD#g" huawei_driver_config.ini

    CURRENT_WHITE_LIST=/etc/neutron/whitelist.ini
    cat $CURRENT_WHITE_LIST|grep 'ipv6-ns-qos-policies' || sed -i  "/external-policy-groups/a\    \'ipv6-ns-qos-policies\': []," $CURRENT_WHITE_LIST
    cat $CURRENT_WHITE_LIST|grep 'tap-services' || sed -i  "/ipv6-ns-qos-policies/a\    \'tap-services\': []," $CURRENT_WHITE_LIST
    cat $CURRENT_WHITE_LIST|grep 'tap-flows' || sed -i  "/ipv6-ns-qos-policies/a\    \'tap-flows\': []," $CURRENT_WHITE_LIST
    
    # 修改启动文件
    echo "..........step5:Modify boot file.........."
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "neutron-server.service does not exist."
        return 1
    fi
    
    cp neutron-server.service  backup_neutron-server.service.backup
    
    signal=$(grep "^KillSignal[[:space:]]*=" /usr/lib/systemd/system/neutron-server.service)
    if [ -n "$signal" ]; then
        sed -i "s/.*\(KillSignal=\).*/\1SIGKILL/" /usr/lib/systemd/system/neutron-server.service
    else
        sed -i 'N;/\[Service\]/a\KillSignal=SIGKILL' /usr/lib/systemd/system/neutron-server.service
    fi

    NEUTRON_SERVER_SERVICE=/usr/lib/systemd/system/neutron-server.service
    EXEC_STOP="ps -ef | grep -w neutron-server | grep -w huawei_driver_config.ini | grep -v grep | awk '{if(\$2 != \" \"){print \"kill -9 \"\$2} else{exit}}' | sh"
    grep ExecStop $NEUTRON_SERVER_SERVICE
    if [ $? -eq 0 ]; then
        sed -i "s/.*\(ExecStop=\).*/\1$EXEC_STOP/" $NEUTRON_SERVER_SERVICE
    else
        sed -i "N;/\[Service\]/a\ExecStop=$EXEC_STOP" $NEUTRON_SERVER_SERVICE
    fi
    
    cat neutron-server.service | grep ^ExecStart | grep -v /etc/neutron/huawei_driver_config.ini
    if [ $? -eq 0 ]; then
        sed -i "s/\(^ExecStart.*\)/\1 --config-file \/etc\/neutron\/huawei_driver_config.ini/g" neutron-server.service
    fi
    
    #使能华为插件
    echo "..........step6:Enable HUAWEI plug-in.........."
    cd /etc/neutron/plugins/ml2/
    if [ ! -f ml2_conf.ini ]; then
        echo "ml2_conf.ini does not exist."
        return 1
    fi
    cp ml2_conf.ini  backup_ml2_conf.backup
    
    cd /etc/neutron/
    if [ ! -f neutron.conf ]; then
        echo "neutron.conf does not exist."
        return 1
    fi
    cp neutron.conf backup_neutron.backup
    sed -i '/^api_extensions_path/d' neutron.conf
    
    SERVICE_PLUGINS=$(sed '/^service_plugins = /!d;s/.*= //'  /root/easysuite_install/file_bak/neutron.conf)
    plugins_str="service_plugins = $SERVICE_PLUGINS"
    
    API_EXTENSIONS_PATH=$(sed '/^api_extensions_path = /!d;s/.*= //'  /root/easysuite_install/file_bak/neutron.conf)
    extensions_path_str="api_extensions_path = $API_EXTENSIONS_PATH"
    
    cat neutron.conf | grep ^service_plugins
    if [ $? -eq 0 ]; then
        sed -i "s/^service_plugins.*/${plugins_str}/g" neutron.conf
    else
        sed -i "4a${plugins_str}" neutron.conf
    fi
    sed -i "/^service_plugins.*/a${extensions_path_str}" neutron.conf

    #恢复证书
    cp -fp $ORIGIN_CERTS_PATH/ssl_cacert.pem $PYTHON_PATH/networking_huawei/drivers/ac/client
    cp -fp $ORIGIN_CERTS_PATH/client.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
    cp -fp $ORIGIN_CERTS_PATH/client_key.pem $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
    cp -fp $ORIGIN_CERTS_PATH/trust.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket
    #恢复websocket相关向量文件
    cp -fp /root/easysuite_install/file_bak/decrypt_dependency_websocket.txt $PYTHON_PATH/networking_huawei/drivers/ac/cryptor/decrypt_dependency_websocket.txt
    
    #重启neutron-server
    echo "..........step7:Restart neutron-server.........."
    cd /root/
    setenforce 0 >/dev/null 2>&1
    systemctl daemon-reload
    if [ "$OPS_VERSION" = "Newton" -o $OPS_VERSION = "Ocata" ]; then
        ps -ef | grep -w neutron-server | grep -w huawei_driver_config.ini | grep -v grep | awk '{if($2 != " "){print "kill -9 "$2} else{exit}}' | /usr/bin/sh
        systemctl start neutron-server.service
    else
        systemctl restart neutron-server.service
    fi
    if [ -e "${INSTALL_PATH}"/networking-huawei/build  ];then 
        rm -rf ${INSTALL_PATH}/networking-huawei/build 
    fi
    if [ -e "${INSTALL_PATH}"/networking-huawei/networking_huawei.egg-info ];then 
        rm -rf ${INSTALL_PATH}/networking-huawei/networking_huawei.egg-info
    fi
    
    echo "Installing install_openstatck_plugin end."
}
function clean_openstatck_plugin()
{
    echo "Clean_openstatck_plugin before install"
    echo "Clean_openstatck_plugin begin."
    mkdir -p /root/easysuite_install/file_bak
    mkdir -p /root/easysuite_install/file_bak/certs
    tar -zcvPf /root/easysuite_install/file_bak/networking-huawei.tar.gz $PYTHON_PATH/networking_huawei
    tar -zcvPf /root/easysuite_install/file_bak/networking-huawei-egg-info.tar.gz $PYTHON_PATH/networking_huawei-3.1.0-$PYTHON_VERSION.egg-info
    tar -zcvPf /root/easysuite_install/file_bak/networking-huawei-root.tar.gz /root/networking-huawei
    tar -zcvPf /root/easysuite_install/file_bak/neutron-setting.tar.gz /etc/neutron
    cp -f /etc/neutron/neutron.conf /root/easysuite_install/file_bak/neutron.conf
    cp -f /etc/neutron/huawei_driver_config.ini /root/easysuite_install/file_bak/huawei_driver_config.ini
    cp -f /etc/neutron/plugins/ml2/ml2_conf.ini /root/easysuite_install/file_bak/ml2_conf.ini
    cp -f /etc/neutron/whitelist.ini /root/easysuite_install/file_bak/whitelist.ini
    cp -f /usr/lib/systemd/system/neutron-server.service /root/easysuite_install/file_bak/neutron-server.service
    cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/client/ssl_cacert.pem /root/easysuite_install/file_bak/certs
    cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/client.cer /root/easysuite_install/file_bak/certs
    cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/client_key.pem /root/easysuite_install/file_bak/certs
    cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/trust.cer /root/easysuite_install/file_bak/certs
    cp -fp $PYTHON_PATH/networking_huawei/drivers/ac/cryptor/decrypt_dependency_websocket.txt /root/easysuite_install/file_bak
    if [ -e $PYTHON_PATH/networking_huawei ];then
        rm -rf $PYTHON_PATH/networking_huawei
    fi
    if [ -e $PYTHON_PATH/networking_huawei-3.1.0-$PYTHON_VERSION.egg-info ];then
        rm -rf $PYTHON_PATH/networking_huawei-3.1.0-$PYTHON_VERSION.egg-info
    fi
    if [ -e /root/networking-huawei/ ];then
        rm -rf /root/networking-huawei/
    fi
    # 修改启动文件
    echo "..........step1:Modify boot file.........."
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "neutron-server.service does not exist."
    fi
    if [ ! -f backup_neutron-server.service.backup ]; then
        echo "backup_neutron-server.service.backup does not exist."
    else
        cp -f backup_neutron-server.service.backup neutron-server.service
        rm -f backup_neutron-server.service.backup
    fi
    
    #卸载华为插件
    function rollback_config()
    {
        current_file=$1
        config_name=$2
        huawei_config_lists=$3
        rollback_config_lists=$4
        OLD_IFS="$IFS"
        IFS=" "
        huawei_config_list=($huawei_config_lists)
        rollback_config_list=($rollback_config_lists)
        IFS="$OLD_IFS"
        seperator=$5
        label=$6
        current_config=$(sed "/^$config_name[[:space:]]*=/!d;s/.*=//" $current_file)
        new_config=$(echo $current_config | sed -e "s/[[:space:]]//g")
        new_config=$(echo $new_config | sed -e "s|^$seperator||" | sed -e "s|$seperator$||")
        ##remove huawei config
        for(( i=0;i<${#huawei_config_list[@]};i++))do
            huawei_config=${huawei_config_list[i]}
            rollback_to=${rollback_config_list[i]}
            if [[ "$rollback_to" != "" ]];then
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$seperator|$rollback_to$seperator|g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$seperator|$seperator$rollback_to$seperator|g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$|$seperator$rollback_to|g")
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$|$rollback_to|g")
            else
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$seperator||g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$seperator|$seperator|g")
                new_config=$(echo $new_config | sed -e "s|$seperator$huawei_config$||g")
                new_config=$(echo $new_config | sed -e "s|^$huawei_config$||g")
            fi
        done
        new_config=$(echo $new_config | sed -e "s/^$seperator//" | sed -e "s/$seperator$//")
        ##write into config file
        if [[ -n "$current_config" ]]; then
            if [[ -n "$new_config" ]]; then
                sed -i "s#^$config_name[[:space:]]*=.*#$config_name = $new_config#g" $current_file
            else
                sed -i "s#^$config_name[[:space:]]*=.*#\#$config_name = #g" $current_file
            fi
        else
            if [[ -n "$new_config" ]]; then
                new_config=$(echo $new_config | sed 's#/#\\/#g')
                sed -i "/^\[${label}\]/a $config_name = $new_config" $current_file
            fi
        fi
        echo "original config is: $current_config"
        echo "rollback config to: $new_config"
        echo ""
    }
    
    ML2_CONF_CUR=/etc/neutron/plugins/ml2/ml2_conf.ini
    NEUTRON_CONF_CUR=/etc/neutron/neutron.conf
    PYTHON_PATH=/usr/lib/python2.7/site-packages
    
    ##service_plugins
    echo "  unable huawei service_plugins"
    service_plugins_name=service_plugins
    huawei_service_plugins_list=(huawei_ac_router huawei_ac_sync_results huawei_ac_compare_results huawei_ac_ext huawei_ac_fwaas huawei_ac_ipsecvpn huawei_ac_qos huawei_ac_dnat huawei_ac_vpc_connection huawei_ac_bgp_route huawei_ac_l2br huawei_ac_snat huawei_ac_portforwarding)
    rollback_service_list=(router "" firewall vpnaas "" "" "" "" "" "" "")
    rollback_config $NEUTRON_CONF_CUR $service_plugins_name "${huawei_service_plugins_list[*]}" "${rollback_service_list[*]}" ',' 'DEFAULT'
    
    ##api_extensions_path
    echo "  unable huawei api_extensions_path"
    api_extensions_path_name=api_extensions_path
    api_exroute=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/exroute
    api_sync=$PYTHON_PATH/networking_huawei/drivers/ac/extensions/sync
    api_fwaas=$PYTHON_PATH/neutron_fwaas/extensions
    api_vpnaas=$PYTHON_PATH/neutron_vpnaas/extensions
    huawei_ac_extensions_path_list=($api_exroute $api_sync $api_fwaas $api_vpnaas)
    rollback_extensions_path_list=("" "" "" "")
    rollback_config $NEUTRON_CONF_CUR $api_extensions_path_name "${huawei_ac_extensions_path_list[*]}" "${rollback_extensions_path_list[*]}" ':' 'DEFAULT'
    
    if [ -e /etc/neutron/plugin.ini ];then
        rm -f /etc/neutron/plugin.ini
    fi
    ln -s /etc/neutron/plugins/ml2/ml2_conf.ini /etc/neutron/plugin.ini

    systemctl daemon-reload
    systemctl stop neutron-server.service
    $(ps -ef|grep neutron | grep -v grep | awk '{print $2}'|xargs -r kill -9 )
    echo "Clean_openstatck_plugin end."
}

#main
clean_openstatck_plugin
install_openstatck

