#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    upgrade_openstatck_rollback
#  Description: openstatck插件升级回滚
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd


function install_openstatck_plugin()
{
    #回退备份文件
    INSTALL_PATH="/root"
    tar -zxvPf /root/easysuite_install/file_bak/networking-huawei.tar.gz /usr/lib/python2.7/site-packages/networking_huawei/
    tar -zxvPf /root/easysuite_install/file_bak/networking-huawei-egg-info.tar.gz /usr/lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info/
    tar -zxvPf /root/easysuite_install/file_bak/networking-huawei-root.tar.gz /root/networking-huawei/
    tar -zxvPf /root/easysuite_install/file_bak/neutron-setting.tar.gz /etc/neutron/
    cp -f /root/easysuite_install/file_bak/neutron-server.service /usr/lib/systemd/system/neutron-server.service 

    #回滚snat
    current_config=$(sed '/^service_plugins = /!d;s/.*= //'  /etc/neutron/neutron.conf)
    config_flag=$(echo $current_config | grep "huawei_ac_snat")
    if [[ -n "$config_flag" ]]; then
        new_config=$(echo $current_config | sed -e "s/[[:space:]]//g")
        new_config=$(echo $new_config | sed -e "s|^huawei_ac_snat,||g")
        new_config=$(echo $new_config | sed -e "s|,huawei_ac_snat,|,|g")
        new_config=$(echo $new_config | sed -e "s|,huawei_ac_snat||g")
        plugins_str="service_plugins = $new_config"
        sed -i "s/^service_plugins.*/${plugins_str}/g" /etc/neutron/neutron.conf
    fi

    #重启neutron-server
    echo "..........Restart neutron-server.........."
    OPS_VERSION=$(sed '/^OPS_version = /!d;s/.*= //'  /root/easysuite_install/file_bak/huawei_driver_config.ini)
    cd /root/
    setenforce 0 >/dev/null 2>&1
    systemctl daemon-reload
    if [ "$OPS_VERSION" = "Newton" -o $OPS_VERSION = "Ocata" ]; then
        ps -ef | grep -w neutron-server | grep -w huawei_driver_config.ini | grep -v grep | awk '{if($2 != " "){print "kill -9 "$2} else{exit}}' | /usr/bin/sh
        systemctl start neutron-server.service
    else
        systemctl restart neutron-server.service
    fi
    if [ -e "${INSTALL_PATH}"/networking-huawei/build  ];then
        rm -rf ${INSTALL_PATH}/networking-huawei/build 
    fi
    if [ -e "${INSTALL_PATH}"/networking-huawei/networking_huawei.egg-info ];then
        rm -rf ${INSTALL_PATH}/networking-huawei/networking_huawei.egg-info
    fi
    echo "Installing install_openstatck_plugin end."
}
function clean_openstatck_plugin()
{
    echo "Clean_openstatck_plugin before install"
    echo "Clean_openstatck_plugin begin."
    if [ -e /usr/lib/python2.7/site-packages/networking_huawei ];then
        rm -rf /usr/lib/python2.7/site-packages/networking_huawei
    fi
    if [ -e /usr/lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info ];then
        rm -rf /usr/lib/python2.7/site-packages/networking_huawei-3.1.0-py2.7.egg-info
    fi
    if [ -e /etc/neutron/huawei_driver_config.ini ];then
        rm -f /etc/neutron/huawei_driver_config.ini
    fi
    if [ -e /etc/neutron/whitelist.ini ];then
        rm -f /etc/neutron/whitelist.ini
    fi
    if [ -e /root/networking-huawei/ ];then
        rm -rf /root/networking-huawei/
    fi
    # 修改启动文件
    echo "..........step1:Modify boot file.........."
    cd /usr/lib/systemd/system/
    if [ ! -f neutron-server.service ]; then
        echo "neutron-server.service does not exist."
        return 0
    fi
    if [ ! -f backup_neutron-server.service.backup ]; then
        echo "backup_neutron-server.service.backup does not exist."
        return 0
    else
        cp -f backup_neutron-server.service.backup neutron-server.service
        rm -f backup_neutron-server.service.backup
    fi


    
    #使能华为插件
    echo "..........step2:Enable HUAWEI plug-in.........."
    cd /etc/neutron/plugins/ml2/
    if [ ! -f ml2_conf.ini ]; then
        echo "ml2_conf.ini does not exist."
        return 0
    fi
    if [ ! -f backup_ml2_conf.backup ]; then
        echo "backup_ml2_conf.backup does not exist."
    else
        cp -f backup_ml2_conf.backup ml2_conf.ini
        rm -f backup_ml2_conf.backup
    fi  

    cd /etc/neutron/
    if [ ! -f neutron.conf ]; then
        echo "neutron.conf does not exist."
        return 0
    fi
    if [ ! -f backup_neutron.backup ]; then
        echo "backup_neutron.backup does not exist."
    else
        cp -f backup_neutron.backup neutron.conf
        rm backup_neutron.backup
    fi

    systemctl daemon-reload
    systemctl stop neutron-server.service
    ps -ef|grep neutron-server | grep -v grep | awk '{print $2}'|xargs -r kill -9 >/dev/null 2>&1
    echo "Clean_openstatck_plugin end."
}

#main
clean_openstatck_plugin
install_openstatck_plugin

