#!/bin/bash
# files description 
# Copyright Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
#---------------------------------------------------------------------------
#  Function:    install_openstatck
#  Description: FS环境安装AC-DCN插件包上传
#  Input:       NA
#  Output:      NA
#  Return:      NA
#  Others:      NA
#---------------------------------------------------------------------------

#param from cmd
pkg_ops=$1
echo "es_input: os_password" 
read os_password
os_password=${os_password}

source set_env<<EOF > /dev/null 2>&1
1
$os_password
EOF

createcheckfile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/etc/check_fs_result.sh
 
   chmod 755 /etc/check_fs_result.sh
}

getcheckresult()
{
   if [ "$1" -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /etc/check_fs_result.sh
   ">/etc/check_fs_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /etc/check_fs_result.sh
   ">/etc/check_fs_result.sh
   fi
   chmod 755 /etc/check_fs_result.sh > /dev/null 2>&1
}

upload_package()
{
    TMP_DIR=$(mktemp -d)
    if [ ${pkg_ops} != "networking-huawei.tar.gz" ]; then
        unzip /root/${pkg_ops} -d ${TMP_DIR}
    else
        cp -f /root/easysuite_install/${pkg_ops} ${TMP_DIR}
    fi
    cd $TMP_DIR
    PLUG_PKG="networking-huawei.tar.gz"
    if [ ! -e "${PLUG_PKG}" ]; then
        echo "Installing install_openstatck_plugin failed, because ${PLUG_PKG} does not exist."
        exit 1
    fi
    tar -zxvf $PLUG_PKG >/dev/null 2>&1
    cd $TMP_DIR/networking-huawei/

    FSP_PLUGIN_PKG=$(ls NEUTRONACPLUGIN*.tar.gz)
    echo "start cps upload package"
    sleep 5
    export TOKEN=$(openstack token issue | grep -w id | awk '{print $4}')
    https_code=$(curl -i -k -o /dev/null -s -w %{http_code} --insecure -X PUT -T "${FSP_PLUGIN_PKG}" -H "x-package-name: ${FSP_PLUGIN_PKG}" -H "X-Auth-Token:$TOKEN" https://localdomain.com:8008/cps/v1/package/source/swh/upload?type=sync)
    cd /root/
    rm -fr ${TMP_DIR}
    if [[ "${https_code}" == "200" ]]; then
        echo "cps upload package end"
        return 0
    else
        return 1
    fi
}

main_process()
{
    createcheckfile
    echo "upload package start."
    #source environment path
    
    cd /root/easysuite_install
    if [ [ -e "${pkg_ops}"] && [ ${pkg_ops} != "networking-huawei.tar.gz" ] ];then
        rm -f ${pkg_ops}
    fi

    origin_ops=$(cps package-instance-list | grep 'NEUTRONACPLUGIN' | awk '{print $2}')
    if [[ "${origin_ops}" ]]; then
        /bin/cps package-delete --package-name ${origin_ops}
    fi
    sleep 10
    package_list=$(/bin/cps package-instance-list | grep ${origin_ops})

    query_times=0
    while [[ "${package_list}" ]] && [ "${query_times}" -lt 60 ]
    do
        let query_times++
        sleep 2
        package_list=$(/bin/cps package-instance-list | grep ${origin_ops})
    done
    if [[ "${package_list}" ]]; then
        echo "ERROR:delete package failed!"
        exit 1
    fi
    if [ ${pkg_ops} != "networking-huawei.tar.gz" ]; then
        chmod 600 /root/${pkg_ops}
        cp -rf /root/${pkg_ops} /root/easysuite_install/${pkg_ops}
    fi

    upload_package
    if [ $? -ne 0 ]
    then
        echo "ERROR:upload package failed!"
        return 1
    fi
    return 0
}

main_process
getcheckresult $?
exit $?
