#!/usr/bin/env python
# coding=utf-8

"""
功 能：XXX类，该类主要涉及XXX功能
版权信息：华为技术有限公司，版本所有(C) 2010-2021
"""
from xml.dom.minidom import parseString
from aoc.snd.snd_model_pb2.cliTransform_pb2 import CliCustomTransformOutput
from aoc.sys import datastore

from com.huawei.controller.f5.tool.command_proxy import CommandProxy
from com.huawei.controller.f5.tool.constant_path import PORT_TYPE


def clitoyang_common(config, newlines, config_str, state, leaf_arr):
    """
    功能描述：
    参数：config, newlines, config_str, state, leaf_arr
    返回值：newlines, config_str, state
    """
    if config.startswith('}'):
        state = False
        newlines.append(config_str)
    elif config.lstrip().split(' ')[0] in leaf_arr:
        config_str = '%s %s' % (config_str, config.strip())
    return newlines, config_str, state


def clitoyang_ltm_node(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm node'], 120)
    logger.info('clitoyang ltm_node response_data: \r\n%s' % response_data)
    leaf_arr = ['address', 'monitor']
    config_str = ''
    state = False
    newlines = []
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm node'):
            state = True
            config_str = config[0:-2:]
        if not state:
            continue
        newlines, config_str, state = \
            clitoyang_common(config, newlines, config_str, state, leaf_arr)
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_node result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_ltm_monitor_tcp(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm monitor tcp'], 120)
    logger.info('clitoyang ltm_monitor_tcp response_data: \r\n%s' % response_data)
    leaf_arr = ['interval', 'destination', 'recv', 'recv-disable', 'send',
                'time-until-up', 'timeout']
    config_str = ''
    state = False
    newlines = []
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm monitor tcp'):
            state = True
            config_str = config[0:-2:]
        if not state:
            continue
        if config.startswith('}'):
            state = False
            newlines.append(config_str)
        elif config.lstrip().split(' ')[0] == leaf_arr[1]:
            port_arr = config.strip().split(":")
            config_str = '%s %s:%s' % \
                         (config_str, port_arr[0],
                          PORT_TYPE.get(port_arr[1], port_arr[1]))
        elif config.lstrip().split(' ')[0] in leaf_arr:
            config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_monitor_tcp result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_ltm_pool(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm pool'], 120)
    logger.info('clitoyang ltm_pool response_data: \r\n%s' % response_data)
    leaf_arr = ['load-balancing-mode', 'monitor']
    config_str = ''
    state = False
    child_state = False
    newlines = []
    child_conf = []
    child_conf_str = ''
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm pool'):
            if config.endswith('}'):
                newlines.append(config[0:-4:])
            else:
                state = True
                config_str = config[0:-2:]
        if not state:
            continue
        if config.startswith('    members'):
            child_state = True
            continue
        if child_state:
            if config.endswith('{') or config.endswith('{ }'):
                port_arr = config.strip().split(" ")[0].split(':')
                child_conf.append('%s:%s' %
                                  (port_arr[0], PORT_TYPE.get(port_arr[1], port_arr[1])))
            elif config.startswith('    }'):
                child_conf_str = ' members replace-all-with {{ {0}}}'\
                    .format(' '.join(child_conf))
                child_state = False
                child_conf = []
        elif config.startswith('}'):
            state = False
            newlines.append(config_str + child_conf_str)
            child_conf_str = ''
        elif config.lstrip().split(' ')[0] in leaf_arr:
            config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_pool result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_ltm_profile_fastl4(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm profile fastl4'], 120)
    logger.info('clitoyang ltm_profile_fastl4 response_data: \r\n%s' % response_data)
    leaf_arr = ['app-service', 'loose-close', 'tcp-close-timeout', 'defaults-from']
    config_str = ''
    state = False
    newlines = []
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm profile fastl4'):
            state = True
            config_str = config[0:-2:]
        if not state:
            continue
        if config.startswith('}'):
            state = False
            newlines.append(config_str)
        elif config.lstrip().split(' ')[0] == leaf_arr[3]:
            config_str = '%s %s /Common/%s' % \
                         (config_str, config.strip().split(' ')[0],
                          config.strip().split(' ')[1])
        elif config.lstrip().split(' ')[0] in leaf_arr:
            config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_profile_fastl4 result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_ltm_virtual(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm virtual'], 120)
    logger.info('clitoyang ltm_virtual response_data: \r\n%s' % response_data)
    leaf_arr = ['destination', 'ip-protocol', 'mask', 'pool', 'source',
                'translate-address', 'translate-port']
    config_str = ''
    state, child_state, translation_state = False, False, False
    newlines, child_conf = [], []
    ip_protocol = ['fastL4']
    child_conf_str, translation_child_conf_str = '', ''
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm virtual'):
            state = True
            config_str = config[0:-2:]
        if not state:
            continue
        if config.startswith('    profiles'):
            child_state = True
            continue
        if config.startswith('    source-address-translation'):
            translation_state = True
            continue
        if child_state:
            child_state, child_conf, child_conf_str = \
                clitoyang_ltm_virtual_child(config, child_conf, ip_protocol,
                                            child_conf_str, child_state)
        elif translation_state:
            translation_state, translation_child_conf_str = \
                clitoyang_ltm_virtual_translation_child(
                    config, translation_child_conf_str, translation_state)
        elif config.startswith('}'):
            state = False
            newlines.append(config_str + translation_child_conf_str + child_conf_str)
            child_conf_str, translation_child_conf_str = '', ''
        elif config.lstrip().split(' ')[0] == leaf_arr[0]:
            port_arr = config.strip().split(":")
            config_str = '%s %s:%s' % (config_str, port_arr[0],
                                       PORT_TYPE.get(port_arr[1], port_arr[1]))
        elif config.lstrip().split(' ')[0] == leaf_arr[1]:
            ip_protocol.append(config.strip().split(" ")[1])
            config_str = '%s %s' % (config_str, config.strip())
        elif config.lstrip().split(' ')[0] in leaf_arr:
            config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_virtual result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_ltm_virtual_child(config, child_conf, ip_protocol, child_conf_str, child_state):
    """
    功能描述：
    参数：config, child_conf, ip_protocol, child_state, child_conf_str
    返回值：child_state, child_conf, child_conf_str
    """
    if config.endswith('{') or config.endswith('{ }'):
        profile = config.strip().split(" ")[0]
        if profile not in ip_protocol:
            child_conf.append(profile)
    elif config.startswith('    }'):
        if child_conf:
            child_conf_str = ' profiles replace-all-with {{ {0}}}'\
                .format(' '.join(child_conf))
        child_state = False
        child_conf = []
    return child_state, child_conf, child_conf_str


def clitoyang_ltm_virtual_translation_child(config, translation_child_conf_str, translation_state):
    """
    功能描述：
    参数：config, translation_child_conf_str, translation_state
    返回值：translation_state, translation_child_conf_str
    """
    if config.startswith('    }'):
        translation_child_conf_str = ' source-address-translation ' + '{{{0}}}'.format(
            translation_child_conf_str).ljust(50)
        translation_state = False
    elif config.lstrip().split(' ')[0] == 'pool':
        translation_child_conf_str = " pool " + config.lstrip().split(' ')[1]
    elif config.lstrip().split(' ')[0] == 'type':
        translation_child_conf_str = "type " + config.lstrip().split(' ')[1] + \
                                     translation_child_conf_str
    return translation_state, translation_child_conf_str


def clitoyang_ltm_virtual_address(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm virtual-address'], 120)
    logger.info('clitoyang ltm_virtual_address response_data: \r\n%s' % response_data)
    leaf_arr = ['arp', 'icmp-echo', 'address', 'mask', 'traffic-group']
    config_str = ''
    state = False
    newlines = []
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm virtual-address'):
            if len(config.split(".")) != 4:
                state = True
                config_str = config[0:-2:]
        if not state:
            continue
        newlines, config_str, state = \
            clitoyang_common(config, newlines, config_str, state, leaf_arr)
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_virtual_address result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_ltm_snatpool(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config ltm snatpool'], 120)
    logger.info('clitoyang ltm_snatpool response_data: \r\n%s' % response_data)
    leaf_arr = []
    config_str = ''
    state = False
    child_state = False
    newlines = []
    child_conf = []
    child_conf_str = ''
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('ltm snatpool'):
            state = True
            config_str = config[0:-2:]
        if not state:
            continue
        if config.startswith('    members'):
            child_state = True
            continue
        if child_state:
            if config.startswith('    }'):
                child_conf_str = ' members replace-all-with {{ {0}}}'\
                    .format(' '.join(child_conf))
                child_state = False
                child_conf = []
            else:
                child_conf.append(config.strip())
        elif config.startswith('}'):
            state = False
            newlines.append(config_str + child_conf_str)
            child_conf_str = ''
        elif config.lstrip().split(' ')[0] in leaf_arr:
            config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang ltm_snatpool result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_net_vlan(request, logger, aoccontext):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config net vlan'], 120)
    logger.info('clitoyang net_vlan response_data: \r\n%s' % response_data)
    leaf_arr = ['tag']
    config_str = ''
    state = False
    child_state = False
    newlines = []
    child_conf = []
    child_conf_str = ''
    configs = response_data.splitlines()
    vlan_name = ''
    for config in configs:
        if config.startswith('net vlan'):
            state = True
            config_str = config[0:-2:]
            vlan_name = config_str.split(' ')[2]
        if not state:
            continue
        if config.startswith('    interfaces'):
            child_state = True
            continue
        if child_state:
            if config.endswith('{'):
                child_conf.append('%s {tagged}' % config.strip().split(" ")[0])
            elif config.endswith('{ }'):
                child_conf.append('%s {untagged}' % config.strip().split(" ")[0])
            elif config.startswith('    }'):
                child_conf_str = ' interfaces replace-all-with {{{0}}}'\
                    .format(' '.join(child_conf))
                child_state = False
                child_conf = []
        elif config.startswith('}'):
            state = False
            newlines.append(config_str + child_conf_str)
            child_conf_str = ''
        elif config.lstrip().split(' ')[0] == leaf_arr[0]:
            vlan_path = '/huawei-ac-nes:inventory-cfg/nes/ne/%s/f5-net-vlan:' \
                        'f5-net-vlan/f5-net-vlan:net/f5-net-vlan:vlan/%s' \
                        % (request.neId, vlan_name)
            if query_net_vlan(aoccontext, vlan_path, logger):
                config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang net_vlan result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def query_net_vlan(aoccontext, query_address_path, logger):
    """
    功能描述：query_net_vlan
    参数：aoccontext, query_address_path,
    返回值：Boolean
    """
    prefix_cdb = datastore.read_datastore_cdb(aoccontext, query_address_path)
    logger.info('[F5BIGIP] query vlan in cdb is %s' % prefix_cdb)
    try:
        if prefix_cdb != '':
            dict = parseString(prefix_cdb)
            collection = dict.documentElement
            # 集合你要的标签
            tag_child = collection.getElementsByTagName("tag")
            if tag_child and tag_child[0].childNodes \
                    and tag_child[0].childNodes[0].data.isdecimal():
                return True
            logger.info('[F5BIGIP] change vlan in device config')
            return False
    except Exception:
        logger.error('[F5BIGIP] cdb parse string fail!')
        return True
    return True


def clitoyang_net_self(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config net self'], 120)
    logger.info('clitoyang net_self response_data: \r\n%s' % response_data)
    leaf_arr = ['address', 'vlan']
    config_str = ''
    state = False
    newlines = []
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('net self'):
            config_str = config[0:-2:]
            state = True
        if not state:
            continue
        newlines, config_str, state = \
            clitoyang_common(config, newlines, config_str, state, leaf_arr)
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang net_self result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_net_route(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config net route'], 120)
    logger.info('clitoyang net_route response_data: \r\n%s' % response_data)
    leaf_arr = ['gw', 'network']
    config_str = ''
    state = False
    newlines = []
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('net route'):
            config_str = config[0:-2:]
            state = True
        if not state:
            continue
        newlines, config_str, state = \
            clitoyang_common(config, newlines, config_str, state, leaf_arr)
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang net_route result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out


def clitoyang_net_trunk(request, logger):
    """
    功能描述：
    参数：logger, request
    返回值：out
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['tmsh show running-config net trunk'], 120)
    logger.info('clitoyang net_trunk response_data: \r\n%s' % response_data)
    leaf_arr = ['lacp']
    config_str = ''
    state = False
    child_state = False
    newlines = []
    child_conf = []
    child_conf_str = ''
    configs = response_data.splitlines()
    for config in configs:
        if config.startswith('net trunk'):
            state = True
            config_str = config[0:-2:]
        if not state:
            continue
        if config.startswith('    interfaces'):
            child_state = True
            continue
        if child_state:
            if config.startswith('    }'):
                child_conf_str = ' interfaces replace-all-with {{ {0}}}'\
                    .format(' '.join(child_conf))
                child_state = False
                child_conf = []
            else:
                child_conf.append(config.strip())
        elif config.startswith('}'):
            state = False
            newlines.append(config_str + child_conf_str)
            child_conf_str = ''
        elif config.lstrip().split(' ')[0] in leaf_arr:
            config_str = '%s %s' % (config_str, config.strip())
    result_data = '\r\n'.join(newlines) + '\r\n'
    logger.info('clitoyang net_trunk result_data: \r\n%s' % result_data)
    out.data = result_data
    out.endOffset = -1
    return out
