#!/usr/bin/env python
# coding=utf-8

"""
功 能：invoke java, send command to device
版权信息：华为技术有限公司，版本所有(C) 2010-2021
"""
from aoc.sys import cliproxy


class CommandProxy(object):
    """
    invoke java, send command to device
    """

    def __init__(self, ne_id, logger):
        logger.info("build CommandProxy for " + ne_id)
        self.ne_id = ne_id
        self.logger = logger

    def send_command(self, commands, timeout=20):
        """
        query devices’ detail information.
        :param commands: device cli command.
        :param aoccontext aoccontext
        :param timeout: time out
        :return: devices’ detail information.
        """
        for command in commands:
            self.logger.info('send_command command:%s' % command)
            try:
                return cliproxy.sendCli(self.ne_id, command, timeout)
            except Exception as err:
                self.logger.error(err)
                return ""

    def send_command_list(self, commands, timeout=20):
        """
        query devices’ detail information.
        :param commands: device cli command.
        :param aoccontext aoccontext
        :param timeout: time out
        :return: devices’ detail information.
        """
        response = []
        for command in commands:
            self.logger.info('send_command_list command:%s' % command)
            try:
                response.append(cliproxy.sendCli(self.ne_id, command, timeout))
            except Exception as err:
                self.logger.error(err)
                return ""
        return response[-1]
