#!/usr/bin/env python
# coding=utf-8

"""
功 能：cli类，该类主要涉及cli转SND功能
版权信息：华为技术有限公司，版本所有(C) 2010-2021
"""
from aoc.snd.snd_model_pb2.cliTransform_pb2 import CliCustomTransformOutput
from com.huawei.controller.cisco.tool.command_proxy import CommandProxy


def clitoyang_interface(request, logger):
    """
    功能描述：采集CLI命令
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command(['show running-config | section ^interface'], 180)
    logger.info('clitoyang interfaces response_data: %s' % response_data)
    response_body = response_data.response if hasattr(response_data, 'response') else response_data
    out.data = '\n'.join(dealwith_ifm_response(response_body, logger)) + '\n'
    logger.info('clitoyang interfaces config data: %s' % out.data)
    out.endOffset = -1
    return out


def clitoyang_global(request, logger):
    """
    功能描述：采集CLI命令
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command_list(['show running-config | section ^spanning-tree | section mode',
                                             'show running-config | section ^feature'], 180)
    logger.info('clitoyang global response_data: %s' % response_data)
    response_body = response_data.response if hasattr(response_data, 'response') else response_data
    out.data = '\n'.join(dealwith_global_response(response_body, logger)) + '\n'
    logger.info('clitoyang global config data: %s' % out.data)
    out.endOffset = -1
    return out


def clitoyang_instance(request, logger):
    """
    功能描述：采集CLI命令
    """
    out = CliCustomTransformOutput()
    proxy = CommandProxy(request.neId, logger)
    response_data = proxy.send_command_list(
        ['show running-config | section ^vrf', 'show running-config | section ^vlan',
         'show running-config | section ^ip | section route'], 180)
    logger.info('clitoyang instances response_data: %s' % response_data)
    response_body = response_data.response if hasattr(response_data, 'response') else response_data
    out.data = '\n'.join(dealwith_instance_response(response_body, logger)) + '\n'
    logger.info('clitoyang instances config data: %s' % out.data)
    out.endOffset = -1
    return out


def dealwith_response(response, logger):
    """
    功能描述：处理采集信息
    """
    cli_str = str(response)
    logger.info('[Response] formal: %s' % cli_str)
    newlines = []
    lines = cli_str.splitlines()
    for line in lines:
        if not line.isspace() and line and '--More--' not in line and 'show running-config' not in line:
            if '#' not in line and '!Time:' not in line and 'version' not in line:
                temp_line = line.replace("dot1q", "dot1Q").replace("  secondary", " secondary")
                newlines.append(temp_line)
    logger.info('[Response] final: %s' % newlines)
    return newlines


def dealwith_instance_response(response, logger):
    """
    功能描述：处理采集信息
    """
    newlines = dealwith_response(response, logger)
    config_lines = []
    vlan_config_lines = []
    config_line = ''
    for line in newlines:
        if line.startswith('ip') or line.startswith('vrf'):
            config_lines.append(line)
            config_line = line
        elif line.startswith('vlan'):
            vlan_config_lines.append(line)
            config_line = line
        elif line.startswith(' '):
            if config_line.startswith('vrf'):
                config_lines.append(line)
        else:
            if config_line.startswith('vlan'):
                vlan_config_lines[-1] = vlan_config_lines[-1] + line
    vlan_line_arr = []
    for vlan_config_str in vlan_config_lines:
        get_vlan_range(vlan_line_arr, vlan_config_str)
    config_lines.extend(set(vlan_line_arr))
    return config_lines


def get_vlan_range(vlan_line_arr, vlan_config_str):
    """
    功能描述：处理采集信息
    """
    for vlan_str in vlan_config_str[5:].split(','):
        vlan_str = vlan_str.strip()
        if vlan_str.isdigit():
            vlan_line_arr.append('vlan ' + vlan_str)
        elif vlan_str.__contains__("-"):
            vlan_arr = vlan_str.split('-')
            if vlan_arr[0].isdigit() and vlan_arr[1].isdigit():
                vlan_line_arr.extend(
                    ['vlan ' + str(vlan) for vlan in range(int(vlan_arr[0]), int(vlan_arr[1]) + 1)])


def dealwith_global_response(response, logger):
    """
    功能描述：处理采集信息
    """
    newlines = dealwith_response(response, logger)
    if not newlines.__contains__('spanning-tree mode mst'):
        newlines.append("spanning-tree mode rapid-pvst")
    return newlines


def dealwith_ifm_response(response, logger):
    """
    功能描述：处理ifm采集信息
    """
    newlines = dealwith_response(response, logger)
    config_lines = []
    configs = []
    for line in newlines:
        if line.startswith(' '):
            config_lines.append(line)
        else:
            if len(config_lines) > 0:
                configs.append(config_lines)
            config_lines = [line]
    if len(config_lines) > 0:
        configs.append(config_lines)

    final_configs = [deal_ifm_config(config) for config in configs]
    logger.info('[Response] final ifm: %s' % final_configs)
    return final_configs


def deal_ifm_config(config):
    """
    功能描述：处理ifm配置
    """
    config_name = config[0]
    if not config_name.startswith('interface'):
        return '\n'.join(config)
    if not (config.__contains__('  no shutdown') or config.__contains__('  shutdown')):
        if not config_name.__contains__('/') or config.__contains__('  switchport'):
            config.append("  no shutdown")
        else:
            config.append("  shutdown")
    return '\n'.join(config)
