#!/usr/bin/env python
# coding=utf-8

"""
功 能：cli类，该类主要涉及cli转SND功能
版权信息：华为技术有限公司，版本所有(C) 2010-2021
"""
from aoc.sys import cliproxy

class CommandProxy(object):
    """
    invoke java, send command to device
    """
    def __init__(self, ne_id, logger):
        self.ne_id = ne_id
        self.logger = logger

    def send_command(self, commands, timeout=30):
        """
        query devices’ detail information.
        """
        for command in commands:
            self.logger.info('send command:%s' % command)
            try:
                return cliproxy.sendCli(self.ne_id, command, timeout)
            except Exception as e:
                self.logger.error(e)
                return ""

    def send_command_list(self, commands, timeout=30):
        """
        query devices’ detail information.
        """
        response = []
        for command in commands:
            self.logger.info('send command:%s' % command)
            try:
                response.append(cliproxy.sendCli(self.ne_id, command, timeout))
            except Exception as e:
                self.logger.error(e)
                return ""
        cli_str = '\n'.join(response)
        return cli_str
