#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""i18n"""

import oslo_i18n

DOMAIN = "networking_huawei"

_TRANSLATORS = oslo_i18n.TranslatorFactory(domain=DOMAIN)

# The primary translation function using the well-known name "_"
_ = _TRANSLATORS.primary

# Translators for log levels.
#
# The abbreviated names are meant to reflect the usual use of a short
# name like '_'. The "L" is for "log" and the other letter comes from
# the level.
_LI = _TRANSLATORS.log_info
_LW = _TRANSLATORS.log_warning
_LE = _TRANSLATORS.log_error
_LC = _TRANSLATORS.log_critical


def get_available_languages():
    """get_available_languages"""
    return oslo_i18n.get_available_languages(DOMAIN)
