#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei common constants"""

import os

WAIT = 'wait'
IN_PROCESS = 'in_process'
COMPLETE = 'complete'
SUSPEND = 'suspend'
ERROR_RETRY = 'error_retry'

NORMAL = 'normal'
NEUTRON_SYNC = 'neutron_sync'
CONSISTENCY_CHECK = 'consistency_check'
SYNC_CONSISTENCY_CHECK = 'sync_consistency_check'
ERROR = 'error'

LEADER = 1
NON_LEADER = 0

NEUTRON_STATUS_ACTIVE = 'ACTIVE'
NEUTRON_STATUS_BUILD = 'BUILD'
NEUTRON_STATUS_DOWN = 'DOWN'
NEUTRON_STATUS_PENDING_CREATE = 'PENDING_CREATE'
NEUTRON_STATUS_PENDING_UPDATE = 'PENDING_UPDATE'
NEUTRON_STATUS_PENDING_DELETE = 'PENDING_DELETE'
NEUTRON_STATUS_ERROR = 'ERROR'
NEUTRON_STATUS_UNBOUND = 'UNBOUND'
NEUTRON_STATUS_PENDING = [NEUTRON_STATUS_PENDING_CREATE,
                          NEUTRON_STATUS_PENDING_UPDATE,
                          NEUTRON_STATUS_PENDING_DELETE]
AC_REQUEST_ERROR_STATUS = [NEUTRON_STATUS_ERROR]


REPORT_STATUS_INTERVAL_TIME = 1
REPORT_STATUS_RETRY_TIMES = 60

NORMAL_SYNC_THREAD_WAIT = 5.0
NORMAL_SYNC_DEPENDENCY_WAITING_TIME = 60 * 4
FAILED_RESOURCE_SYNC_THREAD_WAIT = 20.0
GET_SERVER_CERTIFICATE_TIME = 20

MAX_SUBPORT_UPDATE_THREADS = 16

PORT_MIGRATE_CONTROLLER_TIMEOUT = 55
CHECK_PORT_MIGRATED_INTERVAL = 2

CLOUD_ALARM_SYNC_THREAD_WAIT = 3600.0
CLOUD_BUSINESS_ALARM_ID = '3285005'
CLOUD_CERT_ALMOST_EXPIRED_ALARM_ID = '3285001'
CLOUD_CERT_EXPIRED_ALARM_ID = '3285002'
CLOUD_BUSINESS_ALARM_TYPE = 'event'
CLOUD_CERT_ALARM_TYPE = 'fault'
CLOUD_CERT_RECOVER_ALARM_TYPE = 'recover'
CLOUD_BUSINESS_ALARM_LEVEL = 'warning'
CLOUD_CERT_ALMOST_EXPIRED_ALARM_LEVEL = 'major'
CLOUD_CERT_EXPIRED_ALARM_LEVEL = 'critical'

SUPPORT_CIPHERS = 'DHE-PSK-AES128-GCM-SHA256:DHE-PSK-AES256-GCM-SHA384:' \
                  'DHE-PSK-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:' \
                  'DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:' \
                  'DHE-RSA-AES256-GCM-SHA384:DHE-RSA-CHACHA20-POLY1305:' \
                  'ECDH-ECDSA-AES128-GCM-SHA256:ECDH-ECDSA-AES256-GCM-SHA384:' \
                  'ECDHE-ECDSA-AES128-GCM-SHA256:' \
                  'ECDHE-ECDSA-AES128-GCM-SHA256:' \
                  'ECDHE-ECDSA-AES256-GCM-SHA384:' \
                  'ECDHE-ECDSA-AES256-GCM-SHA384:' \
                  'ECDHE-ECDSA-CHACHA20-POLY1305:' \
                  'ECDHE-PSK-CHACHA20-POLY1305:ECDHE-RSA-AES128-GCM-SHA256:' \
                  'ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:' \
                  'ECDHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-CHACHA20-POLY1305:' \
                  'ECDH-RSA-AES128-GCM-SHA256:ECDH-RSA-AES256-GCM-SHA384:' \
                  'PSK-AES128-GCM-SHA256:PSK-AES256-GCM-SHA384:' \
                  'PSK-CHACHA20-POLY1305:TLS_AES_128_GCM_SHA256:' \
                  'TLS_AES_256_GCM_SHA384:TLS_CHACHA20_POLY1305_SHA256'

NW_HW_COMPLETE = 'complete'
NW_HW_NETWORKS = 'network'
NW_HW_BINDPORTS = 'bindport'
NW_HW_SUBNETS = 'subnet'
NW_HW_PORTS = 'port'
NW_HW_DHCP_PORT = 'dhcp-port'
NW_HW_MIGRATE_PORT = "migrate_port"
NW_HW_UP_PORT = "up_port"
NW_HW_LAST_DHCP_PORT = 'last-dhcp-port'
NW_HW_SNATS = 'snat'
NW_HW_SEC_GRP = 'security-group'
NW_HW_SEC_GRP_RULE = 'security-rule'
NW_HW_ROUTERS = 'router'
NW_HW_ROUTER_IF = 'router_interface'
NW_HW_ROUTER_EXTRA_ATTRIBUTES = 'router_extra_attributes'
NW_HW_FIP = 'floatingip'
NW_HW_FIREWALL = 'firewall'
NW_HW_FIREWALL_POLICY = 'firewall-policy'
NW_HW_FIREWALL_RULE = 'firewall-rule'
NW_HW_INSERT_RULE = 'insert_rule'
NW_HW_REMOVE_RULE = 'remove_rule'
NW_HW_IKE_POLICY = 'ikepolicy'
NW_HW_IKE_POLICIES = 'ike-policies'
NW_HW_IPSEC_POLICY = 'ipsecpolicy'
NW_HW_IPSEC_POLICIES = 'ipsec-policies'
NW_HW_VPN_SERVICE = 'vpnservice'
NW_HW_VPN_SERVICES = 'vpn-services'
NW_HW_IPSEC_SITE_CONNECTION = 'ipsecsiteconnection'
NW_HW_IPSEC_SITE_CONNECTIONS = 'ipsec-site-connections'
NW_HW_EP_GROUPS = 'endpoint-group'
NW_HW_QOS_POLICY = 'qos-policy'
NW_HW_CMCC_QOS_POLICY = 'cmcc-qos-policy'
NW_HW_LOADBALANCER = 'loadbalancer'
NW_HW_LISTENER = 'listener'
NW_HW_POOL = 'pool'
NW_HW_MEMBER = 'member'
NW_HW_HEALTH_MONITOR = 'healthmonitor'
NW_HW_L2BRS = 'l2brs'
NW_HW_L2BR = 'l2br'
NW_HW_EXROUTE = 'exroute'
NW_HW_VPC_CONNECTION = 'vpc-connection'
NW_HW_BGP_ROUTE = 'bgp-route'
NW_HW_POLICY_TRAGET_GROUP = 'policy-target-group'
NW_HW_POLICY_CLASSIFIER = 'policy-classifier'
NW_HW_POLICY_RULE = 'policy-rule'
NW_HW_POLICY_RULE_SET = 'policy-rule-set'
NW_HW_DNAT = 'dnat'
NW_HW_DNATS = 'dnats'
NW_HW_PF = 'portforwarding'
NW_HW_EXTERNAL_SEGMENT = 'external-segment-group'
NW_HW_EXTERNAL_POLICY = 'external-policy-group'
NW_HW_EXTERNAL_WHITELIST = 'external_whitelist'
NW_HW_IPV6_NS_QOS_POLICY = 'ipv6-ns-qos-policy'
NW_HW_SECURITY_GROUP_RULE = 'security-group-rule'

NW_HW_CLOUD_HEART_BEAT = '/cloud/northheartbeat'

NW_HW_CREATE_EXTERNAL_WHITELIST = "create_" + NW_HW_EXTERNAL_WHITELIST
NW_HW_DELETE_EXTERNAL_WHITELIST = "delete_" + NW_HW_EXTERNAL_WHITELIST
NW_HW_UPDATE_EXTERNAL_WHITELIST = "update_" + NW_HW_EXTERNAL_WHITELIST

NW_HW_ADDROUTES_EXTERNAL_WHITELIST = "addroutes_" + NW_HW_EXTERNAL_WHITELIST
NW_HW_REMOVEROUTES_EXTERNAL_WHITELIST = "removeroutes_" + NW_HW_EXTERNAL_WHITELIST
NW_HW_ADDSUBNETS_EXTERNAL_WHITELIST = "addsubnets_" + NW_HW_EXTERNAL_WHITELIST
NW_HW_REMOVESUBNETS_EXTERNAL_WHITELIST = "removesubnets_" + NW_HW_EXTERNAL_WHITELIST

NW_HW_TAP_SERVICE = 'tap-service'
NW_HW_TAP_FLOW = 'tap-flow'
NW_HW_FLOW_MIRROR = 'flow-mirror'

NW_HW_CREATE_TAP_SERVICE = "create_" + NW_HW_TAP_SERVICE
NW_HW_DELETE_TAP_SERVICE = "delete_" + NW_HW_TAP_SERVICE
NW_HW_UPDATE_TAP_SERVICE = "update_" + NW_HW_TAP_SERVICE

NW_HW_CREATE_TAP_FLOW = "create_" + NW_HW_TAP_FLOW
NW_HW_DELETE_TAP_FLOW = "delete_" + NW_HW_TAP_FLOW
NW_HW_UPDATE_TAP_FLOW = "update_" + NW_HW_TAP_FLOW

NW_HW_CREATE_NETWORK = "create_" + NW_HW_NETWORKS
NW_HW_DELETE_NETWORK = "delete_" + NW_HW_NETWORKS
NW_HW_UPDATE_NETWORK = "update_" + NW_HW_NETWORKS
NW_HW_GET_NETWORK = 'get_' + NW_HW_NETWORKS

NW_HW_CREATE_SUBNET = "create_" + NW_HW_SUBNETS
NW_HW_DELETE_SUBNET = "delete_" + NW_HW_SUBNETS
NW_HW_UPDATE_SUBNET = "update_" + NW_HW_SUBNETS

NW_HW_CREATE_PORT = "create_" + NW_HW_PORTS
NW_HW_DELETE_PORT = "delete_" + NW_HW_PORTS
NW_HW_UPDATE_PORT = "update_" + NW_HW_PORTS

NW_HW_CREATE_ROUTER_IF = "create_" + NW_HW_ROUTER_IF
NW_HW_DELETE_ROUTER_IF = "delete_" + NW_HW_ROUTER_IF
NW_HW_UPDATE_ROUTER_IF = "update_" + NW_HW_ROUTER_IF

NW_HW_CREATE_ROUTER = "create_" + NW_HW_ROUTERS
NW_HW_DELETE_ROUTER = "delete_" + NW_HW_ROUTERS
NW_HW_UPDATE_ROUTER = "update_" + NW_HW_ROUTERS

NW_HW_CREATE_EXROUTE = "create_" + NW_HW_EXROUTE
NW_HW_DELETE_EXROUTE = "delete_" + NW_HW_EXROUTE

NW_HW_CREATE_SNAT = "create_" + NW_HW_SNATS
NW_HW_DELETE_SNAT = "delete_" + NW_HW_SNATS
NW_HW_UPDATE_SNAT = "update_" + NW_HW_SNATS

NW_HW_CREATE_FIP = "create_" + NW_HW_FIP
NW_HW_DELETE_FIP = "delete_" + NW_HW_FIP
NW_HW_UPDATE_FIP = "update_" + NW_HW_FIP

NW_HW_CREATE_QOS_POLICY = "create_" + NW_HW_QOS_POLICY
NW_HW_DELETE_QOS_POLICY = "delete_" + NW_HW_QOS_POLICY
NW_HW_UPDATE_QOS_POLICY = "update_" + NW_HW_QOS_POLICY

NW_HW_CREATE_IPV6_NS_QOS_POLICY = "create_" + NW_HW_IPV6_NS_QOS_POLICY
NW_HW_DELETE_IPV6_NS_QOS_POLICY = "delete_" + NW_HW_IPV6_NS_QOS_POLICY
NW_HW_UPDATE_IPV6_NS_QOS_POLICY = "update_" + NW_HW_IPV6_NS_QOS_POLICY

NW_HW_CREATE_SEC_GRP = "create_" + NW_HW_SEC_GRP
NW_HW_DELETE_SEC_GRP = "delete_" + NW_HW_SEC_GRP
NW_HW_UPDATE_SEC_GRP = "update_" + NW_HW_SEC_GRP

NW_HW_CREATE_SEC_GRP_RULE = "create_" + NW_HW_SEC_GRP_RULE
NW_HW_DELETE_SEC_GRP_RULE = "delete_" + NW_HW_SEC_GRP_RULE

NW_HW_CREATE_IKEPOLICY = "create_" + NW_HW_IKE_POLICY
NW_HW_DELETE_IKEPOLICY = "delete_" + NW_HW_IKE_POLICY
NW_HW_UPDATE_IKEPOLICY = "update_" + NW_HW_IKE_POLICY

NW_HW_CREATE_IPSECPOLICY = "create_" + NW_HW_IPSEC_POLICY
NW_HW_DELETE_IPSECPOLICY = "delete_" + NW_HW_IPSEC_POLICY
NW_HW_UPDATE_IPSECPOLICY = "update_" + NW_HW_IPSEC_POLICY

NW_HW_CREATE_VPNSERVICE = "create_" + NW_HW_VPN_SERVICE
NW_HW_DELETE_VPNSERVICE = "delete_" + NW_HW_VPN_SERVICE
NW_HW_UPDATE_VPNSERVICE = "update_" + NW_HW_VPN_SERVICE

NW_HW_CREATE_IPSEC_SITE_CONN = "create_" + NW_HW_IPSEC_SITE_CONNECTION
NW_HW_DELETE_IPSEC_SITE_CONN = "delete_" + NW_HW_IPSEC_SITE_CONNECTION
NW_HW_UPDATE_IPSEC_SITE_CONN = "update_" + NW_HW_IPSEC_SITE_CONNECTION

NW_HW_CREATE_EP_GROUP = "create_" + NW_HW_EP_GROUPS
NW_HW_UPDATE_EP_GROUP = "update_" + NW_HW_EP_GROUPS
NW_HW_DELETE_EP_GROUP = "delete_" + NW_HW_EP_GROUPS

NW_HW_CREATE_FIREWALL_RULE = "create_" + NW_HW_FIREWALL_RULE
NW_HW_DELETE_FIREWALL_RULE = "delete_" + NW_HW_FIREWALL_RULE
NW_HW_UPDATE_FIREWALL_RULE = "update_" + NW_HW_FIREWALL_RULE

NW_HW_CREATE_FIREWALL_POLICY = "create_" + NW_HW_FIREWALL_POLICY
NW_HW_DELETE_FIREWALL_POLICY = "delete_" + NW_HW_FIREWALL_POLICY
NW_HW_UPDATE_FIREWALL_POLICY = "update_" + NW_HW_FIREWALL_POLICY

NW_HW_CREATE_FIREWALL = "create_" + NW_HW_FIREWALL
NW_HW_DELETE_FIREWALL = "delete_" + NW_HW_FIREWALL
NW_HW_UPDATE_FIREWALL = "update_" + NW_HW_FIREWALL

NW_HW_INSERT_FIREWALL_RULE = "update_insert_rule"
NW_HW_REMOVE_FIREWALL_RULE = "update_remove_rule"

NW_HW_CREATE_LOADBALANCER = "create_" + NW_HW_LOADBALANCER
NW_HW_DELETE_LOADBALANCER = "delete_" + NW_HW_LOADBALANCER
NW_HW_UPDATE_LOADBALANCER = "update_" + NW_HW_LOADBALANCER

NW_HW_CREATE_LISTENER = "create_" + NW_HW_LISTENER
NW_HW_DELETE_LISTENER = "delete_" + NW_HW_LISTENER
NW_HW_UPDATE_LISTENER = "update_" + NW_HW_LISTENER

NW_HW_CREATE_POOL = "create_" + NW_HW_POOL
NW_HW_DELETE_POOL = "delete_" + NW_HW_POOL
NW_HW_UPDATE_POOL = "update_" + NW_HW_POOL

NW_HW_CREATE_MEMBER = "create_" + NW_HW_MEMBER
NW_HW_DELETE_MEMBER = "delete_" + NW_HW_MEMBER
NW_HW_UPDATE_MEMBER = "update_" + NW_HW_MEMBER

NW_HW_CREATE_HEALTHMONITOR = "create_" + NW_HW_HEALTH_MONITOR
NW_HW_DELETE_HEALTHMONITOR = "delete_" + NW_HW_HEALTH_MONITOR
NW_HW_UPDATE_HEALTHMONITOR = "update_" + NW_HW_HEALTH_MONITOR

NW_HW_CREATE_L2BR = "create_" + NW_HW_L2BR
NW_HW_DELETE_L2BR = "delete_" + NW_HW_L2BR
NW_HW_UPDATE_L2BR = "update_" + NW_HW_L2BR

NW_HW_CREATE_VPC_CONNECTION = "create_" + NW_HW_VPC_CONNECTION
NW_HW_DELETE_VPC_CONNECTION = "delete_" + NW_HW_VPC_CONNECTION
NW_HW_UPDATE_VPC_CONNECTION = "update_" + NW_HW_VPC_CONNECTION

NW_HW_CREATE_BGP_ROUTE = "create_" + NW_HW_BGP_ROUTE
NW_HW_DELETE_BGP_ROUTE = "delete_" + NW_HW_BGP_ROUTE
NW_HW_UPDATE_BGP_ROUTE = "update_" + NW_HW_BGP_ROUTE

NW_HW_CREATE_POLICY_TRAGE_TGROUP = "create_" + NW_HW_POLICY_TRAGET_GROUP
NW_HW_DELETE_POLICY_TRAGE_TGROUP = "delete_" + NW_HW_POLICY_TRAGET_GROUP
NW_HW_UPDATE_POLICY_TRAGE_TGROUP = "update_" + NW_HW_POLICY_TRAGET_GROUP
NW_HW_GET_POLICY_TRAGE_TGROUP = 'get_' + NW_HW_POLICY_TRAGET_GROUP

NW_HW_CREATE_POLICY_CLASSIFIER = "create_" + NW_HW_POLICY_CLASSIFIER
NW_HW_DELETE_POLICY_CLASSIFIER = "delete_" + NW_HW_POLICY_CLASSIFIER
NW_HW_UPDATE_POLICY_CLASSIFIER = "update_" + NW_HW_POLICY_CLASSIFIER
NW_HW_GET_POLICY_CLASSIFIER = 'get_' + NW_HW_POLICY_CLASSIFIER

NW_HW_CREATE_POLICY_RULE = "create_" + NW_HW_POLICY_RULE
NW_HW_DELETE_POLICY_RULE = "delete_" + NW_HW_POLICY_RULE
NW_HW_UPDATE_POLICY_RULE = "update_" + NW_HW_POLICY_RULE
NW_HW_GET_POLICY_RULE = 'get_' + NW_HW_POLICY_RULE

NW_HW_CREATE_POLICY_RULE_SET = "create_" + NW_HW_POLICY_RULE_SET
NW_HW_DELETE_POLICY_RULE_SET = "delete_" + NW_HW_POLICY_RULE_SET
NW_HW_UPDATE_POLICY_RULE_SET = "update_" + NW_HW_POLICY_RULE_SET
NW_HW_GET_POLICY_RULE_SET = 'get_' + NW_HW_POLICY_RULE_SET

NW_HW_CREATE_DNAT = "create_" + NW_HW_DNAT
NW_HW_DELETE_DNAT = "delete_" + NW_HW_DNAT
NW_HW_UPDATE_DNAT = "update_" + NW_HW_DNAT

NW_HW_CREATE_EXTERNAL_SEGMENT = "create_" + NW_HW_EXTERNAL_SEGMENT
NW_HW_DELETE_EXTERNAL_SEGMENT = "delete_" + NW_HW_EXTERNAL_SEGMENT
NW_HW_UPDATE_EXTERNAL_SEGMENT = "update_" + NW_HW_EXTERNAL_SEGMENT
NW_HW_GET_EXTERNAL_SEGMENT = "get_" + NW_HW_EXTERNAL_SEGMENT

NW_HW_CREATE_EXTERNAL_POLICY = "create_" + NW_HW_EXTERNAL_POLICY
NW_HW_DELETE_EXTERNAL_POLICY = "delete_" + NW_HW_EXTERNAL_POLICY
NW_HW_UPDATE_EXTERNAL_POLICY = "update_" + NW_HW_EXTERNAL_POLICY
NW_HW_GET_EXTERNAL_POLICY = "get_" + NW_HW_EXTERNAL_POLICY

# the resource list for having state
RESOURCE_HAVE_STATE = [NW_HW_NETWORKS, NW_HW_PORTS, NW_HW_ROUTERS,
                       NW_HW_FIREWALL, NW_HW_VPN_SERVICE,
                       NW_HW_IPSEC_SITE_CONNECTION, NW_HW_FIP,
                       NW_HW_LOADBALANCER, NW_HW_LISTENER, NW_HW_MEMBER,
                       NW_HW_POOL, NW_HW_HEALTH_MONITOR, NW_HW_L2BR,
                       NW_HW_CREATE_VPC_CONNECTION, NW_HW_DNAT]
LB_RESOURCES = [NW_HW_LOADBALANCER, NW_HW_LISTENER, NW_HW_MEMBER,
                NW_HW_POOL, NW_HW_HEALTH_MONITOR]
RESOURCE_NO_TENANT_NAME = [NW_HW_SEC_GRP, NW_HW_SEC_GRP_RULE, NW_HW_FIP,
                           NW_HW_LOADBALANCER,
                           NW_HW_LISTENER, NW_HW_MEMBER, NW_HW_POOL,
                           NW_HW_HEALTH_MONITOR, NW_HW_VPC_CONNECTION,
                           NW_HW_BGP_ROUTE]

NW_HW_URL = '/restconf/data'
NW_HW_RPC = '/restconf/operations'
NW_HW_OPER_URL = '/restconf/operations'
NW_HW_RESTFUL_V3 = '/controller/dc/v2/neutronapi'
NW_HW_RESTFUL_MIRROR = '/controller/dc/mirror/neutronapi'
NW_HW_CONSIST_QUERY_URL = '%s/huawei-ac-neutron-consist:consist-query' % \
                          NW_HW_OPER_URL
NW_HW_CLOUD_ALARM_URL = '%s/huawei-ac-neutron:neutron-cfg/alarms' % \
                        NW_HW_URL
NW_HW_CLUSTERS_URL = '%s/protection-oper/clusters' % NW_HW_RESTFUL_V3

NW_HW_RESTFUL_FIREWALL_POLICY = '/fw/firewall_policies'
NW_HW_RESTFUL_FLOW_MIRROR = '/v2.0/taas'
NW_HW_QUERY_HOST_URL = '%s/huawei-ac-neutron:neutron-cfg/query-host-status' % \
                       NW_HW_URL

NW_HW_EXROUTE_QUERY_URL = '/restconf/operations/huawei-ac-neutron-exroutes:get-exroute'

NW_HW_L2L3_RESOURCES = [
    NW_HW_NETWORKS,
    NW_HW_SUBNETS,
    NW_HW_PORTS,
    NW_HW_ROUTERS,
    NW_HW_FIP,
    NW_HW_SEC_GRP]

NW_HW_REPORT_STATUS_RESOURCES = [
    NW_HW_PORTS,
    NW_HW_ROUTERS,
    NW_HW_FIP,
    NW_HW_FIREWALL,
    NW_HW_VPN_SERVICE,
    NW_HW_IPSEC_SITE_CONNECTION,
    NW_HW_LOADBALANCER,
    NW_HW_POOL,
    NW_HW_LISTENER,
    NW_HW_MEMBER,
    NW_HW_HEALTH_MONITOR,
    NW_HW_L2BR]

NW_HW_NEUTRON_RESOURCES = {
    NW_HW_CREATE_NETWORK: {'rsrc': NW_HW_NETWORKS,
                           'method': 'POST',
                           'needSvcNameUpdate': True},
    NW_HW_DELETE_NETWORK: {'rsrc': NW_HW_NETWORKS,
                           'method': 'DELETE',
                           'needSvcNameUpdate': False},
    NW_HW_UPDATE_NETWORK: {'rsrc': NW_HW_NETWORKS,
                           'method': 'PUT',
                           'needSvcNameUpdate': False},
    NW_HW_GET_NETWORK: {'rsrc': NW_HW_NETWORKS,
                        'method': 'GET',
                        'needSvcNameUpdate': False},
    NW_HW_CREATE_SUBNET: {'rsrc': NW_HW_SUBNETS,
                          'method': 'POST',
                          'needSvcNameUpdate': True},
    NW_HW_DELETE_SUBNET: {'rsrc': NW_HW_SUBNETS,
                          'method': 'DELETE',
                          'needSvcNameUpdate': False},
    NW_HW_UPDATE_SUBNET: {'rsrc': NW_HW_SUBNETS,
                          'method': 'PUT',
                          'needSvcNameUpdate': False},
    NW_HW_CREATE_PORT: {'rsrc': NW_HW_PORTS,
                        'method': 'POST',
                        'needSvcNameUpdate': True},
    NW_HW_DELETE_PORT: {'rsrc': NW_HW_PORTS,
                        'method': 'DELETE',
                        'needSvcNameUpdate': False},
    NW_HW_UPDATE_PORT: {'rsrc': NW_HW_PORTS,
                        'method': 'PUT',
                        'needSvcNameUpdate': False},
    NW_HW_CREATE_ROUTER_IF: {'rsrc': NW_HW_PORTS,
                             'method': 'POST',
                             'needSvcNameUpdate': True},
    NW_HW_DELETE_ROUTER_IF: {'rsrc': NW_HW_PORTS,
                             'method': 'DELETE',
                             'needSvcNameUpdate': False},
    NW_HW_UPDATE_ROUTER_IF: {'rsrc': NW_HW_PORTS,
                             'method': 'PUT',
                             'needSvcNameUpdate': False},
    NW_HW_CREATE_SEC_GRP: {'rsrc': NW_HW_SEC_GRP,
                           'method': 'POST',
                           'needSvcNameUpdate': False},
    NW_HW_DELETE_SEC_GRP: {'rsrc': NW_HW_SEC_GRP,
                           'method': 'DELETE',
                           'needSvcNameUpdate': False},
    NW_HW_UPDATE_SEC_GRP: {'rsrc': NW_HW_SEC_GRP,
                           'method': 'PUT',
                           'needSvcNameUpdate': False},
    NW_HW_CREATE_SEC_GRP_RULE: {'rsrc': NW_HW_SEC_GRP_RULE,
                                'method': 'POST',
                                'needSvcNameUpdate': False},
    NW_HW_DELETE_SEC_GRP_RULE: {'rsrc': NW_HW_SEC_GRP_RULE,
                                'method': 'DELETE',
                                'needSvcNameUpdate': False},
    NW_HW_CREATE_VPC_CONNECTION: {'rsrc': NW_HW_VPC_CONNECTION,
                                  'method': 'POST',
                                  'needSvcNameUpdate': False},
    NW_HW_DELETE_VPC_CONNECTION: {'rsrc': NW_HW_VPC_CONNECTION,
                                  'method': 'DELETE',
                                  'needSvcNameUpdate': False},
    NW_HW_UPDATE_VPC_CONNECTION: {'rsrc': NW_HW_VPC_CONNECTION,
                                  'method': 'PUT',
                                  'needSvcNameUpdate': False},
    NW_HW_CREATE_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                      'method': 'POST',
                                      'needSvcNameUpdate': False},
    NW_HW_DELETE_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                      'method': 'DELETE',
                                      'needSvcNameUpdate': False},
    NW_HW_UPDATE_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                      'method': 'PUT',
                                      'needSvcNameUpdate': False},
    NW_HW_ADDROUTES_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                         'method': 'PUT',
                                         'needSvcNameUpdate': False},
    NW_HW_REMOVEROUTES_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                            'method': 'PUT',
                                            'needSvcNameUpdate': False},
    NW_HW_ADDSUBNETS_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                          'method': 'PUT',
                                          'needSvcNameUpdate': False},
    NW_HW_REMOVESUBNETS_EXTERNAL_WHITELIST: {'rsrc': NW_HW_EXTERNAL_WHITELIST,
                                             'method': 'PUT',
                                             'needSvcNameUpdate': False},
    NW_HW_CREATE_EXROUTE: {'rsrc': NW_HW_EXROUTE,
                           'method': 'POST',
                           'needSvcNameUpdate': False},
    NW_HW_DELETE_EXROUTE: {'rsrc': NW_HW_EXROUTE,
                           'method': 'POST',
                           'needSvcNameUpdate': False},
    NW_HW_CREATE_ROUTER: {'rsrc': NW_HW_ROUTERS,
                          'method': 'POST',
                          'needSvcNameUpdate': False},
    NW_HW_DELETE_ROUTER: {'rsrc': NW_HW_ROUTERS,
                          'method': 'DELETE',
                          'needSvcNameUpdate': False},
    NW_HW_UPDATE_ROUTER: {'rsrc': NW_HW_ROUTERS,
                          'method': 'PUT',
                          'needSvcNameUpdate': False},
    NW_HW_CREATE_SNAT: {'rsrc': NW_HW_SNATS,
                        'method': 'POST',
                        'needSvcNameUpdate': False},
    NW_HW_DELETE_SNAT: {'rsrc': NW_HW_SNATS,
                        'method': 'DELETE',
                        'needSvcNameUpdate': False},
    NW_HW_UPDATE_SNAT: {'rsrc': NW_HW_SNATS,
                        'method': 'PUT',
                        'needSvcNameUpdate': False},
    NW_HW_CREATE_FIP: {'rsrc': NW_HW_FIP,
                       'method': 'POST',
                       'needSvcNameUpdate': False},
    NW_HW_DELETE_FIP: {'rsrc': NW_HW_FIP,
                       'method': 'DELETE',
                       'needSvcNameUpdate': False},
    NW_HW_UPDATE_FIP: {'rsrc': NW_HW_FIP,
                       'method': 'PUT',
                       'needSvcNameUpdate': False},
    NW_HW_CREATE_IKEPOLICY: {'rsrc': NW_HW_IKE_POLICY,
                             'method': 'POST',
                             'needSvcNameUpdate': False},
    NW_HW_DELETE_IKEPOLICY: {'rsrc': NW_HW_IKE_POLICY,
                             'method': 'DELETE',
                             'needSvcNameUpdate': False},
    NW_HW_UPDATE_IKEPOLICY: {'rsrc': NW_HW_IKE_POLICY,
                             'method': 'PUT',
                             'needSvcNameUpdate': False},
    NW_HW_CREATE_IPSECPOLICY: {'rsrc': NW_HW_IPSEC_POLICY,
                               'method': 'POST',
                               'needSvcNameUpdate': False},
    NW_HW_DELETE_IPSECPOLICY: {'rsrc': NW_HW_IPSEC_POLICY,
                               'method': 'DELETE',
                               'needSvcNameUpdate': False},
    NW_HW_UPDATE_IPSECPOLICY: {'rsrc': NW_HW_IPSEC_POLICY,
                               'method': 'PUT',
                               'needSvcNameUpdate': False},
    NW_HW_CREATE_VPNSERVICE: {'rsrc': NW_HW_VPN_SERVICE,
                              'method': 'POST',
                              'needSvcNameUpdate': False},
    NW_HW_DELETE_VPNSERVICE: {'rsrc': NW_HW_VPN_SERVICE,
                              'method': 'DELETE',
                              'needSvcNameUpdate': False},
    NW_HW_UPDATE_VPNSERVICE: {'rsrc': NW_HW_VPN_SERVICE,
                              'method': 'PUT',
                              'needSvcNameUpdate': False},
    NW_HW_CREATE_EP_GROUP: {'rsrc': NW_HW_EP_GROUPS,
                            'method': 'POST',
                            'needSvcNameUpdate': False},
    NW_HW_UPDATE_EP_GROUP: {'rsrc': NW_HW_EP_GROUPS,
                            'method': 'PUT',
                            'needSvcNameUpdate': False},
    NW_HW_DELETE_EP_GROUP: {'rsrc': NW_HW_EP_GROUPS,
                            'method': 'DELETE',
                            'needSvcNameUpdate': False},
    NW_HW_CREATE_FIREWALL: {'rsrc': NW_HW_FIREWALL,
                            'method': 'POST',
                            'needSvcNameUpdate': False},
    NW_HW_DELETE_FIREWALL: {'rsrc': NW_HW_FIREWALL,
                            'method': 'DELETE',
                            'needSvcNameUpdate': False},
    NW_HW_UPDATE_FIREWALL: {'rsrc': NW_HW_FIREWALL,
                            'method': 'PUT',
                            'needSvcNameUpdate': False},
    NW_HW_CREATE_FIREWALL_POLICY: {'rsrc': NW_HW_FIREWALL_POLICY,
                                   'method': 'POST',
                                   'needSvcNameUpdate': False},
    NW_HW_DELETE_FIREWALL_POLICY: {'rsrc': NW_HW_FIREWALL_POLICY,
                                   'method': 'DELETE',
                                   'needSvcNameUpdate': False},
    NW_HW_UPDATE_FIREWALL_POLICY: {'rsrc': NW_HW_FIREWALL_POLICY,
                                   'method': 'PUT',
                                   'needSvcNameUpdate': False},
    NW_HW_CREATE_FIREWALL_RULE: {'rsrc': NW_HW_FIREWALL_RULE,
                                 'method': 'POST',
                                 'needSvcNameUpdate': False},
    NW_HW_DELETE_FIREWALL_RULE: {'rsrc': NW_HW_FIREWALL_RULE,
                                 'method': 'DELETE',
                                 'needSvcNameUpdate': False},
    NW_HW_UPDATE_FIREWALL_RULE: {'rsrc': NW_HW_FIREWALL_RULE,
                                 'method': 'PUT',
                                 'needSvcNameUpdate': False},
    NW_HW_INSERT_FIREWALL_RULE: {'rsrc': NW_HW_INSERT_RULE,
                                 'method': 'PUT',
                                 'needSvcNameUpdate': False},
    NW_HW_REMOVE_FIREWALL_RULE: {'rsrc': NW_HW_REMOVE_RULE,
                                 'method': 'PUT',
                                 'needSvcNameUpdate': False},
    NW_HW_CREATE_IPSEC_SITE_CONN: {'rsrc': NW_HW_IPSEC_SITE_CONNECTION,
                                   'method': 'POST',
                                   'needSvcNameUpdate': False},
    NW_HW_DELETE_IPSEC_SITE_CONN: {'rsrc': NW_HW_IPSEC_SITE_CONNECTION,
                                   'method': 'DELETE',
                                   'needSvcNameUpdate': False},
    NW_HW_UPDATE_IPSEC_SITE_CONN: {'rsrc': NW_HW_IPSEC_SITE_CONNECTION,
                                   'method': 'PUT',
                                   'needSvcNameUpdate': False},
    NW_HW_CREATE_QOS_POLICY: {'rsrc': NW_HW_QOS_POLICY,
                              'method': 'POST',
                              'needSvcNameUpdate': False},
    NW_HW_UPDATE_QOS_POLICY: {'rsrc': NW_HW_QOS_POLICY,
                              'method': 'PUT',
                              'needSvcNameUpdate': False},
    NW_HW_DELETE_QOS_POLICY: {'rsrc': NW_HW_QOS_POLICY,
                              'method': 'DELETE',
                              'needSvcNameUpdate': False},
    NW_HW_CREATE_IPV6_NS_QOS_POLICY: {'rsrc': NW_HW_IPV6_NS_QOS_POLICY,
                                      'method': 'POST',
                                      'needSvcNameUpdate': False},
    NW_HW_UPDATE_IPV6_NS_QOS_POLICY: {'rsrc': NW_HW_IPV6_NS_QOS_POLICY,
                                      'method': 'PUT',
                                      'needSvcNameUpdate': False},
    NW_HW_DELETE_IPV6_NS_QOS_POLICY: {'rsrc': NW_HW_IPV6_NS_QOS_POLICY,
                                      'method': 'DELETE',
                                      'needSvcNameUpdate': False},
    NW_HW_CREATE_LOADBALANCER: {'rsrc': NW_HW_LOADBALANCER,
                                'method': 'POST',
                                'needSvcNameUpdate': False},
    NW_HW_DELETE_LOADBALANCER: {'rsrc': NW_HW_LOADBALANCER,
                                'method': 'DELETE',
                                'needSvcNameUpdate': False},
    NW_HW_UPDATE_LOADBALANCER: {'rsrc': NW_HW_LOADBALANCER,
                                'method': 'PUT',
                                'needSvcNameUpdate': False},
    NW_HW_CREATE_LISTENER: {'rsrc': NW_HW_LISTENER,
                            'method': 'POST',
                            'needSvcNameUpdate': False},
    NW_HW_DELETE_LISTENER: {'rsrc': NW_HW_LISTENER,
                            'method': 'DELETE',
                            'needSvcNameUpdate': False},
    NW_HW_UPDATE_LISTENER: {'rsrc': NW_HW_LISTENER,
                            'method': 'PUT',
                            'needSvcNameUpdate': False},
    NW_HW_CREATE_POOL: {'rsrc': NW_HW_POOL,
                        'method': 'POST',
                        'needSvcNameUpdate': False},
    NW_HW_DELETE_POOL: {'rsrc': NW_HW_POOL,
                        'method': 'DELETE',
                        'needSvcNameUpdate': False},
    NW_HW_UPDATE_POOL: {'rsrc': NW_HW_POOL,
                        'method': 'PUT',
                        'needSvcNameUpdate': False},
    NW_HW_CREATE_MEMBER: {'rsrc': NW_HW_MEMBER,
                          'method': 'POST',
                          'needSvcNameUpdate': False},
    NW_HW_DELETE_MEMBER: {'rsrc': NW_HW_MEMBER,
                          'method': 'DELETE',
                          'needSvcNameUpdate': False},
    NW_HW_UPDATE_MEMBER: {'rsrc': NW_HW_MEMBER,
                          'method': 'PUT',
                          'needSvcNameUpdate': False},
    NW_HW_CREATE_HEALTHMONITOR: {'rsrc': NW_HW_HEALTH_MONITOR,
                                 'method': 'POST',
                                 'needSvcNameUpdate': False},
    NW_HW_DELETE_HEALTHMONITOR: {'rsrc': NW_HW_HEALTH_MONITOR,
                                 'method': 'DELETE',
                                 'needSvcNameUpdate': False},
    NW_HW_UPDATE_HEALTHMONITOR: {'rsrc': NW_HW_HEALTH_MONITOR,
                                 'method': 'PUT',
                                 'needSvcNameUpdate': False},
    NW_HW_CREATE_L2BR: {'rsrc': NW_HW_L2BR,
                        'method': 'POST',
                        'needSvcNameUpdate': True},
    NW_HW_DELETE_L2BR: {'rsrc': NW_HW_L2BR,
                        'method': 'DELETE',
                        'needSvcNameUpdate': False},
    NW_HW_UPDATE_L2BR: {'rsrc': NW_HW_L2BR,
                        'method': 'PUT',
                        'needSvcNameUpdate': False},
    NW_HW_CREATE_BGP_ROUTE: {'rsrc': NW_HW_BGP_ROUTE,
                             'method': 'POST',
                             'needSvcNameUpdate': False},
    NW_HW_DELETE_BGP_ROUTE: {'rsrc': NW_HW_BGP_ROUTE,
                             'method': 'DELETE',
                             'needSvcNameUpdate': False},
    NW_HW_UPDATE_BGP_ROUTE: {'rsrc': NW_HW_BGP_ROUTE,
                             'method': 'PUT',
                             'needSvcNameUpdate': False},

    NW_HW_CREATE_POLICY_TRAGE_TGROUP: {'rsrc': NW_HW_POLICY_TRAGET_GROUP,
                                       'method': 'POST',
                                       'needSvcNameUpdate': True},
    NW_HW_DELETE_POLICY_TRAGE_TGROUP: {'rsrc': NW_HW_POLICY_TRAGET_GROUP,
                                       'method': 'DELETE',
                                       'needSvcNameUpdate': False},
    NW_HW_UPDATE_POLICY_TRAGE_TGROUP: {'rsrc': NW_HW_POLICY_TRAGET_GROUP,
                                       'method': 'PUT',
                                       'needSvcNameUpdate': False},

    NW_HW_CREATE_POLICY_CLASSIFIER: {'rsrc': NW_HW_POLICY_CLASSIFIER,
                                     'method': 'POST',
                                     'needSvcNameUpdate': True},
    NW_HW_DELETE_POLICY_CLASSIFIER: {'rsrc': NW_HW_POLICY_CLASSIFIER,
                                     'method': 'DELETE',
                                     'needSvcNameUpdate': False},
    NW_HW_UPDATE_POLICY_CLASSIFIER: {'rsrc': NW_HW_POLICY_CLASSIFIER,
                                     'method': 'PUT',
                                     'needSvcNameUpdate': False},

    NW_HW_CREATE_POLICY_RULE: {'rsrc': NW_HW_POLICY_RULE,
                               'method': 'POST',
                               'needSvcNameUpdate': True},
    NW_HW_DELETE_POLICY_RULE: {'rsrc': NW_HW_POLICY_RULE,
                               'method': 'DELETE',
                               'needSvcNameUpdate': False},
    NW_HW_UPDATE_POLICY_RULE: {'rsrc': NW_HW_POLICY_RULE,
                               'method': 'PUT',
                               'needSvcNameUpdate': False},

    NW_HW_CREATE_POLICY_RULE_SET: {'rsrc': NW_HW_POLICY_RULE_SET,
                                   'method': 'POST',
                                   'needSvcNameUpdate': True},
    NW_HW_UPDATE_POLICY_RULE_SET: {'rsrc': NW_HW_POLICY_RULE_SET,
                                   'method': 'PUT',
                                   'needSvcNameUpdate': False},
    NW_HW_DELETE_POLICY_RULE_SET: {'rsrc': NW_HW_POLICY_RULE_SET,
                                   'method': 'DELETE',
                                   'needSvcNameUpdate': False},

    NW_HW_CREATE_EXTERNAL_SEGMENT: {'rsrc': NW_HW_EXTERNAL_SEGMENT,
                                    'method': 'POST',
                                    'needSvcNameUpdate': True},
    NW_HW_UPDATE_EXTERNAL_SEGMENT: {'rsrc': NW_HW_EXTERNAL_SEGMENT,
                                    'method': 'PUT',
                                    'needSvcNameUpdate': False},
    NW_HW_DELETE_EXTERNAL_SEGMENT: {'rsrc': NW_HW_EXTERNAL_SEGMENT,
                                    'method': 'DELETE',
                                    'needSvcNameUpdate': False},

    NW_HW_CREATE_EXTERNAL_POLICY: {'rsrc': NW_HW_EXTERNAL_POLICY,
                                   'method': 'POST',
                                   'needSvcNameUpdate': True},
    NW_HW_UPDATE_EXTERNAL_POLICY: {'rsrc': NW_HW_EXTERNAL_POLICY,
                                   'method': 'PUT',
                                   'needSvcNameUpdate': False},
    NW_HW_DELETE_EXTERNAL_POLICY: {'rsrc': NW_HW_EXTERNAL_POLICY,
                                   'method': 'DELETE',
                                   'needSvcNameUpdate': False},

    NW_HW_CREATE_TAP_SERVICE: {'rsrc': NW_HW_TAP_SERVICE,
                               'method': 'POST',
                               'needSvcNameUpdate': True},
    NW_HW_DELETE_TAP_SERVICE: {'rsrc': NW_HW_TAP_SERVICE,
                               'method': 'DELETE',
                               'needSvcNameUpdate': False},
    NW_HW_UPDATE_TAP_SERVICE: {'rsrc': NW_HW_TAP_SERVICE,
                               'method': 'PUT',
                               'needSvcNameUpdate': False},

    NW_HW_CREATE_TAP_FLOW: {'rsrc': NW_HW_TAP_FLOW,
                            'method': 'POST',
                            'needSvcNameUpdate': True},
    NW_HW_DELETE_TAP_FLOW: {'rsrc': NW_HW_TAP_FLOW,
                            'method': 'DELETE',
                            'needSvcNameUpdate': False},
    NW_HW_UPDATE_TAP_FLOW: {'rsrc': NW_HW_TAP_FLOW,
                               'method': 'PUT',
                               'needSvcNameUpdate': False},

    NW_HW_CREATE_DNAT: {'rsrc': NW_HW_DNAT,
                        'method': 'POST',
                        'needSvcNameUpdate': True},
    NW_HW_DELETE_DNAT: {'rsrc': NW_HW_DNAT,
                        'method': 'DELETE',
                        'needSvcNameUpdate': True},
    NW_HW_UPDATE_DNAT: {'rsrc': NW_HW_DNAT,
                        'method': 'PUT',
                        'needSvcNameUpdate': True},
}

NEUTRON_RESOURCES_YANG = {
    NW_HW_NETWORKS: {
        'container_name': 'networks',
        'list_name': 'network',
        'module_name': 'huawei-ac-neutron-networks'},
    NW_HW_SUBNETS: {
        'container_name': 'subnets',
        'list_name': 'subnet',
        'module_name': 'huawei-ac-neutron-subnets'},
    NW_HW_PORTS: {
        'container_name': 'ports',
        'list_name': 'port',
        'module_name': 'huawei-ac-neutron-ports'},
    NW_HW_ROUTERS: {
        'container_name': 'routers',
        'list_name': 'router',
        'module_name': 'huawei-ac-neutron-l3-routers'},
    NW_HW_ROUTER_IF: {
        'container_name': 'router-ifs',
        'list_name': 'router-if',
        'module_name': 'huawei-ac-neutron-router-ifs'},
    NW_HW_SNATS: {
        'container_name': 'snats',
        'list_name': 'snat',
        'module_name': 'huawei-ac-neutron-snats'},
    NW_HW_FIP: {
        'container_name': 'floatingips',
        'list_name': 'floatingip',
        'module_name': 'huawei-ac-neutron-l3-floatingips'},
    NW_HW_VPN_SERVICE: {
        'container_name': 'vpn-services',
        'list_name': 'vpnservice',
        'module_name': 'huawei-ac-neutron-vpnaas-vpn-services'},
    NW_HW_FIREWALL: {
        'container_name': 'firewalls',
        'list_name': 'firewall',
        'module_name': 'huawei-ac-neutron-fwaas-firewalls'},
    NW_HW_FIREWALL_POLICY: {
        'container_name': 'firewall-policies',
        'list_name': 'firewall-policy',
        'module_name': 'huawei-ac-neutron-fwaas-firewall-policies'},
    NW_HW_FIREWALL_RULE: {
        'container_name': 'firewall-rules',
        'list_name': 'firewall-rule',
        'module_name': 'huawei-ac-neutron-fwaas-firewall-rules'},
    NW_HW_INSERT_RULE: {
        'container_name': 'insert-rules',
        'list_name': 'insert-rule',
        'module_name': ''},
    NW_HW_REMOVE_RULE: {
        'container_name': 'remove-rules',
        'list_name': 'remove-rule',
        'module_name': ''},
    NW_HW_IKE_POLICY: {
        'container_name': 'ike-policies',
        'list_name': 'ikepolicy',
        'module_name': 'huawei-ac-neutron-vpnaas-ike-policies'},
    NW_HW_IPSEC_POLICY: {
        'container_name': 'ipsec-policies',
        'list_name': 'ipsecpolicy',
        'module_name': 'huawei-ac-neutron-vpnaas-ipsec-policies'},
    NW_HW_IPSEC_SITE_CONNECTION: {
        'container_name': 'ipsec-site-connections',
        'list_name': 'ipsecsiteconnection',
        'module_name': 'huawei-ac-neutron-vpnaas-ipsec-site-connections'},
    NW_HW_EP_GROUPS: {
        'container_name': 'endpoint-groups',
        'list_name': 'endpoint-group',
        'module_name': 'huawei-ac-neutron-vpnaas-endpoint-groups'},
    NW_HW_QOS_POLICY: {
        'container_name': 'qos-policies',
        'list_name': 'qos-policy',
        'module_name': 'huawei-ac-neutron-qos-polices'},
    NW_HW_SEC_GRP: {
        'container_name': 'security-groups',
        'list_name': 'security-group',
        'module_name': 'huawei-ac-neutron-secgroups-security-groups'},
    NW_HW_SEC_GRP_RULE: {
        'container_name': 'security-rules',
        'list_name': 'security-rule',
        'module_name': 'huawei-ac-neutron-secgroups-security-rules'},
    NW_HW_LOADBALANCER: {
        'container_name': 'loadbalancers',
        'list_name': 'loadbalancer',
        'module_name': 'huawei-ac-neutron-lbaas-loadbalancers'},
    NW_HW_LISTENER: {
        'container_name': 'listeners',
        'list_name': 'listener',
        'module_name': 'huawei-ac-neutron-lbaas-listeners'},
    NW_HW_POOL: {
        'container_name': 'pools',
        'list_name': 'pool',
        'module_name': 'huawei-ac-neutron-lbaas-pools'},
    NW_HW_MEMBER: {
        'container_name': 'members',
        'list_name': 'member',
        'module_name': 'huawei-ac-neutron-lbaas-pool-members'},
    NW_HW_HEALTH_MONITOR: {
        'container_name': 'healthmonitors',
        'list_name': 'healthmonitor',
        'module_name': 'huawei-ac-neutron-lbaas-healthmonitors'},
    NW_HW_L2BR: {'container_name': 'l2brs',
                 'list_name': 'l2br',
                 'module_name': 'huawei-ac-neutron-l2brs'},
    NW_HW_EXROUTE: {'container_name': 'exroutes',
                    'list_name': 'exroute',
                    'module_name': 'huawei-ac-neutron-exroutes'},
    NW_HW_VPC_CONNECTION: {
        'container_name': 'vpc-connections',
        'list_name': 'vpc-connection',
        'module_name': 'huawei-ac-neutron-vpc-connections'},
    NW_HW_BGP_ROUTE: {
        'container_name': 'bgp-routes',
        'list_name': 'bgp-route',
        'module_name': 'huawei-ac-neutron-bgp-routes'},
    NW_HW_POLICY_CLASSIFIER: {
        'container_name': 'policy-classifiers',
        'list_name': 'policy-classifier',
        'module_name': 'huawei-ac-neutron-policy-classifiers'},
    NW_HW_POLICY_TRAGET_GROUP: {
        'container_name': 'policy-target-groups',
        'list_name': 'policy-target-group',
        'module_name': 'huawei-ac-neutron-policy-target-groups'},
    NW_HW_POLICY_RULE: {
        'container_name': 'policy-rules',
        'list_name': 'policy-rule',
        'module_name': 'huawei-ac-neutron-policy-rules'},
    NW_HW_POLICY_RULE_SET: {
        'container_name': 'policy-rule-sets',
        'list_name': 'policy-rule-set',
        'module_name': 'huawei-ac-neutron-policy-rule-sets'},
    NW_HW_BINDPORTS: {
        'container_name': 'bind-ports',
        'list_name': 'bind-port',
        'module_name': 'huawei-ac-neutron-bind-ports'},
    NW_HW_DNAT: {
        'container_name': 'dnats',
        'list_name': 'dnat',
        'module_name': 'huawei-ac-neutron-l3-dnats'},
    NW_HW_PF: {
        'container_name': 'dnats',
        'list_name': 'dnat',
        'module_name': 'huawei-ac-neutron-l3-dnats'},
    NW_HW_EXTERNAL_SEGMENT: {
        'container_name': 'external-segment-groups',
        'list_name': 'external-segment-group',
        'module_name': 'huawei-ac-neutron-external-segment-groups'},
    NW_HW_EXTERNAL_POLICY: {
        'container_name': 'external-policy-groups',
        'list_name': 'external-policy-group',
        'module_name': 'huawei-ac-neutron-external-policy-groups'},
    NW_HW_EXTERNAL_WHITELIST: {
        'container_name': 'external_whitelist',
        'list_name': 'external_whitelist',
        'module_name': 'external_whitelist'},
    NW_HW_TAP_SERVICE: {
        'container_name': 'tap-services',
        'list_name': 'tap_service',
        'module_name': 'huawei-ac-neutron-tap-services'},
    NW_HW_TAP_FLOW: {
        'container_name': 'tap-flows',
        'list_name': 'tap_flow',
        'module_name': 'huawei-ac-neutron-tap-flows'},
    NW_HW_IPV6_NS_QOS_POLICY: {
        'container_name': 'ipv6-ns-qos-policies',
        'list_name': 'ipv6-ns-qos-policy',
        'module_name': 'huawei-ac-neutron-ipv6-ns-qos-policies'},
}


NW_HW_L3_DESCRIPTION = 'Huawei L3 Router Service Plugin for basic L3 ' \
                       'forwarding between (L2) Neutron networks and ' \
                       'access to external networks via a NAT gateway.'

# Rest Request timeout increase value
REST_TIMEOUT_INCREASE = 0.25

# 2017.8.24 1) decrease 5s, for softcom project, use neutron api
# timeout is 120s
REQUEST_TIMEOUT_DECREASE = 5

# AC return especial error code when have data consistency problem.
# All characters should be in lower-format.
DATA_CONSISTENCY_ERROR_CODE = ['0x006e000d', '0x00320006']
ALREADY_IN_SYNC_ERROR_CODE = '0x006e000e'
AC_OFF_LINE = '0x00320b16'

# AC auth base url
AUTH_BASE_URL = "/controller/v2/tokens"

# HTTP header
HTTP_HEADER = 'http://'

# HTTPS header
HTTPS_HEADER = 'https://'

# Keystone version suffix
KEYSTONE_VERSION_SUFFIX = '/v2.0'

# Bind port rpc url suffix
BIND_PORT_SUFFIX = \
    '/restconf/operations/huawei-ac-neutron-bind-port-level:get-local-vlan'

# ExRoutes local vtep ip suffix
VTEP_IP_SUFFIX = \
    '/restconf/operations/huawei-ac-neutron-exroutes:get-local-vtepip'

# ExRoutes RPC input container
EXROUTES_INPUT = 'huawei-ac-neutron-exroutes:input'

# ExRoutes RPC output container
EXROUTES_OUTPUT = 'huawei-ac-neutron-exroutes:output'

# Add ExRoutes restconf url
ADD_EXROUTES_URL = NW_HW_RPC + '/huawei-ac-neutron-exroutes:add-exroute'

# Remove ExRoutes restconf url
REMOVE_EXROUTES_URL = NW_HW_RPC + '/huawei-ac-neutron-exroutes:remove-exroute'

EXTERNAL_WHITELIST_URL = "/controller/dc/v3/logicnetwork/external_whitelists"
EXTERNAL_GATEWAYS_URL = "/controller/dc/v3/publicservice/external-gateways"
EXTERNAL_WHITELIST_URL_SUFFIX = {"addroutes": "add_routes",
                                 "removeroutes": "remove_routes",
                                 "addsubnets": "add_subnets",
                                 "removesubnets": "remove_subnets"}

# Network type preffix
NETWORK_TYPE_PREFFIX = 'huawei-ac-neutron-networks:network-type-'

# Get port suffix
GET_PORT_SUFFIX = '/restconf/data/huawei-ac-neutron:neutron-cfg/ports/port/'

NW_HW_FLOW_MIRROR_URL_PREFIX = '/controller/dc/mirror/neutronapi/v2.0/taas/'


# Device owner compute nova
DEVICE_OWNER_COMPUTE_NOVA = 'compute:nova'

# Invalid sequence number
PLUGIN_INVALID_SEQ_NUM = -1

# Interval at which timeout triggers and check for the tasks
CONTROL_TASK_STEP_INTERVAL = (1 * 60)  # One minute

# Maximum DB retry count
DB_MAX_RETRIES = 200

# Maximum retry for DB state updation
DB_UPDATE_SERVER_MAX_RETRIES = 1000

# Retry interval in seconds for the DB exception.
DB_UPDATE_SERVER_RETRY_INTERVAL = 10

# Max retry interval in seconds for the DB exception.
DB_UPDATE_SERVER_MAX_RETRY_INTERVAL = 50

# User Operations
OPER_CREATE = 'create'  # for POST method
OPER_UPDATE = 'update'  # for PUT method
OPER_DELETE = 'delete'  # for DELETE method
OPER_GET = 'get'     # for GET method

# Normal sync thread pool default count
SYNC_THREAD_POOL_DEFAULT_COUNT = 10

# Neutron sync thread pool default count
NEUTRON_SYNC_THREAD_POOL_DEFAULT_COUNT = 10

# Neutron sync thread pool l47 count
NEUTRON_SYNC_THREAD_POOL_L47_COUNT = 5

# Neutron sync speed limit in 60s
NEUTRON_SYNC_SPEED_LIMIT = 500

# Neutron sync limit for the tasks in process at the same time of L23
AC_MAX_PROCESSING_REQUEST_COUNT = 50

# Neutron sync limit for the tasks in process at the same time of L47
AC_MAX_PROCESSING_REQUEST_L47_COUNT = 5

# Neutron sync limit max loop times to wait ac process
MAX_LOOP_TIMES_TO_WAIT_AC_PROCESS = 100

# State of sync thread where no chile threads are spawn
SYNC_THREAD_POOL_NO_SPAWN = 0

# State of sync thread has threads are spawn
SYNC_THREAD_POOL_ALREADY_SPAWNED = 1

# If there is no records to send after 2 times retry then we kill all
# child threads.
SYNC_THREAD_POOL_MAX_TRY = 3

# Error code
NW_HW_SUCCESS = 0
NW_HW_CONTINUE = 1
NW_HW_STOP_PROCESSING = 2
NW_HW_TIMEOUT = 3
NW_HW_TRIGGER_NEUTRON_SYNC = 4
NW_HW_RETRY = 4
NW_HW_SKIP_SYNC = 5
NW_HW_ERROR = 0xFFFFFF

# To indicate the neutron sync is initialised.
NW_HW_NEUTRON_SYNC_INIT = 0

# To indicate the neutron sync is started.
NW_HW_NEUTRON_SYNC_START = 1

# To indicate any internal error occured on neutron sync.
NW_HW_NEUTRON_SYNC_ERROR = 2

# Json rpc connect config

# The monitor time(seconds) for jsonrpc reconnect
# and it is also heart time.
RECONNECT_MONITOR_TIME = 10

# Heart request timout value in seconds.
HEARTBEAT_TIMEOUT = 10

# echo send times
SEND_HEARTBEAT_TIMES = 2

# The time value for jsonrpc reconnect.
RECONNECT_TIME = 5

# The max thread count for jsonrpc client.
RPC_CLIENT_MAX_WORKERS = 1

# The max thread count for jsonrpc handle.
RPC_HANDLE_MAX_WORKERS = 50

# The retry times when jsonrpc threadtool starts fail.
RPC_RESUBMIT_THREADPOOL_TIMES = 10

# The timeout value(seconds) for jsonrpc request.
RPC_DEFAULT_TIMEOUT = 10

# The timeout value(seconds) for socket.
SOCKET_TIMEOUT = 10

# The interval of initing heart thread.
DEFAULT_PERIOD = 5

# The delay time of initialing rpc agent
DELAY_TIME_TO_INITIAL_RPC_AGENT = 1

# The delay time of starting rpc client
DELAY_TIME_TO_START_CLIENT = 0

# switch to open ac_agent or not
AC_AGENT_CLOSED = False

# ac agent register method
REGISTER_AC_AGENT = 'registerACAgent'
SYNC_MSG = "sync_msg"
NEUTRON_SYNC_NONE = 'none'
NEUTRON_SYNC_INTERVAL = 'neutron_sync_interval'
NEUTRON_SYNC_RESTART = 'restart'
NEUTRON_SYNC_INTERVAL_AND_RESTART = 'neutron_sync_interval_and_restart'

# get request from ac
INCONSISTENCY_CHECK = 'inconsistency_check'
INCONSISTENCY_RECOVER = 'inconsistency_recover'
SINGLE_FEATURE_RECOVER = 'single_feature_recover'
MULTI_INSTANCE_RECOVER = 'multi_instance_recover'
SINGLE_INSTANCE_RECOVER = 'single_instance_recover'
SINGLE_INSTANCE_CHECK = 'single_instance_check'
SINGLE_FEATURE_CHECK = 'single_feature_check'
QUERY_WHITELIST = 'query_whitelist'
SET_WHITELIST = 'set_whitelist'
HEALTH_DETECT = 'health_detect'

CHECK_SYNC_TIMES = 6 * 60 * 24

RESOURCE_LIST = {
    NW_HW_NETWORKS: 'read_networks',
    NW_HW_SUBNETS: 'read_subnets',
    NW_HW_PORTS: 'read_ports',
    NW_HW_ROUTERS: 'read_routers',
    NW_HW_ROUTER_IF: 'read_router_if',
    NW_HW_IKE_POLICY: 'read_ike_policy',
    NW_HW_IPSEC_POLICY: 'read_ipsec_policy',
    NW_HW_VPN_SERVICE: 'read_vpn_service',
    NW_HW_IPSEC_SITE_CONNECTION: 'read_ipsec_site_conn',
    NW_HW_FIREWALL_POLICY: 'read_firewall_policy',
    NW_HW_FIREWALL_RULE: 'read_firewall_rule',
    NW_HW_FIREWALL: 'read_firewall',
    NW_HW_QOS_POLICY: 'read_qos_policy',
    NW_HW_SEC_GRP: 'read_security_group',
    NW_HW_SEC_GRP_RULE: 'read_security_group_rule',
    NW_HW_LOADBALANCER: 'read_load_balancer',
    NW_HW_LISTENER: 'read_listener',
    NW_HW_POOL: 'read_pool',
    NW_HW_MEMBER: 'read_member',
    NW_HW_HEALTH_MONITOR: 'read_health_monitor',
    NW_HW_FIP: 'read_floating_ip',
    NW_HW_EP_GROUPS: 'read_endpoint_group',
    NW_HW_SNATS: 'read_snats',
    NW_HW_EXROUTE: 'read_exroute',
    NW_HW_VPC_CONNECTION: 'read_vpc_connection',
    NW_HW_BGP_ROUTE: 'read_bgp_route',
    NW_HW_L2BR: 'read_l2br',
    NW_HW_CMCC_QOS_POLICY: "read_cmcc_qos_policy",
    NW_HW_POLICY_CLASSIFIER: "read_classifier",
    NW_HW_POLICY_TRAGET_GROUP: "read_policy_target_group",
    NW_HW_POLICY_RULE: "read_policy_rule",
    NW_HW_POLICY_RULE_SET: "read_policy_rule_set",
    NW_HW_DNAT: 'read_dnat',
    NW_HW_PF: 'read_pf',
    NW_HW_EXTERNAL_SEGMENT: 'read_external_segment',
    NW_HW_EXTERNAL_POLICY: 'read_external_policy',
    NW_HW_IPV6_NS_QOS_POLICY: 'read_ipv6_ns_qos_policy',
    NW_HW_TAP_SERVICE: 'read_tap_service',
    NW_HW_TAP_FLOW: 'read_tap_flow'
}

FORMATTER_FUNC = {
    NW_HW_NETWORKS: 'set_network_data',
    NW_HW_SUBNETS: 'set_subnet_data',
    NW_HW_PORTS: 'set_port_data',
    NW_HW_ROUTERS: 'set_router_data',
    NW_HW_ROUTER_IF: 'set_router_if',
    NW_HW_IKE_POLICY: 'set_ike_policy',
    NW_HW_IPSEC_POLICY: 'set_ipsec_policy',
    NW_HW_VPN_SERVICE: 'set_vpn_service',
    NW_HW_EP_GROUPS: 'set_endpoint_group',
    NW_HW_IPSEC_SITE_CONNECTION: 'set_ipsec_site_connection',
    NW_HW_FIREWALL_POLICY: 'set_firewall_policy',
    NW_HW_FIREWALL_RULE: 'set_firewall_rule',
    NW_HW_FIREWALL: 'set_firewall',
    NW_HW_QOS_POLICY: 'set_qos_policy_data',
    NW_HW_SEC_GRP: 'set_security_group_data',
    NW_HW_SEC_GRP_RULE: 'set_security_group_rule_data',
    NW_HW_LOADBALANCER: 'set_loadbalancer',
    NW_HW_LISTENER: 'set_listener',
    NW_HW_POOL: 'set_pool',
    NW_HW_MEMBER: 'set_member',
    NW_HW_HEALTH_MONITOR: 'set_healthmonitor',
    NW_HW_FIP: 'set_floating_ip',
    NW_HW_SNATS: 'set_snat',
    NW_HW_VPC_CONNECTION: 'set_vpc_connection',
    NW_HW_BGP_ROUTE: 'set_bgp_route',
    NW_HW_L2BR: 'set_l2br',
    NW_HW_CMCC_QOS_POLICY: 'set_cmcc_qos_policy',
    NW_HW_POLICY_TRAGET_GROUP: 'set_policy_target_group',
    NW_HW_POLICY_RULE_SET: 'set_policy_rule_set',
    NW_HW_POLICY_RULE: 'set_policy_rule',
    NW_HW_POLICY_CLASSIFIER: 'set_policy_classifier',
    NW_HW_DNAT: 'set_dnat',
    NW_HW_PF: 'set_pf',
    NW_HW_EXTERNAL_SEGMENT: 'set_external_segment',
    NW_HW_EXTERNAL_POLICY: 'set_external_policy',
    NW_HW_IPV6_NS_QOS_POLICY: 'set_ipv6_ns_qos_policy',
    NW_HW_TAP_SERVICE: 'set_tap_service',
    NW_HW_TAP_FLOW: 'set_tap_flow'
}

WHITELIST_SEQUENCE = [
    'networks', 'subnets', 'ports', 'routers', 'floatingips', 'dnats',
    'snats', 'vpc-connections', 'bgp-routes', 'bgpneighbors', 'vpn-services',
    'firewalls', 'firewall-policies', 'firewall-rules', 'ike-policies',
    'ipsec-policies', 'ipsec-site-connections', 'endpoint-groups',
    'qos-policies', 'security-groups', 'security-rules', 'loadbalancers',
    'listeners', 'pools', 'members', 'healthmonitors', 'l2brs', 'policy-rules',
    'policy-rule-sets', 'policy-classifiers', 'policy-target-groups',
    'external-segment-groups', 'external-policy-groups'
]

WEBSOCKET_REQUEST_LIST = [
    SYNC_MSG,
    INCONSISTENCY_CHECK,
    INCONSISTENCY_RECOVER,
    SINGLE_FEATURE_RECOVER,
    SINGLE_INSTANCE_RECOVER,
    MULTI_INSTANCE_RECOVER,
    SINGLE_INSTANCE_CHECK,
    SINGLE_FEATURE_CHECK,
    QUERY_WHITELIST,
    HEALTH_DETECT,
    SET_WHITELIST
]

AC_PLUGIN_OPERATE_LIST = [
    INCONSISTENCY_CHECK,
    INCONSISTENCY_RECOVER,
    SINGLE_FEATURE_RECOVER,
    SINGLE_INSTANCE_RECOVER,
    MULTI_INSTANCE_RECOVER,
    SINGLE_INSTANCE_CHECK,
    SINGLE_FEATURE_CHECK,
    QUERY_WHITELIST,
    HEALTH_DETECT,
    SET_WHITELIST
]

ASYNCHRONOUS_RETURN_LIST = [
    INCONSISTENCY_CHECK,
    INCONSISTENCY_RECOVER,
    SINGLE_FEATURE_RECOVER,
    MULTI_INSTANCE_RECOVER,
    SINGLE_FEATURE_CHECK
]

# Neutron sync operations supported
SYNC_NO_DIFFERENCE = 0
SYNC_OP_SYNC_DATA = 1
SYNC_OP_COMPARE_DATA = 2
SYNC_OP_SYNC_AND_COMPARE_DATA = 3
SYNC_OP_SYNC_SINGLE_INSTANCE = 4
SYNC_TIMEOUT_TIMES_SINGLE_RES_TYPE = 10

# json rpc client thread cancel max times
THREAD_CANCEL_MAX_TIMES = 15

# socket shutdown mode
SHUT_RDWR = 2

# OpenStack version
OPS_K = "Kilo"
OPS_L = "Liberty"
OPS_M = "Mitaka"
OPS_N = "Newton"
OPS_O = "Ocata"
OPS_P = "Pike"
OPS_Q = "Queens"
OPS_R = "Rocky"
OPS_T = "Train"
OPS_W = "Wallaby"
OPS_EZ_M = "EZ_Mitaka"
FSP_6_1 = "FusionSphere6.1"
FSP_6_3_0 = "FusionSphere6.3.0"
FSP_6_3_1 = "FusionSphere6.3.1"
FSP_6_5 = "FusionSphere6.5"
FSP_6_5_private = "FusionSphere6.5.0Private"
FSP_6_5_NFVI = "FusionSphere6.5.0NFVI"
FSP_6_5_1 = "FusionSphere6.5.1"
FSP_8_0_0 = "FusionSphere8.0.0"
FSP_8_0_3 = "FusionSphere8.0.3"
FSP_21_0 = "FusionSphere21.0"
DECOUPLING_FSP_VERSION = '8.0.0'
LATEST_FSP_VERSION = '8.0.0'

CLOUD_NAME_PARAM = 'cloud-name'
NEUTRON_SYNC_PATH = 'neutronsync'
OPS_VER = "ops-version"
UPDATE_TIME_SUPPORT_VERSION = [OPS_M, OPS_EZ_M]
DEFAULT_LOG_PATH = os.path.realpath('/var/log/neutron/')
# the file is used to record the neutron_sync result
NEUTRON_SYNC_RESULT_FILE = "/var/log/neutron/neutron_sync_%s.log"
# Neutron-sync comparison result file
NEUTRON_SYNC_COMPARE_RESULT_FILE = \
    "/var/log/neutron/neutron_sync_comp_res.csv"
# Default initial interval for neutron sync
NEUTRON_SYNC_INITIAL_INTERVAL = 5
NEUTRON_SYNC_PARAM_DEFAULT = {
    "seconds": NEUTRON_SYNC_INITIAL_INTERVAL,
    "looping": False,
    "force_trigger": False,
    "sync_op": SYNC_OP_COMPARE_DATA,
    "compare_data": NEUTRON_SYNC_COMPARE_RESULT_FILE,
    "need_delete": False,
    "include_bindports": False,
    "sync_resource_type": None,
    "sync_resources": None,
    "sync_segments": None
}

# limit the file size to 10M
LIMIT_FILE_SIZE = 10 * 1024 * 1024

CONSIST_CONSISTENCY_QUERY = 'consist_query'
CONSIST_QUERY_GATHER_DATA = 'gather data'
CONSIST_QUERY_GATHER_STATUS = 'gather status'
CONSIST_QUERY_DOWNLOAD_FILE = 'download data'
CONSIST_QUERY_COND = 'cond'
CONSIST_CONSISTENCY_REPLY = 'consist_reply'

# By considering max packet size as 1MB and each packet contain 2KB of data
NW_HW_MAX_GET_PACKET_COUNT = 500

NW_HW_NEUTRON_CFG_CONTAINER = 'neutron-cfg'

# Time interval on which the access-time needs to be updated by each neutron
#  server. Units in minutes.
ACCESS_TIME_UPDATE = 2

# Time interval on which to clear the long pending in-process records from
# the plugin-table. Units in minutes.
LONG_PENDING_IN_PROCESS = 2

# Time interval on which the neturon servers are identified as error,
# if it doesnt update the access-time for more than CLEAR_SERVER_INTERVAL.
# Units in minutes.
CLEAR_SERVER_INTERVAL = 10

# Time interval on which to clear the neutron server records in error
# state from neutron state table. Units in minutes.
SERVER_ERR_REC_INTERVAL = 60

# Time interval on which the leader selection should be performed. Units in
# minutes.
LEADER_SELECTION_INTERVAL = 1

# Time interval on which the server alive check needs to be perfomed. Units
# in minutes.
SERVER_ALIVE_CHECK_INTERVAL = 10

# Time interval on clean invalid segments needs to be perfomed. Units
# in minutes.
CLEAN_INVALID_SEGMENTS_INTERVAL = (60 * 24 * 30)

# Time interval on which the neutron sync needs to be performed after reboot
#  or startup as per the configuration.
NEUTRON_SYNC_AT_REBOOT = 1

# Time interval for the validation db records long pending process cleaning
LONG_PEND_VALIDATION_INTERVAL = 10

# Default interval for neutron sync for daily
NEUTRON_SYNC_DEFAULT_TIMEOUT_DAILY = (24 * 60 * 60)

# Default interval for neutron sync for weekly
NEUTRON_SYNC_DEFAULT_TIMEOUT_WEEKLY = (7 * 24 * 60 * 60)

MAX_SYNC_START_RETRY_COUNT = 5
MAX_SYNC_START_RETRY_TIME = 60

NEUTRON_SYNC_LOG_INTERVAL = 60
MAX_MSG_IN_BULK = 1
MAX_CONTINUOUS_TIMEOUT = 10

# Max affordable time-interval on which the in-process records to be cleared
#  for neutron-sync. Its calculated with default request timeout* default
# timeout retry + time_interval for long pending in-process. ie (6*60=360).
# So it will continue to check till the counter expires. On each count the
# counter will wait for 2 seconds. So counter is calculated as (360/2=180)
# MAX_IN_PROCESS_CLEAR_RETRY_COUNT
MAX_IN_PROCESS_CLEAR_RETRY_COUNT = 180

RESOURCE_IS_ASYNCHRONOUS = [NW_HW_PORTS]

NEUTRON_SYNC_MESSAGE_TIMEOUT = (10 * 60)

NEUTRON_SYNC_DEPENDENCY_ORDER = [
    NW_HW_QOS_POLICY,
    NW_HW_SEC_GRP,
    NW_HW_SEC_GRP_RULE,
    NW_HW_NETWORKS,
    NW_HW_BINDPORTS,
    NW_HW_SUBNETS,
    NW_HW_PORTS,
    NW_HW_ROUTERS,
    NW_HW_ROUTER_IF,
    NW_HW_FIP,
    NW_HW_SNATS,
    NW_HW_DNAT,
    NW_HW_PF,
    NW_HW_BGP_ROUTE,
    NW_HW_POLICY_CLASSIFIER,
    NW_HW_POLICY_RULE,
    NW_HW_POLICY_RULE_SET,
    NW_HW_POLICY_TRAGET_GROUP,
    NW_HW_EXTERNAL_SEGMENT,
    NW_HW_EXTERNAL_POLICY,
    NW_HW_FIREWALL_RULE,
    NW_HW_FIREWALL_POLICY,
    NW_HW_FIREWALL,
    NW_HW_IKE_POLICY,
    NW_HW_VPN_SERVICE,
    NW_HW_IPSEC_POLICY,
    NW_HW_EP_GROUPS,
    NW_HW_IPSEC_SITE_CONNECTION,
    NW_HW_VPC_CONNECTION,
    NW_HW_LOADBALANCER,
    NW_HW_LISTENER,
    NW_HW_POOL,
    NW_HW_MEMBER,
    NW_HW_HEALTH_MONITOR,
    NW_HW_L2BR,
    NW_HW_EXROUTE,
    NW_HW_TAP_SERVICE,
    NW_HW_TAP_FLOW,
    NW_HW_IPV6_NS_QOS_POLICY,
]

# minute translate to seconds
SECONDS_EVRY_MINUTE = 60

TIME_NEED_PER_SEQ = 5

LOADBALANCER2 = "LOADBALANCER2"

NW_HW_NEUTRON_SYNC_REST_HEADER = None

NW_HW_NEUTRON_SYNC_GET_FILE = {"Content-Type": "application/json"}

NW_HW_MAX_DEBUG_CONTENT_SIZE = (5 * 1024)

NW_HW_MAX_GATHER_STATUS_RETRY_COUNT = 240

# detect active AC
AC_ACTIVE_ROLE = "Active"
DEFAULT_AC_ID = 1
DEFAULT_AC_IP = "0.0.0.0"

# Config validators
CLOUD_STR_MAX_LEN = 129
USER_NAME_MAX_LEN = 129
USER_PASS_MAX_LEN = 129
NEUTRON_SERVER_MAX_LEN = 256
NEUTRON_SYNC_TYPE_STR_MAX_LEN = 50

# request body constants
NEUTRON_CONSTANTS = "huawei-ac-neutron-constants:"
SECURITY_GROUP_ETHER_TYPE = "ethertype-"
SECURITY_GROUP_DIRECTION = "direction-"
DEFAULT_IPV4_PREFIX = "0.0.0.0/0"
DEFAULT_IPV6_PREFIX = "::/0"

URL_POOL_ID = "pool-id"


# Waiting for configuration restore check after reboot(value in seconds)
NW_HW_KEYSTONE_CONFIG_WAIT_COUNT = 20

# Neutron sync status of each record
STAT_WAIT = 0  # Wait to send
STAT_SENT = 1  # Send success
STAT_ERR = 2  # Send error
STAT_TIME_OUT = 3  # Send timeout

# ISO8601 time format
ISO8601_TIME_FORMAT = '%Y-%m-%dT%H:%M:%S'

# Remote IP prefix length
REMOTE_IP_PREFIX_LEN = 4

# Reject remote ip prefixes
REJECT_REMOTE_IP_PREFIXES = ['127.0.0.1', '255.255.255.255']

# FusionSphere network blacklist
NETWORK_BLACKLIST = ['external_om', 'external_api', 'internal_base']

# support to process f5 port
DEVICE_OWNER_F5_V1 = "network:f5lbaas"
DEVICE_OWNER_F5_V2 = "network:f5lbaasv2"

ACCOUNT_SECURE_KEY = 1
KEYSTONE_AUTH_SECURE_KEY = 2
WEBSOCKET_SECURE_KEY = 3

NEUTRON_FINAL_RSP_CHECK_INTRVL = 5  # Final response check interval

NW_HW_AC_STATUS_PORT = 'huawei_ac_status_port'
NW_HW_AC_STATUS_FIREWALL_POLICY = 'huawei_ac_status_firewall_policy'
NW_HW_FWAAS = 'huawei_ac_fwaas'
NW_HW_L3 = 'huawei_ac_router'
NW_HW_LBAAS = 'huawei_ac_lbaas'
NW_HW_ML2 = 'huawei_ac_ml2'
NW_HW_QOS = 'huawei_ac_qos'
NW_HW_CMCC_QOS = 'huawei_ac_cmcc_qos'
NW_HW_VPNAAS = 'huawei_ac_ipsecvpn'
NW_HW_GBP = 'huawei_ac_gbp'
NW_HW_GBP_EXTERNAL = 'huawei_ac_gbp_external'

NW_HW_FWAAS_RES_LIST = [NW_HW_FIREWALL_POLICY, NW_HW_FIREWALL_RULE,
                        NW_HW_FIREWALL]
NW_HW_L3_RES_LIST = [NW_HW_ROUTERS, NW_HW_FIP, NW_HW_EXROUTE]
NW_HW_SNAT_RES_LIST = [NW_HW_SNATS]
NW_HW_LBAAS_RES_LIST = [NW_HW_LOADBALANCER, NW_HW_LISTENER, NW_HW_POOL,
                        NW_HW_MEMBER, NW_HW_HEALTH_MONITOR]
NW_HW_ML2_RES_LIST = [NW_HW_NETWORKS, NW_HW_SUBNETS, NW_HW_PORTS, NW_HW_ROUTER_IF,
                      NW_HW_SEC_GRP, NW_HW_SEC_GRP_RULE]
NW_HW_QOS_RES_LIST = [NW_HW_QOS_POLICY]
NW_HW_CMCC_QOS_RES_LIST = [NW_HW_CMCC_QOS_POLICY]
NW_HW_VPNAAS_RES_LIST = [NW_HW_IKE_POLICY, NW_HW_IPSEC_POLICY,
                         NW_HW_IPSEC_SITE_CONNECTION, NW_HW_VPN_SERVICE,
                         NW_HW_EP_GROUPS]
NW_HW_L47_LIST = [NW_HW_FIP,
                  NW_HW_FIREWALL,
                  NW_HW_VPN_SERVICE,
                  NW_HW_IPSEC_SITE_CONNECTION,
                  NW_HW_VPC_CONNECTION,
                  NW_HW_DNAT,
                  NW_HW_SNATS,
                  NW_HW_IKE_POLICY,
                  NW_HW_IPSEC_POLICY,
                  NW_HW_EP_GROUPS,
                  NW_HW_FIREWALL_POLICY,
                  NW_HW_FIREWALL_RULE,
                  NW_HW_PF]
NW_HW_EXROUTE_LIST = [NW_HW_EXROUTE]
NW_HW_VPC_CONNECTION_LIST = [NW_HW_VPC_CONNECTION]
NW_HW_BGP_ROUTE_LIST = [NW_HW_BGP_ROUTE]
NW_HW_FLOW_MIRROR_LIST = [NW_HW_TAP_SERVICE, NW_HW_TAP_FLOW]
NW_HW_L2BR_LIST = [NW_HW_L2BR]
NW_HW_GBP_LIST = [NW_HW_POLICY_TRAGET_GROUP, NW_HW_POLICY_CLASSIFIER,
                  NW_HW_POLICY_RULE, NW_HW_POLICY_RULE_SET]
NW_HW_GBP_EXTERNAL_LIST = [NW_HW_EXTERNAL_SEGMENT, NW_HW_EXTERNAL_POLICY]
NW_HW_DNAT_LIST = [NW_HW_DNAT]
NW_HW_PF_LIST = [NW_HW_PF]
NW_HW_IPV6_NS_QOS_LIST = [NW_HW_IPV6_NS_QOS_POLICY]

NW_HW_AC_PLUGIN_RES_LIST = {NW_HW_FWAAS: NW_HW_FWAAS_RES_LIST,
                            NW_HW_L3: NW_HW_L3_RES_LIST,
                            NW_HW_SNATS: NW_HW_SNAT_RES_LIST,
                            NW_HW_LBAAS: NW_HW_LBAAS_RES_LIST,
                            NW_HW_ML2: NW_HW_ML2_RES_LIST,
                            NW_HW_QOS: NW_HW_QOS_RES_LIST,
                            NW_HW_VPNAAS: NW_HW_VPNAAS_RES_LIST,
                            NW_HW_EXROUTE: NW_HW_EXROUTE_LIST,
                            NW_HW_VPC_CONNECTION: NW_HW_VPC_CONNECTION_LIST,
                            NW_HW_BGP_ROUTE: NW_HW_BGP_ROUTE_LIST,
                            NW_HW_L2BR: NW_HW_L2BR_LIST,
                            NW_HW_CMCC_QOS: NW_HW_CMCC_QOS_RES_LIST,
                            NW_HW_GBP: NW_HW_GBP_LIST,
                            NW_HW_FLOW_MIRROR: NW_HW_FLOW_MIRROR_LIST,
                            NW_HW_GBP_EXTERNAL: NW_HW_GBP_EXTERNAL_LIST,
                            NW_HW_DNAT: NW_HW_DNAT_LIST,
                            NW_HW_PF: NW_HW_PF_LIST,
                            NW_HW_IPV6_NS_QOS_POLICY: NW_HW_IPV6_NS_QOS_LIST}

NW_HW_NEUTRON_SYNC_SUPPORT_RES = []
AUTH_METHOD_KEYSTONECLIENT = "keystoneclient"
AUTH_METHOD_KEYSTONEAUTH1 = "keystoneauth1"

BOND_MODE_0 = 0
BOND_MODE_1 = 1
BOND_MODE_4 = 4
BOND_MODE_LIST = ["balance-rr", "active-backup", "balance-xor", "broadcast",
                  "802.3ad", "balance-tlb", "balance-alb"]

PORT_MIGRATION_EVENT = "port_migration"

# ethertype
IPv4 = 'IPv4'
IPv6 = 'IPv6'

# black white list type
NOT_IN_WHITE = 1
IN_BLACK = 2

# JsonRpc server port
rpc_server_port = 4096

# websocket server port
websocket_server_port = 18010

# Huawei Agile Controller(AC) REST host port number
rest_server_port = 18002

# neutron config
NEUTRON_CONF = os.path.realpath('/etc/neutron/neutron.conf')

# neutron sync whitelist filename
NEUTRON_SYNC_WHITELIST_FILENAME = os.path.realpath("/etc/neutron/whitelist.ini")

# AC system NCD info url
system_ncd_info_url = "/restconf/operations/ietf-system-ext:get-ncd-brief"

# max value of payload
max_payload_length = 64 * 1024

HTTP_HEART_TIME = 10
HTTP_CONNECTION_DOWN = 0
HTTP_CONNECTION_ACTIVE = 1

TOKEN_TIME_OUT = 5 * 60
NETWORK_DELETE_RETRY_TIME = 3
WAIT_AC_DELETE_DHCP_TIME = 2

HTTP_FAIL_COUNT_MAX = 3
HTTP_RECOVER_COUNT_MAX = 2

# websocket para setting
WEBSOCKET_FAIL_COUNT_MAX = 2
WEBSOCKET_RECOVER_COUNT_MAX = 2

EMPTY_STR = ''

BEFORE_AC_CREATE = 'before_ac_create'
AFTER_AC_CREATE = 'after_ac_create'
BEFORE_AC_UPDATE = 'before_ac_update'
AFTER_AC_UPDATE = 'after_ac_update'
BEFORE_AC_DELETE = 'before_ac_delete'
AFTER_AC_DELETE = 'after_ac_delete'
AFTER_HS_CREATE = "after_hs_create"
AFTER_HS_DELETE = "after_hs_delete"
HILL_STONE_PLUGIN = {'neutron_fwaas.services.firewall.'
                     'hs_fwaas_plugin.FirewallPlugin',
                     'hillstone_firewall', 'hs_fwaas_plugin'}

VERSION_IPV4 = 4
VERSION_IPV6 = 6

REMOTE_VERSION_IPV4 = 'remote_v4ip'
REMOTE_VERSION_IPV6 = 'remote_v6ip'

DESTIONATION_V4IP_PREFIX = 'destination_v4ip_prefix'
DESTIONATION_V6IP_PREFIX = 'destination_v6ip_prefix'

CFG_PATH = "networking_huawei/drivers/ac/cryptor/cfg_factor.txt"

# external access mode
GLOBAL_SNAT = "global_SNAT"
FLEX_SNAT = "flexible_SNAT"

# FusionSphere RDS subnet list
SUBNET_RDS_LIST = ['dbs_res_subnet']

QOS_CLASSES = [
    'networking_huawei.drivers.ac.plugins.qos.ac_qos_plugin.HuaweiQoSPlugin',
    'huawei_ac_qos',
    'neutron.services.qos.qos_plugin.QoSPlugin',
    'qos'
]

MAX_SYNC_TRANS_LEN = 150

HUAWEI_CONFIG = 'huawei_ac_config'

HEALTH_CHECK_SCENE = {'ops_network': 1,
                      'ops_hybrid': 2,
                      'fsp_network': 3,
                      'fsp_hybrid': 4}

HUAWEI_CONFIG_FILE = os.path.realpath('/etc/neutron/huawei_driver_config.ini')
ML2_CONFIG_FILE = os.path.realpath('/etc/neutron/plugins/ml2/ml2_conf.ini')

FSP_PATH = os.path.realpath('/var/log/fusionsphere/component/neutron-server/')
OPS_PATH = os.path.realpath('/var/log/neutron/')

FSP_LOG = os.path.join(FSP_PATH, 'neutron-server_info.log.200')
OPS_LOG = os.path.join(OPS_PATH, 'server.log')

CEHCK_CONFIG_VALUES_ITEMS = {'rpc_server_ip': 'check_ac_ip',
                             'host_ip': 'check_host_ip',
                             'vni_ranges': 'check_vni_ranges',
                             'plugin_version': 'get_plugin_version'}

CHECK_MANDATORY_PARAMS = ['cloud_name',
                          'physical_network',
                          'OPS_version']

CHECK_DEFAULT_VALUE_PARAMS = {
    'enable_snat': {'values': ['true', 'false'],
                    'default': 'true'},
    'enable_security_group': {'values': ['true', 'false'],
                              'default': 'true'},
    'network_list_matching': {'values': ['suffix', 'prefix'],
                              'default': 'suffix'},
    'bare_metal_bond_mode': {'values': ['0', '1', '4'],
                             'default': '1'}}

CHECK_FSP_OTHER_ITEMS = ['logical_hostnames',
                         'vcenter_host_mappings',
                         'vcenter_cluster_mappings',
                         'vcenter_network_mappings',
                         'primary_interface',
                         'vpc_peering']

KEYSTONE_DEFAULT_PARAMS = {'keystone_tenant': 'admin',
                           'keystone_user': 'admin',
                           'keystone_passwd': '',
                           'domain_id': None,
                           'user_domain_id': None,
                           'project_domain_id': None}

NOVA_REQ_TIMEOUT = 5

FS_NETWORK_OVERLAY_SCENE = '3'
FS_HYBRID_OVERLAY_SCENE = '4'

SYNC_TYPE_LIST = {
    NW_HW_NETWORKS,
    NW_HW_SUBNETS,
    NW_HW_PORTS,
    NW_HW_ROUTERS,
    NW_HW_IKE_POLICY,
    NW_HW_IPSEC_POLICY,
    NW_HW_VPN_SERVICE,
    NW_HW_IPSEC_SITE_CONNECTION,
    NW_HW_FIREWALL_POLICY,
    NW_HW_FIREWALL_RULE,
    NW_HW_FIREWALL,
    NW_HW_QOS_POLICY,
    NW_HW_SEC_GRP,
    NW_HW_SECURITY_GROUP_RULE,
    NW_HW_FIP,
    NW_HW_EP_GROUPS,
    NW_HW_SNATS,
    NW_HW_EXROUTE,
    NW_HW_VPC_CONNECTION,
    NW_HW_BGP_ROUTE,
    NW_HW_L2BR,
    NW_HW_CMCC_QOS_POLICY,
    NW_HW_POLICY_CLASSIFIER,
    NW_HW_POLICY_TRAGET_GROUP,
    NW_HW_POLICY_RULE,
    NW_HW_POLICY_RULE_SET,
    NW_HW_DNAT,
    NW_HW_PF,
    NW_HW_EXTERNAL_SEGMENT,
    NW_HW_EXTERNAL_POLICY,
    NW_HW_IPV6_NS_QOS_POLICY,
    NW_HW_TAP_SERVICE,
    NW_HW_TAP_FLOW
}

DATA_NOT_FOUND = 'data not found'

PRE_BFD_NAME_MAX_LENGTH = 24

VNIC_TYPE_NORMAL = 'normal'
VNIC_TYPE_BAREMETAL = 'baremetal'
VNIC_TYPE_SUB_BAREMETAL = 'sub-baremetal'

OPS_VERSION_O_PQRTW_6_21 = [OPS_O, OPS_P, OPS_Q, OPS_R, OPS_T, OPS_W, FSP_6_5, FSP_21_0]
OPS_VERSION_PQRTW_6_21 = [OPS_P, OPS_Q, OPS_R, OPS_T, OPS_W, FSP_6_5, FSP_21_0]

QUERY_RETRY_COUNT = 3
QUERY_SLEEP_TIMES = 10