#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""encrypy"""

try:
    from Crypto.Cipher import AES
except ImportError:
    from Cryptodome.Cipher import AES

from networking_huawei.drivers.ac.encode_convert import convert_to_bytes

LENGTH = 16


def aes_encrypt(text, key, key_iv):
    """aes_encrypt"""
    cryptor = AES.new(key, AES.MODE_CBC, key_iv)
    count = len(text)
    if count < LENGTH:
        add = LENGTH - count
        text = text + ('\0' * add)
    elif count > LENGTH:
        add = LENGTH - (count % LENGTH)
        text = text + ('\0' * add)

    return cryptor.encrypt(convert_to_bytes(text))
